/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.endpoints;

import com.sap.ide.metamodel.vi.ClassEndpointReference;
import com.sap.ide.metamodel.vi.EjbEndpointReference;
import com.sap.ide.metamodel.vi.ParEndpointReference;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.vi.endpoints.EndpointReference;
import com.sap.ide.vi.endpoints.ITypeGetter;
import java.util.Hashtable;
import org.eclipse.jdt.core.IType;

public class EndpointAnalyser {
    private static Hashtable classesForTypes = new Hashtable();
    private static final String WS_CONF_BEAN_KEY = "BEAN";
    private static final String WS_CONF_CLASS_KEY = "JAVA_CLASS";
    private static final String WS_CONF_PAR_KEY = "PAR";

    public static void registerEndPointType(String type, ITypeGetter getter) {
        if (!classesForTypes.contains(type)) {
            classesForTypes.put(type, getter);
        }
    }

    public static ITypeGetter getITypeGetter(EndpointReference endpoint) {
        if (endpoint == null) {
            return null;
        }
        if (endpoint.getType() == null) {
            return null;
        }
        return (ITypeGetter)classesForTypes.get(endpoint.getType());
    }

    public static IType getITypeByEndpoint(EndpointReference endpoint) {
        ITypeGetter getter = EndpointAnalyser.getITypeGetter(endpoint);
        if (getter != null) {
            return getter.getITypeByEndpoint(endpoint);
        }
        return null;
    }

    public static String getEndPointName(com.sap.ide.metamodel.vi.EndpointReference endpoint) {
        if (endpoint instanceof EjbEndpointReference) {
            return ((EjbEndpointReference)endpoint).getBeanName();
        }
        if (endpoint instanceof ClassEndpointReference) {
            return ((ClassEndpointReference)endpoint).getQualifiedClassName();
        }
        if (endpoint instanceof ParEndpointReference) {
            return ((ParEndpointReference)endpoint).getQualifiedClassName();
        }
        return null;
    }

    public static void setEndPointReferenceInMetadata(VirtualInterface vi, EndpointReference endpoint) {
        ITypeGetter getter = EndpointAnalyser.getITypeGetter(endpoint);
        if (getter != null) {
            getter.setEndPointReferenceInMetadata(vi, endpoint);
        }
    }

    public static EndpointReference getEndPointReferenceByEndpoint(com.sap.ide.metamodel.vi.EndpointReference endpoint, String projectName) {
        if (endpoint instanceof EjbEndpointReference) {
            return new EndpointReference(projectName, ((EjbEndpointReference)endpoint).getBeanName(), EndpointReference.EJB_TYPE);
        }
        if (endpoint instanceof ClassEndpointReference) {
            return new EndpointReference(projectName, ((ClassEndpointReference)endpoint).getQualifiedClassName(), EndpointReference.CLASS_TYPE);
        }
        if (endpoint instanceof ParEndpointReference) {
            return new EndpointReference(projectName, ((ParEndpointReference)endpoint).getQualifiedClassName(), EndpointReference.PAR_TYPE);
        }
        return null;
    }

    public static IType getITypeByEndpoint(com.sap.ide.metamodel.vi.EndpointReference endpoint, String projectName) {
        return EndpointAnalyser.getITypeByEndpoint(EndpointAnalyser.getEndPointReferenceByEndpoint(endpoint, projectName));
    }

    public static String getKeyForConfiguration(com.sap.ide.metamodel.vi.EndpointReference endpoint) {
        if (endpoint instanceof EjbEndpointReference) {
            return WS_CONF_BEAN_KEY;
        }
        if (endpoint instanceof ClassEndpointReference) {
            return WS_CONF_CLASS_KEY;
        }
        if (endpoint instanceof ParEndpointReference) {
            return WS_CONF_PAR_KEY;
        }
        return null;
    }

    public static String getType(com.sap.ide.metamodel.vi.EndpointReference endpoint) {
        if (endpoint instanceof EjbEndpointReference) {
            return EndpointReference.EJB_TYPE;
        }
        if (endpoint instanceof ClassEndpointReference) {
            return EndpointReference.CLASS_TYPE;
        }
        if (endpoint instanceof ParEndpointReference) {
            return EndpointReference.PAR_TYPE;
        }
        return null;
    }
}

