/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.check;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.vi.Elementary;
import com.sap.ide.metamodel.vi.Fault;
import com.sap.ide.metamodel.vi.Field;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.metamodel.vi.Structure;
import com.sap.ide.metamodel.vi.Table;
import com.sap.ide.metamodel.vi.Type;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.vi.plugin.VIRootManager;
import com.sap.ide.vi.check.CheckTypeException;
import com.sap.ide.vi.check.CycleDetector;
import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.check.result.TaskManager;
import com.sap.ide.vi.check.result.metamodel.Body;
import com.sap.ide.vi.check.result.metamodel.CRRoot;
import com.sap.ide.vi.check.result.metamodel.CheckResult;
import com.sap.ide.vi.check.result.metamodel.Header;
import com.sap.ide.vi.check.result.metamodel.Message;
import com.sap.ide.vi.check.result.metamodel.MessageCategory;
import com.sap.ide.vi.check.result.metamodel.MessageCount;
import com.sap.ide.vi.check.result.metamodel.plugin.CRRootManager;
import com.sap.ide.vi.core.text.ViUiTexts;
import com.sap.ide.vi.endpoints.EndPointIsAbstractException;
import com.sap.ide.vi.endpoints.EndPointIsAbstractOrInterfaceException;
import com.sap.ide.vi.endpoints.EndPointIsInterfaceException;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.types.TypeAnalyser;
import com.sap.ide.ws.core.adapter.MetamodelResourceAdapter;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;

public class ViCheck {
    private static Hashtable messageTable;
    private static int messageCounter;
    static /* synthetic */ Class class$com$sap$ide$vi$check$ViCheck;

    public ViCheck() {
        if (messageTable == null) {
            messageTable = new Hashtable();
            messageTable.put("1", ViUiTexts.getString("ViCheck.method.MethodExposedDeleted"));
            messageTable.put("2", ViUiTexts.getString("ViCheck.method.MethodNotExposedDeleted"));
            messageTable.put("3", ViUiTexts.getString("ViCheck.method.MethodAdded"));
            messageTable.put("4", ViUiTexts.getString("ViCheck.method.ParametersDeleted"));
            messageTable.put("5", ViUiTexts.getString("ViCheck.method.ParametersAdded"));
            messageTable.put("6", ViUiTexts.getString("ViCheck.method.FaultDeleted"));
            messageTable.put("7", ViUiTexts.getString("ViCheck.method.FaultAdded"));
            messageTable.put("8", ViUiTexts.getString("ViCheck.method.ParameterRenamed"));
            messageTable.put("9", ViUiTexts.getString("ViCheck.method.TypeExchanged"));
            messageTable.put("10", ViUiTexts.getString("ViCheck.method.TypeIncompatibility"));
            messageTable.put("11", ViUiTexts.getString("ViCheck.method.FieldRenamed"));
            messageTable.put("12", ViUiTexts.getString("ViCheck.method.FieldRenamed2"));
            messageTable.put("13", ViUiTexts.getString("ViCheck.method.MethodNowNotOverloaded"));
            messageTable.put("14", ViUiTexts.getString("ViCheck.method.MethodComparisonInposs"));
            messageTable.put("21", ViUiTexts.getString("ViCheck.method.ExpVersionMethodDeleted"));
            messageTable.put("22", ViUiTexts.getString("ViCheck.method.NotExpVersionMethDeleted"));
            messageTable.put("23", ViUiTexts.getString("ViCheck.method.VersionMethodAdded"));
            messageTable.put("24", ViUiTexts.getString("ViCheck.method.FieldDeleted"));
            messageTable.put("25", ViUiTexts.getString("ViCheck.method.FieldAdded"));
            messageTable.put("26", ViUiTexts.getString("ViCheck.method.TypeWasTableNowNoMore"));
            messageTable.put("27", ViUiTexts.getString("ViCheck.method.TypeIsTableButHasNotBeen"));
            messageTable.put("28", ViUiTexts.getString("ViCheck.method.TableTypeDimensionHasChanged"));
            messageTable.put("100", ViUiTexts.getString("ViCheck.method.EndpointNotExists"));
            messageTable.put("110", ViUiTexts.getString("ViCheck.method.NoRuntimeClassForInterf"));
            messageTable.put("111", ViUiTexts.getString("ViCheck.method.RuntimeClassForInterfInv"));
            messageTable.put("112", ViUiTexts.getString("ViCheck.method.RuntimeClassNotImpInterf"));
            messageTable.put("120", ViUiTexts.getString("ViCheck.method.NoRuntimeClassForAbstClass"));
            messageTable.put("121", ViUiTexts.getString("ViCheck.method.RuntimeClassForAbstClassInv"));
            messageTable.put("122", ViUiTexts.getString("ViCheck.method.RuntimeClassNotExtendClass"));
            messageTable.put("123", ViUiTexts.getString("ViCheck.method.RuntimeClassAbstract"));
            messageTable.put("124", ViUiTexts.getString("ViCheck.method.RuntimeClassNotExisting"));
            messageTable.put("130", "&");
        }
    }

    private void clearCheckResult(CheckResult result) {
        try {
            if (result.hasBody()) {
                result.getBody().delete();
            }
            if (result.hasHeader()) {
                result.getHeader().delete();
            }
        }
        catch (DeleteException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViCheck == null ? (class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : class$com$sap$ide$vi$check$ViCheck));
        }
    }

    public static IPath getSourcePathOfMdo(MainDevelopmentObject mdo) {
        Path path = new Path(mdo.getAbsolutePath());
        Path packagePath = new Path(mdo.getPackage().replace('.', File.separatorChar));
        path = path.removeLastSegments(packagePath.segmentCount() + 1);
        return path;
    }

    public void checkVi(String projectName, VirtualInterface vi, IType type) {
        TypeAnalyser.clearAnalysedTypes();
        CRRoot crRoot = CRRootManager.getCRRoot(projectName);
        CheckResult newResult = null;
        Body body = null;
        Header header = null;
        try {
            if (crRoot.hasCheckResult(vi.getPackage(), vi.getName())) {
                newResult = crRoot.getCheckResult(vi.getPackage(), vi.getName());
                if (newResult.isReadOnly()) {
                    MetamodelResourceAdapter.mdoToResource((MainDevelopmentObject)newResult).setReadOnly(false);
                }
                this.clearCheckResult(newResult);
            } else {
                newResult = crRoot.createCheckResult(vi.getPackage(), vi.getName(), MetamodelManager.getMetamodelManager((String)projectName).getSourcePathIdentifier(ViCheck.getSourcePathOfMdo((MainDevelopmentObject)vi)));
            }
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViCheck == null ? (class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : class$com$sap$ide$vi$check$ViCheck));
            return;
        }
        try {
            header = newResult.createHeader();
            header.createCheckedUnit(EndpointAnalyser.getEndPointName(vi.getEndpointReference()));
            body = newResult.createBody();
        }
        catch (CreateException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViCheck == null ? (class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : class$com$sap$ide$vi$check$ViCheck));
            return;
        }
        try {
            this.checkViSingularly(projectName, vi, body);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logErrorSimulated((Throwable)e);
        }
        this.checkViAgainstEndPoint(projectName, vi, type, body);
        this.countMessages(header, body);
        try {
            newResult.commitChanges();
        }
        catch (SaveException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViCheck == null ? (class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : class$com$sap$ide$vi$check$ViCheck));
        }
        catch (DeleteException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViCheck == null ? (class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : class$com$sap$ide$vi$check$ViCheck));
        }
        TaskManager.showCheckResults(vi, newResult);
    }

    public void checkRunTimeClass(String rtcName, String baseClassName, String projectName, Object body) throws CheckTypeException {
        TypeAnalyser analyser = null;
        try {
            analyser = TypeAnalyser.getInstance(projectName, rtcName, 1);
        }
        catch (InadmissableTypeException e) {
            this.createMessage(body, MessageCategory.ERROR, 130, new String[]{e.getMessage()});
        }
        if (analyser == null) {
            this.createMessage(body, MessageCategory.ERROR, 124, new String[]{rtcName});
        }
        if (analyser.isAbstract()) {
            this.createMessage(body, MessageCategory.ERROR, 123, new String[]{rtcName});
        }
        TypeAnalyser targetAnalyser = null;
        try {
            targetAnalyser = TypeAnalyser.getInstance(projectName, baseClassName, 1);
        }
        catch (InadmissableTypeException e) {
            this.createMessage(body, MessageCategory.ERROR, 130, new String[]{e.getMessage()});
        }
        if (targetAnalyser == null) {
            return;
        }
        if (targetAnalyser.isInterface()) {
            boolean check = false;
            try {
                check = this.checkImplementingRelation(analyser, targetAnalyser, 0);
            }
            catch (InadmissableTypeException e) {
                this.createMessage(body, MessageCategory.ERROR, 130, new String[]{e.getMessage()});
            }
            if (!check) {
                this.createMessage(body, MessageCategory.ERROR, 112, new String[]{rtcName, baseClassName});
            }
        } else {
            boolean check = false;
            try {
                check = targetAnalyser.getAnalysedTypeName().equals("java.lang.Object") ? true : this.checkExtendingRelation(analyser, targetAnalyser, 0);
            }
            catch (InadmissableTypeException e) {
                this.createMessage(body, MessageCategory.ERROR, 130, new String[]{e.getMessage()});
            }
            if (!check) {
                this.createMessage(body, MessageCategory.WARNING, 122, new String[]{rtcName, baseClassName});
            }
        }
    }

    public void checkViSingularly(String projectName, VirtualInterface vi, Object body) throws CheckTypeException, EndPointIsAbstractOrInterfaceException {
        if (vi == null) {
            return;
        }
        Type[] types = vi.getTypes();
        int i = 0;
        while (i < types.length) {
            if (!(types[i] instanceof Table) && types[i].getName().equals(types[i].getOriginal().getName()) && !ViBasics.isAllowedJavaType(types[i].getName())) {
                this.doCheckForType(projectName, vi, types[i], body);
            }
            ++i;
        }
    }

    private void doCheckForType(String projectName, VirtualInterface vi, Type type, Object body) throws CheckTypeException, EndPointIsAbstractOrInterfaceException {
        TypeAnalyser analyser = null;
        try {
            analyser = TypeAnalyser.getInstance(projectName, type.getName(), 1);
        }
        catch (InadmissableTypeException e) {
            this.createMessage(body, MessageCategory.ERROR, 130, new String[]{e.getMessage()});
        }
        if (analyser == null) {
            return;
        }
        if (type.getIsAbstract()) {
            if (!this.runtimeClassExistsForType(vi, type)) {
                if (analyser.isInterface()) {
                    if (body == null) {
                        throw new EndPointIsInterfaceException(type.getName());
                    }
                    this.createMessage(body, MessageCategory.ERROR, 110, new String[]{type.getName()});
                } else if (analyser.isAbstract()) {
                    if (body == null) {
                        throw new EndPointIsAbstractException(type.getName());
                    }
                    this.createMessage(body, MessageCategory.ERROR, 120, new String[]{type.getName()});
                }
            }
        } else {
            this.checkRunTimeClass(type.getName(), type.getParentTypeName(), projectName, body);
        }
    }

    private boolean runtimeClassExistsForType(VirtualInterface vi, Type type) {
        Type[] types = vi.getTypes();
        int i = 0;
        while (i < types.length) {
            if (!(types[i] instanceof Table) && types[i].getParentTypeName() != null && types[i].getParentTypeName().equals(type.getOriginal().getName())) {
                if (types[i].getIsAbstract()) {
                    return this.runtimeClassExistsForType(vi, types[i]);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkExtendingRelation(TypeAnalyser currentAnalyser, TypeAnalyser targetAnalyser, int level) throws InadmissableTypeException {
        if (level > 0 && currentAnalyser.equals(targetAnalyser)) {
            return true;
        }
        if (currentAnalyser.getParentType() != null) {
            return this.checkExtendingRelation(currentAnalyser.getParentType(), targetAnalyser, level + 1);
        }
        return false;
    }

    private boolean checkImplementingRelation(TypeAnalyser currentAnalyser, TypeAnalyser targetAnalyser, int level) throws InadmissableTypeException {
        if (level > 0 && currentAnalyser.equals(targetAnalyser)) {
            return true;
        }
        TypeAnalyser[] tas = currentAnalyser.getInterfaceTypes();
        int i = 0;
        while (i < tas.length) {
            if (this.checkImplementingRelation(tas[i], targetAnalyser, level + 1)) {
                return true;
            }
            ++i;
        }
        TypeAnalyser pa = currentAnalyser.getParentType();
        return pa != null && this.checkImplementingRelation(pa, targetAnalyser, level + 1);
    }

    /*
     * Unable to fully structure code
     */
    private void checkViAgainstEndPoint(String projectName, VirtualInterface vi, IType type, Body body) {
        block10: {
            tempViName = vi.getName();
            virtualInterface = null;
            endPointName = EndpointAnalyser.getEndPointName(vi.getEndpointReference());
            if (type != null) ** GOTO lbl21
            this.createMessage(body, MessageCategory.ERROR, 100, new String[]{endPointName});
            break block10;
lbl-1000:
            // 1 sources

            {
                tempViName = "CopyOf_" + tempViName;
                try {
                    virtualInterface = VIRootManager.getVIRoot((String)projectName).createVirtualInterface("", tempViName);
                    EndpointAnalyser.setEndPointReferenceInMetadata(virtualInterface, EndpointAnalyser.getEndPointReferenceByEndpoint(vi.getEndpointReference(), projectName));
                    ma = ViBasics.buildUpMethodAttributeList(virtualInterface.getName(), projectName, type);
                    ViBasics.fillMetaDataByIType(virtualInterface, projectName, type, ma);
                    this.compareVirtualInterfaces(vi, virtualInterface, body);
                    this.compareRuntimeClasses(vi, virtualInterface, body, projectName, new CycleDetector());
                    continue;
                }
                catch (InadmissableTypeException ex) {
                    WebServiceCorePlugin.logMessage((String)ViUiTexts.getString("ViCheck.method.EndpointInvalid", endPointName), (String)"checkViAgainstEndpoint()", (Class)(ViCheck.class$com$sap$ide$vi$check$ViCheck == null ? ViCheck.class$("com.sap.ide.vi.check.ViCheck") : ViCheck.class$com$sap$ide$vi$check$ViCheck));
                    continue;
                }
                catch (Exception e) {
                    WebServiceCorePlugin.logError((Throwable)e, (Class)(ViCheck.class$com$sap$ide$vi$check$ViCheck == null ? ViCheck.class$("com.sap.ide.vi.check.ViCheck") : ViCheck.class$com$sap$ide$vi$check$ViCheck));
                }
lbl21:
                // 4 sources

                ** while (virtualInterface == null)
            }
lbl22:
            // 1 sources

            if (virtualInterface == null) {
                try {
                    virtualInterface = VIRootManager.getVIRoot((String)projectName).getVirtualInterface("", tempViName);
                }
                catch (LoadException e) {
                    WebServiceCorePlugin.logError((Throwable)e, (Class)(ViCheck.class$com$sap$ide$vi$check$ViCheck == null ? (ViCheck.class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : ViCheck.class$com$sap$ide$vi$check$ViCheck));
                }
            }
            if (virtualInterface != null) {
                try {
                    virtualInterface.delete();
                }
                catch (DeleteException e) {
                    WebServiceCorePlugin.logError((Throwable)e, (Class)(ViCheck.class$com$sap$ide$vi$check$ViCheck == null ? (ViCheck.class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : ViCheck.class$com$sap$ide$vi$check$ViCheck));
                }
            }
        }
    }

    private void compareRuntimeClasses(VirtualInterface oldVi, VirtualInterface newVi, Body body, String projectName, CycleDetector cycleDetector) {
        int i = 0;
        while (i < oldVi.getTypeCount()) {
            block7: {
                if (!(oldVi.getTypes()[i] instanceof Table)) {
                    String typeName = oldVi.getTypes()[i].getName();
                    TypeAnalyser ana = null;
                    try {
                        ana = TypeAnalyser.getInstance(projectName, typeName, 1);
                    }
                    catch (InadmissableTypeException e) {
                        break block7;
                    }
                    if (ana != null && !ana.isAbstract() && !newVi.hasType(typeName)) {
                        try {
                            ViBasics.createTypeIntoTypeHierarchy(newVi, projectName, typeName, false, typeName, null);
                        }
                        catch (InadmissableTypeException e1) {
                            WebServiceCorePlugin.logError((Throwable)e1, this.getClass());
                        }
                        this.compareTypes(oldVi, newVi, null, typeName, typeName, body, cycleDetector);
                    }
                }
            }
            ++i;
        }
    }

    private void compareVirtualInterfaces(VirtualInterface oldVi, VirtualInterface newVi, Body body) {
        Vector oldVe = new Vector();
        Vector newVe = new Vector();
        Function[] oldFunctions = oldVi.getFunctions();
        Function[] newFunctions = newVi.getFunctions();
        int i = 0;
        while (i < oldFunctions.length) {
            Function oldFunction = oldFunctions[i];
            oldVe = this.getVersions(oldFunctions, oldFunction);
            newVe = this.getVersions(newFunctions, oldFunction);
            if (newVe.size() == 0) {
                if (oldFunction.getIsExposed()) {
                    this.createMessage(body, MessageCategory.ERROR, 1, new String[]{oldFunction.getOriginalName()});
                } else {
                    this.createMessage(body, MessageCategory.WARNING, 2, new String[]{oldFunction.getOriginalName()});
                }
            } else if (newVe.size() == 1) {
                if (oldVe.size() == 1) {
                    this.compareFunctions(oldVi, newVi, (Function)oldVe.elementAt(0), (Function)newVe.elementAt(0), body);
                } else {
                    this.createMessage(body, MessageCategory.INFO, 13, new String[]{oldFunction.getOriginalName()});
                }
            } else if (oldVe.size() == 1) {
                this.createMessage(body, MessageCategory.INFO, 12, new String[]{oldFunction.getOriginalName()});
            }
            if (oldVe.size() > 1 || newVe.size() > 1) {
                this.handleOverloadedFunctions(oldVi, newVi, oldVe, newVe, body);
            }
            ++i;
        }
    }

    private void handleOverloadedFunctions(VirtualInterface oldVi, VirtualInterface newVi, Vector oldFuns, Vector newFuns, Body body) {
        String funcname = ((Function)oldFuns.elementAt(0)).getOriginalName();
        int i = 0;
        while (i < oldFuns.size()) {
            boolean found = false;
            Function oldFun = (Function)oldFuns.elementAt(i);
            int j = 0;
            while (j < newFuns.size()) {
                Function newFun = (Function)newFuns.elementAt(j);
                if (oldFun.getName().equals(newFun.getName())) {
                    this.compareFunctions(oldVi, newVi, (Function)oldFuns.elementAt(i), (Function)newFuns.elementAt(j), body);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                if (oldFun.getIsExposed()) {
                    this.createMessage(body, MessageCategory.ERROR, 21, new String[]{oldFun.getOriginalName()});
                } else {
                    this.createMessage(body, MessageCategory.WARNING, 22, new String[]{oldFun.getOriginalName()});
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < newFuns.size()) {
            boolean found = false;
            Function newFun = (Function)newFuns.elementAt(i2);
            int j = 0;
            while (j < oldFuns.size()) {
                Function oldFun = (Function)oldFuns.elementAt(j);
                if (newFun.getName().equals(oldFun.getName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.createMessage(body, MessageCategory.WARNING, 23, new String[]{newFun.getOriginalName()});
            }
            ++i2;
        }
    }

    private Vector getVersions(Function[] allFunctions, Function thisFunction) {
        Vector<Function> resultVector = new Vector<Function>();
        boolean counter = false;
        int i = 0;
        while (i < allFunctions.length) {
            if (allFunctions[i].getOriginalName().equals(thisFunction.getOriginalName())) {
                resultVector.add(allFunctions[i]);
            }
            ++i;
        }
        return resultVector;
    }

    private void compareFunctions(VirtualInterface oldVi, VirtualInterface newVi, Function oldFu, Function newFu, Body body) {
        Vector<String> v;
        Parameter[] oldParameters = oldFu.getIncomingParameters();
        Parameter[] newParameters = newFu.getIncomingParameters();
        int minNumber = this.min(oldParameters.length, newParameters.length);
        int i = 0;
        while (i < minNumber) {
            this.compareParameters(oldVi, newVi, oldFu.getOriginalName(), oldParameters[i], newParameters[i], body);
            ++i;
        }
        if (oldParameters.length > minNumber) {
            this.createMessage(body, MessageCategory.ERROR, 4, new String[]{oldFu.getOriginalName()});
        } else if (newParameters.length > minNumber) {
            this.createMessage(body, MessageCategory.WARNING, 5, new String[]{oldFu.getOriginalName()});
        }
        if (oldFu.getOutgoingParameterCount() > 0 && newFu.getOutgoingParameterCount() > 0) {
            this.compareParameters(oldVi, newVi, oldFu.getOriginalName(), oldFu.getOutgoingParameters()[0], newFu.getOutgoingParameters()[0], body);
        } else if (oldFu.getOutgoingParameterCount() == 0 && newFu.getOutgoingParameterCount() > 0) {
            v = new Vector<String>(2);
            v.add(newFu.getOutgoingParameter(0).getName());
            v.add(oldFu.getOriginalName());
            this.createMessage(body, MessageCategory.ERROR, 9, new String[]{"void", ViUiTexts.getString("ViCheck.nameBuilding.ParameterOfMethod", v), ViBasics.getOriginalTypeforParameter(newVi, newFu.getOutgoingParameter(0))});
        } else if (oldFu.getOutgoingParameterCount() > 0 && newFu.getOutgoingParameterCount() == 0) {
            v = new Vector(2);
            v.add(oldFu.getOutgoingParameter(0).getName());
            v.add(oldFu.getOriginalName());
            this.createMessage(body, MessageCategory.ERROR, 9, new String[]{ViBasics.getOriginalTypeforParameter(oldVi, oldFu.getOutgoingParameter(0)), ViUiTexts.getString("ViCheck.nameBuilding.ParameterOfMethod", v), "void"});
        }
        Fault[] oldFaults = oldFu.getFaults();
        Fault[] newFaults = newFu.getFaults();
        int i2 = 0;
        while (i2 < oldFaults.length) {
            if (!newFu.hasFault(oldFaults[i2].getName())) {
                this.createMessage(body, MessageCategory.ERROR, 6, new String[]{oldFaults[i2].getName(), oldFu.getName()});
            } else {
                this.compareFaults(oldVi, newVi, oldFu.getOriginalName(), oldFaults[i2], newFaults[i2], body);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < newFaults.length) {
            if (!oldFu.hasFault(newFaults[i3].getName())) {
                this.createMessage(body, MessageCategory.WARNING, 7, new String[]{newFaults[i3].getName(), newFu.getName()});
            }
            ++i3;
        }
    }

    private void compareFaults(VirtualInterface oldVi, VirtualInterface newVi, String funcName, Fault oldFa, Fault newFa, Body body) {
        String oldOriginalType = ViBasics.getOriginalType(oldVi, oldFa.getName());
        String newOriginalType = ViBasics.getOriginalType(newVi, newFa.getName());
        Vector<String> v = new Vector<String>(2);
        v.add(oldFa.getName());
        v.add(funcName);
        this.compareTypes(oldVi, newVi, ViUiTexts.getString("ViCheck.nameBuilding.FaultOfMethod", v), oldOriginalType, newOriginalType, body, new CycleDetector());
    }

    private void compareParameters(VirtualInterface oldVi, VirtualInterface newVi, String funcName, Parameter oldPa, Parameter newPa, Body body) {
        String oldOriginalType = ViBasics.getOriginalTypeforParameter(oldVi, oldPa);
        String newOriginalType = ViBasics.getOriginalTypeforParameter(newVi, newPa);
        Vector<String> v = new Vector<String>(2);
        v.add(oldPa.getName());
        v.add(funcName);
        this.compareTypes(oldVi, newVi, ViUiTexts.getString("ViCheck.nameBuilding.ParameterOfMethod", v), oldOriginalType, newOriginalType, body, new CycleDetector());
        if (!oldPa.getName().equals(newPa.getName())) {
            this.createMessage(body, MessageCategory.INFO, 8, new String[]{oldPa.getName(), funcName, newPa.getName()});
        }
    }

    private void compareTypes(VirtualInterface oldVi, VirtualInterface newVi, String typeFor, String oldType, String newType, Body body, CycleDetector cycleDetector) {
        if (TypeAnalyser.isVoidType(oldType) && TypeAnalyser.isVoidType(newType)) {
            return;
        }
        if (TypeAnalyser.isVoidType(oldType) || TypeAnalyser.isVoidType(newType)) {
            this.createMessage(body, MessageCategory.ERROR, 9, new String[]{oldType, typeFor, newType});
        } else if (TypeAnalyser.isConvertableType(oldType) && TypeAnalyser.isConvertableType(newType)) {
            this.compareConvertableTypes(oldVi, newVi, typeFor, oldType, newType, body);
        } else if (TypeAnalyser.isConvertableType(oldType) || TypeAnalyser.isConvertableType(newType)) {
            this.createMessage(body, MessageCategory.ERROR, 9, new String[]{oldType, typeFor, newType});
        } else if (TypeAnalyser.isTableType(oldType) && TypeAnalyser.isTableType(newType)) {
            this.compareTypes(oldVi, newVi, typeFor, TypeAnalyser.getLineType(oldType), TypeAnalyser.getLineType(newType), body, cycleDetector);
        } else if (TypeAnalyser.isTableType(oldType) || TypeAnalyser.isTableType(newType)) {
            this.createMessage(body, MessageCategory.ERROR, 9, new String[]{oldType, typeFor, newType});
        } else {
            this.compareComplexTypes(oldVi, newVi, typeFor, oldVi.getType(oldType), newVi.getType(newType), body, cycleDetector);
        }
    }

    private void compareConvertableTypes(VirtualInterface oldVi, VirtualInterface newVi, String typeFor, String oldType, String newType, Body body) {
        if (!oldType.equals(newType)) {
            this.createMessage(body, MessageCategory.ERROR, 9, new String[]{oldType, typeFor, newType});
        }
    }

    private void compareComplexTypes(VirtualInterface oldVi, VirtualInterface newVi, String typeFor, Type oldType, Type newType, Body body, CycleDetector cycleDetector) {
        boolean equalTypes = false;
        if (!oldType.getName().equals(newType.getName())) {
            this.createMessage(body, MessageCategory.ERROR, 9, new String[]{oldType.getName(), typeFor, newType.getName()});
            return;
        }
        if (oldType instanceof Elementary) {
            if (newType instanceof Elementary) {
                equalTypes = true;
                this.compareElementaryTypes(oldVi, newVi, typeFor, (Elementary)oldType, (Elementary)newType, body);
            } else if (newType instanceof Structure) {
                this.createMessage(body, MessageCategory.INFO, 25, new String[]{((Structure)newType).getField(0).getFieldName(), oldType.getName()});
            } else if (newType instanceof Table) {
                this.createMessage(body, MessageCategory.WARNING, 27, new String[]{oldType.getName()});
            }
        }
        if (oldType instanceof Structure) {
            if (newType instanceof Elementary) {
                this.createMessage(body, MessageCategory.WARNING, 24, new String[]{((Structure)oldType).getField(0).getFieldName(), oldType.getName()});
            } else if (newType instanceof Structure) {
                equalTypes = true;
                this.compareStructureTypes(oldVi, newVi, typeFor, (Structure)oldType, (Structure)newType, body, cycleDetector);
            } else if (newType instanceof Table) {
                this.createMessage(body, MessageCategory.ERROR, 27, new String[]{oldType.getName()});
            }
        }
        if (oldType instanceof Table) {
            if (newType instanceof Elementary || newType instanceof Structure) {
                this.createMessage(body, MessageCategory.ERROR, 26, new String[]{oldType.getName()});
            } else if (newType instanceof Table) {
                equalTypes = true;
                this.compareTableTypes(oldVi, newVi, typeFor, (Table)oldType, (Table)newType, body);
            }
        }
        if (!equalTypes) {
            this.createMessage(body, MessageCategory.INFO, 10, new String[]{oldType.getName()});
        }
    }

    private void compareElementaryTypes(VirtualInterface oldVi, VirtualInterface newVi, String typeFor, Elementary oldType, Elementary newType, Body body) {
    }

    private void compareStructureTypes(VirtualInterface oldVi, VirtualInterface newVi, String typeFor, Structure oldType, Structure newType, Body body, CycleDetector cycleDetector) {
        boolean fieldFound;
        if (cycleDetector.isInvolvedInCycle((Type)oldType)) {
            return;
        }
        cycleDetector.addType((Type)oldType);
        Field[] oldFields = oldType.getFields();
        Field[] newFields = newType.getFields();
        int i = 0;
        while (i < oldFields.length) {
            fieldFound = false;
            int j = 0;
            while (j < newFields.length) {
                if (oldFields[i].getFieldName().equals(newFields[j].getFieldName())) {
                    fieldFound = true;
                    this.compareFields(oldVi, newVi, typeFor, oldFields[i], newFields[j], oldType.getName(), body, cycleDetector);
                    j = newFields.length - 1;
                }
                ++j;
            }
            if (!fieldFound) {
                this.createMessage(body, MessageCategory.WARNING, 24, new String[]{oldFields[i].getFieldName(), oldType.getName()});
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < newFields.length) {
            fieldFound = false;
            int j = 0;
            while (j < oldFields.length) {
                if (newFields[i2].getFieldName().equals(oldFields[j].getFieldName())) {
                    fieldFound = true;
                    j = oldFields.length - 1;
                }
                ++j;
            }
            if (!fieldFound) {
                this.createMessage(body, MessageCategory.INFO, 25, new String[]{newFields[i2].getFieldName(), oldType.getName()});
            }
            ++i2;
        }
    }

    private void compareTableTypes(VirtualInterface oldVi, VirtualInterface newVi, String typeFor, Table oldType, Table newType, Body body) {
        this.compareTypes(oldVi, newVi, oldType.getName() + "' in '" + typeFor, oldType.getLineType().getName(), newType.getLineType().getName(), body, new CycleDetector());
    }

    private void compareFields(VirtualInterface oldVi, VirtualInterface newVi, String typeFor, Field oldField, Field newField, String structureName, Body body, CycleDetector cycleDetector) {
        if (!oldField.getFieldName().equals(newField.getFieldName())) {
            if (typeFor == null) {
                this.createMessage(body, MessageCategory.INFO, 12, new String[]{oldField.getFieldName(), structureName, newField.getFieldName()});
            } else {
                this.createMessage(body, MessageCategory.INFO, 11, new String[]{oldField.getFieldName(), structureName, typeFor, newField.getFieldName()});
            }
        }
        Vector<String> v = new Vector<String>(2);
        v.add(oldField.getFieldName());
        v.add(structureName);
        this.compareTypes(oldVi, newVi, ViUiTexts.getString("ViCheck.nameBuilding.InType", v), oldField.getTypeReference().getName(), newField.getTypeReference().getName(), body, cycleDetector);
    }

    private void countMessages(Header header, Body body) {
        int errorCount = 0;
        int warningCount = 0;
        int infoCount = 0;
        Message[] messages = body.getMessages();
        int i = 0;
        while (i < messages.length) {
            MessageCategory mc = messages[i].getCategory();
            if (mc == MessageCategory.ERROR) {
                ++errorCount;
            } else if (mc == MessageCategory.WARNING) {
                ++warningCount;
            } else if (mc == MessageCategory.INFO) {
                ++infoCount;
            }
            ++i;
        }
        MessageCount ec = null;
        MessageCount wc = null;
        MessageCount ic = null;
        try {
            ec = header.createMessageCount("Error messages");
            ec.setCategory(MessageCategory.ERROR);
            ec.setCounter(1);
            ec.setCounter(errorCount);
            wc = header.createMessageCount("Warning messages");
            wc.setCategory(MessageCategory.WARNING);
            wc.setCounter(1);
            wc.setCounter(warningCount);
            ic = header.createMessageCount("Info messages");
            ic.setCategory(MessageCategory.ERROR);
            ic.setCategory(MessageCategory.INFO);
            ic.setCounter(1);
            ic.setCounter(infoCount);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViCheck == null ? (class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : class$com$sap$ide$vi$check$ViCheck));
        }
    }

    private String replaceFirstPlaceHolder(String source, String replaceBy) {
        int pos = source.indexOf("&");
        if (pos > -1) {
            return source.substring(0, pos) + replaceBy + source.substring(pos + 1, source.length());
        }
        return source;
    }

    private String buildUpMessageText(int number, String[] args) {
        boolean i = false;
        if (number == 130) {
            return args[0];
        }
        String messageText = (String)messageTable.get(new Integer(number).toString());
        Vector<String> v = new Vector<String>(args.length);
        int j = 0;
        while (j < args.length) {
            v.add(args[j]);
            ++j;
        }
        return ViUiTexts.exchangeVariables(messageText, v);
    }

    private void createMessage(Object bodyObject, MessageCategory mc, int number, String[] args) throws CheckTypeException {
        if (bodyObject == null) {
            throw new CheckTypeException(this.buildUpMessageText(number, args));
        }
        Body body = (Body)bodyObject;
        this.createMessage(body, mc, number, args);
    }

    private void createMessage(Body body, MessageCategory mc, int number, String[] args) {
        try {
            String messageText = this.buildUpMessageText(number, args);
            int j = 0;
            while (j < body.getMessageCount()) {
                if (body.getMessage(j).getText().equals(messageText)) {
                    return;
                }
                ++j;
            }
            Message m = body.createMessage(new Integer(messageCounter++).toString());
            m.setNumber(number);
            m.setText(messageText);
            m.setCategory(MessageCategory.ERROR);
            m.setCategory(mc);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViCheck == null ? (class$com$sap$ide$vi$check$ViCheck = ViCheck.class$("com.sap.ide.vi.check.ViCheck")) : class$com$sap$ide$vi$check$ViCheck));
        }
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        messageCounter = 0;
    }
}

