/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.check;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.clipboard.PasteProcess;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.IllegalNamingException;
import com.sap.ide.metamodel.general.exception.IncompleteRefactoringInfoException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.vi.ComplexTypeReference;
import com.sap.ide.metamodel.vi.ConvertedTableReference;
import com.sap.ide.metamodel.vi.ConvertedTypeReference;
import com.sap.ide.metamodel.vi.Elementary;
import com.sap.ide.metamodel.vi.ElementaryTypeKinds;
import com.sap.ide.metamodel.vi.EndpointReference;
import com.sap.ide.metamodel.vi.Fault;
import com.sap.ide.metamodel.vi.Field;
import com.sap.ide.metamodel.vi.Function;
import com.sap.ide.metamodel.vi.InlineComplexTableReference;
import com.sap.ide.metamodel.vi.InlinePrimitiveTableReference;
import com.sap.ide.metamodel.vi.Parameter;
import com.sap.ide.metamodel.vi.SoapExtensionFunction;
import com.sap.ide.metamodel.vi.SoapExtensionParameter;
import com.sap.ide.metamodel.vi.SoapExtensionType;
import com.sap.ide.metamodel.vi.Structure;
import com.sap.ide.metamodel.vi.Table;
import com.sap.ide.metamodel.vi.Type;
import com.sap.ide.metamodel.vi.TypeReference;
import com.sap.ide.metamodel.vi.VirtualInterface;
import com.sap.ide.metamodel.vi.plugin.VIRootManager;
import com.sap.ide.vi.check.CycleDetector;
import com.sap.ide.vi.check.result.metamodel.CRRoot;
import com.sap.ide.vi.check.result.metamodel.CheckResult;
import com.sap.ide.vi.check.result.metamodel.plugin.CRRootManager;
import com.sap.ide.vi.endpoints.EndpointAnalyser;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.endpoints.NoDefaultConstructorException;
import com.sap.ide.vi.endpoints.NotSupportedJavaTypeException;
import com.sap.ide.vi.endpoints.SerializableNotImplementedException;
import com.sap.ide.vi.endpoints.VectorOccurenceException;
import com.sap.ide.vi.structure.Faults;
import com.sap.ide.vi.structure.InputParameters;
import com.sap.ide.vi.structure.OutputParameters;
import com.sap.ide.vi.types.Attribute;
import com.sap.ide.vi.types.Method;
import com.sap.ide.vi.types.MethodAttributes;
import com.sap.ide.vi.types.TypeAnalyser;
import com.sap.ide.vi.types.TypeInSourcePaths;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class ViBasics {
    public static final String REQUEST = "Request";
    public static final String RESPONSE = "Response";
    public static final String EMPTY_CONTENT = "";
    private static final String PARAMETER_NAME_RETURN = "Response";
    private static final String SEMICOLON = ";";
    private static final String DOT = ".";
    private static final String URN = "urn:";
    private static final String characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String numbers = "0123456789";
    private static final String allowedSymbols = "_-.%^&:/,";
    private static Fault deletedFault = null;
    private static Hashtable specialClasses = new Hashtable();
    private static HashSet analysedTypes;
    static /* synthetic */ Class class$com$sap$ide$vi$check$ViBasics;

    private static boolean isOverloaded(IMethod[] methods, IMethod method) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i] != method && methods[i].getElementName().equals(method.getElementName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String makeCapital(String source) {
        return source.substring(0, 1).toUpperCase() + source.substring(1, source.length());
    }

    private static String replaceAll(String source, String toBeReplaced, String replaceBy, boolean makeCapital) {
        int ind = source.indexOf(toBeReplaced);
        if (ind > -1) {
            String lastPart = source.substring(ind + toBeReplaced.length());
            if (makeCapital) {
                lastPart = ViBasics.makeCapital(lastPart);
            }
            source = source.substring(0, ind) + replaceBy + lastPart;
            source = ViBasics.replaceAll(source, toBeReplaced, replaceBy, makeCapital);
        }
        return source;
    }

    public static String getMethodNameWithSignature(IType type, IMethod method) {
        String methodSig = ViBasics.getMappedMethodName(type, method);
        try {
            methodSig = methodSig + " : " + TypeInSourcePaths.getResolvedType(method.getReturnType(), type, true);
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        return methodSig;
    }

    public static String getMappedMethodName(IType type, IMethod method) {
        String mappedName = method.getElementName();
        int n = method.getParameterTypes().length;
        if (n > 0) {
            mappedName = mappedName + "(";
        }
        int i = 0;
        while (i < n) {
            String resType = TypeInSourcePaths.getResolvedType(method.getParameterTypes()[i], type, true);
            if (i > 0) {
                mappedName = mappedName + ",";
            }
            mappedName = mappedName + resType;
            ++i;
        }
        if (n > 0) {
            mappedName = mappedName + ")";
        }
        return mappedName;
    }

    private static IMethod[] sortMethods(IMethod[] methods) {
        boolean changed = true;
        while (changed) {
            changed = false;
            int i = 0;
            while (i < methods.length - 1) {
                if (methods[i].getElementName().compareTo(methods[i + 1].getElementName()) > 0) {
                    IMethod intermediate = methods[i];
                    methods[i] = methods[i + 1];
                    methods[i + 1] = intermediate;
                    changed = true;
                }
                ++i;
            }
        }
        return methods;
    }

    private static boolean equalMethods(IMethod method1, IMethod method2) {
        if (!method1.getElementName().equals(method2.getElementName())) {
            return false;
        }
        try {
            int p1 = method1.getParameterNames().length;
            int p2 = method2.getParameterNames().length;
            if (p1 != p2) {
                return false;
            }
            int i = 0;
            while (i < p1) {
                if (!method1.getParameterNames()[i].equals(method2.getParameterNames()[i]) || !method1.getParameterTypes()[i].equals(method2.getParameterTypes()[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        return true;
    }

    private static boolean methodIsInSetOfCheckedMethods(IMethod method, IMethod[] methods) {
        int i = 0;
        while (i < methods.length) {
            if (ViBasics.equalMethods(method, methods[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean checkXMLElementName(String elementName, boolean metamodelCheck) {
        if (elementName == null || elementName.length() == 0) {
            return true;
        }
        String first = characters.concat("_");
        if (first.indexOf(elementName.substring(0, 1)) == -1) {
            return false;
        }
        String rest = characters.concat(numbers).concat(allowedSymbols);
        int i = 1;
        while (i < elementName.length()) {
            if (rest.indexOf(elementName.substring(i, i + 1)) == -1) {
                return false;
            }
            ++i;
        }
        if (metamodelCheck) {
            try {
                Metamodel.getNamingService().checkDevelopmentObjectName(elementName);
            }
            catch (IllegalNamingException e) {
                return false;
            }
            return true;
        }
        return true;
    }

    private static IMethod[] getPublicNoneConstructorMethods(IType type) throws JavaModelException {
        if (type != null) {
            IMethod[] allMethods = type.getMethods();
            Vector<IMethod> publicMethods = new Vector<IMethod>();
            if (type.isInterface()) {
                int i = 0;
                while (i < allMethods.length) {
                    if (type.isInterface()) {
                        publicMethods.add(allMethods[i]);
                    } else if (Flags.isPublic((int)allMethods[i].getFlags()) && !type.getElementName().equals(allMethods[i].getElementName())) {
                        publicMethods.add(allMethods[i]);
                    }
                    ++i;
                }
            }
            return publicMethods.toArray(new IMethod[publicMethods.size()]);
        }
        return new IMethod[0];
    }

    public static MethodAttributes[] buildUpMethodAttributeList(VirtualInterface tempVi, String projectName, IType type) {
        IMethod[] methods = null;
        try {
            methods = ViBasics.getPublicNoneConstructorMethods(type);
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        methods = ViBasics.sortMethods(methods);
        MethodAttributes[] returnValues = new MethodAttributes[methods.length];
        int i = 0;
        while (i < returnValues.length) {
            returnValues[i] = new MethodAttributes(true, methods[i], type);
            ++i;
        }
        int i2 = 0;
        while (i2 < returnValues.length) {
            try {
                ViBasics.fillMethodByIType(tempVi, projectName, returnValues[i2]);
            }
            catch (InadmissableTypeException e) {
                returnValues[i2].setForbidden(e);
            }
            ++i2;
        }
        return returnValues;
    }

    public static MethodAttributes[] buildUpMethodAttributeList(String tempViName, String projectName, IType type) {
        VirtualInterface tempVi = null;
        TypeAnalyser.clearAnalysedTypes();
        while (tempVi == null) {
            tempViName = "CopyOf_" + tempViName;
            try {
                tempVi = VIRootManager.getVIRoot((String)projectName).createVirtualInterface(EMPTY_CONTENT, tempViName);
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? ViBasics.class$("com.sap.ide.vi.check.ViBasics") : class$com$sap$ide$vi$check$ViBasics));
            }
        }
        MethodAttributes[] returnValues = ViBasics.buildUpMethodAttributeList(tempVi, projectName, type);
        if (tempVi == null) {
            try {
                tempVi = VIRootManager.getVIRoot((String)projectName).getVirtualInterface(EMPTY_CONTENT, tempViName);
            }
            catch (LoadException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
        }
        if (tempVi != null) {
            try {
                CRRoot root = CRRootManager.getCRRoot(projectName);
                CheckResult cr = null;
                try {
                    if (root.hasCheckResult(tempVi.getPackage(), tempVi.getName())) {
                        cr = root.getCheckResult(tempVi.getPackage(), tempVi.getName());
                    }
                }
                catch (LoadException e) {
                    WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
                }
                tempVi.delete();
                if (cr != null) {
                    cr.delete();
                }
            }
            catch (DeleteException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
        }
        return returnValues;
    }

    public static void fillMetaDataByIType(VirtualInterface virtualInterface, String projectName, IType type, MethodAttributes[] incomingMethods) throws InadmissableTypeException {
        try {
            virtualInterface.createSoapExtensionVI();
        }
        catch (CreateException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        EndpointReference ref = virtualInterface.getEndpointReference();
        TypeAnalyser analyser = TypeAnalyser.getInstance(projectName, EndpointAnalyser.getEndPointName(ref), 0);
        if (analyser == null) {
            return;
        }
        if (analyser.parameterFullConstructorExisting() && !analyser.parameterLessConstructorExisting()) {
            throw new NoDefaultConstructorException(type.getElementName());
        }
        int i = 0;
        while (i < incomingMethods.length) {
            if (incomingMethods[i].isToBeContained()) {
                ViBasics.fillMethodByIType(virtualInterface, projectName, incomingMethods[i]);
            }
            ++i;
        }
    }

    private static String converMethodName(String methodName) {
        return methodName.replace('(', '_').replace(')', '_').replace('[', '_').replace(']', '_');
    }

    public static void fillMethodByIType(VirtualInterface virtualInterface, String projectName, MethodAttributes method) throws InadmissableTypeException {
        TypeAnalyser.clearAnalysedTypes();
        if (method.isForbidden() || !method.isToBeContained()) {
            return;
        }
        String typeName = null;
        String methodName = method.getMethod().getElementName();
        Function function = null;
        try {
            function = virtualInterface.createFunction(method.getNameWithSignature());
            function.setOriginalName(methodName);
            String convertedMethodName = ViBasics.converMethodName(method.getName());
            function.setNameMappedTo(convertedMethodName);
            SoapExtensionFunction soapFunction = function.createSoapExtensionFunction();
            soapFunction.setSOAPRequestName(convertedMethodName);
            soapFunction.setSOAPResponseName(convertedMethodName + "Response");
            soapFunction.setNamespace(URN + virtualInterface.getName());
            String[] parameterNames = method.getMethod().getParameterNames();
            typeName = TypeInSourcePaths.getResolvedType(method.getMethod().getReturnType(), method.getType(), true);
        }
        catch (CreateException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        if (!TypeAnalyser.isVoidType(typeName)) {
            Parameter outParameter = null;
            try {
                outParameter = function.createOutgoingParameter("Response");
                outParameter.setNameMappedTo("Response");
                SoapExtensionParameter sep = outParameter.createSoapExtensionParameter();
                sep.setIsHeader(false);
            }
            catch (CreateException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
            outParameter.setNameMappedTo("Response");
            ViBasics.createTypeReferenceForDO(virtualInterface, projectName, typeName, typeName, (DevelopmentObject)outParameter);
            outParameter.setIsExposed(ViBasics.isToShow(virtualInterface, outParameter));
            outParameter.setIsOptional(false);
        }
        int j = 0;
        while (j < method.getMethod().getNumberOfParameters()) {
            Parameter inParameter = null;
            try {
                inParameter = function.createIncomingParameter(method.getMethod().getParameterNames()[j]);
                inParameter.setNameMappedTo(method.getMethod().getParameterNames()[j]);
                SoapExtensionParameter sep = inParameter.createSoapExtensionParameter();
                sep.setIsHeader(false);
            }
            catch (CreateException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? ViBasics.class$("com.sap.ide.vi.check.ViBasics") : class$com$sap$ide$vi$check$ViBasics));
            }
            catch (JavaModelException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? ViBasics.class$("com.sap.ide.vi.check.ViBasics") : class$com$sap$ide$vi$check$ViBasics));
            }
            typeName = TypeInSourcePaths.getResolvedType(method.getMethod().getParameterTypes()[j], method.getType(), true);
            ViBasics.createTypeReferenceForDO(virtualInterface, projectName, typeName, typeName, (DevelopmentObject)inParameter);
            inParameter.setIsExposed(ViBasics.isToShow(virtualInterface, inParameter));
            inParameter.setIsOptional(false);
            ++j;
        }
        String[] exceptions = null;
        try {
            exceptions = method.getMethod().getExceptionTypes();
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        int j2 = 0;
        while (j2 < exceptions.length) {
            TypeAnalyser analyser;
            if (exceptions[j2] != null && (analyser = TypeAnalyser.getInstance(projectName, typeName = TypeInSourcePaths.getResolvedType(exceptions[j2], method.getType(), true), 1)) != null && !analyser.isForbidden(true)) {
                Fault fault = (Fault)ViBasics.createTypeReferenceForDO(virtualInterface, projectName, typeName, typeName, (DevelopmentObject)function);
                fault.setDescription(EMPTY_CONTENT);
            }
            ++j2;
        }
        function.setIsExposed(true);
    }

    public static TypeAnalyser getTypeAnalyser(String projectName, String qualifiedType) throws InadmissableTypeException {
        TypeAnalyser analyser = TypeAnalyser.getInstance(projectName, qualifiedType, 1);
        if (analyser != null && !analyser.isJavaPrimitiveType()) {
            return analyser;
        }
        return null;
    }

    private static int createLineTypeForConvertableTableType(String qualifiedTypeName, String originalTypeName, ConvertedTableReference containingObject) {
        if (TypeAnalyser.isTableType(qualifiedTypeName)) {
            return ViBasics.createLineTypeForConvertableTableType(TypeAnalyser.getLineType(qualifiedTypeName), TypeAnalyser.getLineType(originalTypeName), containingObject) + 1;
        }
        try {
            ConvertedTypeReference ref = containingObject.createLineType(qualifiedTypeName);
            ref.setOriginalType(originalTypeName);
            ref.createSoapExtensionConvertedTypeRef().setIsAttribute(false);
        }
        catch (CreateException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        return 0;
    }

    public static DevelopmentObject createTypeReferenceForDO(VirtualInterface virtualInterface, String projectName, String qualifiedTypeName, String originalTypeName, DevelopmentObject containingObject) throws InadmissableTypeException {
        TypeAnalyser analyser;
        boolean isAbstract = false;
        if (projectName != null && (analyser = TypeAnalyser.getInstance(projectName, qualifiedTypeName, 1)) != null) {
            isAbstract = analyser.isAbstract();
        }
        return ViBasics.createTypeReferenceForDO(virtualInterface, projectName, qualifiedTypeName, isAbstract, originalTypeName, containingObject);
    }

    public static DevelopmentObject createTypeReferenceForDO(VirtualInterface virtualInterface, String projectName, String qualifiedTypeName, boolean isAbstract, String originalTypeName, DevelopmentObject containingObject) throws InadmissableTypeException {
        if (TypeAnalyser.isConvertableType(originalTypeName)) {
            try {
                Object ctr = null;
                if (containingObject instanceof Parameter) {
                    ctr = TypeAnalyser.isTableType(qualifiedTypeName) ? ((Parameter)containingObject).createMappedTypeReferenceAsConvertedTableReference(qualifiedTypeName) : ((Parameter)containingObject).createMappedTypeReferenceAsConvertedTypeReference(qualifiedTypeName);
                } else if (containingObject instanceof Field) {
                    ctr = TypeAnalyser.isTableType(qualifiedTypeName) ? ((Field)containingObject).createTypeReferenceAsConvertedTableReference(qualifiedTypeName) : ((Field)containingObject).createTypeReferenceAsConvertedTypeReference(qualifiedTypeName);
                } else if (containingObject instanceof Table) {
                    ctr = TypeAnalyser.isTableType(qualifiedTypeName) ? ((Table)containingObject).createLineTypeAsConvertedTableReference(qualifiedTypeName) : ((Table)containingObject).createLineTypeAsConvertedTypeReference(qualifiedTypeName);
                }
                if (ctr instanceof ConvertedTypeReference) {
                    ((ConvertedTypeReference)ctr).setOriginalType(originalTypeName);
                    ((ConvertedTypeReference)ctr).createSoapExtensionConvertedTypeRef().setIsAttribute(false);
                } else if (ctr instanceof ConvertedTableReference) {
                    int dim = ViBasics.createLineTypeForConvertableTableType(qualifiedTypeName, originalTypeName, ctr);
                    ctr.setDimension(dim);
                }
                return ctr;
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
        } else {
            if (!virtualInterface.hasType(qualifiedTypeName) && !TypeAnalyser.isVoidType(qualifiedTypeName)) {
                String tempQualifiedTypeName = qualifiedTypeName;
                String tempOriginalTypeName = originalTypeName;
                if (projectName == null) {
                    ViBasics.copyTypeIntoTypeHierarchy(virtualInterface, tempQualifiedTypeName, tempOriginalTypeName);
                } else {
                    ViBasics.createTypeIntoTypeHierarchy(virtualInterface, projectName, tempQualifiedTypeName, isAbstract, tempOriginalTypeName, containingObject);
                }
            }
            try {
                if (containingObject instanceof Parameter) {
                    return ((Parameter)containingObject).createMappedTypeReferenceAsComplexTypeReference(qualifiedTypeName);
                }
                if (containingObject instanceof Function) {
                    return ((Function)containingObject).createFault(qualifiedTypeName);
                }
                if (containingObject instanceof Field) {
                    return ((Field)containingObject).createTypeReferenceAsComplexTypeReference(qualifiedTypeName);
                }
                if (containingObject instanceof Table) {
                    return ((Table)containingObject).createLineTypeAsComplexTypeReference(qualifiedTypeName);
                }
                if (containingObject instanceof Type) {
                    Type type = virtualInterface.getType(qualifiedTypeName);
                    return type;
                }
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
        }
        return null;
    }

    private static final void copyTypeIntoTypeHierarchy(VirtualInterface virtualInterface, String typeName, String originalTypeName) {
        if (originalTypeName.equals(typeName)) {
            return;
        }
        Type oldType = virtualInterface.getType(originalTypeName);
        MetamodelClipboard clipBoard = Metamodel.createInternalClipboard();
        clipBoard.copy((DevelopmentObject)oldType);
        PasteProcess pp = clipBoard.initiatePaste((MetamodelObject)virtualInterface);
        pp.getObjectsToRefactor()[0].setNewName(typeName);
        try {
            pp.execute();
        }
        catch (CreateException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
        catch (IncompleteRefactoringInfoException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
    }

    private static final Vector getAttributesBySetterGetter(Vector methods) {
        int j;
        Vector<Attribute> resultVector = new Vector<Attribute>();
        if (methods != null) {
            int i = 0;
            while (i < methods.size()) {
                Method getter = (Method)methods.elementAt(i);
                if (getter.isGetter()) {
                    String toGet = getter.getterGetsWhat(false);
                    j = 0;
                    while (j < methods.size()) {
                        Method setter = (Method)methods.elementAt(j);
                        if (setter.isSetterFor(toGet, getter.getType()) && getter.getHarbour().equals(setter.getHarbour())) {
                            resultVector.add(new Attribute(getter.getterGetsWhat(true), getter.getType(), getter.getFlags(), getter.getReturnTypeArrayDimension() > 0, getter.getReturnTypeArrayDimension(), getter.getHarbour()));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < resultVector.size()) {
            Attribute attribute1 = (Attribute)resultVector.elementAt(i);
            j = i + 1;
            while (j < resultVector.size()) {
                if (attribute1.getName().equals(((Attribute)resultVector.elementAt(j)).getName())) {
                    resultVector.remove(j);
                }
                ++j;
            }
            ++i;
        }
        return resultVector;
    }

    public static boolean isAllowedJavaType(String typeName) {
        return specialClasses.containsKey(typeName);
    }

    private static final void createSuperTypeIntoTypeHierarchy(VirtualInterface virtualInterface, String projectName, TypeAnalyser ta) throws InadmissableTypeException {
        if (ta != null) {
            ViBasics.createTypeIntoTypeHierarchy(virtualInterface, projectName, ta.getAnalysedTypeName(), ta.isAbstract(), ta.getAnalysedTypeName(), null);
        }
    }

    public static final void createTypeIntoTypeHierarchy(VirtualInterface virtualInterface, String projectName, String typeName, boolean isAbstractType, String originalTypeName, DevelopmentObject containingObject) throws InadmissableTypeException {
        if (virtualInterface.hasType(typeName)) {
            return;
        }
        Elementary newType = null;
        try {
            if (!typeName.equals("java.lang.Object") && !virtualInterface.hasType("java.lang.Object")) {
                ViBasics.createTypeIntoTypeHierarchy(virtualInterface, projectName, "java.lang.Object", false, "java.lang.Object", null);
            }
            if (specialClasses.containsKey(typeName)) {
                newType = virtualInterface.createTypeAsElementary(typeName);
                newType.setKind(ElementaryTypeKinds.JAVA_TYPE);
            } else {
                Vector attributes = new Vector();
                Vector methods = new Vector();
                Vector<Attribute> publicAttributes = new Vector<Attribute>();
                TypeAnalyser analyser = ViBasics.getTypeAnalyser(projectName, typeName);
                if (analyser != null && !TypeAnalyser.isTableType(typeName)) {
                    ViBasics.createSuperTypeIntoTypeHierarchy(virtualInterface, projectName, analyser.getParentType());
                    attributes = analyser.getAttributes();
                    attributes.addAll(ViBasics.getAttributesBySetterGetter(analyser.getMethods()));
                    if (attributes != null) {
                        int i = 0;
                        while (i < attributes.size()) {
                            Attribute att = (Attribute)attributes.elementAt(i);
                            if (att.getName() != null && att.getName().length() != 0 && att.getType() != null && att.getType().length() != 0 && att.isPublicMember()) {
                                publicAttributes.add(att);
                            }
                            ++i;
                        }
                    }
                }
                if (publicAttributes.size() == 0) {
                    if (TypeAnalyser.isTableType(typeName)) {
                        newType = virtualInterface.createTypeAsTable(typeName);
                        ((Table)newType).createSoapExtensionTable();
                        String lineType = typeName.substring(0, typeName.length() - 2);
                        ViBasics.createTypeReferenceForDO(virtualInterface, projectName, lineType, lineType, (DevelopmentObject)newType);
                    } else {
                        newType = virtualInterface.createTypeAsElementary(typeName);
                        newType.setKind(ElementaryTypeKinds.JAVA_TYPE);
                    }
                } else {
                    newType = virtualInterface.createTypeAsStructure(typeName);
                    Hashtable<String, String> createdAttributes = new Hashtable<String, String>();
                    int i = 0;
                    while (i < publicAttributes.size()) {
                        Attribute att = (Attribute)publicAttributes.elementAt(i);
                        if (!createdAttributes.containsKey(att.getName())) {
                            String qTypeNameWithArrayBrackets = att.getType();
                            if (att.isArray() && att.getDimension() > 0) {
                                int j = 0;
                                while (j < att.getDimension()) {
                                    qTypeNameWithArrayBrackets = qTypeNameWithArrayBrackets + "[]";
                                    ++j;
                                }
                            }
                            if (analyser.isInterface() && (analyser.getParentType() == null || analyser.getParentType().getAnalysedTypeName().equals("java.lang.Object")) || !ViBasics.doesFieldExistInParentInterface(analyser.getParentType(), virtualInterface, att.getName())) {
                                Field field = ((Structure)newType).createField(new Integer(i).toString());
                                field.setFieldName(att.getName());
                                ViBasics.createTypeReferenceForDO(virtualInterface, projectName, qTypeNameWithArrayBrackets, qTypeNameWithArrayBrackets, (DevelopmentObject)field);
                                createdAttributes.put(att.getName(), EMPTY_CONTENT);
                            }
                        }
                        ++i;
                    }
                    ((Structure)newType).createSoapExtensionStructure();
                }
                if (!TypeAnalyser.isTableType(typeName)) {
                    if (analyser.getParentType() != null) {
                        newType.setParentTypeName(analyser.getParentType().getAnalysedTypeName());
                    } else {
                        newType.setParentTypeName("java.lang.Object");
                    }
                }
            }
            if (containingObject instanceof Function) {
                newType.createOriginalAsFault(originalTypeName);
            } else {
                newType.createOriginalAsComplexTypeReference(originalTypeName);
            }
            if (isAbstractType) {
                newType.setIsAbstract(isAbstractType);
            }
            SoapExtensionType set = newType.createSoapExtensionType();
            if (newType.getName().indexOf(DOT) > -1) {
                set.setNamespace(URN + newType.getName().substring(0, newType.getName().lastIndexOf(DOT)));
                if (newType instanceof Table) {
                    set.setLocalname(ViBasics.createLocalNameForTableType(newType.getName().substring(newType.getName().lastIndexOf(DOT) + 1)));
                } else {
                    set.setLocalname(newType.getName().substring(newType.getName().lastIndexOf(DOT) + 1));
                }
            } else {
                set.setNamespace(URN);
                if (newType instanceof Table) {
                    set.setLocalname(ViBasics.createLocalNameForTableType(newType.getName()));
                } else {
                    set.setLocalname(newType.getName());
                }
            }
        }
        catch (Throwable e) {
            if (newType != null) {
                try {
                    newType.delete();
                }
                catch (DeleteException ex) {
                    WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
                }
            }
            if (e instanceof SerializableNotImplementedException) {
                throw (SerializableNotImplementedException)e;
            }
            if (e instanceof VectorOccurenceException) {
                throw (VectorOccurenceException)e;
            }
            if (e instanceof NotSupportedJavaTypeException) {
                throw (NotSupportedJavaTypeException)e;
            }
            if (!(e instanceof CreateException)) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
        }
    }

    private static String createLocalNameForTableType(String name) {
        String typeName = name.substring(0, name.indexOf("[]"));
        int dimension = 0;
        while (name.endsWith("[]")) {
            ++dimension;
            name = name.substring(0, name.lastIndexOf("[]"));
        }
        if (dimension == 1) {
            return "ArrayOf" + typeName;
        }
        return "ArrayOf" + typeName + dimension + "D";
    }

    private static boolean doesFieldExistInParentInterface(TypeAnalyser analyser, VirtualInterface virtualInterface, String fieldName) throws InadmissableTypeException {
        if (analyser == null) {
            return false;
        }
        if (analyser.getParentType() != null && ViBasics.doesFieldExistInParentInterface(analyser.getParentType(), virtualInterface, fieldName)) {
            return true;
        }
        boolean attributeExistsInSuperInterface = false;
        Type type = virtualInterface.getType(analyser.getAnalysedTypeName());
        if (type instanceof Structure) {
            int k = 0;
            while (k < ((Structure)type).getFieldCount()) {
                Field field = ((Structure)type).getField(k);
                if (field.getFieldName().equals(fieldName)) {
                    attributeExistsInSuperInterface = true;
                    break;
                }
                ++k;
            }
        }
        return attributeExistsInSuperInterface;
    }

    public static boolean isToShow(VirtualInterface virtualInterface, Object devObj) {
        if (devObj instanceof Function) {
            return true;
        }
        if (devObj instanceof Parameter) {
            return ViBasics.isToShow(virtualInterface, (Parameter)devObj);
        }
        if (devObj instanceof Fault) {
            return ViBasics.isToShow((Fault)devObj);
        }
        if (devObj instanceof InputParameters) {
            return ViBasics.isToShow(virtualInterface, ((InputParameters)devObj).getParameters());
        }
        if (devObj instanceof OutputParameters) {
            return ViBasics.isToShow(virtualInterface, ((OutputParameters)devObj).getParameters());
        }
        if (devObj instanceof Faults) {
            return ViBasics.isToShow(virtualInterface, ((Faults)devObj).getFaults());
        }
        return false;
    }

    public static boolean isToShow(VirtualInterface virtualInterface, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (ViBasics.isToShow(virtualInterface, objects[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isToShow(VirtualInterface virtualInterface, Parameter parameter) {
        return !TypeAnalyser.isVoidType(ViBasics.getOriginalTypeforParameter(virtualInterface, parameter));
    }

    public static boolean isToShow(VirtualInterface virtualInterface, Fault fault) {
        return ViBasics.isToShow(fault);
    }

    public static boolean isToShow(Fault fault) {
        return true;
    }

    public static String getOriginalTypeforParameter(VirtualInterface virtualInterface, Parameter parameter) {
        String mappedType = parameter.getMappedTypeReference().getName();
        if (TypeAnalyser.isConvertableType(mappedType)) {
            if (TypeAnalyser.isTableType(mappedType)) {
                int dim;
                String originalType;
                if (parameter.getMappedTypeReference() instanceof ConvertedTableReference) {
                    originalType = ((ConvertedTableReference)parameter.getMappedTypeReference()).getLineType().getOriginalType();
                    dim = ((ConvertedTableReference)parameter.getMappedTypeReference()).getDimension();
                } else {
                    originalType = ((InlinePrimitiveTableReference)parameter.getMappedTypeReference()).getLineType();
                    dim = ((InlinePrimitiveTableReference)parameter.getMappedTypeReference()).getDimension();
                }
                int i = 0;
                while (i < dim) {
                    originalType = originalType + "[]";
                    ++i;
                }
                return originalType;
            }
            return ((ConvertedTypeReference)parameter.getMappedTypeReference()).getOriginalType();
        }
        return ViBasics.getOriginalType(virtualInterface, mappedType);
    }

    public static String getOriginalType(VirtualInterface virtualInterface, String mappedType) {
        if (TypeAnalyser.isVoidType(mappedType)) {
            return mappedType;
        }
        return virtualInterface.getType(mappedType).getOriginal().getName();
    }

    public static final DevelopmentObject deleteTypeReference(VirtualInterface virtualInterface, DevelopmentObject containingObject, String typeName, String originalTypeName) {
        TypeReference objectToBeDeleted = null;
        if (containingObject instanceof Parameter && ((Parameter)containingObject).hasMappedTypeReference()) {
            try {
                objectToBeDeleted = ((Parameter)containingObject).getMappedTypeReference();
                objectToBeDeleted.delete();
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
        }
        if (containingObject instanceof Function && ((Function)containingObject).hasFault(typeName)) {
            try {
                objectToBeDeleted = ((Function)containingObject).getFault(typeName);
                objectToBeDeleted.delete();
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
        }
        if (!TypeAnalyser.isConvertableType(originalTypeName)) {
            ViBasics.deleteTypeFromTypeHierarchy(virtualInterface, containingObject, typeName, originalTypeName);
        }
        return objectToBeDeleted;
    }

    public static void deleteAllPossibleTypes(VirtualInterface virtualInterface, Function function) throws DeleteException {
        HashSet<Type> objectsToDelete = new HashSet<Type>();
        HashSet<Type> objectsToDelete2 = new HashSet<Type>();
        int i = 0;
        while (i < virtualInterface.getTypeCount()) {
            HashSet dos;
            Type t = virtualInterface.getTypes()[i];
            if (!t.getName().equals("java.lang.Object") && (dos = ViBasics.getAllFunctionsWithTypeReference(virtualInterface, t.getName())).size() == 1 && ((AbstractCollection)dos).toArray(new Function[1])[0] == function) {
                objectsToDelete.add(t);
            }
            ++i;
        }
        Type[] delArray = ((AbstractCollection)objectsToDelete).toArray(new Type[objectsToDelete.size()]);
        if (objectsToDelete.size() > 0) {
            int i2 = 0;
            while (i2 < virtualInterface.getTypeCount()) {
                Type t = virtualInterface.getTypes()[i2];
                int j = 0;
                while (j < delArray.length) {
                    HashSet dos;
                    if (t.getParentTypeName() != null && t.getParentTypeName().equals(delArray[j].getName()) && (dos = ViBasics.getAllFunctionsWithTypeReference(virtualInterface, t.getName())).size() == 0) {
                        objectsToDelete2.add(virtualInterface.getTypes()[i2]);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < delArray.length) {
            delArray[i3].delete();
            ++i3;
        }
        Type[] delArray2 = ((AbstractCollection)objectsToDelete2).toArray(new Type[objectsToDelete2.size()]);
        int i4 = 0;
        while (i4 < delArray2.length) {
            delArray2[i4].delete();
            ++i4;
        }
    }

    public static boolean isMappedTypeDeletable(VirtualInterface virtualInterface, DevelopmentObject containingObject, String mappedTypeName, String originalTypeName) {
        if (originalTypeName != null && (mappedTypeName.equals(originalTypeName) || ViBasics.isOriginalType(virtualInterface, mappedTypeName))) {
            return false;
        }
        HashSet dos = ViBasics.getAllFunctionsWithTypeReference(virtualInterface, mappedTypeName);
        return dos.size() == 0 || dos.size() == 1 && ((AbstractCollection)dos).toArray(new Function[1])[0] == containingObject;
    }

    public static boolean isMappedTypeStillInUse(VirtualInterface virtualInterface, String typeName) {
        return true;
    }

    public static final void deleteTypeFromTypeHierarchy(VirtualInterface virtualInterface, DevelopmentObject containingObject, String typeName, String originalTypeName) {
        if (ViBasics.isMappedTypeDeletable(virtualInterface, containingObject, typeName, originalTypeName)) {
            Type typeToBeDeleted = virtualInterface.getType(typeName);
            if (typeToBeDeleted == null) {
                return;
            }
            try {
                typeToBeDeleted.delete();
                System.out.println("type deleted: " + typeName);
            }
            catch (Exception e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ViBasics == null ? (class$com$sap$ide$vi$check$ViBasics = ViBasics.class$("com.sap.ide.vi.check.ViBasics")) : class$com$sap$ide$vi$check$ViBasics));
            }
            ViBasics.cleanUpTypeHierarchy(virtualInterface);
        }
    }

    private static final void cleanUpTypeHierarchy(VirtualInterface virtualInterface) {
        int i = 0;
        while (i < virtualInterface.getTypeCount()) {
            String parentName = virtualInterface.getTypes()[i].getParentTypeName();
            if (parentName != null && !virtualInterface.hasType(parentName)) {
                ViBasics.deleteTypeFromTypeHierarchy(virtualInterface, null, virtualInterface.getTypes()[i].getName(), null);
                return;
            }
            ++i;
        }
    }

    private static boolean isOriginalType(VirtualInterface virtualInterface, String typeName) {
        return virtualInterface.hasType(typeName) && virtualInterface.getType(typeName).getOriginal().getName().equals(typeName);
    }

    private static HashSet getAllFunctionsWithTypeReference(VirtualInterface vi, String typeName) {
        HashSet set = new HashSet();
        int i = 0;
        while (i < vi.getFunctionCount()) {
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, vi.getFunctions()[i], typeName));
            ++i;
        }
        return set;
    }

    private static HashSet getAllFunctionsWithTypeReference(VirtualInterface vi, Function fun, String typeName) {
        HashSet set = new HashSet();
        int i = 0;
        while (i < fun.getIncomingParameterCount()) {
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, fun.getIncomingParameters()[i].getMappedTypeReference(), typeName, fun, new CycleDetector()));
            ++i;
        }
        int i2 = 0;
        while (i2 < fun.getOutgoingParameterCount()) {
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, fun.getOutgoingParameters()[i2].getMappedTypeReference(), typeName, fun, new CycleDetector()));
            ++i2;
        }
        int i3 = 0;
        while (i3 < fun.getFaultCount()) {
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, (TypeReference)fun.getFaults()[i3], typeName, fun, new CycleDetector()));
            ++i3;
        }
        return set;
    }

    private static HashSet getAllFunctionsWithTypeReference(VirtualInterface vi, TypeReference typeRef, String typeName, Function fun, CycleDetector cycleDetector) {
        HashSet<Function> set = new HashSet<Function>();
        if (typeRef != null && typeRef.getName().equals(typeName)) {
            set.add(fun);
            return set;
        }
        if (typeRef instanceof ComplexTypeReference) {
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, vi.getType(typeRef.getName()), typeName, fun, cycleDetector));
        } else if (typeRef instanceof InlineComplexTableReference) {
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, vi.getType(typeRef.getName()), typeName, fun, cycleDetector));
        } else if (typeRef.getName().startsWith(typeName) && TypeAnalyser.isTableType(typeRef.getName())) {
            String lineType = TypeAnalyser.getLineType(typeRef.getName());
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, vi.getType(lineType), lineType, fun, cycleDetector));
        }
        return set;
    }

    private static HashSet getAllFunctionsWithTypeReference(VirtualInterface vi, Type type, String typeName, Function fun, CycleDetector cycleDetector) {
        String parentName;
        HashSet<Function> set = new HashSet<Function>();
        if (type != null && type.getName().equals(typeName)) {
            set.add(fun);
            return set;
        }
        if (cycleDetector.isInvolvedInCycle(type)) {
            set.add(fun);
            return set;
        }
        cycleDetector.addType(type);
        if (type instanceof Structure) {
            Structure struct = (Structure)type;
            int i = 0;
            while (i < struct.getFieldCount()) {
                Field field = struct.getFields()[i];
                if (field != null) {
                    set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, field.getTypeReference(), typeName, fun, cycleDetector));
                }
                ++i;
            }
        }
        if (type instanceof Table) {
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, ((Table)type).getLineType(), typeName, fun, cycleDetector));
        }
        if ((parentName = type.getParentTypeName()) != null && vi.hasType(parentName)) {
            set.addAll(ViBasics.getAllFunctionsWithTypeReference(vi, vi.getType(parentName), typeName, fun, cycleDetector));
        }
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        specialClasses.put("java.util.Calendar", EMPTY_CONTENT);
        specialClasses.put("java.util.Date", EMPTY_CONTENT);
        specialClasses.put("java.util.GregorianCalendar", EMPTY_CONTENT);
        specialClasses.put("java.util.ArrayList", EMPTY_CONTENT);
        specialClasses.put("java.util.HashSet", EMPTY_CONTENT);
        specialClasses.put("java.util.LinkedList", EMPTY_CONTENT);
        specialClasses.put("java.util.List", EMPTY_CONTENT);
        specialClasses.put("java.util.Stack", EMPTY_CONTENT);
        specialClasses.put("java.util.Vector", EMPTY_CONTENT);
        specialClasses.put("java.math.BigDecimal", EMPTY_CONTENT);
        specialClasses.put("java.math.BigInteger", EMPTY_CONTENT);
        specialClasses.put("java.lang.Object", EMPTY_CONTENT);
        specialClasses.put("java.lang.String", EMPTY_CONTENT);
        specialClasses.put("java.lang.Boolean", EMPTY_CONTENT);
        specialClasses.put("java.lang.Integer", EMPTY_CONTENT);
        specialClasses.put("java.lang.Character", EMPTY_CONTENT);
        specialClasses.put("java.lang.Float", EMPTY_CONTENT);
        specialClasses.put("java.lang.Byte", EMPTY_CONTENT);
        specialClasses.put("java.lang.Double", EMPTY_CONTENT);
        specialClasses.put("java.lang.Long", EMPTY_CONTENT);
        specialClasses.put("java.lang.Short", EMPTY_CONTENT);
        specialClasses.put("java.lang.Void", EMPTY_CONTENT);
        specialClasses.put("java.rmi.RemoteException", EMPTY_CONTENT);
        specialClasses.put("java.lang.Exception", EMPTY_CONTENT);
        specialClasses.put("java.lang.Throwable", EMPTY_CONTENT);
        specialClasses.put("java.io.Serializable", EMPTY_CONTENT);
        specialClasses.put("java.lang.Cloneable", EMPTY_CONTENT);
        specialClasses.put("java.lang.Comparable", EMPTY_CONTENT);
        analysedTypes = new HashSet();
    }
}

