/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.check;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class ProjectBuilderHandler {
    public static final String BUILDER_ID_WS = "com.sap.ide.ws.wsbuilder";
    static /* synthetic */ Class class$com$sap$ide$vi$check$ProjectBuilderHandler;

    public static void addWsBuilder(IProject project) throws CoreException {
        ProjectBuilderHandler.addBuilder(project, BUILDER_ID_WS);
    }

    public static void addBuilder(IProject project, String id) throws CoreException {
        if (!ProjectBuilderHandler.isAutoConsistencyCheckBuilderEnabled(project, id)) {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            ICommand command = description.newCommand();
            command.setBuilderName(id);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[newCommands.length - 1] = command;
            ProjectBuilderHandler.setProjectDescription(project, description, newCommands);
        }
    }

    public static void removeBuilder(IProject project, String id) throws CoreException {
        if (ProjectBuilderHandler.isAutoConsistencyCheckBuilderEnabled(project, id)) {
            ArrayList<ICommand> commsList = new ArrayList<ICommand>();
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                commsList.add(i, commands[i]);
                ++i;
            }
            ((AbstractCollection)commsList).remove(ProjectBuilderHandler.getAutoTestingBuilder(project, id));
            ProjectBuilderHandler.setProjectDescription(project, description, commsList.toArray(new ICommand[commands.length - 1]));
        }
    }

    public static void refresh(IProject project) {
        Workspace ws = (Workspace)project.getWorkspace();
        boolean isLocked = ws.isTreeLocked();
        if (isLocked) {
            ws.setTreeLocked(false);
        }
        new WsRefreshAction().refresh(project.getName());
        if (isLocked) {
            ws.setTreeLocked(isLocked);
        }
    }

    private static void setProjectDescription(IProject project, IProjectDescription description, ICommand[] commands) {
        Workspace ws = (Workspace)project.getWorkspace();
        boolean isLocked = ws.isTreeLocked();
        if (isLocked) {
            ws.setTreeLocked(false);
        }
        description.setBuildSpec(commands);
        try {
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$check$ProjectBuilderHandler == null ? (class$com$sap$ide$vi$check$ProjectBuilderHandler = ProjectBuilderHandler.class$("com.sap.ide.vi.check.ProjectBuilderHandler")) : class$com$sap$ide$vi$check$ProjectBuilderHandler));
        }
        if (isLocked) {
            ws.setTreeLocked(isLocked);
        }
    }

    public static boolean isAutoConsistencyCheckBuilderEnabled(IProject project, String id) {
        try {
            IProjectDescription description = project.getDescription();
            List<ICommand> commands = Arrays.asList(description.getBuildSpec());
            return commands.contains(ProjectBuilderHandler.getAutoTestingBuilder(project, id));
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static ICommand getAutoTestingBuilder(IProject project, String id) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand command = description.newCommand();
        command.setBuilderName(id);
        return command;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

