/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.repository.generation;

import com.sap.tc.webdynpro.basesrvc.util.SAPStringBuffer;
import com.sap.tc.webdynpro.basesrvc.util.StringUtil;
import com.sap.tc.webdynpro.repository.FileMROLocatorAdapter;
import com.sap.tc.webdynpro.repository.IMROInstanceInfo;
import com.sap.tc.webdynpro.repository.RepositoryRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class RepositoryGenerationMROLocator
extends FileMROLocatorAdapter {
    private final String mroName;
    private final String mroType;
    private final OutputStream stream;
    private final String rootPath;
    private final String[] additionalPaths;
    private static final String FILE_EXTENSION = "xml";
    private static final Map directory = new HashMap();

    public RepositoryGenerationMROLocator(String mroName, String mroType, OutputStream mroStream, String rootPath, String[] additionalPaths) {
        this.mroName = mroName;
        this.mroType = mroType;
        this.stream = mroStream;
        this.rootPath = rootPath;
        this.additionalPaths = additionalPaths;
    }

    public static String getPathExtension(String mroName, String mroType) {
        SAPStringBuffer pathB = new SAPStringBuffer();
        pathB.append(File.separatorChar);
        pathB.append(directory.get(mroType));
        pathB.append(File.separatorChar);
        pathB.append(mroName);
        pathB.append(File.separatorChar);
        pathB.append(StringUtil.getUnqualifiedClassName((String)mroName));
        pathB.append('.');
        pathB.append(FILE_EXTENSION);
        return pathB.toString();
    }

    protected String getPathToLanguageResource(IMROInstanceInfo mroInstanceInfo, Locale locale, boolean forWriteOperation) {
        return null;
    }

    protected String getPathToMRO(IMROInstanceInfo mroInstanceInfo, boolean forWriteOperation) {
        throw new UnsupportedOperationException("Internal error!");
    }

    public OutputStream getOutputStream(IMROInstanceInfo mroInstanceInfo) throws IOException {
        if (mroInstanceInfo.getQualifiedName().equals(this.mroName) && mroInstanceInfo.getTypeName().equals(this.mroType)) {
            return this.stream;
        }
        throw new RepositoryRuntimeException("Cannot open file for versionable model object " + mroInstanceInfo.getQualifiedName() + " of type " + mroInstanceInfo.getTypeName() + " for writing since versionable model object " + this.mroName + " of type " + this.mroType + " is generated.");
    }

    public InputStream getInputStream(IMROInstanceInfo mroInstanceInfo) throws IOException {
        if (mroInstanceInfo.getQualifiedName().equals(this.mroName) && mroInstanceInfo.getTypeName().equals(this.mroType)) {
            return null;
        }
        String pathExtension = RepositoryGenerationMROLocator.getPathExtension(mroInstanceInfo.getQualifiedName(), mroInstanceInfo.getTypeName());
        File file = new File(this.rootPath + pathExtension);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        pathExtension = pathExtension.replace(File.separatorChar, '/');
        int i = 0;
        while (i < this.additionalPaths.length) {
            JarFile jarFile = new JarFile(this.additionalPaths[i]);
            JarEntry jarEntry = jarFile.getJarEntry("configuration" + pathExtension);
            if (jarEntry != null) {
                return jarFile.getInputStream(jarEntry);
            }
            ++i;
        }
        return null;
    }

    static {
        String pakkage = "com.sap.tc.webdynpro.progmodel.repository.";
        directory.put(pakkage + "IWDApplicationInfo", "Applications");
        directory.put(pakkage + "IWDComponentInfo", "Components");
        directory.put(pakkage + "IWDConfigurationInfo", "ComponentConfigurations");
        directory.put(pakkage + "IWDComponentInterfaceDefinitionInfo", "ComponentInterfaces");
        directory.put(pakkage + "IWDUIElementDefinitionInfo", "UIElements");
        directory.put(pakkage + "IWDApplicationPropertySetDefinitionInfo", "PropertySets");
    }
}

