/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.runtime;

import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.generation.runtime.ModelTemplateHelper;
import com.sap.ide.webdynpro.generation.runtime.StringUtil;
import java.util.ArrayList;

public class RFCModelTemplateHelper
extends ModelTemplateHelper {
    private static final int PROXYTYPE_STRUCTURE = 0;
    private static final int PROXYTYPE_INPUT = 1;
    private static final int PROXYTYPE_OUTPUT = 2;

    public ModelRelationRole getTargetRoleOutput(ModelClass modelClass) {
        ModelRelationRole[] targetRoles = this.getAllTargetRoles(modelClass);
        int i = 0;
        while (i < targetRoles.length) {
            if (targetRoles[i].getName().equals("Output") && targetRoles[i].getNavigable() && (targetRoles[i].getCardinality() == CardinalityEnum._0_1 || targetRoles[i].getCardinality() == CardinalityEnum._1_1 || targetRoles[i].getCardinality() == CardinalityEnum.NONE)) {
                return targetRoles[i];
            }
            ++i;
        }
        return null;
    }

    public ModelRelationRole[] getTargetRolesToN(ModelClass modelClass) {
        ArrayList<ModelRelationRole> targetRolesToN = new ArrayList<ModelRelationRole>();
        ModelRelationRole[] targetRoles = this.getAllTargetRoles(modelClass);
        int i = 0;
        while (i < targetRoles.length) {
            if (targetRoles[i].getNavigable() && !targetRoles[i].getName().equals("Output") && (targetRoles[i].getCardinality() == CardinalityEnum._0_N || targetRoles[i].getCardinality() == CardinalityEnum._1_N)) {
                targetRolesToN.add(targetRoles[i]);
            }
            ++i;
        }
        if (targetRolesToN.isEmpty()) {
            return new ModelRelationRole[0];
        }
        return targetRolesToN.toArray(new ModelRelationRole[targetRolesToN.size()]);
    }

    public ModelRelationRole[] getTargetRolesTo1(ModelClass modelClass) {
        ArrayList<ModelRelationRole> targetRolesTo1 = new ArrayList<ModelRelationRole>();
        ModelRelationRole[] targetRoles = this.getAllTargetRoles(modelClass);
        int i = 0;
        while (i < targetRoles.length) {
            if (targetRoles[i].getNavigable() && !targetRoles[i].getName().equals("Output") && (targetRoles[i].getCardinality() == CardinalityEnum._0_1 || targetRoles[i].getCardinality() == CardinalityEnum._1_1 || targetRoles[i].getCardinality() == CardinalityEnum.NONE)) {
                targetRolesTo1.add(targetRoles[i]);
            }
            ++i;
        }
        if (targetRolesTo1.isEmpty()) {
            return new ModelRelationRole[0];
        }
        return targetRolesTo1.toArray(new ModelRelationRole[targetRolesTo1.size()]);
    }

    public String getProxyListJavaClassName(String proxyTypeClassName) {
        return StringUtil.getQualifiedClassName(StringUtil.getPackageName(proxyTypeClassName), "util." + StringUtil.getUnqualifiedClassName(proxyTypeClassName) + "_List");
    }

    public String getRFCMethodName(ModelClass modelClass) {
        ModelClassSetting setting = modelClass.getSetting("proxyClassName");
        String methodName = setting.getValue();
        if (methodName.endsWith("_Input")) {
            methodName = methodName.substring(0, methodName.length() - 6);
        } else if (methodName.endsWith("_Output")) {
            methodName = methodName.substring(0, methodName.length() - 7);
        } else {
            return null;
        }
        methodName = methodName.substring(methodName.lastIndexOf(46) + 1);
        return methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
    }

    public ModelClass[] getExecutableModelClasses(Model model) {
        return this.getModelClassesWithSettingValue(model, "isExecutable", "true");
    }

    private int getRFCPartTypeAsInt(ModelClass modelClass, String classNameUpperCase) {
        String rfcPartTypeStr = this.getSettingValue(modelClass, "rfcPartType", "structure");
        if (rfcPartTypeStr == null) {
            return 0;
        }
        if (rfcPartTypeStr.equalsIgnoreCase("input")) {
            return 1;
        }
        if (rfcPartTypeStr.equalsIgnoreCase("output")) {
            return 2;
        }
        return 0;
    }

    private int getRFCPartTypeAsInt(ModelClass modelClass) {
        return this.getRFCPartTypeAsInt(modelClass, modelClass.getName().toUpperCase());
    }

    private String getRFCMethodName2(ModelClass modelClass) {
        String functionName = modelClass.getName();
        if (this.getRFCPartTypeAsInt(modelClass) == 1) {
            return functionName.substring(0, functionName.length() - "_Input".length());
        }
        throw new RuntimeException("can't determine function for class " + modelClass.getQualifiedName());
    }

    public String getRFCFunctionName(ModelClass modelClass) {
        return this.getABAPName(modelClass);
    }

    public String getMethodInModelName(ModelClass modelClass) {
        return this.decapitalize(this.getRFCMethodName2(modelClass));
    }

    public String getQualifiedInputClassName(ModelClass modelClass) {
        return modelClass.getQualifiedName();
    }

    public String getQualifiedOutputClassName(ModelClass modelClass) {
        String input = modelClass.getQualifiedName();
        return input.substring(0, input.length() - 6) + "_Output";
    }

    public String getModelInstance_defaultLogicalSystem(Model model) {
        return this.getSettingValue(model, "modelInstance_defaultLogicalSystem", "DEFAULTSYSTEMNAME");
    }

    public String getRfcMetadata_defaultLogicalSystem(Model model) {
        DevelopmentObject devObj = model.getLogicalDictionary();
        if (devObj == null) {
            return "NO_DEFAULT_SYSTEM_NAME";
        }
        DtLogicalDictionary dic = (DtLogicalDictionary)devObj;
        return dic.getLogicalSystemName();
    }

    public String getModelInstance_defaultScope(Model model) {
        String scopeValue = this.getSettingValue(model, "modelInstance_defaultScope", "com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType.APPLICATION_SCOPE");
        if (scopeValue == null) {
            return "com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType.APPLICATION_SCOPE";
        }
        if (scopeValue.equalsIgnoreCase("task")) {
            return "com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType.TASK_SCOPE";
        }
        if (scopeValue.equalsIgnoreCase("taskscope")) {
            return "com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType.TASK_SCOPE";
        }
        if (scopeValue.equalsIgnoreCase("task_scope")) {
            return "com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType.TASK_SCOPE";
        }
        return "com.sap.tc.webdynpro.progmodel.model.api.WDModelScopeType.APPLICATION_SCOPE";
    }

    public String getABAPName(ModelClass modelClass) {
        return this.getSettingValue(modelClass, "abapName", "");
    }

    public String getRFCPartType(ModelClass modelClass) {
        switch (this.getRFCPartTypeAsInt(modelClass)) {
            case 1: {
                return "PROXYTYPE_INPUT";
            }
            case 2: {
                return "PROXYTYPE_OUTPUT";
            }
        }
        return "PROXYTYPE_STRUCTURE";
    }

    public String getPropertyType(ModelClassProperty property) {
        DevelopmentObject element;
        if (property.hasType()) {
            return this.getQualifiedJavaClassName(property.getType());
        }
        if (property.hasStructureElement() && (element = property.getStructureElement()) instanceof DtField) {
            return this.getQualifiedJavaClassName((DevelopmentObject)((DtField)element).getReferencedType());
        }
        throw new RuntimeException("unable to determine type of model property " + property.getName());
    }
}

