/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.runtime;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.webdynpro.generation.runtime.BaseTemplateHelper;
import com.sap.ide.webdynpro.generation.runtime.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ArchiveTemplateHelper
extends BaseTemplateHelper {
    private static final String PUBLIC_PART_MF_DEPLOY_FILE_NAME = "Deploy-File-Name";
    private static final String PUBLIC_PART_MF_DEPLOY_FILE_REF_TYPE = "Deploy-File-Ref-Type";
    private static final String PUBLIC_PART_MF_DC_NAME = "DC-Name";
    private static final String PUBLIC_PART_MF_PP_TYPE = "PP-Type";
    private static final String PUBLIC_PART_MF_DC_TYPE = "DC-Type";
    private static final String PUBLIC_PART_MF_DC_VENDOR = "DC-Vendor";
    private static final String PUBLIC_PART_MF_MM_CONTENT = "MM-Content";
    private static final String DC_TYPE_WEB_DYNPRO = "Web Dynpro";
    private static final String DC_TYPE_DICTIONARY = "Dictionary";
    private static final String DC_TYPE_COMMON_MODEL = "Common Model";
    private static final String DEPLOY_FILE_REF_TYPE_SHARING = "SharingReference";
    private static final String DEPLOY_FILE_REF_TYPE_LIB = "LibrariesReference";
    private static final String DEPLOY_FILE_REF_TYPE_DEFAULT = "SharingReference";
    private static final String MM_CONTENT_TYPE_DICTIONARY = "Dictionary";
    private static final String MM_CONTENT_TYPE_WEB_DYNPRO = "Web Dynpro";
    private static final String MM_CONTENT_TYPE_COMMON_MODEL = "Common Model";
    private ComponentVersionInfo[] versionInfos = null;
    private static final String COMPONENTS_OF_INTEREST_FILE = "wdgeninfo.properties";
    private static final String PROPERTY_PREFIX_FOR_NAME = "GenerationComponent.Name.";
    private static final String PROPERTY_PREFIX_FOR_CLASS = "GenerationComponent.Class.";

    public static final String getPublicPartManifestAttributeValue(String publicPartArchivePath, String attributeName) {
        try {
            JarFile lJarFile = new JarFile(publicPartArchivePath);
            if (lJarFile == null) {
                return "";
            }
            Manifest lManifest = lJarFile.getManifest();
            if (lManifest == null) {
                return "";
            }
            Attributes lAttributes = lManifest.getMainAttributes();
            Set<Object> lAttributeKeys = lAttributes.keySet();
            Iterator<Object> lIterator = lAttributeKeys.iterator();
            Attributes.Name lAttributeKey = null;
            while (lIterator.hasNext()) {
                lAttributeKey = (Attributes.Name)lIterator.next();
                if (!lAttributeKey.toString().equals(attributeName)) continue;
                return lAttributes.get(lAttributeKey).toString();
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public static final String getPublicPartType(String publicPartArchivePath) {
        String lPpType = ArchiveTemplateHelper.getPublicPartManifestAttributeValue(publicPartArchivePath, PUBLIC_PART_MF_PP_TYPE);
        if (lPpType == null) {
            lPpType = "";
        }
        return lPpType;
    }

    public static final String getDevelopmentComponentType(String publicPartArchivePath) {
        String lDcType = ArchiveTemplateHelper.getPublicPartManifestAttributeValue(publicPartArchivePath, PUBLIC_PART_MF_DC_TYPE);
        if (lDcType == null) {
            lDcType = "";
        }
        return lDcType;
    }

    public static final String getDevelopmentComponentName(String publicPartArchivePath) {
        String lDcName = ArchiveTemplateHelper.getPublicPartManifestAttributeValue(publicPartArchivePath, PUBLIC_PART_MF_DC_NAME);
        if (lDcName == null) {
            lDcName = "";
        }
        return lDcName;
    }

    public static final String getDeployFileName(String publicPartArchivePath) {
        String lArchiveName = ArchiveTemplateHelper.getPublicPartManifestAttributeValue(publicPartArchivePath, PUBLIC_PART_MF_DEPLOY_FILE_NAME);
        if (lArchiveName == null) {
            lArchiveName = "";
        }
        return lArchiveName;
    }

    public static final String getVendor(String publicPartArchivePath) {
        String lVendor = ArchiveTemplateHelper.getPublicPartManifestAttributeValue(publicPartArchivePath, PUBLIC_PART_MF_DC_VENDOR);
        if (lVendor == null) {
            lVendor = "";
        }
        return lVendor;
    }

    public static final String getRuntimeReference(String publicPartArchivePath) {
        String lDcName = ArchiveTemplateHelper.getDevelopmentComponentName(publicPartArchivePath);
        String lVendor = ArchiveTemplateHelper.getVendor(publicPartArchivePath);
        if (lDcName != null && lDcName.length() > 0) {
            while (lDcName.indexOf("/") != -1) {
                lDcName = lDcName.replace('/', '~');
            }
            if (lVendor == null || lVendor.length() == 0) {
                return lDcName;
            }
            return lVendor + "/" + lDcName;
        }
        return "";
    }

    public static String getQualifiedName(DevelopmentObject devObj) {
        if (devObj instanceof MainDevelopmentObject) {
            return ((MainDevelopmentObject)devObj).getQualifiedName();
        }
        if (devObj.getMDO() != null) {
            return StringUtil.getQualifiedClassName(devObj.getMDO().getPackage(), devObj.getName());
        }
        return devObj.getName();
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static final String getPublicPartDeployFileRefType(String publicPartArchivePath) {
        String lRefType = ArchiveTemplateHelper.getPublicPartManifestAttributeValue(publicPartArchivePath, PUBLIC_PART_MF_DEPLOY_FILE_REF_TYPE);
        if (lRefType == null || lRefType.length() == 0) {
            return "SharingReference";
        }
        return lRefType;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl.getClass().getName().equals("com.sapmarkets.technology.classloader.ExtendedClassLoader")) {
            try {
                Method m = cl.getClass().getDeclaredMethod("getClassPath", null);
                String classpath = (String)m.invoke((Object)cl, null);
                String[] cpEntries = StringUtil.divide(classpath, ';');
                ArrayList<URL> urls = new ArrayList<URL>();
                int i = 0;
                while (i < cpEntries.length) {
                    if (cpEntries[i] != null && cpEntries[i].length() != 0) {
                        File f = new File(cpEntries[i]);
                        urls.add(f.toURL());
                    }
                    ++i;
                }
                cl = new URLClassLoader(urls.toArray(new URL[urls.size()]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cl;
    }

    private void collectInfos() {
        ArrayList<ComponentVersionInfo> infos = new ArrayList<ComponentVersionInfo>();
        Properties infoDefs = new Properties();
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(COMPONENTS_OF_INTEREST_FILE);
            if (in != null) {
                infoDefs.load(in);
            } else {
                System.err.println("couldn't find wdgeninfo.properties in classpath");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClassLoader classLoader = this.getClassLoader();
        int i = 1;
        while (true) {
            String compName = infoDefs.getProperty(PROPERTY_PREFIX_FOR_NAME + i);
            String compClass = infoDefs.getProperty(PROPERTY_PREFIX_FOR_CLASS + i);
            if (compName == null) break;
            String compVersion = "(unknown)";
            try {
                Class<?> referenceClass = classLoader.loadClass(compClass);
                Package pkg = referenceClass.getPackage();
                String implVersion = pkg.getImplementationVersion();
                if (implVersion != null && implVersion.length() > 0) {
                    compVersion = implVersion;
                }
            }
            catch (Exception e) {
                System.out.println("[Warning] no version info found for " + compName + ": " + StringUtil.getUnqualifiedClassName(e.getClass()) + " " + e.getMessage());
            }
            infos.add(new ComponentVersionInfo(compName, compVersion));
            ++i;
        }
        this.versionInfos = infos.toArray(new ComponentVersionInfo[infos.size()]);
    }

    public ComponentVersionInfo[] getVersionInfos() {
        if (this.versionInfos == null) {
            this.collectInfos();
        }
        return this.versionInfos;
    }

    public class ComponentVersionInfo {
        private final String name;
        private final String versionInfo;

        private ComponentVersionInfo(String name, String versionInfo) {
            this.name = name;
            this.versionInfo = versionInfo;
        }

        public String getComponentName() {
            return this.name;
        }

        public String getComponentVersionInfo() {
            return this.versionInfo;
        }
    }
}

