/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.wizards.prx.pages;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.proxygenerator.ProxyHelperFunctions;
import com.sap.ide.wsproxy.core.text.WsProxyUiTexts;
import com.sap.ide.wsproxy.ui.table.WsTableModel;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NamespacePackageMappingPage
extends WizardPage
implements TableModelListener {
    private static final String[] TABLE_COLUMNS = new String[]{"URI", "Package"};
    private static final String[][] INITIAL_TABLE_DATA = new String[0][];
    private DefaultTableModel tableModel = null;
    private ISapTableViewer tableViewer = null;
    private Text basePackageLabel = null;
    private static final int INIT_ROWS = 3;
    private Properties namespacePackageMap = null;
    private String basePackage = null;
    private String wsdlUrl = null;
    private IStatus currentStatus = null;
    static /* synthetic */ Class class$com$sap$ide$wsproxy$wizards$prx$pages$NamespacePackageMappingPage;

    public NamespacePackageMappingPage() {
        super("Namespace Package Mapping page");
        this.setTitle(WsProxyUiTexts.getString("DeployableProxyDefinitionPage.pageTitle"));
        this.setDescription(WsProxyUiTexts.getString("NamespacePackageMappingPage.enterUriMappings"));
    }

    public void init(String wsdlUrl, String basePackage) {
        this.basePackage = basePackage;
        this.wsdlUrl = wsdlUrl;
    }

    private void initTable() {
        this.tableModel.removeTableModelListener(this);
        this.resetTable();
        final IStatus[] status = new IStatus[]{new StatusInfo(0, WsProxyUiTexts.getString("NamespacePackageMappingPage.enterUriMappings"))};
        this.basePackageLabel.setText(this.basePackage);
        final Properties[] props = new Properties[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(WsProxyUiTexts.getString("NamespacePackageMappingPage.creatinMappingMessage"), 100);
                try {
                    monitor.worked(25);
                    props[0] = ProxyHelperFunctions.createNamespacePackageMappingFile((String)NamespacePackageMappingPage.this.wsdlUrl, (String)NamespacePackageMappingPage.this.basePackage);
                }
                catch (Exception e) {
                    status[0] = new StatusInfo(4, WsProxyUiTexts.getString("DeployableProxyDefinitionPage.invalidWsdlOrUrlError"));
                    monitor.worked(100);
                    NamespacePackageMappingPage.this.updateStatus(status);
                    return;
                }
                monitor.worked(100);
            }
        };
        ProgressMonitorDialog dialog1 = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog1.run(false, false, op);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$prx$pages$NamespacePackageMappingPage == null ? (class$com$sap$ide$wsproxy$wizards$prx$pages$NamespacePackageMappingPage = NamespacePackageMappingPage.class$("com.sap.ide.wsproxy.wizards.prx.pages.NamespacePackageMappingPage")) : class$com$sap$ide$wsproxy$wizards$prx$pages$NamespacePackageMappingPage));
        }
        this.updateStatus(status);
        if (props[0] != null) {
            this.namespacePackageMap = this.convertPackageProperties(props[0], this.basePackage, true);
            Enumeration enumeration = ((Hashtable)this.namespacePackageMap).keys();
            while (enumeration.hasMoreElements()) {
                String uri = (String)enumeration.nextElement();
                Object[] rowdata = new Object[]{uri, this.namespacePackageMap.getProperty(uri)};
                this.tableModel.addRow(rowdata);
            }
        }
        this.tableModel.addTableModelListener(this);
    }

    public void tableChanged(TableModelEvent e) {
        Properties props = new Properties();
        if (e.getType() == 0) {
            IStatus[] statuses = new IStatus[this.tableModel.getRowCount()];
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                String newValue = (String)((WsTableModel)e.getSource()).getValueAt(i, 1);
                statuses[i] = this.proxyPackageFieldChanged(newValue);
                ++i;
            }
            this.updateStatus(statuses);
        }
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            ((Hashtable)props).put(this.tableModel.getValueAt(i, 0), this.tableModel.getValueAt(i, 1));
            ++i;
        }
        this.namespacePackageMap = props;
    }

    public void createControl(Composite parent) {
        int nColumns = 2;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        mainPane.setLayoutData((Object)new GridData(1808));
        IGridLayoutPane packagePane = mainPane.addGridLayoutPane(nColumns, mainPane.createGridLayoutData(4, 1, true, false, 2, 2));
        packagePane.addTextLabel(WsProxyUiTexts.getString("NamespacePackageMappingPage.basePackageLabel"), mainPane.createGridLayoutData(1, 1, false, false, 1, 1));
        this.basePackageLabel = packagePane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false, 1, 1));
        packagePane.addPlaceholder();
        IGridLayoutPane generalpane = mainPane.addGridLayoutPane(1, mainPane.createGridLayoutData(4, 4, true, true, 1, 5));
        this.tableModel = new WsTableModel(TABLE_COLUMNS, 0);
        this.tableViewer = generalpane.addSapTableViewer((TableModel)this.tableModel, generalpane.createGridLayoutData(4, 4, true, true, 1, 5));
        this.tableViewer.getTable().getColumn(0).setWidth(150);
        this.tableViewer.getTable().getColumn(1).setWidth(220);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initTable();
        }
    }

    public Properties getMapping() {
        return this.convertPackageProperties(this.namespacePackageMap, this.basePackage, false);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.isCurrentPage();
    }

    protected void updateStatus(IStatus status) {
        this.currentStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.isCurrentPage()) {
            StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
        }
    }

    private void updateStatus(IStatus[] statuses) {
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])statuses));
    }

    private void resetTable() {
        this.tableModel = new WsTableModel(TABLE_COLUMNS, 0);
        this.tableViewer.setTableModel((TableModel)this.tableModel);
    }

    private Properties convertPackageProperties(Properties props, String basePackage, boolean removeBase) {
        Properties convertedProps = new Properties();
        if (props != null) {
            Enumeration keys = ((Hashtable)props).keys();
            while (keys.hasMoreElements()) {
                String uri = (String)keys.nextElement();
                String pack = props.getProperty(uri);
                String subPackage = null;
                subPackage = removeBase ? pack.substring(basePackage.length() + 1) : basePackage + '.' + pack;
                ((Hashtable)convertedProps).put(uri, subPackage);
            }
        }
        return convertedProps;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    private IStatus proxyPackageFieldChanged(String packPath) {
        if (packPath != null) {
            if (packPath.length() < 1) {
                return new StatusInfo(4, WsProxyUiTexts.getString("NamespacePackageMappingPage.basePackageNotEnteredError"));
            }
            IStatus status = JavaConventions.validatePackageName((String)packPath);
            if (status.getSeverity() == 4) {
                return status;
            }
        }
        return new StatusInfo(0, WsProxyUiTexts.getString("NamespacePackageMappingPage.enterUriMappings"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

