/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.wizards.project.pages;

import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.wsproxy.core.text.WsProxyUiTexts;
import com.tssap.dii.component.IStartCreateProjectWizard;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class WsProxyAbstractProjectPage
extends WizardPage {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final int SIZING_INDENTATION_WIDTH = 10;
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private Button useDefaultsButton;
    private IStartCreateProjectWizard compWizard;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WsProxyAbstractProjectPage.this.setLocationForSelection();
            WsProxyAbstractProjectPage.this.setPageComplete(WsProxyAbstractProjectPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WsProxyAbstractProjectPage.this.setPageComplete(WsProxyAbstractProjectPage.this.validatePage());
        }
    };

    public WsProxyAbstractProjectPage(String pageName, IStartCreateProjectWizard compWizard) {
        super(pageName);
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
        this.customLocationFieldValue = "";
        this.compWizard = compWizard;
    }

    public WsProxyAbstractProjectPage(String pageName) {
        this(pageName, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        if (this.getComponentWizard() != null) {
            IProjectDescription projectDesc = this.getComponentWizard().getProjectDescription();
            this.initAndDisable(projectDesc);
        }
    }

    public IStartCreateProjectWizard getComponentWizard() {
        return this.compWizard;
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.projectContentsLabel"));
        GridData labelData = new GridData();
        labelData.horizontalSpan = 3;
        projectContentsLabel.setLayoutData((Object)labelData);
        this.useDefaultsButton = new Button(projectGroup, 131104);
        this.useDefaultsButton.setText(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.useDefaultLabel"));
        this.useDefaultsButton.setSelection(this.useDefaults);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WsProxyAbstractProjectPage.this.useDefaults = WsProxyAbstractProjectPage.this.useDefaultsButton.getSelection();
                WsProxyAbstractProjectPage.this.browseButton.setEnabled(!WsProxyAbstractProjectPage.this.useDefaults);
                WsProxyAbstractProjectPage.this.locationPathField.setEnabled(!WsProxyAbstractProjectPage.this.useDefaults);
                WsProxyAbstractProjectPage.this.locationLabel.setEnabled(!WsProxyAbstractProjectPage.this.useDefaults);
                if (WsProxyAbstractProjectPage.this.useDefaults) {
                    WsProxyAbstractProjectPage.this.customLocationFieldValue = WsProxyAbstractProjectPage.this.locationPathField.getText();
                    WsProxyAbstractProjectPage.this.setLocationForSelection();
                } else {
                    WsProxyAbstractProjectPage.this.locationPathField.setText(WsProxyAbstractProjectPage.this.customLocationFieldValue);
                }
            }
        };
        this.useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.nameLabel"));
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.locationLabel"));
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(WsCoreUiTexts.getString((String)"WsButton.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WsProxyAbstractProjectPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.directoryLabel"));
        String dirName = this.getProjectLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    public void setInitialProjectName(String name) {
        this.initialProjectFieldValue = name == null ? null : name.trim();
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.getProjectNameFieldValue());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }

    private boolean validatePage() {
        File f;
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.projectNameEmpty"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.projectLocationEmpty"));
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.locationError"));
            return false;
        }
        if (!this.useDefaults && Platform.getLocation().isPrefixOf((IPath)new Path(locationFieldContents))) {
            this.setErrorMessage(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.defaultLocationError"));
            return false;
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(WsProxyUiTexts.getString("NewWsProxyComponentProjectPage.projectExistsMessage"));
            return false;
        }
        if (!this.isComponentWizard() && (f = new File(locationFieldContents)) != null && f.exists() && f.listFiles().length > 0) {
            this.setErrorMessage(WsProxyUiTexts.getString("WsProxyAbstractProjectPage.folderOfNameExistsError"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    protected final boolean isComponentWizard() {
        return this.compWizard != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    protected final void initAndDisable(IProjectDescription projectDesc) {
        this.projectNameField.setText(projectDesc.getName());
        this.locationPathField.setText(projectDesc.getLocation().toOSString());
        this.useDefaults = false;
        this.projectNameField.setEnabled(false);
        this.useDefaultsButton.setEnabled(false);
    }
}

