/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.wizards.project;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.vi.check.ProjectBuilderHandler;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.resources.EclipseProjectService;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.sap.ide.ws.core.ui.views.IViewStateInfo;
import com.sap.ide.wsproxy.core.text.WsProxyUiTexts;
import com.sap.ide.wsproxy.wizards.project.pages.WsProxyAbstractProjectPage;
import com.sap.ide.wsproxy.wizards.project.pages.WsProxyProjectJavaPage;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class WsProxyProjectWizard
extends BasicNewResourceWizard
implements IConnectedWizard {
    protected static final String NEW_PROJECT_PAGENAME = "New Client Proxy Name";
    private static final String NEW_JAVA_PROJECT_PAGENAME = "Java Settings";
    public static final String WS_PROXY_SRC_FOLDER = "src";
    public static final String WS_PROXY_OP_FOLDER = "bin";
    private static final String FILE_NAME_PROJECT = ".project";
    private static final String FILE_NAME_CLASSPATH = ".classpath";
    private static final String FILE_NAME_TSSAPINFO = ".tssapinfo";
    public static final String WS_PROXY_LIB_FOLDER = "lib";
    protected WsProxyAbstractProjectPage newProjectPage;
    protected WsProxyProjectJavaPage newJavaProjectPage;
    private IStartCreateProjectWizard startComponentWizard;
    protected IProject wsProxyPrj;
    static /* synthetic */ Class class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard;

    public WsProxyProjectWizard() {
        this.setWindowTitle(WsCoreUiTexts.getString((String)"WebServices.Wizards.title"));
    }

    public boolean completeProject(IProject project, Properties properties) {
        if (!this.setDerivedFiles(project)) {
            return false;
        }
        if (!this.setProjectNatures(project)) {
            return false;
        }
        return this.setClasspath(project, properties);
    }

    public void finalProject() {
    }

    public boolean performFinish() {
        this.performMyFinish();
        if (this.wsProxyPrj != null) {
            if (this.startComponentWizard != null) {
                if (!this.startComponentWizard.fillProject(this.wsProxyPrj, this.createPropertiesForDC(this.wsProxyPrj))) {
                    try {
                        this.wsProxyPrj.delete(true, true, null);
                    }
                    catch (CoreException e) {
                        WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
                    }
                    ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage("DC Project could not be created.");
                    ((WizardPage)this.getContainer().getCurrentPage()).setPageComplete(false);
                    return false;
                }
                this.addFilesToSourceControl(this.getCreatedAdditionalResources(), this.newProjectPage.getProjectHandle());
            }
            return true;
        }
        return false;
    }

    public void init(IStartCreateProjectWizard wizard) {
        this.startComponentWizard = wizard;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
    }

    public void addPages() {
        super.addPages();
        this.newProjectPage = this.getProxyProjectPage();
        this.addPage((IWizardPage)this.newProjectPage);
        this.newJavaProjectPage = new WsProxyProjectJavaPage(this.newProjectPage);
        this.addPage((IWizardPage)this.newJavaProjectPage);
        this.getProxyProjectPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.startComponentWizard == null) {
            return super.getNextPage(page);
        }
        return null;
    }

    public void openDefaultPerspective() {
        try {
            PlatformUI.getWorkbench().showPerspective("com.sap.ide.ws.perspective.WebServicePerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            if (this.startComponentWizard == null) {
                IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.sap.ide.ws.perspective.views.projects.ws.ProxyProjectExplorer");
                if (((IViewStateInfo)viewPart).isInDcMode()) {
                    ((IViewStateInfo)viewPart).switchToDcMode(false);
                }
            } else {
                IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.sap.ide.ws.perspective.views.projects.ws.ProxyProjectExplorer");
                if (!((IViewStateInfo)viewPart).isInDcMode()) {
                    ((IViewStateInfo)viewPart).switchToDcMode(true);
                }
            }
        }
        catch (WorkbenchException e) {
            WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
        }
    }

    protected abstract WsProxyAbstractProjectPage getProxyProjectPage();

    protected abstract String getMyNature();

    protected abstract void createAdditionalResources();

    protected abstract IFile[] getCreatedAdditionalResources();

    protected IStartCreateProjectWizard getStartComponentWizard() {
        return this.startComponentWizard;
    }

    protected void addFilesToSourceControl(IFile[] specificFiles, IProject prj) {
        if (prj != null && this.getStartComponentWizard() != null && !this.getStartComponentWizard().isLocal()) {
            IVfsActivity activity = this.getStartComponentWizard().getActivity();
            ArrayList<IFile> allFiles = new ArrayList<IFile>();
            if (specificFiles != null) {
                int i = 0;
                while (i < specificFiles.length) {
                    if (specificFiles[i] != null) {
                        allFiles.add(specificFiles[i]);
                    }
                    ++i;
                }
            }
            if (allFiles.size() > 0) {
                DTRUtils.doAddToVCS((IResource[])allFiles.toArray(new IFile[0]), (IProject)prj, (IVfsActivity)activity, (String)"WsProject", (String)"projectfiles", (String)"Add project files to dtr");
            }
        }
    }

    private void performMyFinish() {
        if (!this.newJavaProjectPage.isVisited()) {
            this.newJavaProjectPage.initPage(this.newProjectPage.getProjectHandle());
        }
        this.createNewProject();
        this.openDefaultPerspective();
    }

    private boolean setClasspath(IProject project, Properties props) {
        Object obj = null;
        if (((Hashtable)props).containsKey("DCPackageFolder")) {
            obj = ((Hashtable)props).get("DCPackageFolder");
        }
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            if (((ArrayList)obj).size() > 0) {
                int i = 0;
                while (i < ((ArrayList)obj).size()) {
                    list.add(JavaCore.newSourceEntry((IPath)new Path(javaProject.getCorrespondingResource().getFullPath().toOSString() + "\\" + (String)((ArrayList)obj).get(i))));
                    ++i;
                }
            }
            if (!EclipseProjectService.isInClasspath((IClasspathEntry[])javaProject.getRawClasspath(), (IClasspathEntry)JavaRuntime.getJREVariableEntry())) {
                list.add(JavaRuntime.getJREVariableEntry());
            }
            IClasspathEntry[] clpEntries = javaProject.getRawClasspath();
            int i = 0;
            while (i < clpEntries.length) {
                if (clpEntries[i].getEntryKind() != 3 || clpEntries[i].getPath().toOSString().equals(WS_PROXY_SRC_FOLDER)) {
                    list.add(clpEntries[i]);
                }
                ++i;
            }
            javaProject.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), null);
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
            return false;
        }
        return true;
    }

    private boolean setProjectNatures(IProject project) {
        try {
            this.updateProjectNatures(project, new String[]{this.getMyNature(), "org.eclipse.jdt.core.javanature", "com.sap.ide.eclipse.component.provider.dcnature"}, null);
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
            return false;
        }
        return true;
    }

    public void updateProjectNatures(IProject project, String[] natures, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < natures.length) {
            if (!project.hasNature(natures[i])) {
                list.add(natures[i]);
            }
            ++i;
        }
        if (list.size() == 0) {
            return;
        }
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        list.addAll(Arrays.asList(prevNatures));
        String[] newNatures = new String[list.size()];
        newNatures = list.toArray(newNatures);
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    private boolean setDerivedFiles(IProject project) {
        IFile file = project.getFile(FILE_NAME_PROJECT);
        if (file.exists()) {
            try {
                file.setDerived(true);
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
                return false;
            }
        }
        if ((file = project.getFile(FILE_NAME_CLASSPATH)).exists()) {
            try {
                file.setDerived(true);
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
                return false;
            }
        }
        if ((file = project.getFile(FILE_NAME_TSSAPINFO)).exists()) {
            try {
                file.setDerived(true);
                return false;
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
            }
        }
        return true;
    }

    private Properties createPropertiesForDC(IProject project) {
        Properties properties = new Properties();
        IJavaProject javaProject = ServicesEclipse.getJavaProject((String)project.getName());
        ArrayList<String> list = new ArrayList<String>();
        if (javaProject != null) {
            IClasspathEntry[] classpathEntries = null;
            try {
                classpathEntries = javaProject.getRawClasspath();
            }
            catch (JavaModelException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
                return null;
            }
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    String path = classpathEntries[i].getPath().removeFirstSegments(1).toString();
                    list.add(path);
                }
                ++i;
            }
        }
        ((Hashtable)properties).put("DCPackageFolder", list);
        ArrayList<String> sourceFolderList = new ArrayList<String>();
        sourceFolderList.add("META-INF");
        ((Hashtable)properties).put("DCSourceFolder", sourceFolderList);
        return properties;
    }

    private void createNewProject() {
        WorkspaceModifyDelegatingOperation op1 = new WorkspaceModifyDelegatingOperation(this.newJavaProjectPage.getRunnable());
        ProgressMonitorDialog dialog1 = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog1.run(false, false, (IRunnableWithProgress)op1);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
        }
        WorkspaceModifyOperation op2 = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                WsProxyProjectWizard.this.createProject(monitor);
            }
        };
        ProgressMonitorDialog dialog2 = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog2.run(false, true, (IRunnableWithProgress)op2);
        }
        catch (InterruptedException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
        }
        catch (InvocationTargetException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard == null ? (class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard = WsProxyProjectWizard.class$("com.sap.ide.wsproxy.wizards.project.WsProxyProjectWizard")) : class$com$sap$ide$wsproxy$wizards$project$WsProxyProjectWizard));
        }
    }

    private void createProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.wsProxyPrj = this.newProjectPage.getProjectHandle();
        try {
            monitor.beginTask(WsProxyUiTexts.getString("WsClientProxyProjectWizard.configureProjectMessage"), 100);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IProject projectHandle = this.newProjectPage.getProjectHandle();
            if (!projectHandle.isOpen()) {
                projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 25));
            }
            String[] natures = this.startComponentWizard == null ? new String[]{this.getMyNature()} : new String[]{"com.sap.ide.eclipse.component.provider.dcnature", this.getMyNature()};
            this.createAdditionalResources();
            this.updateProjectNatures(projectHandle, natures, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        if (this.startComponentWizard == null) {
            ProjectBuilderHandler.addBuilder((IProject)this.newProjectPage.getProjectHandle(), (String)"com.sap.ide.wsproxy.clientapijarbuilder");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

