/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.editors.lp.pages;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.sap.ide.wsproxy.editors.lp.LogicalPortEditor;
import com.sap.ide.wsproxy.editors.lp.pages.LpEditorPage;
import com.sap.ide.wsproxy.editors.lp.text.WsLPEditorTexts;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SecurityPage
extends LpEditorPage
implements SelectionListener,
ModifyListener {
    public static String SECURITY_PAGE_TEXT = WsLPEditorTexts.getString("LPEditor.Pages.Security.name");
    private Button bAuthNone;
    private Button bAuthBasic;
    private Button bAuthStrong;
    private Button bAuthSAPLogon;
    private IGridLayoutPane authenticationGroup;
    private Label lUserName;
    private Label lUserPass;
    private Label lKeyStoreName;
    private Label lCertName;
    private Text fUserName;
    private Text fUserPass;
    private Text fKeyStoreName;
    private Text fCertName;
    private IGridLayoutPane serverCertificatesGroup;
    private Button bDoNotVerifyCert;
    private Button bVerifyCert;
    private Label lTrustedCerts;
    private Text fTrustedCerts;

    public SecurityPage(Composite parentComposite, LogicalPortEditor parentEditor) {
        super(parentComposite, parentEditor);
    }

    public Composite getControl() {
        IGridLayoutPane featureDetailPane = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)2);
        featureDetailPane.setLayoutData((Object)new GridData(1808));
        String authLevel = "None";
        String authMethod = "";
        String authUser = "";
        String authKeyStoreName = "";
        String authCertName = "";
        boolean verifyCert = false;
        String trustedCert = "";
        boolean authenticationFeaturePreselected = false;
        FeatureType feature = ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/630/soap/features/authentication", false);
        if (feature != null) {
            authenticationFeaturePreselected = feature.getOriginal();
            authLevel = this.getProperty(feature, "AuthenticationLevel");
            authMethod = this.getProperty(feature, "AuthenticationMethod");
            authUser = this.getProperty(feature, "AuthenticationCredentialUser");
            authKeyStoreName = this.getProperty(feature, "clientKeystore");
            authCertName = this.getProperty(feature, "certName");
            verifyCert = "true".equals(this.getProperty(feature, "SSLServerAuthentication"));
            trustedCert = this.getProperty(feature, "SSLServerAuthenticationKeystoreView");
        }
        this.addSecurityFeature(featureDetailPane, authenticationFeaturePreselected, authLevel, authMethod, authUser, authKeyStoreName, authCertName, verifyCert, trustedCert);
        return featureDetailPane.getComposite();
    }

    private void addSecurityFeature(IGridLayoutPane pane, boolean authenticationFeaturePreselected, String level, String method, String user, String keyStoreName, String certName, boolean verifyCert, String trustedCert) {
        IGridLayoutPane securityGroup = pane.addGridLayoutPane(WsLPEditorTexts.getString("LPEditor.Pages.Security.name"), 1, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.authenticationGroup = securityGroup.addGridLayoutPane(WsLPEditorTexts.getString("LPEditor.Pages.Security.authenticationType") + ": ", 1, pane.createGridLayoutData(1, 4, false, false, 1, 1));
        this.bAuthNone = this.authenticationGroup.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Security.authNone"), pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.bAuthBasic = this.authenticationGroup.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Security.authBasic"), pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.bAuthStrong = this.authenticationGroup.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Security.authStrong"), pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.bAuthSAPLogon = this.authenticationGroup.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Security.authSAPLogon"), pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.lUserName = securityGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Security.userName") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fUserName = securityGroup.addTextField("", pane.createGridLayoutData(4, 4, false, false, 1, 1));
        this.lUserPass = securityGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Security.password") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.lUserPass.setEnabled(false);
        this.fUserPass = securityGroup.addTextField("", pane.createGridLayoutData(4, 1, false, false, 1, 1));
        this.fUserPass.setEnabled(false);
        this.lKeyStoreName = securityGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Security.keystoreName") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fKeyStoreName = securityGroup.addTextField("", pane.createGridLayoutData(4, 4, false, false, 1, 1));
        this.lCertName = securityGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Security.certificationName") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fCertName = securityGroup.addTextField("", pane.createGridLayoutData(4, 1, false, false, 1, 1));
        this.serverCertificatesGroup = securityGroup.addGridLayoutPane(WsLPEditorTexts.getString("LPEditor.Pages.Security.serverCertificates"), 1, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.bDoNotVerifyCert = this.serverCertificatesGroup.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Security.doNotVerifyCert"), pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.bDoNotVerifyCert.setSelection(!verifyCert);
        this.bVerifyCert = this.serverCertificatesGroup.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Security.verifyCert"), pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.bVerifyCert.setSelection(verifyCert);
        this.lTrustedCerts = this.serverCertificatesGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Security.trustedCerts") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fTrustedCerts = this.serverCertificatesGroup.addTextField(trustedCert, pane.createGridLayoutData(4, 1, false, false, 1, 1));
        if (method == null || "".equals(method)) {
            if ("Basic".equals(level)) {
                method = "BasicAuth";
            } else if ("Strong".equals(level)) {
                method = "CertAuth";
            }
        }
        boolean basicEnabled = false;
        boolean strongEnabled = false;
        boolean sapLogonSelected = false;
        if ("BasicAuth".equals(method)) {
            this.bAuthBasic.setSelection(true);
            basicEnabled = true;
            this.fUserName.setText(user);
        } else if ("CertAuth".equals(method)) {
            this.bAuthStrong.setSelection(true);
            this.fKeyStoreName.setText(keyStoreName);
            this.fCertName.setText(certName);
            strongEnabled = true;
        } else if ("SSO2".equals(method)) {
            this.bAuthSAPLogon.setSelection(true);
            sapLogonSelected = true;
        } else {
            this.bAuthNone.setSelection(true);
        }
        this.enableSecurityFields(basicEnabled, strongEnabled, sapLogonSelected);
        if (authenticationFeaturePreselected) {
            this.bAuthNone.setEnabled(this.bAuthNone.getSelection());
            this.bAuthBasic.setEnabled(this.bAuthBasic.getSelection());
            this.bAuthStrong.setEnabled(this.bAuthStrong.getSelection());
            this.bAuthSAPLogon.setEnabled(this.bAuthSAPLogon.getSelection());
        } else {
            this.bAuthNone.addSelectionListener((SelectionListener)this);
            this.bAuthBasic.addSelectionListener((SelectionListener)this);
            this.bAuthStrong.addSelectionListener((SelectionListener)this);
            this.bAuthSAPLogon.addSelectionListener((SelectionListener)this);
        }
        if (!this.isSSL()) {
            this.bAuthStrong.setEnabled(false);
        }
        this.bDoNotVerifyCert.addSelectionListener((SelectionListener)this);
        this.bVerifyCert.addSelectionListener((SelectionListener)this);
        this.fUserName.addModifyListener((ModifyListener)this);
        this.fKeyStoreName.addModifyListener((ModifyListener)this);
        this.fCertName.addModifyListener((ModifyListener)this);
        this.fTrustedCerts.addModifyListener((ModifyListener)this);
    }

    private boolean isSSL() {
        PropertyType tlsType;
        String endpoint = this.port.getEndpoint();
        boolean ssl = endpoint == null || endpoint.startsWith("https://");
        FeatureType transportGuarantee = ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/630/soap/features/transportguarantee", false);
        if (transportGuarantee != null && (tlsType = transportGuarantee.getProperty("TLSType")) != null && "SSL".equals(tlsType.getValue())) {
            ssl = true;
        }
        return ssl;
    }

    private void enableSecurityFields(boolean basicEnabled, boolean strongEnabled, boolean sapLogonSelected) {
        this.lUserName.setEnabled(basicEnabled);
        this.fUserName.setEnabled(basicEnabled);
        this.lKeyStoreName.setEnabled(strongEnabled);
        this.fKeyStoreName.setEnabled(strongEnabled);
        this.lCertName.setEnabled(strongEnabled);
        this.fCertName.setEnabled(strongEnabled);
        if (sapLogonSelected && this.isSSL()) {
            this.bDoNotVerifyCert.setEnabled(true);
            this.bVerifyCert.setEnabled(true);
            this.lTrustedCerts.setEnabled(true);
            this.fTrustedCerts.setEnabled(true);
        } else {
            this.bDoNotVerifyCert.setEnabled(false);
            this.bVerifyCert.setEnabled(false);
            this.lTrustedCerts.setEnabled(false);
            this.fTrustedCerts.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.getParentEditor().notifyOfChange();
        this.enableSecurityFields(this.bAuthBasic.getSelection(), this.bAuthStrong.getSelection(), this.bAuthSAPLogon.getSelection());
    }

    public void setSensitivity(boolean enable) {
    }

    public void modifyText(ModifyEvent e) {
        this.getParentEditor().notifyOfChange();
    }

    public boolean doSave() {
        this.processAuthentication();
        return true;
    }

    private boolean processAuthentication() {
        FeatureType authenticationFeature = ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/630/soap/features/authentication", true);
        PropertyType[] oldProperties = authenticationFeature.getProperty();
        Properties newProperties = new Properties();
        int i = 0;
        while (i < oldProperties.length) {
            PropertyType prop = oldProperties[i];
            newProperties.setProperty(prop.getName(), prop.getValue());
            ++i;
        }
        if (this.bAuthNone.getSelection()) {
            newProperties.setProperty("AuthenticationLevel", "None");
            ((Hashtable)newProperties).remove("AuthenticationMethod");
            ((Hashtable)newProperties).remove("AuthenticationCredentialUser");
            ((Hashtable)newProperties).remove("clientKeystore");
            ((Hashtable)newProperties).remove("certName");
            ((Hashtable)newProperties).remove("SSLServerAuthentication");
            ((Hashtable)newProperties).remove("SSLServerAuthenticationKeystoreView");
        } else if (this.bAuthBasic.getSelection()) {
            String username = this.fUserName.getText().trim();
            if (username.length() == 0) {
                this.showWarning(WsLPEditorTexts.getString("LPEditor.Pages.Security.wrongUserName"), WsLPEditorTexts.getString("LPEditor.Pages.Security.wrongUserNameMsg"));
            }
            newProperties.setProperty("AuthenticationLevel", "Basic");
            newProperties.setProperty("AuthenticationMethod", "BasicAuth");
            newProperties.setProperty("AuthenticationCredentialUser", username);
            ((Hashtable)newProperties).remove("clientKeystore");
            ((Hashtable)newProperties).remove("certName");
            ((Hashtable)newProperties).remove("SSLServerAuthentication");
            ((Hashtable)newProperties).remove("SSLServerAuthenticationKeystoreView");
        } else if (this.bAuthStrong.getSelection()) {
            String certName;
            String keystoreName = this.fKeyStoreName.getText().trim();
            if (keystoreName.length() == 0) {
                this.showWarning(WsLPEditorTexts.getString("LPEditor.Pages.Security.wrongKeystoreName"), WsLPEditorTexts.getString("LPEditor.Pages.Security.wrongKeystoreNameMsg"));
            }
            if ((certName = this.fCertName.getText().trim()).length() == 0) {
                this.showWarning(WsLPEditorTexts.getString("LPEditor.Pages.Security.wrongCertName"), WsLPEditorTexts.getString("LPEditor.Pages.Security.wrongCertNameMsg"));
            }
            newProperties.setProperty("AuthenticationLevel", "Strong");
            newProperties.setProperty("AuthenticationMethod", "CertAuth");
            newProperties.setProperty("clientKeystore", keystoreName);
            newProperties.setProperty("certName", certName);
            ((Hashtable)newProperties).remove("AuthenticationCredentialUser");
            ((Hashtable)newProperties).remove("SSLServerAuthentication");
            ((Hashtable)newProperties).remove("SSLServerAuthenticationKeystoreView");
        } else if (this.bAuthSAPLogon.getSelection()) {
            newProperties.setProperty("AuthenticationLevel", "Strong");
            newProperties.setProperty("AuthenticationMethod", "SSO2");
            newProperties.setProperty("SSLServerAuthentication", this.bDoNotVerifyCert.getSelection() ? "false" : "true");
            newProperties.setProperty("SSLServerAuthenticationKeystoreView", this.fTrustedCerts.getText());
            ((Hashtable)newProperties).remove("AuthenticationCredentialUser");
            ((Hashtable)newProperties).remove("clientKeystore");
            ((Hashtable)newProperties).remove("certName");
        }
        Set keys = ((Hashtable)newProperties).keySet();
        int size = keys.size();
        PropertyType[] newProps = new PropertyType[size];
        Iterator it = keys.iterator();
        int i2 = 0;
        while (i2 < size) {
            String name = it.next().toString();
            String value = newProperties.getProperty(name, "");
            newProps[i2] = new PropertyType();
            newProps[i2].setName(name);
            newProps[i2].setValue(value);
            ++i2;
        }
        authenticationFeature.setProperty(newProps);
        return true;
    }

    public void setReadOnly(boolean globalReadOnly, boolean localReadOnly) {
        if (this.fUserName.isEnabled()) {
            this.fUserName.setEditable(!globalReadOnly);
        }
        if (this.fKeyStoreName.isEnabled()) {
            this.fKeyStoreName.setEditable(!globalReadOnly);
        }
        if (this.fCertName.isEnabled()) {
            this.fCertName.setEditable(!globalReadOnly);
        }
    }

    public void refresh() {
    }
}

