/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.editors.lp.pages;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.OperationType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.sap.ide.ws.core.editors.FileReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.soapapp.FeatureConstants;
import com.sap.ide.ws.soapapp.SoapAppToolPlugin;
import com.sap.ide.wsproxy.editors.lp.LogicalPortEditor;
import com.sap.ide.wsproxy.editors.lp.pages.LpEditorPage;
import com.sap.ide.wsproxy.editors.lp.text.WsLPEditorTexts;
import com.sap.security.core.policy.PolicyTemplateInfoManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class SecurityConfigurationPage
extends LpEditorPage
implements SelectionListener,
ModifyListener,
FeatureConstants {
    private boolean securityrolesallowed;
    private static final Image OPERATION_ICON = SoapAppToolPlugin.getImage((String)"config_wizard/operation1.gif");
    private static final int SSO2_AUTHENTICATION = 16;
    public static final String MECHANISM_NONE = WsLPEditorTexts.getString("LPeditor.Pages.Security.Combo.None");
    public static final String MECHANISM_HTTP = WsLPEditorTexts.getString("LPeditor.Pages.Security.Combo.HTTPAuthentication");
    public static final String MECHANISM_DOCUMENT = WsLPEditorTexts.getString("LPeditor.Pages.Security.Combo.DocumentAuthentication");
    private static final String[] TRANSPORTS = new String[]{WsLPEditorTexts.getString("LPeditor.Pages.Security.Combo.HTTP"), WsLPEditorTexts.getString("LPeditor.Pages.Security.Combo.HTTPS")};
    private static final String[] HTTPS_TRANSPORT = new String[]{WsLPEditorTexts.getString("LPeditor.Pages.Security.Combo.HTTPS")};
    private static final String[] AUTHENTICATIONS = new String[]{"None", "Basic", "X.509"};
    private static final String[] MECHANISMS = new String[]{MECHANISM_NONE, MECHANISM_HTTP, MECHANISM_DOCUMENT};
    private static final String[] HTTP_AND_NONE = new String[]{MECHANISM_NONE, MECHANISM_HTTP};
    private ISelection selection;
    private OperationType[] configs;
    private IGridLayoutPane mainPane = null;
    private org.eclipse.swt.widgets.List tv = null;
    private Combo authmechanism = null;
    private FeatureType[] features = null;
    private boolean isstateful = false;
    private int wsdsecuritylevel = 0;
    private int wscfgsecuritylevel = 0;
    private Button currentselectedbutton = null;
    private Button basicauthbutton = null;
    private Button certauthbutton = null;
    private Button acceptSAPticket = null;
    private Button firstbutton = null;
    private Button secondbutton = null;
    private Button thirdbutton = null;
    private Text requestlabel = null;
    private Text responselabel = null;
    private Combo requestcombo = null;
    private Combo responsecombo = null;
    private boolean SSO2auth = false;
    private PolicyTemplateInfoManager ptim = new PolicyTemplateInfoManager();
    private boolean canhavedocauth = true;
    private boolean isSAPWSDL;
    LogicalPortEditor lpe;
    static /* synthetic */ Class class$com$sap$ide$wsproxy$editors$lp$pages$SecurityConfigurationPage;

    public SecurityConfigurationPage(Composite parentComposite, LogicalPortEditor parentEditor) {
        super(parentComposite, parentEditor);
        this.lpe = parentEditor;
    }

    public FeatureType[] createDeployTimeFeatures() {
        PropertyType[] properties;
        FeatureType[] dtfeatures = new FeatureType[]{};
        int deployfeaturecount = 0;
        if (this.isstateful) {
            ++deployfeaturecount;
        }
        int noneauthindex = this.authmechanism.getItemCount() - 3;
        int authindex = this.authmechanism.getSelectionIndex();
        boolean httpstransport = this.lpe.getEndpoint().toUpperCase().startsWith("HTTPS");
        if (!httpstransport && authindex == noneauthindex) {
            dtfeatures = new FeatureType[deployfeaturecount];
            this.wscfgsecuritylevel = 0;
        } else if (httpstransport && authindex == noneauthindex) {
            dtfeatures = new FeatureType[++deployfeaturecount];
            dtfeatures[0] = new FeatureType();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new PropertyType[]{new PropertyType()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[0].setProperty(properties);
            dtfeatures[0].setProvider("SecurityProtocol");
            this.wscfgsecuritylevel = 1;
        } else if (!httpstransport && this.basicauthbutton.getSelection()) {
            dtfeatures = new FeatureType[++deployfeaturecount];
            dtfeatures[0] = new FeatureType();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new PropertyType[]{new PropertyType()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("BasicAuth");
            dtfeatures[0].setProperty(properties);
            dtfeatures[0].setProvider("SecurityProtocol");
            this.wscfgsecuritylevel = 4;
        } else if (httpstransport && this.basicauthbutton.getSelection()) {
            dtfeatures = new FeatureType[deployfeaturecount += 2];
            dtfeatures[0] = new FeatureType();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new PropertyType[]{new PropertyType()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("BasicAuth");
            dtfeatures[0].setProvider("SecurityProtocol");
            dtfeatures[0].setProperty(properties);
            dtfeatures[1] = new FeatureType();
            dtfeatures[1].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new PropertyType[]{new PropertyType()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[1].setProvider("SecurityProtocol");
            dtfeatures[1].setProperty(properties);
            this.wscfgsecuritylevel = 5;
        } else if (httpstransport && this.certauthbutton.getSelection()) {
            dtfeatures = new FeatureType[deployfeaturecount += 2];
            dtfeatures[0] = new FeatureType();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new PropertyType[]{new PropertyType()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("CertAuth");
            dtfeatures[0].setProvider("SecurityProtocol");
            dtfeatures[0].setProperty(properties);
            dtfeatures[1] = new FeatureType();
            dtfeatures[1].setName("http://www.sap.com/webas/630/soap/features/transportguarantee");
            properties = new PropertyType[]{new PropertyType()};
            properties[0].setName("TLSType");
            properties[0].setValue("SSL");
            dtfeatures[1].setProvider("SecurityProtocol");
            dtfeatures[1].setProperty(properties);
            this.wscfgsecuritylevel = 9;
        } else if (!httpstransport && this.certauthbutton.getSelection()) {
            dtfeatures = new FeatureType[++deployfeaturecount];
            dtfeatures[0] = new FeatureType();
            dtfeatures[0].setName("http://www.sap.com/webas/630/soap/features/authentication");
            properties = new PropertyType[]{new PropertyType()};
            properties[0].setName("AuthenticationMethod");
            properties[0].setValue("CertAuth");
            dtfeatures[0].setProvider("SecurityProtocol");
            dtfeatures[0].setProperty(properties);
            this.wscfgsecuritylevel = 8;
        }
        if (this.isstateful) {
            dtfeatures[deployfeaturecount - 1] = new FeatureType();
            dtfeatures[deployfeaturecount - 1].setName("http://www.sap.com/webas/630/soap/features/session/");
            properties = new PropertyType[]{new PropertyType()};
            properties[0].setName("SessionMethod");
            properties[0].setValue("httpCookies");
            dtfeatures[deployfeaturecount - 1].setProperty(properties);
        }
        PropertyType pt = this.findProperty(dtfeatures, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism");
        int index = this.authmechanism.getSelectionIndex();
        if (pt == null) {
            dtfeatures = this.addFeature(dtfeatures, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism", "None");
            pt = dtfeatures[dtfeatures.length - 1].getProperty()[0];
        }
        if (index == 0) {
            pt.setValue("None");
        } else if (index == 1) {
            pt.setValue("HTTP");
        } else if (index == 2) {
            pt.setValue("Document");
        }
        return this.splitFeatures(dtfeatures);
    }

    public void init() {
        boolean hasoperations;
        this.canhavedocauth = this.lpe.isDeployableProject();
        this.canhavedocauth = this.canhavedocauth && this.port.getBindingImplementation().equals("SOAP 1.1 HTTP Binding with Attachments");
        this.isSAPWSDL = this.allFeaturesAreOriginal();
        this.configs = this.port.hasLocalFeatures() ? this.port.getLocalFeatures().getOperation() : new OperationType[0];
        this.features = this.splitFeatures(this.filterFeatures(this.port.getGlobalFeatures().getFeature(), false));
        String[] s = new String[this.configs.length];
        this.tv.addSelectionListener((SelectionListener)this);
        int i = 0;
        while (i < this.configs.length) {
            s[i] = this.configs[i].getName();
            ++i;
        }
        this.tv.setItems(s);
        boolean bl = hasoperations = this.configs.length > 0;
        if (this.canhavedocauth) {
            this.authmechanism.setItems(MECHANISMS);
        } else {
            this.authmechanism.setItems(HTTP_AND_NONE);
        }
        this.requestcombo.setEnabled(hasoperations && this.canhavedocauth && !this.isSAPWSDL);
        this.responsecombo.setEnabled(hasoperations && this.canhavedocauth && !this.isSAPWSDL);
        this.initFeatures(this.features);
        if (hasoperations && this.canhavedocauth) {
            this.tv.setSelection(0);
            this.responsecombo.setItems(this.getPolicies("ResponsePolicy"));
            this.requestcombo.setItems(this.getPolicies("RequestPolicy"));
            this.responsecombo.setText(this.getPolicy(this.configs[0], "ResponsePolicy"));
            this.requestcombo.setText(this.getPolicy(this.configs[0], "RequestPolicy"));
            String descr = this.ptim.getInboundPolicyShortDescription(this.responsecombo.getText());
            if (descr != null) {
                this.responselabel.setText(descr);
            } else {
                this.responselabel.setText("");
            }
            descr = this.ptim.getOutboundPolicyShortDescription(this.requestcombo.getText());
            if (descr != null) {
                this.requestlabel.setText(descr);
            } else {
                this.requestlabel.setText("");
            }
        }
        if (this.canhavedocauth) {
            int i2 = 1;
            while (i2 < this.configs.length) {
                this.getPolicy(this.configs[i2], "RequestPolicy");
                this.getPolicy(this.configs[i2], "ResponsePolicy");
                ++i2;
            }
            if (hasoperations) {
                this.setPolicycombo(this.configs[0], this.requestcombo, this.requestlabel, "RequestPolicy", true);
                this.setPolicycombo(this.configs[0], this.responsecombo, this.responselabel, "ResponsePolicy", true);
            }
        } else {
            this.requestcombo.setEnabled(false);
            this.responsecombo.setEnabled(false);
        }
    }

    void initFeatures(FeatureType[] features) {
        this.wsdsecuritylevel = this.getWSDSecurityLevel(features);
        this.wscfgsecuritylevel = this.getCfgSecurityLevel(features);
        this.basicauthbutton.setEnabled((this.wsdsecuritylevel & 0xC) < 8);
        this.basicauthbutton.setSelection((this.wscfgsecuritylevel & 0xC) == 4);
        this.certauthbutton.setSelection((this.wscfgsecuritylevel & 0xC) == 8);
        this.acceptSAPticket.setSelection(this.SSO2auth && !this.basicauthbutton.getSelection() && !this.certauthbutton.getSelection());
        if (this.basicauthbutton.getSelection()) {
            this.currentselectedbutton = this.basicauthbutton;
        }
        if (this.certauthbutton.getSelection()) {
            this.currentselectedbutton = this.certauthbutton;
        }
        if (this.acceptSAPticket.getSelection()) {
            this.currentselectedbutton = this.acceptSAPticket;
        }
        PropertyType pt = this.findProperty(features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism");
        if ((this.wscfgsecuritylevel & 0xC) == 0 && !this.SSO2auth) {
            if (pt == null) {
                features = this.addFeature(features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism", "None");
                pt = features[features.length - 1].getProperty()[0];
            }
            this.authmechanism.select(0);
        } else {
            if (pt == null) {
                features = this.addFeature(features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism", "HTTP");
                pt = features[features.length - 1].getProperty()[0];
            }
            if (pt.getValue().equals("Document") && this.canhavedocauth) {
                this.authmechanism.select(2);
            } else {
                this.authmechanism.select(1);
            }
        }
        int index = this.authmechanism.getSelectionIndex();
        this.basicauthbutton.setVisible(index > 0);
        this.certauthbutton.setVisible(index > 0 && this.lpe.getEndpoint().toUpperCase().startsWith("HTTPS") || pt.getValue().equals("Document"));
        this.acceptSAPticket.setVisible(index == 1);
        this.basicauthbutton.setEnabled(this.certauthbutton.getVisible() || this.acceptSAPticket.getVisible());
        this.authmechanism.setEnabled(!this.isSAPWSDL);
    }

    public Composite getControl() {
        try {
            IGridLayoutPane mainPane1 = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)3);
            IGridLayoutPane tpane = mainPane1.addGridLayoutPane(1, mainPane1.createGridLayoutData(4, 4, true, true, 2, 2));
            IGridLayoutPane generalpane = tpane.addGridLayoutPane(1, tpane.createGridLayoutData(4, 1, true, false, 1, 2));
            this.createAuthenticationPane(generalpane);
            this.mainPane = tpane.addGridLayoutPane(2, generalpane.createGridLayoutData(4, 4, true, true, 1, 1));
            this.createOperationListPane(tpane);
            return mainPane1.getComposite();
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$wsproxy$editors$lp$pages$SecurityConfigurationPage == null ? (class$com$sap$ide$wsproxy$editors$lp$pages$SecurityConfigurationPage = SecurityConfigurationPage.class$("com.sap.ide.wsproxy.editors.lp.pages.SecurityConfigurationPage")) : class$com$sap$ide$wsproxy$editors$lp$pages$SecurityConfigurationPage));
            return null;
        }
    }

    private void doSecurityLevelReset(SelectionEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(final SelectionEvent event) {
        if (event.widget != this.tv && event.widget != this.currentselectedbutton && !this.isInResetMode()) {
            ResetPageStateI reset = new ResetPageStateI(){

                public void handleReset() {
                    if (event.widget == SecurityConfigurationPage.this.authmechanism || event.widget == SecurityConfigurationPage.this.basicauthbutton || event.widget == SecurityConfigurationPage.this.certauthbutton || event.widget == SecurityConfigurationPage.this.acceptSAPticket) {
                        SecurityConfigurationPage.this.initFeatures(SecurityConfigurationPage.this.features);
                    } else if (event.widget == SecurityConfigurationPage.this.requestcombo || event.widget == SecurityConfigurationPage.this.responsecombo) {
                        int index = SecurityConfigurationPage.this.tv.getSelectionIndex();
                        if (SecurityConfigurationPage.this.canhavedocauth) {
                            SecurityConfigurationPage.this.responsecombo.setItems(SecurityConfigurationPage.this.getPolicies("ResponsePolicy"));
                            SecurityConfigurationPage.this.requestcombo.setItems(SecurityConfigurationPage.this.getPolicies("RequestPolicy"));
                            SecurityConfigurationPage.this.responsecombo.setText(SecurityConfigurationPage.this.getPolicy(SecurityConfigurationPage.this.configs[index], "ResponsePolicy"));
                            SecurityConfigurationPage.this.requestcombo.setText(SecurityConfigurationPage.this.getPolicy(SecurityConfigurationPage.this.configs[index], "RequestPolicy"));
                            String descr = SecurityConfigurationPage.this.ptim.getOutboundPolicyShortDescription(SecurityConfigurationPage.this.responsecombo.getText());
                            if (descr != null) {
                                SecurityConfigurationPage.this.responselabel.setText(descr);
                            }
                            if ((descr = SecurityConfigurationPage.this.ptim.getInboundPolicyShortDescription(SecurityConfigurationPage.this.requestcombo.getText())) != null) {
                                SecurityConfigurationPage.this.requestlabel.setText(descr);
                            }
                        }
                    }
                }
            };
            if (!this.isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(((LogicalPortEditor)this.getParentEditor()).getLPXMLFile()), reset) || !this.isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(((LogicalPortEditor)this.getParentEditor()).getLPFile()), reset)) {
                return;
            }
        }
        this.adjustPageData((TypedEvent)event);
    }

    void adjustPageData(TypedEvent te) {
        if (te.widget == this.tv) {
            int selected = this.tv.getSelectionIndex();
            if (selected > -1 && this.canhavedocauth) {
                this.setPolicycombo(this.configs[selected], this.requestcombo, this.requestlabel, "RequestPolicy", true);
                this.setPolicycombo(this.configs[selected], this.responsecombo, this.responselabel, "ResponsePolicy", true);
            }
        } else if (te.widget == this.basicauthbutton || te.widget == this.certauthbutton || te.widget == this.authmechanism || te.widget == this.acceptSAPticket) {
            if (te.widget == this.authmechanism) {
                int index = this.authmechanism.getSelectionIndex();
                this.basicauthbutton.setVisible(index > 0);
                this.certauthbutton.setVisible(index > 0 && (this.lpe.getEndpoint().toUpperCase().startsWith("HTTPS") || index == 2));
                this.acceptSAPticket.setVisible(index == 1);
                if (index == 1) {
                    if (!(this.basicauthbutton.getSelection() || this.certauthbutton.getSelection() || this.acceptSAPticket.getSelection())) {
                        this.basicauthbutton.setSelection(true);
                    }
                } else if (index == 2) {
                    this.acceptSAPticket.setSelection(false);
                    if (!this.basicauthbutton.getSelection() && !this.certauthbutton.getSelection()) {
                        this.basicauthbutton.setSelection(true);
                    }
                }
                this.basicauthbutton.setEnabled(this.certauthbutton.getVisible() || this.acceptSAPticket.getVisible());
            }
            if (te.widget != this.currentselectedbutton) {
                int configindex;
                this.setTransportFeature(((LogicalPortEditor)this.getParentEditor()).getEndpoint());
                FeatureType[] wsdfeatures = this.features;
                ArrayList<FeatureType> al = new ArrayList<FeatureType>();
                int i = 0;
                while (i < wsdfeatures.length) {
                    if (!this.isDeployTimeFeature(wsdfeatures[i])) {
                        al.add(wsdfeatures[i]);
                    }
                    ++i;
                }
                this.isstateful = this.containsSessionFeature(al);
                FeatureType[] dtfeatures = this.createDeployTimeFeatures();
                int i2 = 0;
                while (i2 < dtfeatures.length) {
                    al.add(dtfeatures[i2]);
                    ++i2;
                }
                FeatureType[] f = new FeatureType[al.size()];
                f = al.toArray(f);
                this.features = f;
                if (te.widget instanceof Button) {
                    this.currentselectedbutton = (Button)te.widget;
                }
                if (te.widget == this.acceptSAPticket) {
                    this.setSSO();
                }
                if ((configindex = this.tv.getSelectionIndex()) >= 0 && this.canhavedocauth) {
                    this.setPolicycombo(this.configs[configindex], this.requestcombo, this.requestlabel, "RequestPolicy", false);
                    this.setPolicycombo(this.configs[configindex], this.responsecombo, this.responselabel, "ResponsePolicy", false);
                }
                super.notifyOfChange();
            }
        } else if (te.widget == this.requestcombo) {
            String descr;
            int index = this.tv.getSelectionIndex();
            if (index > -1) {
                this.setPolicy(this.configs[index], "RequestPolicy", this.requestcombo.getText());
            }
            if ((descr = this.ptim.getOutboundPolicyShortDescription(this.requestcombo.getText())) != null) {
                this.requestlabel.setText(descr);
            }
            super.notifyOfChange();
        } else if (te.widget == this.responsecombo) {
            String descr;
            int index = this.tv.getSelectionIndex();
            if (index > -1) {
                this.setPolicy(this.configs[index], "ResponsePolicy", this.responsecombo.getText());
            }
            if ((descr = this.ptim.getInboundPolicyShortDescription(this.responsecombo.getText())) != null) {
                this.responselabel.setText(descr);
            }
            super.notifyOfChange();
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    private PropertyType findProperty(OperationType operation) {
        PropertyType[] props;
        FeatureType feature = this.findFeature(operation);
        if (feature != null && (props = feature.getProperty()) != null) {
            int k = 0;
            while (k < props.length) {
                if ("user-role".equals(props[k].getName())) {
                    return props[k];
                }
                ++k;
            }
        }
        return null;
    }

    private FeatureType findFeature(OperationType operation) {
        FeatureType[] oldFeatures = operation.getFeature();
        if (oldFeatures != null) {
            int j = 0;
            while (j < oldFeatures.length) {
                if ("http://sap.com/security".equals(oldFeatures[j].getName())) {
                    return oldFeatures[j];
                }
                ++j;
            }
        }
        return null;
    }

    private PropertyType[] getNewProperties(PropertyType[] oldProps, String roles) {
        PropertyType[] newProps = new PropertyType[oldProps.length + 1];
        System.arraycopy(oldProps, 0, newProps, 0, oldProps.length);
        newProps[newProps.length - 1] = new PropertyType();
        newProps[newProps.length - 1].setName("user-role");
        newProps[newProps.length - 1].setValue(roles);
        return newProps;
    }

    boolean containsSessionFeature(ArrayList features) {
        int i = 0;
        while (i < features.size()) {
            if (((FeatureType)features.get(i)).getName().equals("http://www.sap.com/webas/630/soap/features/session/")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updatePage() {
    }

    public void setInitialSelectedRadioButton() {
    }

    public void createAuthenticationPane(IGridLayoutPane parent) {
        IGridLayoutPane authpane = parent.addGridLayoutPane(WsLPEditorTexts.getString("LPeditor.Pages.Security.authentication"), 3, parent.createGridLayoutData(4, 4, true, true, 1, 2));
        authpane.addTextLabel(WsLPEditorTexts.getString("LPeditor.Pages.Security.authenticationmechanism"), parent.createGridLayoutData(1, 4, false, true, 1, 1));
        this.authmechanism = authpane.addComboBox(new String[0], "", true, parent.createGridLayoutData(4, 4, true, true, 1, 1));
        this.authmechanism.addSelectionListener((SelectionListener)this);
        this.basicauthbutton = authpane.addRadioButton(WsLPEditorTexts.getString("LPeditor.Pages.Security.basicauth"), parent.createGridLayoutData(4, 4, true, true, 3, 1));
        boolean proxyhttpsselected = false;
        boolean documentselected = false;
        FeatureType[] f = this.port.getGlobalFeatures().getFeature();
        int i = 0;
        while (i < f.length) {
            if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/transportguarantee") || f[i].getName().equals("http://www.sap.com/webas/630/soap/features/authentication")) {
                PropertyType[] p = f[i].getProperty();
                int j = 0;
                while (j < p.length) {
                    if (p[j].getName().equals("TLSType")) {
                        if (p[j].getValue().equals("SSL")) {
                            proxyhttpsselected = true;
                        }
                    } else if (p[j].getValue().equals("AuthenticationMechanism") && p[j].getValue().equals("Document")) {
                        documentselected = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.firstbutton = this.basicauthbutton;
        if (proxyhttpsselected || documentselected) {
            this.certauthbutton = authpane.addRadioButton(WsLPEditorTexts.getString("LPeditor.Pages.Security.certauth"), parent.createGridLayoutData(4, 4, true, true, 3, 1));
            this.acceptSAPticket = authpane.addRadioButton(WsLPEditorTexts.getString("LPeditor.Pages.Security.acceptsapticket"), parent.createGridLayoutData(4, 4, true, true, 3, 1));
            this.secondbutton = this.certauthbutton;
            this.thirdbutton = this.acceptSAPticket;
        }
        if (!proxyhttpsselected && !documentselected) {
            this.acceptSAPticket = authpane.addRadioButton(WsLPEditorTexts.getString("LPeditor.Pages.Security.acceptsapticket"), parent.createGridLayoutData(4, 4, true, true, 3, 1));
            this.certauthbutton = authpane.addRadioButton(WsLPEditorTexts.getString("LPeditor.Pages.Security.certauth"), parent.createGridLayoutData(4, 4, true, true, 3, 1));
            this.certauthbutton.setVisible(false);
            this.secondbutton = this.acceptSAPticket;
            this.thirdbutton = this.certauthbutton;
        }
        this.basicauthbutton.addSelectionListener((SelectionListener)this);
        this.certauthbutton.addSelectionListener((SelectionListener)this);
        this.acceptSAPticket.addSelectionListener((SelectionListener)this);
    }

    public void createOperationListPane(IGridLayoutPane parent) {
        IGridLayoutPane authpane = parent.addGridLayoutPane(3, parent.createGridLayoutData(4, 4, true, true, 1, 5));
        IGridLayoutPane operationspane = authpane.addGridLayoutPane(WsLPEditorTexts.getString("LPeditor.Pages.Security.operations"), 1, this.mainPane.createGridLayoutData(4, 4, true, false, 1, 2));
        this.tv = operationspane.addList(new String[0], false, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 2));
        ITabbedPane tpane = authpane.addTabbedPane(this.mainPane.createGridLayoutData(4, 4, true, true, 2, 2));
        IGridLayoutPane securitytab = tpane.addGridLayoutPaneAsTab(WsLPEditorTexts.getString("LPeditor.Pages.Security.documentsecurity"), 1);
        int selected = this.tv.getSelectionIndex();
        IGridLayoutPane sectabpane = securitytab.addGridLayoutPane(1, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 3));
        IGridLayoutPane requestpane = sectabpane.addGridLayoutPane(WsLPEditorTexts.getString("LPeditor.Pages.Security.request"), 1, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 3));
        this.requestcombo = requestpane.addComboBox(new String[0], "", true, this.mainPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.requestcombo.addSelectionListener((SelectionListener)this);
        this.requestlabel = requestpane.addTextPane("", true, true, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 3));
        IGridLayoutPane responsepane = sectabpane.addGridLayoutPane(WsLPEditorTexts.getString("LPeditor.Pages.Security.response"), 1, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 3));
        this.responsecombo = responsepane.addComboBox(new String[0], "", true, this.mainPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.responsecombo.addSelectionListener((SelectionListener)this);
        this.responselabel = responsepane.addTextPane("", true, true, this.mainPane.createGridLayoutData(4, 4, true, true, 1, 3));
    }

    public FeatureType getWSSecurityFeature(OperationType cfg) {
        FeatureType[] f = cfg.getFeature();
        FeatureType f1 = null;
        int i = 0;
        while (i < f.length) {
            if (f[i].getName().equals("http://www.sap.com/webas/630/soap/features/wss")) {
                f1 = f[i];
            }
            ++i;
        }
        if (f1 == null) {
            f1 = new FeatureType();
            f1.setName("http://www.sap.com/webas/630/soap/features/wss");
            f1.setProvider("SecurityProtocol");
            FeatureType[] f2 = new FeatureType[f.length + 1];
            System.arraycopy(f, 0, f2, 0, f.length);
            f2[f.length] = f1;
            cfg.setFeature(f2);
        }
        return f1;
    }

    public void setPolicy(OperationType cfg, String policytype, String policyname) {
        FeatureType f = this.getWSSecurityFeature(cfg);
        PropertyType[] p = f.getProperty();
        PropertyType requestp = null;
        int i = 0;
        while (i < p.length) {
            if (p[i].getName().equals(policytype)) {
                requestp = p[i];
            }
            ++i;
        }
        if (requestp == null) {
            requestp = new PropertyType();
            requestp.setName(policytype);
        }
        requestp.setValue(policyname);
    }

    public String getPolicy(OperationType cfg, String policytype) {
        FeatureType f = this.getWSSecurityFeature(cfg);
        PropertyType[] p = f.getProperty();
        PropertyType p1 = null;
        int i = 0;
        while (i < p.length) {
            if (p[i].getName().equals(policytype)) {
                p1 = p[i];
            }
            ++i;
        }
        if (p1 == null) {
            PropertyType[] p2 = new PropertyType[p.length + 1];
            System.arraycopy(p, 0, p2, 0, p.length);
            p1 = new PropertyType();
            p1.setName(policytype);
            p1.setValue(this.getDefaultPolicyName(policytype));
            p2[p.length] = p1;
            f.setProperty(p2);
        }
        return p1.getValue();
    }

    public String getDefaultPolicyName(String policytype) {
        String policygroup = this.getPolicyGroup();
        List policies = null;
        if (policytype.equals("RequestPolicy")) {
            policies = this.ptim.getOutboundPolicyNamesByFeature(policygroup);
        } else if (policytype.equals("ResponsePolicy")) {
            policies = this.ptim.getInboundPolicyNamesByFeature("AUTHENTICATION_NONE");
        }
        return (String)policies.get(0);
    }

    public String[] getPolicies(String policytype) {
        String policygroup = this.getPolicyGroup();
        List policies = null;
        if (policytype.equals("RequestPolicy")) {
            policies = this.ptim.getOutboundPolicyNamesByFeature(policygroup);
        } else if (policytype.equals("ResponsePolicy")) {
            policies = this.ptim.getInboundPolicyNamesByFeature("AUTHENTICATION_NONE");
        }
        String[] s = new String[policies.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = (String)policies.get(i);
            ++i;
        }
        return s;
    }

    public void setPolicycombo(OperationType cfg, Combo combo, Text description, String policytype, boolean initial) {
        int policyindex = -1;
        String policy = this.getPolicy(cfg, policytype);
        String[] policies = this.getPolicies(policytype);
        int i = 0;
        while (i < policies.length) {
            if (policy.equals(policies[i])) {
                policyindex = i;
            }
            ++i;
        }
        combo.setItems(policies);
        if (policyindex == -1) {
            if (initial) {
                combo.add(policy);
                policyindex = combo.getItemCount() - 1;
            } else {
                policyindex = 0;
                String[] outbound = this.getPolicies("RequestPolicy");
                String[] inbound = this.getPolicies("ResponsePolicy");
                int i2 = 0;
                while (i2 < this.configs.length) {
                    boolean found = false;
                    String cfgpolicy = this.getPolicy(this.configs[i2], "RequestPolicy");
                    int j = 0;
                    while (j < outbound.length) {
                        if (cfgpolicy.equals(outbound[j])) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        this.setPolicy(this.configs[i2], "RequestPolicy", outbound[0]);
                    }
                    found = false;
                    cfgpolicy = this.getPolicy(this.configs[i2], "ResponsePolicy");
                    int j2 = 0;
                    while (j2 < inbound.length) {
                        if (cfgpolicy.equals(inbound[j2])) {
                            found = true;
                            break;
                        }
                        ++j2;
                    }
                    if (!found) {
                        this.setPolicy(this.configs[i2], "ResponsePolicy", inbound[0]);
                    }
                    ++i2;
                }
            }
        }
        combo.select(policyindex);
        if (policytype.equals("RequestPolicy")) {
            description.setText(this.ptim.getOutboundPolicyShortDescription(this.getPolicy(cfg, "RequestPolicy")));
        } else if (policytype.equals("ResponsePolicy")) {
            description.setText(this.ptim.getInboundPolicyShortDescription(this.getPolicy(cfg, "ResponsePolicy")));
        }
    }

    public FeatureType getSSOFeature() {
        PropertyType[] p;
        FeatureType f = null;
        int i = 0;
        while (i < this.features.length) {
            if (this.features[i].getName().equals("http://www.sap.com/webas/630/soap/features/authentication")) {
                p = this.features[i].getProperty();
                int j = 0;
                while (j < p.length) {
                    if (p[j].getName().equals("AuthenticationMethod")) {
                        f = this.features[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (f == null) {
            f = new FeatureType();
            f.setName("http://www.sap.com/webas/630/soap/features/authentication");
            p = new PropertyType[]{new PropertyType()};
            p[0].setName("AuthenticationMethod");
            p[0].setValue("SSOAuth");
            f.setProperty(p);
            FeatureType[] f1 = new FeatureType[this.features.length + 1];
            System.arraycopy(this.features, 0, f1, 0, this.features.length);
            f1[this.features.length] = f;
            this.features = f1;
        }
        return f;
    }

    public void setSSO() {
        FeatureType f = this.getSSOFeature();
        PropertyType pt = this.findProperty(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMethod");
        if (pt == null) {
            this.features = this.addFeature(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMethod", "");
            pt = this.features[this.features.length - 1].getProperty()[0];
        }
        pt.setValue("SSO2Auth");
    }

    public FeatureType[] splitFeatures(FeatureType[] source) {
        Vector<FeatureType> v = new Vector<FeatureType>();
        int i = 0;
        while (i < source.length) {
            PropertyType[] props = source[i].getProperty();
            int j = 0;
            while (j < props.length) {
                FeatureType ft = new FeatureType();
                ft.setName(source[i].getName());
                ft.setOriginal(source[i].getOriginal());
                ft.setProvider(source[i].getProvider());
                PropertyType[] pt = new PropertyType[]{props[j]};
                ft.setProperty(pt);
                v.add(ft);
                ++j;
            }
            ++i;
        }
        FeatureType[] result = new FeatureType[v.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (FeatureType)v.elementAt(i2);
            ++i2;
        }
        return result;
    }

    public FeatureType[] mergeFeatures(FeatureType[] source) {
        Vector<FeatureType> v = new Vector<FeatureType>();
        int i = 0;
        while (i < source.length) {
            FeatureType ft;
            boolean found = false;
            int j = 0;
            while (j < v.size()) {
                if (source[i].getName().equals(((FeatureType)v.elementAt(j)).getName())) {
                    ft = (FeatureType)v.elementAt(j);
                    ft.addProperty(source[i].getProperty()[0]);
                    found = true;
                    if (source[i].getProvider() == null || source[i].getProvider().equals("")) break;
                    ft.setProvider(source[i].getProvider());
                    break;
                }
                ++j;
            }
            if (!found) {
                ft = new FeatureType();
                ft.setName(source[i].getName());
                ft.setOriginal(source[i].getOriginal());
                if (source[i].getProvider() != null && !source[i].getProvider().equals("")) {
                    ft.setProvider(source[i].getProvider());
                }
                ft.addProperty(source[i].getProperty()[0]);
                v.add(ft);
            }
            ++i;
        }
        FeatureType[] result = new FeatureType[v.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (FeatureType)v.elementAt(i2);
            ++i2;
        }
        return result;
    }

    public boolean doSave() {
        this.setTransportFeature(this.port.getEndpoint());
        FeatureType[] security = this.mergeFeatures(this.features);
        FeatureType[] nonsecurity = this.filterFeatures(this.port.getGlobalFeatures().getFeature(), true);
        FeatureType[] portfeatures = this.addSecurityFeatures(nonsecurity, security);
        this.port.getGlobalFeatures().setFeature(portfeatures);
        if (this.configs.length > 0) {
            this.port.getLocalFeatures().setOperation(this.configs);
        }
        return true;
    }

    public void refresh() {
    }

    public void setReadOnly(boolean globalReadOnly, boolean localReadOnly) {
    }

    private Vector getSelectedSecurityRoles(OperationType op) {
        FeatureType[] ft = op.getFeature();
        PropertyType pt = this.findProperty(ft, "http://www.sap.com/webas/630/soap/features/authorization", "security-roles");
        if (pt == null) {
            ft = this.addFeature(this.features, "http://www.sap.com/webas/630/soap/features/authorization", "security-roles", "");
            pt = ft[this.features.length - 1].getProperty()[0];
        }
        PropertyType[] roles = pt.getProperty();
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < roles.length) {
            v.add(roles[i].getValue());
            ++i;
        }
        return v;
    }

    private FeatureType[] getDesignTimeFeatures() {
        Vector<FeatureType> v = new Vector<FeatureType>();
        FeatureType[] ft = this.port.getGlobalFeatures().getFeature();
        int i = 0;
        while (i < ft.length) {
            if (!this.isDeployTimeFeature(ft[i])) {
                v.add(ft[i]);
            }
            ++i;
        }
        ft = new FeatureType[v.size()];
        int i2 = 0;
        while (i2 < ft.length) {
            ft[i2] = (FeatureType)v.elementAt(i2);
            ++i2;
        }
        return ft;
    }

    private int getCfgSecurityLevel(FeatureType[] features) {
        int transport = 0;
        int authentication = 0;
        int sso2 = 0;
        PropertyType pt = this.findProperty(features, "http://www.sap.com/webas/630/soap/features/transportguarantee", "TLSType");
        if (pt != null && pt.getValue().equals("SSL")) {
            transport = 1;
        }
        if ((pt = this.findProperty(features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMethod")) != null) {
            String value = pt.getValue();
            if (value.equals("BasicAuth")) {
                authentication = 4;
            } else if (value.equals("CertAuth")) {
                authentication = 8;
            } else if (value.equals("SSO2Auth")) {
                sso2 = 16;
                this.SSO2auth = true;
            }
        }
        if (!this.SSO2auth && (pt = this.findProperty(features, "http://www.sap.com/webas/630/soap/features/authentication", "SupportsSSO2Authentication")) != null && pt.getValue().equals("true")) {
            this.SSO2auth = true;
        }
        return transport | authentication;
    }

    private int getWSDSecurityLevel(FeatureType[] features) {
        String value;
        int transport = 0;
        int authentication = 0;
        PropertyType pt = this.findProperty(features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationLevel");
        if (pt != null) {
            value = pt.getValue();
            if (value.equals("None")) {
                authentication = 0;
            } else if (value.equals("Basic")) {
                authentication = 4;
            } else if (value.equals("Strong")) {
                authentication = 8;
            }
        }
        if ((pt = this.findProperty(features, "http://www.sap.com/webas/630/soap/features/transportguarantee", "Level")) != null) {
            value = pt.getValue();
            if (value.equals("No")) {
                transport = 0;
            } else if (value.equals("Both")) {
                transport = 1;
            }
        }
        return transport | authentication;
    }

    private boolean isDeployTimeFeature(FeatureType feature) {
        boolean dtfeature = true;
        String fname = feature.getName();
        if (fname.equals("http://www.sap.com/webas/630/soap/features/authentication")) {
            PropertyType[] pt = feature.getProperty();
            if (pt[0].getName().equals("AuthenticationLevel")) {
                dtfeature = false;
            }
        } else if (fname.equals("http://www.sap.com/webas/630/soap/features/authorization")) {
            dtfeature = true;
        } else if (fname.equals("http://www.sap.com/webas/630/soap/features/transportguarantee")) {
            PropertyType[] pt = feature.getProperty();
            if (pt[0].getName().equals("Level")) {
                dtfeature = false;
            }
        } else if (fname.equals("http://www.sap.com/webas/630/soap/features/session/")) {
            dtfeature = false;
        }
        return dtfeature;
    }

    private void setSelectedSecurityRoles(OperationType cfg, Vector v) {
        FeatureType[] ft = cfg.getFeature();
        PropertyType pt = this.findProperty(ft, "http://www.sap.com/webas/630/soap/features/authorization", "security-roles");
        if (pt == null) {
            ft = this.addFeature(this.features, "http://www.sap.com/webas/630/soap/features/authorization", "security-roles", "");
            pt = ft[this.features.length - 1].getProperty()[0];
        }
        PropertyType[] roles = new PropertyType[v.size()];
        int i = 0;
        while (i < roles.length) {
            roles[i] = new PropertyType();
            roles[i].setName("role" + (i + 1));
            roles[i].setValue((String)v.elementAt(i));
            ++i;
        }
        pt.setProperty(roles);
    }

    private PropertyType findProperty(FeatureType[] features, String featurename, String propertyname) {
        int i = 0;
        while (i < features.length) {
            if (features[i].getName().equals(featurename)) {
                PropertyType[] props = features[i].getProperty();
                int j = 0;
                while (j < props.length) {
                    if (props[j].getName().equals(propertyname)) {
                        return props[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public FeatureType[] addFeature(FeatureType[] source, String name, String propname, String propvalue) {
        FeatureType ft = new FeatureType();
        PropertyType[] props = new PropertyType[]{new PropertyType()};
        props[0].setName(propname);
        props[0].setValue(propvalue);
        ft.setName(name);
        ft.setProperty(props);
        ft.setProvider("SecurityProtocol");
        FeatureType[] features = new FeatureType[source.length + 1];
        System.arraycopy(source, 0, features, 0, source.length);
        features[source.length] = ft;
        return features;
    }

    public void setTransportFeature(String endpoint) {
        boolean httpstransport = endpoint.toUpperCase().startsWith("HTTPS");
        PropertyType docprop = this.findProperty(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMechanism");
        boolean documentmechanism = this.authmechanism.getSelectionIndex() == 2;
        PropertyType pt = this.findProperty(this.features, "http://www.sap.com/webas/630/soap/features/transportguarantee", "TLSType");
        boolean certselected = this.certauthbutton.getSelection();
        boolean sapticket = this.acceptSAPticket.getSelection();
        if (httpstransport || documentmechanism) {
            if (pt == null && httpstransport) {
                this.features = this.addFeature(this.features, "http://www.sap.com/webas/630/soap/features/transportguarantee", "TLSType", "SSL");
                pt = this.features[this.features.length - 1].getProperty()[0];
                pt = this.features[this.features.length - 1].getProperty()[0];
                pt.setValue("SSL");
            }
            this.certauthbutton = this.secondbutton;
            this.acceptSAPticket = this.thirdbutton;
        } else if (!httpstransport && !documentmechanism) {
            if (pt != null) {
                int j;
                FeatureType f = null;
                int i = 0;
                while (i < this.features.length) {
                    if (this.features[i].getName().equals("http://www.sap.com/webas/630/soap/features/transportguarantee")) {
                        PropertyType[] ptype = this.features[i].getProperty();
                        j = 0;
                        while (j < ptype.length) {
                            if (pt == ptype[j]) {
                                f = this.features[i];
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                if (f != null) {
                    FeatureType[] f1 = new FeatureType[this.features.length - 1];
                    j = 0;
                    int i2 = 0;
                    while (i2 < this.features.length) {
                        if (this.features[i2] != f) {
                            f1[j] = this.features[i2];
                            ++j;
                        }
                        ++i2;
                    }
                    this.features = f1;
                }
            }
            this.acceptSAPticket = this.secondbutton;
            this.certauthbutton = this.thirdbutton;
        }
        this.certauthbutton.setText(WsLPEditorTexts.getString("LPeditor.Pages.Security.certauth"));
        this.certauthbutton.setSelection(certselected);
        this.acceptSAPticket.setText(WsLPEditorTexts.getString("LPeditor.Pages.Security.acceptsapticket"));
        this.acceptSAPticket.setSelection(sapticket);
        this.secondbutton.setVisible(this.authmechanism.getSelectionIndex() > 0);
        this.thirdbutton.setVisible(this.authmechanism.getSelectionIndex() == 1 && httpstransport);
        if (this.certauthbutton.getSelection() && !this.certauthbutton.getVisible()) {
            this.certauthbutton.setSelection(false);
            if (this.basicauthbutton.getVisible()) {
                this.basicauthbutton.setSelection(true);
                pt = this.findProperty(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMethod");
                if (pt == null) {
                    this.features = this.addFeature(this.features, "http://www.sap.com/webas/630/soap/features/authentication", "AuthenticationMethod", "BasicAuth");
                } else {
                    pt.setValue("BasicAuth");
                }
            }
        }
        this.basicauthbutton.setEnabled(this.certauthbutton.getVisible() || this.acceptSAPticket.getVisible());
    }

    String getPolicyGroup() {
        String policygroup = "";
        if (this.authmechanism.getText().equals(MECHANISM_NONE)) {
            policygroup = "AUTHENTICATION_NONE";
        } else if (this.authmechanism.getText().equals(MECHANISM_HTTP)) {
            if (this.basicauthbutton.getSelection()) {
                policygroup = "AUTHENTICATION_TRANSPORT_SECURITY_USERNAME";
            } else if (this.certauthbutton.getSelection()) {
                policygroup = "AUTHENTICATION_TRANSPORT_SECURITY_CERTIFICATE";
            } else if (this.acceptSAPticket.getSelection()) {
                policygroup = "AUTHENTICATION_TRANSPORT_SECURITY_SSO2";
            }
        } else if (this.authmechanism.getText().equals(MECHANISM_DOCUMENT)) {
            if (this.basicauthbutton.getSelection()) {
                policygroup = "AUTHENTICATION_MESSAGE_SECURITY_USERNAME";
            } else if (this.certauthbutton.getSelection()) {
                policygroup = "AUTHENTICATION_MESSAGE_SECURITY_CERTIFICATE";
            }
        }
        return policygroup;
    }

    FeatureType[] filterFeatures(FeatureType[] features, boolean throwthemaway) {
        ArrayList<FeatureType> al = new ArrayList<FeatureType>();
        int i = 0;
        while (i < features.length) {
            if (this.isSecurityFeature(features[i]) && !throwthemaway || !this.isSecurityFeature(features[i]) && throwthemaway) {
                al.add(features[i]);
            }
            ++i;
        }
        FeatureType[] f = new FeatureType[al.size()];
        f = al.toArray(f);
        return f;
    }

    boolean isSecurityFeature(FeatureType ft) {
        String s = ft.getName();
        return s.equals("http://www.sap.com/webas/630/soap/features/transportguarantee") || s.equals("http://www.sap.com/webas/630/soap/features/authentication") || s.equals("http://www.sap.com/webas/630/soap/features/authorization");
    }

    FeatureType[] addSecurityFeatures(FeatureType[] nonsecurity, FeatureType[] security) {
        FeatureType[] f = new FeatureType[nonsecurity.length + security.length];
        System.arraycopy(nonsecurity, 0, f, 0, nonsecurity.length);
        System.arraycopy(security, 0, f, nonsecurity.length, security.length);
        return f;
    }

    private boolean allFeaturesAreOriginal() {
        if (this.port.hasGlobalFeatures()) {
            GlobalFeatures features = this.port.getGlobalFeatures();
            FeatureType[] featureTypes = features.getFeature();
            int i = 0;
            while (i < featureTypes.length) {
                if (featureTypes[i].getOriginal()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

