/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.editors.lp.pages;

import com.sap.ide.wsproxy.editors.lp.LogicalPortEditor;
import com.sap.ide.wsproxy.editors.lp.pages.LpEditorPage;
import com.sap.ide.wsproxy.editors.lp.text.WsLPEditorTexts;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class SLDPage
extends LpEditorPage
implements ModifyListener {
    public static final String SLD_PAGE_TEXT = WsLPEditorTexts.getString("LPEditor.Pages.SLD.name");
    private Text fPortName;
    private Text fSystemName;
    private Text fSLDWS;
    private Text fSLDWSPort;

    public SLDPage(Composite parentComposite, LogicalPortEditor parentEditor) {
        super(parentComposite, parentEditor);
    }

    public Composite getControl() {
        IGridLayoutPane featureDetailPane = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)1);
        featureDetailPane.setLayoutData((Object)new GridData(1808));
        this.addSLDEntries(featureDetailPane);
        featureDetailPane.addTextLabel(" ", featureDetailPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.addPortName(featureDetailPane);
        this.refresh();
        return featureDetailPane.getComposite();
    }

    private void addSLDEntries(IGridLayoutPane pane) {
        pane.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.SLDPage.sldSystemName") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fSystemName = pane.addTextField("", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fSystemName.addModifyListener((ModifyListener)this);
        pane.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.SLDPage.sldWS") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fSLDWS = pane.addTextField("", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fSLDWS.addModifyListener((ModifyListener)this);
        pane.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.SLDPage.sldWSPort") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fSLDWSPort = pane.addTextField("", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fSLDWSPort.addModifyListener((ModifyListener)this);
    }

    private void addPortName(IGridLayoutPane pane) {
        pane.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Access.lpName") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        int verticalMode = 4;
        this.fPortName = pane.addTextField("", pane.createGridLayoutData(4, verticalMode, true, false, 1, 1));
        this.fPortName.addModifyListener((ModifyListener)this);
    }

    public boolean doSave() {
        this.port.setName(this.fPortName.getText().trim());
        this.port.setSystemName(this.fSystemName.getText().trim());
        this.port.setSLDWS(this.fSLDWS.getText().trim());
        this.port.setSLDWSPort(this.fSLDWSPort.getText().trim());
        return true;
    }

    public void refresh() {
        String sldWSPort;
        String sldWS;
        String systemName = this.port.getSystemName();
        if (systemName == null) {
            systemName = "";
        }
        if ((sldWS = this.port.getSLDWS()) == null) {
            sldWS = "";
        }
        if ((sldWSPort = this.port.getSLDWSPort()) == null) {
            sldWSPort = "";
        }
        String portName = this.port.getName();
        this.fSystemName.setText(systemName);
        this.fSLDWS.setText(sldWS);
        this.fSLDWSPort.setText(sldWSPort);
        this.fPortName.setText(portName);
        ((LogicalPortEditor)this.getParentEditor()).notifyOfNotDirty();
    }

    public void setReadOnly(boolean globalReadOnly, boolean localReadOnly) {
        this.fSystemName.setEditable(!globalReadOnly);
        this.fSLDWS.setEditable(!globalReadOnly);
        this.fSLDWSPort.setEditable(!globalReadOnly);
        this.fPortName.setEditable(!globalReadOnly && !localReadOnly);
    }

    public void modifyText(ModifyEvent e) {
        this.getParentEditor().notifyOfChange();
    }
}

