/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.editors.lp.pages;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.sap.ide.ws.core.editors.FileReadOnlyStateHandler;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.editors.ResetPageStateI;
import com.sap.ide.wsproxy.editors.lp.LogicalPortEditor;
import com.sap.ide.wsproxy.editors.lp.pages.LpEditorPage;
import com.sap.ide.wsproxy.editors.lp.text.WsLPEditorTexts;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommunicationPage
extends LpEditorPage
implements SelectionListener,
ModifyListener {
    public static final String COMMUNICATION_PAGE_TEXT = WsLPEditorTexts.getString("LPEditor.Pages.Access.name");
    private Button bUseProxy;
    private Label lHttpProxyHost;
    private Label lHttpProxyPort;
    private Label lProxyUserName;
    private Label lProxyUserPass;
    private Text fHttpProxyHost;
    private Text fHttpProxyPort;
    private Text fProxyUserName;
    private Text fProxyUserPass;
    private Text fTargetAddress;
    private Text fPortName;
    private Button bNoSession;
    private Button bUseSession;
    private Button bUseAbapSession;
    private Button bMessageID;
    private boolean isSAPWSDL;

    public CommunicationPage(Composite parentComposite, LogicalPortEditor parentEditor) {
        super(parentComposite, parentEditor);
    }

    public Composite getControl() {
        this.isSAPWSDL = this.allFeaturesAreOriginal();
        IGridLayoutPane featureDetailPane = PaneFactory.createGridLayoutPane((Composite)this.getParentComposite(), (int)1);
        featureDetailPane.addPlaceholder();
        featureDetailPane.setLayoutData((Object)new GridData(1808));
        String proxyHost = "";
        String proxyPort = "";
        String proxyUser = "";
        String targetAddress = this.port.getEndpoint();
        if (targetAddress == null) {
            targetAddress = "";
            this.port.setEndpoint("");
        }
        String portName = this.port.getName();
        boolean useProxyFeature = false;
        boolean shouldHaveProxy = false;
        FeatureType feature = ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/630/soap/features/proxy", false);
        if (feature != null) {
            useProxyFeature = true;
            shouldHaveProxy = feature.getOriginal();
            proxyHost = this.getProperty(feature, "proxyHost");
            proxyPort = this.getProperty(feature, "proxyPort");
            proxyUser = this.getProperty(feature, "proxyUser");
        }
        if (!((LogicalPortEditor)this.getParentEditor()).isDeployableProject()) {
            this.addProxyFeature(featureDetailPane, useProxyFeature, shouldHaveProxy, proxyHost, proxyPort, proxyUser);
            featureDetailPane.addTextLabel(" ", featureDetailPane.createGridLayoutData(4, 4, true, false, 1, 1));
        }
        this.addTargetAddress(featureDetailPane, targetAddress);
        featureDetailPane.addTextLabel(" ", featureDetailPane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.addPortName(featureDetailPane, portName);
        featureDetailPane.addTextLabel(" ", featureDetailPane.createGridLayoutData(4, 4, true, false, 1, 1));
        IGridLayoutPane sessionFeaturePane = featureDetailPane.addGridLayoutPane(WsLPEditorTexts.getString("LPEditor.Pages.Access.satateful.communication"), 1, featureDetailPane.createGridLayoutData(4, 1, true, false, 1, 1));
        this.addStatefulFeature(sessionFeaturePane, ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/630/soap/features/session/", false));
        IGridLayoutPane messageIDPane = featureDetailPane.addGridLayoutPane("", 1, featureDetailPane.createGridLayoutData(4, 1, true, false, 1, 1));
        this.addMessageIDFeature(messageIDPane, ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/640/soap/features/messageId/", false));
        return featureDetailPane.getComposite();
    }

    private void addMessageIDFeature(IGridLayoutPane pane, FeatureType messageIDFeature) {
        boolean hasMessageID = messageIDFeature != null;
        this.bMessageID = pane.addCheckBox(WsLPEditorTexts.getString("LPEditor.Pages.Access.send.messageid"), hasMessageID, pane.createGridLayoutData(4, 1, true, false, 1, 1));
        this.bMessageID.setEnabled(!this.isSAPWSDL);
        this.bMessageID.addSelectionListener((SelectionListener)this);
    }

    private void addStatefulFeature(IGridLayoutPane pane, FeatureType sessionFeature) {
        boolean session = false;
        boolean abapSession = false;
        boolean disabled = this.isSAPWSDL;
        if (sessionFeature != null) {
            session = true;
            abapSession = this.getProperty(sessionFeature, "abapSession").equalsIgnoreCase("yes");
        }
        this.bNoSession = pane.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Access.noSession"), pane.createGridLayoutData(4, 1, true, false, 1, 1));
        this.bNoSession.setSelection(!session && !abapSession);
        this.bNoSession.setEnabled(!disabled);
        this.bUseSession = pane.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Access.useSession"), pane.createGridLayoutData(4, 1, true, false, 1, 1));
        this.bUseSession.setEnabled(!disabled);
        this.bUseSession.setSelection(session && !abapSession);
        this.bUseAbapSession = pane.addRadioButton(WsLPEditorTexts.getString("LPEditor.Pages.Access.useABAPSession"), pane.createGridLayoutData(4, 1, true, false, 1, 1));
        this.bUseAbapSession.setEnabled(!disabled);
        this.bUseAbapSession.setSelection(session && abapSession);
        this.bNoSession.addSelectionListener((SelectionListener)this);
        this.bUseSession.addSelectionListener((SelectionListener)this);
        this.bUseAbapSession.addSelectionListener((SelectionListener)this);
    }

    private void addProxyFeature(IGridLayoutPane pane, boolean useProxyFeature, boolean shouldHaveProxy, String host, String port, String user) {
        this.bUseProxy = pane.addCheckBox(WsLPEditorTexts.getString("LPEditor.Pages.Access.useProxy"), useProxyFeature, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.bUseProxy.setEnabled(!shouldHaveProxy);
        this.bUseProxy.addSelectionListener((SelectionListener)this);
        IGridLayoutPane httpGroup = pane.addGridLayoutPane(WsLPEditorTexts.getString("LPEditor.Pages.Access.httpProxy"), 2, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.lHttpProxyHost = httpGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Access.proxyHost") + ": ", pane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.fHttpProxyHost = httpGroup.addTextField(host, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.fHttpProxyHost.addModifyListener((ModifyListener)this);
        this.lHttpProxyPort = httpGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Access.proxyPort") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        httpGroup.addTextLabel(" ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fHttpProxyPort = httpGroup.addTextField(port, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fHttpProxyPort.addModifyListener((ModifyListener)this);
        httpGroup.addTextLabel(" ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.lProxyUserName = httpGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Access.proxyUser") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.lProxyUserPass = httpGroup.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Access.proxyPassword") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.lProxyUserPass.setEnabled(false);
        this.fProxyUserName = httpGroup.addTextField(user, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fProxyUserName.addModifyListener((ModifyListener)this);
        this.fProxyUserPass = httpGroup.addTextField("", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fProxyUserPass.setEnabled(false);
        this.enableProxyFields(useProxyFeature);
    }

    private void addTargetAddress(IGridLayoutPane pane, String targetAddress) {
        pane.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Access.targetAddress") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fTargetAddress = pane.addTextField(targetAddress, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.fTargetAddress.addModifyListener((ModifyListener)this);
    }

    private void addPortName(IGridLayoutPane pane, String portName) {
        pane.addTextLabel(WsLPEditorTexts.getString("LPEditor.Pages.Access.lpName") + ": ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        int verticalMode = 4;
        this.fPortName = pane.addTextField(portName, pane.createGridLayoutData(4, verticalMode, true, false, 1, 1));
        if (((LogicalPortEditor)this.getParentEditor()).isJaxRPCInterfaces()) {
            this.fPortName.setEnabled(false);
        } else {
            this.fPortName.addModifyListener((ModifyListener)this);
        }
    }

    private void enableProxyFields(boolean useProxy) {
        this.lHttpProxyHost.setEnabled(useProxy);
        this.fHttpProxyHost.setEnabled(useProxy);
        this.lProxyUserName.setEnabled(useProxy);
        this.fProxyUserName.setEnabled(useProxy);
        this.lHttpProxyPort.setEnabled(useProxy);
        this.fHttpProxyPort.setEnabled(useProxy);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(final SelectionEvent e) {
        if (!this.isInResetMode()) {
            ResetPageStateI reset = new ResetPageStateI(){

                public void handleReset() {
                    if (e.widget instanceof Button) {
                        Button b;
                        b.setSelection(!(b = (Button)e.widget).getSelection());
                    }
                }
            };
            if (!this.isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(((LogicalPortEditor)this.getParentEditor()).getLPXMLFile()), reset) || !this.isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(((LogicalPortEditor)this.getParentEditor()).getLPFile()), reset)) {
                return;
            }
        }
        this.getParentEditor().notifyOfChange();
        Object source = e.getSource();
        if (source == this.bUseProxy) {
            this.enableProxyFields(this.bUseProxy.getSelection());
        }
    }

    public void modifyText(final ModifyEvent e) {
        if (!this.isInResetMode()) {
            ResetPageStateI reset = new ResetPageStateI(){

                public void handleReset() {
                    if (e.widget instanceof Text) {
                        FeatureType feature = ((LogicalPortEditor)CommunicationPage.this.getParentEditor()).getFeature("http://www.sap.com/webas/630/soap/features/proxy", false);
                        if (feature != null) {
                            if (e.widget == CommunicationPage.this.fHttpProxyHost) {
                                String proxyHost = CommunicationPage.this.getProperty(feature, "proxyHost");
                                CommunicationPage.this.fHttpProxyHost.setText(proxyHost);
                            } else if (e.widget == CommunicationPage.this.fHttpProxyPort) {
                                String proxyPort = CommunicationPage.this.getProperty(feature, "proxyPort");
                                CommunicationPage.this.fHttpProxyPort.setText(proxyPort);
                            } else if (e.widget == CommunicationPage.this.fProxyUserName) {
                                String proxyUser = CommunicationPage.this.getProperty(feature, "proxyUser");
                                CommunicationPage.this.fProxyUserName.setText(proxyUser);
                            }
                        } else if (e.widget == CommunicationPage.this.fTargetAddress) {
                            String targetAddress = CommunicationPage.this.port.getEndpoint();
                            if (targetAddress == null) {
                                targetAddress = "";
                                CommunicationPage.this.port.setEndpoint("");
                            }
                            CommunicationPage.this.fTargetAddress.setText(targetAddress);
                        } else if (e.widget == CommunicationPage.this.fPortName) {
                            String portName = CommunicationPage.this.port.getName();
                            CommunicationPage.this.fPortName.setText(portName);
                        }
                    }
                }
            };
            if (!this.isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(((LogicalPortEditor)this.getParentEditor()).getLPXMLFile()), reset) || !this.isChangeAllowed((HandleReadOnlyStateI)new FileReadOnlyStateHandler(((LogicalPortEditor)this.getParentEditor()).getLPFile()), reset)) {
                return;
            }
            this.getParentEditor().notifyOfChange();
        }
    }

    public boolean doSave() {
        if (this.isSAPWSDL) {
            String targetAddr = this.port.getEndpoint();
            if (targetAddr.substring(0, 5).equalsIgnoreCase("https") && !this.fTargetAddress.getText().substring(0, 5).equalsIgnoreCase("https")) {
                MessageDialog.openError((Shell)this.fTargetAddress.getShell(), (String)WsLPEditorTexts.getString("LPEditor.Pages.Access.error"), (String)WsLPEditorTexts.getString("LPEditor.Pages.Access.error.message"));
                return false;
            }
            if (targetAddr.substring(0, 4).equalsIgnoreCase("http") && !this.fTargetAddress.getText().substring(0, 4).equalsIgnoreCase("http")) {
                MessageDialog.openError((Shell)this.fTargetAddress.getShell(), (String)WsLPEditorTexts.getString("LPEditor.Pages.Access.error"), (String)WsLPEditorTexts.getString("LPEditor.Pages.Access.error.message"));
                return false;
            }
        }
        String portName = this.fPortName.getText().trim();
        this.port.setName(portName);
        String targetAddress = this.fTargetAddress.getText().trim();
        this.port.setEndpoint(targetAddress);
        if (!((LogicalPortEditor)this.getParentEditor()).isDeployableProject() && !this.processProxy()) {
            return false;
        }
        this.processSession();
        this.processMessageID();
        return true;
    }

    private boolean processProxy() {
        if (this.bUseProxy.getSelection()) {
            PropertyType[] properties;
            FeatureType proxyFeature = ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/630/soap/features/proxy", true);
            String proxyHost = this.fHttpProxyHost.getText().trim();
            String proxyPort = this.fHttpProxyPort.getText().trim();
            try {
                Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException nfe) {
                this.showError(WsLPEditorTexts.getString("LPEditor.Pages.Access.invalidProxy"), WsLPEditorTexts.getString("LPEditor.Pages.Access.invalidProxyMsg"));
                return false;
            }
            String proxyUser = this.fProxyUserName.getText().trim();
            if (proxyUser.length() == 0) {
                properties = new PropertyType[2];
            } else {
                properties = new PropertyType[3];
                properties[2] = this.createProperty("proxyUser", proxyUser);
            }
            properties[0] = this.createProperty("proxyHost", proxyHost);
            properties[1] = this.createProperty("proxyPort", proxyPort);
            proxyFeature.setProperty(properties);
        } else {
            ((LogicalPortEditor)this.getParentEditor()).removeFeature("http://www.sap.com/webas/630/soap/features/proxy");
        }
        return true;
    }

    private void processSession() {
        if (!this.bUseSession.getEnabled()) {
            return;
        }
        if (this.bUseSession.getSelection() || this.bUseAbapSession.getSelection()) {
            FeatureType sessionFeature = ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/630/soap/features/session/", true);
            PropertyType[] oldProperties = sessionFeature.getProperty();
            Vector<PropertyType> propsVector = new Vector<PropertyType>();
            boolean hasMethodProp = false;
            int i = 0;
            while (i < oldProperties.length) {
                if (!"abapSession".equals(oldProperties[i].getName())) {
                    if ("SessionMethod".equals(oldProperties[i].getName())) {
                        hasMethodProp = true;
                    }
                    propsVector.addElement(oldProperties[i]);
                }
                ++i;
            }
            if (!hasMethodProp) {
                propsVector.addElement(this.createProperty("SessionMethod", "httpCookies"));
            }
            if (this.bUseAbapSession.getSelection()) {
                propsVector.addElement(this.createProperty("abapSession", "yes"));
            }
            Object[] properties = new PropertyType[propsVector.size()];
            propsVector.copyInto(properties);
            sessionFeature.setProperty((PropertyType[])properties);
        } else {
            ((LogicalPortEditor)this.getParentEditor()).removeFeature("http://www.sap.com/webas/630/soap/features/session/");
        }
    }

    private void processMessageID() {
        if (this.bMessageID.getSelection()) {
            FeatureType featureType = ((LogicalPortEditor)this.getParentEditor()).getFeature("http://www.sap.com/webas/640/soap/features/messageId/", true);
        } else {
            ((LogicalPortEditor)this.getParentEditor()).removeFeature("http://www.sap.com/webas/640/soap/features/messageId/");
        }
    }

    public void setReadOnly(boolean globalReadOnly, boolean localReadOnly) {
    }

    public void refresh() {
        this.fTargetAddress.setText(this.port.getEndpoint());
    }

    public void setSensitivity(boolean enable) {
    }

    public String getEndpoint() {
        return this.fTargetAddress.getText();
    }

    private boolean allFeaturesAreOriginal() {
        if (this.port.hasGlobalFeatures()) {
            GlobalFeatures features = this.port.getGlobalFeatures();
            FeatureType[] featureTypes = features.getFeature();
            int i = 0;
            while (i < featureTypes.length) {
                if (featureTypes[i].getOriginal()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

