/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.editors.lp;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.DefaultProviders;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.editors.GenericMultiPageEditor;
import com.sap.ide.ws.core.editors.GenericMultiPageEditorPage;
import com.sap.ide.ws.core.editors.GenericWsEditorActionContributor;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.editors.FileEditorI;
import com.sap.ide.ws.core.services.editors.FileEditorUtils;
import com.sap.ide.ws.core.services.filter.generic.GenericProjectFilter;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.sap.ide.ws.proxygenerator.InternalHelperFunctions;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorWrapper;
import com.sap.ide.wsproxy.editors.lp.ILpRenameListener;
import com.sap.ide.wsproxy.editors.lp.pages.CommunicationPage;
import com.sap.ide.wsproxy.editors.lp.pages.LpEditorPage;
import com.sap.ide.wsproxy.editors.lp.pages.SLDPage;
import com.sap.ide.wsproxy.editors.lp.pages.SecurityConfigurationPage;
import com.sap.ide.wsproxy.editors.lp.text.WsLPEditorTexts;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class LogicalPortEditor
extends GenericMultiPageEditor
implements EditorItemI,
FileEditorI,
IResourceChangeListener {
    private int securitypageindex = 0;
    private boolean dirty = false;
    private boolean globalReadOnly = false;
    private boolean localReadOnly = false;
    private boolean jaxrpcInterfaces = false;
    private Vector renameListeners = new Vector();
    private LpEditorPage[] pages;
    private String logicalPortFilePath;
    private File globalXMLFile;
    private LogicalPortType logicalPort;
    private String originalPortName;
    private String projectName;

    public LogicalPortEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        IResourceDelta rootDelta;
        if ((event.getType() == 1 || event.getType() == 4) && (rootDelta = event.getDelta()) != null && (projectDeltas = rootDelta.getAffectedChildren()) != null) {
            int i = 0;
            while (i < projectDeltas.length) {
                if ((projectDeltas[i].getFlags() == 16384 || projectDeltas[i].getKind() == 2) && projectDeltas[i].getResource() instanceof IProject && projectDeltas[i].getResource().getName().equals(this.projectName) && !projectDeltas[i].getResource().isAccessible()) {
                    final IWorkbenchPage page = this.getEditorSite().getPage();
                    LogicalPortEditor editor = this;
                    editor.getEditorSite().getShell().getDisplay().syncExec(new Runnable((IEditorPart)editor){
                        private final /* synthetic */ IEditorPart val$editor;
                        {
                            this.val$editor = val$editor;
                        }

                        public void run() {
                            page.closeEditor(this.val$editor, true);
                        }
                    });
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                }
                ++i;
            }
        }
    }

    public String getEditedFilePath() {
        return this.logicalPortFilePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor monitor) {
        int i;
        monitor.beginTask(WsLPEditorTexts.getString("LPEditor.saveTask"), -1);
        try {
            try {
                int i2 = 0;
                while (i2 < this.pages.length) {
                    if (!this.pages[i2].doSave()) {
                        monitor.setCanceled(true);
                        monitor.done();
                        Object var5_5 = null;
                        monitor.done();
                        return;
                    }
                    ++i2;
                }
                i = 0;
                while (i < this.pages.length) {
                    this.pages[i].refresh();
                    ++i;
                }
                InternalHelperFunctions.saveLogicalPort((LogicalPortType)this.logicalPort, (String)this.logicalPortFilePath, (String)this.originalPortName);
                if (this.projectName != null) {
                    new WsRefreshAction().refresh(this.projectName);
                }
                this.notifyOfNotDirty();
            }
            catch (Exception e) {
                monitor.setCanceled(true);
                ProxyGeneratorWrapper.log((Throwable)e);
                Object var5_7 = null;
                monitor.done();
                return;
            }
            Object var5_6 = null;
            monitor.done();
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            monitor.done();
            throw throwable;
        }
        String newName = this.logicalPort.getName();
        if (!newName.equals(this.originalPortName)) {
            i = 0;
            while (i < this.renameListeners.size()) {
                ((ILpRenameListener)this.renameListeners.elementAt(i)).renameLogicalPort(newName);
                ++i;
            }
            this.originalPortName = newName;
            this.setTitle(newName);
        }
    }

    public void notifyOfChange() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public void notifyOfNotDirty() {
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void firePropertyChanged(int propertyID) {
        super.firePropertyChange(propertyID);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            this.projectName = file.getProject().getName();
            this.logicalPortFilePath = file.getLocation().toOSString();
        }
        try {
            Properties props = InternalHelperFunctions.getLPProperties((String)this.logicalPortFilePath);
            this.globalXMLFile = InternalHelperFunctions.getLportsXML((Properties)props, (String)this.logicalPortFilePath);
            String metaInfDirName = props.getProperty("metaInfSubDir");
            String infoFileName = "info_" + props.getProperty("id") + ".properties";
            File lpFile = new File(this.logicalPortFilePath);
            File metaInfDir = new File(lpFile.getParentFile(), metaInfDirName);
            File infoFile = new File(metaInfDir, infoFileName);
            Properties infoProps = new Properties();
            FileInputStream in = new FileInputStream(infoFile);
            infoProps.load(in);
            ((InputStream)in).close();
            this.jaxrpcInterfaces = "1".equals(infoProps.getProperty(ProxyGeneratorWrapper.RPC_INTERFACES));
        }
        catch (Exception e) {
            throw new PartInitException("Cannot open LP Editor", (Throwable)e);
        }
        try {
            this.logicalPort = InternalHelperFunctions.getLPType((String)this.logicalPortFilePath);
            this.originalPortName = this.logicalPort.getName();
        }
        catch (Exception e) {
            throw new PartInitException("Problem in loading the logical port", (Throwable)e);
        }
        IEditorPart logicalPortPart = FileEditorUtils.findEditorPartForFile((String)this.logicalPortFilePath);
        if (logicalPortPart != null) {
            logicalPortPart.getEditorSite().getPage().activate((IWorkbenchPart)logicalPortPart);
        }
        this.setTitle(this.logicalPort.getName());
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createPages() {
        if (InternalHelperFunctions.isSLDLogicalPort((LogicalPortType)this.logicalPort)) {
            this.pages = new LpEditorPage[1];
            this.pages[0] = new SLDPage(this.getContainer(), this);
            int pageIndex = this.addPage((Control)this.pages[0].getControl());
            this.setPageText(0, SLDPage.SLD_PAGE_TEXT);
        } else {
            this.pages = new LpEditorPage[2];
            this.pages[0] = new CommunicationPage(this.getContainer(), this);
            int pageIndex = this.addPage((Control)this.pages[0].getControl());
            this.setPageText(pageIndex, CommunicationPage.COMMUNICATION_PAGE_TEXT);
            this.pages[1] = new SecurityConfigurationPage(this.getContainer(), this);
            this.securitypageindex = this.addPage((Control)this.pages[1].getControl());
            this.setPageText(this.securitypageindex, WsLPEditorTexts.getString("LPEditor.Pages.Security.name"));
            ((SecurityConfigurationPage)this.pages[1]).init();
        }
    }

    public Object getEditingObject() {
        return this.logicalPort;
    }

    public void setPageAndIndex(GenericMultiPageEditorPage page, int index) {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public File getLogicalPortFile() {
        return new File(this.logicalPortFilePath);
    }

    public void changeLPName(String newName) {
        this.setTitle(newName);
        this.logicalPort.setName(newName);
        this.notifyOfChange();
    }

    public FeatureType getFeature(String featureName, boolean createNew) {
        String provider;
        FeatureType feature;
        GlobalFeatures global = null;
        try {
            global = this.logicalPort.getGlobalFeatures();
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
        }
        if (global == null) {
            if (!createNew) {
                return null;
            }
            global = new GlobalFeatures();
            this.logicalPort.setGlobalFeatures(global);
        }
        if ((feature = global.getFeature(featureName)) == null) {
            if (createNew) {
                feature = new FeatureType();
                feature.setName(featureName);
                global.addFeature(feature);
            } else {
                return null;
            }
        }
        if ((provider = DefaultProviders.getProvider((String)featureName)) != null) {
            feature.setProvider(provider);
        }
        return feature;
    }

    public void removeFeature(String featureName) {
        GlobalFeatures global = null;
        try {
            global = this.logicalPort.getGlobalFeatures();
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, ((Object)((Object)this)).getClass());
        }
        if (global == null) {
            return;
        }
        FeatureType feature = global.getFeature(featureName);
        if (feature != null) {
            FeatureType[] features = global.getFeature();
            FeatureType[] newFeatures = new FeatureType[features.length - 1];
            int index = 0;
            int i = 0;
            while (i < features.length) {
                if (!features[i].getName().equals(featureName)) {
                    newFeatures[index++] = features[i];
                }
                ++i;
            }
            global.setFeature(newFeatures);
        }
    }

    public void addLpRenameListener(ILpRenameListener listener) {
        this.renameListeners.addElement(listener);
    }

    public void removeLpRenameListener(ILpRenameListener listener) {
        this.renameListeners.removeElement(listener);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setFocus() {
        IEditorActionBarContributor contributor;
        File f = new File(this.logicalPortFilePath);
        boolean changed = false;
        if (this.localReadOnly != !f.canWrite()) {
            this.localReadOnly = !this.localReadOnly;
            changed = true;
        }
        if (this.globalReadOnly != !this.globalXMLFile.canWrite()) {
            this.globalReadOnly = !this.globalReadOnly;
            changed = true;
        }
        if (changed && this.pages != null) {
            int i = 0;
            while (i < this.pages.length) {
                this.pages[i].setReadOnly(this.globalReadOnly, this.localReadOnly);
                ++i;
            }
        }
        if ((contributor = this.getEditorSite().getActionBarContributor()) instanceof GenericWsEditorActionContributor) {
            if (!f.canWrite() || !this.globalXMLFile.canWrite()) {
                ((GenericWsEditorActionContributor)contributor).setReadOnlyText("Read Only");
            } else {
                ((GenericWsEditorActionContributor)contributor).setReadOnlyText("Writable");
            }
        }
    }

    public boolean getReadOnly() {
        return this.globalReadOnly && this.localReadOnly;
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isDeployableProject() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        return GenericProjectFilter.hasNature((IProject)project, (String)"com.sap.ide.wsproxy.wsProxyDeployableNature");
    }

    private IFile getGlobalXML() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        Properties props = InternalHelperFunctions.getLPProperties((String)this.logicalPortFilePath);
        File globalFile = InternalHelperFunctions.getLportsXML((Properties)props, (String)this.logicalPortFilePath);
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(globalFile.getCanonicalPath().replace('\\', '/')));
    }

    public void pageChange(int newPageindex) {
        if (newPageindex == this.securitypageindex) {
            String endpoint = ((CommunicationPage)this.pages[0]).getEndpoint();
            ((SecurityConfigurationPage)this.pages[1]).setTransportFeature(endpoint);
        }
    }

    public String getEndpoint() {
        return ((CommunicationPage)this.pages[0]).getEndpoint();
    }

    public boolean isJaxRPCInterfaces() {
        return this.jaxrpcInterfaces;
    }

    public IFile getLPFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.logicalPortFilePath));
    }

    public IFile getLPXMLFile() {
        try {
            return this.getGlobalXML();
        }
        catch (Exception e) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
            return project.getFile(this.logicalPortFilePath);
        }
    }

    protected boolean doSaveTask() {
        return false;
    }

    protected boolean isEditedObjectReadOnly() {
        return this.getReadOnly();
    }

    protected String getProjectName() {
        return null;
    }
}

