/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.wsproxy.archive;

import com.sap.ide.ws.core.services.filter.WebServiceFilterFactory;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IMutablePattern;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClientAPIArchiveBuilder {
    public static final String JAR_EXTENSION = ".jar";
    public static final String CLIENT_API_JAR_NAME = "ClientAPI";
    private IProject mProject = null;
    private IProgressMonitor mMonitor = null;

    public ClientAPIArchiveBuilder(IProject project, IProgressMonitor monitor) {
        this.mProject = project;
        this.mMonitor = monitor;
    }

    protected IProject getProject() {
        return this.mProject;
    }

    public void createClientAPIJar() {
        IArchiveDescriptor wsArchiveDescriptor = ArchiveDescriptionManager.newArchiveDescription();
        wsArchiveDescriptor.setDestPath(this.mProject, this.mProject.getName() + CLIENT_API_JAR_NAME + JAR_EXTENSION);
        wsArchiveDescriptor.setCompressed(true);
        this.mMonitor.worked(25);
        IProjectFileSet publicFiles = ArchiveDescriptionManager.getProjectFileSet();
        publicFiles.addRelativeFile(this.mProject, RelativePath.CLASSES, this.getOutputFilesPattern());
        wsArchiveDescriptor.addFileSet((IFileSet)publicFiles);
        this.mMonitor.worked(50);
        wsArchiveDescriptor.performBuild();
    }

    protected IPattern getOutputFilesPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addExcludePattern("**/*.lp");
        pattern.addExcludePattern("**/*.wsprxdef");
        pattern.addExcludePattern("**/*.java");
        pattern.addExcludePattern("**/*.txvpck");
        pattern.addExcludePattern("**/*.ear");
        pattern.addIncludePattern("**/*.class");
        if (WebServiceFilterFactory.isStandaloneProxyProject((IProject)this.mProject)) {
            pattern.addIncludePattern("**/*.xml");
            pattern.addIncludePattern("**/*.txt");
            pattern.addIncludePattern("**/*.properties");
        }
        return pattern;
    }
}

