/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.css.dom.CSSOMSVGColor;
import org.apache.batik.css.dom.CSSOMSVGPaint;
import org.apache.batik.css.dom.CSSOMSVGStyleDeclaration;
import org.apache.batik.css.dom.CSSOMStyleDeclaration;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.apache.batik.css.engine.value.svg.SVGPaintManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.svg.SVGAnimatedString;

public abstract class SVGStylableElement
extends SVGOMElement
implements CSSStylableElement {
    protected StyleMap computedStyleMap;

    protected SVGStylableElement() {
    }

    protected SVGStylableElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public StyleMap getComputedStyleMap(String string) {
        return this.computedStyleMap;
    }

    public void setComputedStyleMap(String string, StyleMap styleMap) {
        this.computedStyleMap = styleMap;
    }

    public String getXMLId() {
        return this.getAttributeNS(null, "id");
    }

    public String getCSSClass() {
        return this.getAttributeNS(null, "class");
    }

    public URL getCSSBase() {
        try {
            String string = XMLBaseSupport.getCascadedXMLBase((Element)((Object)this));
            if (string == null) {
                return null;
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            throw new InternalError();
        }
    }

    public boolean isPseudoInstanceOf(String string) {
        if (string.equals("first-child")) {
            Node node = this.getPreviousSibling();
            while (node != null && node.getNodeType() != 1) {
                node = node.getPreviousSibling();
            }
            return node == null;
        }
        return false;
    }

    public CSSStyleDeclaration getStyle() {
        Object object = (CSSStyleDeclaration)((Object)this.getLiveAttributeValue(null, "style"));
        if (object == null) {
            CSSEngine cSSEngine = ((SVGOMDocument)((Object)this.getOwnerDocument())).getCSSEngine();
            object = new StyleDeclaration(cSSEngine);
        }
        return object;
    }

    public CSSValue getPresentationAttribute(String string) {
        Object object = (CSSValue)((Object)this.getLiveAttributeValue(null, string));
        if (object == null) {
            CSSEngine cSSEngine = ((SVGOMDocument)((Object)this.getOwnerDocument())).getCSSEngine();
            int n = cSSEngine.getPropertyIndex(string);
            if (n > 58) {
                if (cSSEngine.getValueManagers()[n] instanceof SVGColorManager) {
                    object = new PresentationAttributeColorValue(cSSEngine, string);
                }
                if (cSSEngine.getValueManagers()[n] instanceof SVGPaintManager) {
                    object = new PresentationAttributePaintValue(cSSEngine, string);
                }
            } else {
                switch (n) {
                    case -1: {
                        return null;
                    }
                    case 15: 
                    case 44: {
                        object = new PresentationAttributePaintValue(cSSEngine, string);
                        break;
                    }
                    case 19: 
                    case 33: 
                    case 42: {
                        object = new PresentationAttributeColorValue(cSSEngine, string);
                        break;
                    }
                    default: {
                        object = new PresentationAttributeValue(cSSEngine, string);
                    }
                }
            }
            this.putLiveAttributeValue(null, string, (LiveAttributeValue)object);
        }
        return object;
    }

    public SVGAnimatedString getClassName() {
        return this.getAnimatedStringAttribute(null, "class");
    }

    public class StyleDeclaration
    extends CSSOMSVGStyleDeclaration
    implements LiveAttributeValue,
    CSSOMStyleDeclaration.ValueProvider,
    CSSOMStyleDeclaration.ModificationHandler {
        protected org.apache.batik.css.engine.StyleDeclaration declaration;
        protected boolean mutate;

        public StyleDeclaration(CSSEngine cSSEngine) {
            super(null, null, cSSEngine);
            ((CSSOMStyleDeclaration)this).valueProvider = this;
            this.setModificationHandler(this);
            this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this.getAttributeNS(null, "style"));
        }

        public Value getValue(String string) {
            int n = this.cssEngine.getPropertyIndex(string);
            int n2 = 0;
            while (n2 < this.declaration.size()) {
                if (n == this.declaration.getIndex(n2)) {
                    return this.declaration.getValue(n2);
                }
                ++n2;
            }
            return null;
        }

        public boolean isImportant(String string) {
            int n = this.cssEngine.getPropertyIndex(string);
            int n2 = 0;
            while (n2 < this.declaration.size()) {
                if (n == this.declaration.getIndex(n2)) {
                    return this.declaration.getPriority(n2);
                }
                ++n2;
            }
            return false;
        }

        public String getText() {
            return this.declaration.toString(this.cssEngine);
        }

        public int getLength() {
            return this.declaration.size();
        }

        public String item(int n) {
            return this.cssEngine.getPropertyName(this.declaration.getIndex(n));
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.declaration = this.cssEngine.parseStyleDeclaration(string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.declaration = this.cssEngine.parseStyleDeclaration(string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.declaration = new org.apache.batik.css.engine.StyleDeclaration();
            }
        }

        public void textChanged(String string) throws DOMException {
            this.declaration = this.cssEngine.parseStyleDeclaration(string);
            this.mutate = true;
            SVGStylableElement.this.setAttributeNS(null, "style", string);
            this.mutate = false;
        }

        public void propertyRemoved(String string) throws DOMException {
            int n = this.cssEngine.getPropertyIndex(string);
            int n2 = 0;
            while (n2 < this.declaration.size()) {
                if (n == this.declaration.getIndex(n2)) {
                    this.declaration.remove(n2);
                    this.mutate = true;
                    SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
                    this.mutate = false;
                    return;
                }
                ++n2;
            }
        }

        public void propertyChanged(String string, String string2, String string3) throws DOMException {
            int n = this.cssEngine.getPropertyIndex(string);
            int n2 = 0;
            while (n2 < this.declaration.size()) {
                if (n == this.declaration.getIndex(n2)) {
                    Value value = this.cssEngine.parsePropertyValue(string, string2);
                    this.declaration.put(n2, value, n, string3.length() > 0);
                    this.mutate = true;
                    SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
                    this.mutate = false;
                    return;
                }
                ++n2;
            }
            Value value = this.cssEngine.parsePropertyValue(string, string2);
            this.declaration.append(value, n, string3.length() > 0);
            this.mutate = true;
            SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
            this.mutate = false;
        }
    }

    public class PresentationAttributePaintValue
    extends CSSOMSVGPaint
    implements LiveAttributeValue,
    CSSOMSVGColor.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributePaintValue(CSSEngine cSSEngine, String string) {
            super(null);
            ((CSSOMSVGColor)this).valueProvider = this;
            this.setModificationHandler((CSSOMSVGColor.ModificationHandler)new CSSOMSVGPaint.AbstractModificationHandler(this){
                private final /* synthetic */ PresentationAttributePaintValue this$1;
                {
                    this.this$1 = presentationAttributePaintValue;
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue(this.this$1.property, string);
                    this.this$1.mutate = true;
                    PresentationAttributePaintValue.access$200(this.this$1).setAttributeNS(null, this.this$1.property, string);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$200(PresentationAttributePaintValue presentationAttributePaintValue) {
            return presentationAttributePaintValue.SVGStylableElement.this;
        }
    }

    public class PresentationAttributeColorValue
    extends CSSOMSVGColor
    implements LiveAttributeValue,
    CSSOMSVGColor.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributeColorValue(CSSEngine cSSEngine, String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler((CSSOMSVGColor.ModificationHandler)new CSSOMSVGColor.AbstractModificationHandler(this){
                private final /* synthetic */ PresentationAttributeColorValue this$1;
                {
                    this.this$1 = presentationAttributeColorValue;
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue(this.this$1.property, string);
                    this.this$1.mutate = true;
                    PresentationAttributeColorValue.access$100(this.this$1).setAttributeNS(null, this.this$1.property, string);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$100(PresentationAttributeColorValue presentationAttributeColorValue) {
            return presentationAttributeColorValue.SVGStylableElement.this;
        }
    }

    public class PresentationAttributeValue
    extends CSSOMValue
    implements LiveAttributeValue,
    CSSOMValue.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributeValue(CSSEngine cSSEngine, String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler((CSSOMValue.ModificationHandler)new CSSOMValue.AbstractModificationHandler(this){
                private final /* synthetic */ PresentationAttributeValue this$1;
                {
                    this.this$1 = presentationAttributeValue;
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    this.this$1.value = this.this$1.cssEngine.parsePropertyValue(this.this$1.property, string);
                    this.this$1.mutate = true;
                    PresentationAttributeValue.access$000(this.this$1).setAttributeNS(null, this.this$1.property, string);
                    this.this$1.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }

        static /* synthetic */ SVGStylableElement access$000(PresentationAttributeValue presentationAttributeValue) {
            return presentationAttributeValue.SVGStylableElement.this;
        }
    }
}

