/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.remote;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.engine.interfaces.keystore.SecurityConnector;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.security.core.server.securestorage.SecureStorageImplMessage;
import com.sap.security.core.server.securestorage.exception.CreateConfigurationsException;
import com.sap.security.core.server.securestorage.exception.KeyGenerationException;
import com.sap.security.core.server.securestorage.exception.KeyStoreAccessException;
import com.sap.security.core.server.securestorage.exception.NoKeyForClientException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.rmi.PortableRemoteObject;

public abstract class RemoteSecureStorageSuperContextImpl
extends PortableRemoteObject
implements Remote {
    private LockingContext _lockingContext = null;
    private ServerInternalLocking _internalLock = null;
    protected ConfigurationHandler _secureStorageConfigurationHandler = null;
    protected ApplicationServiceContext _serviceContext = null;
    protected KeyStore _J2EEEngineKeystore = null;
    private int number_of_keys_generated_today = 0;
    private ProtectionDomain[] _protectionDomainStack;
    private KeystoreManager keystoreManager;
    private String _keyAlias;
    private String _permissionKeyAlias;
    protected String _constants;
    protected String _param1;
    protected String _param2;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageSuperContextImpl == null ? (class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageSuperContextImpl = RemoteSecureStorageSuperContextImpl.class$("com.sap.security.core.server.securestorage.remote.RemoteSecureStorageSuperContextImpl")) : class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageSuperContextImpl));
    final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)"SecureStorage");
    static /* synthetic */ Class class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageSuperContextImpl;

    public RemoteSecureStorageSuperContextImpl() throws RemoteException {
    }

    public RemoteSecureStorageSuperContextImpl(ConfigurationHandler secureStorageConfigurationHandler, ApplicationServiceContext serviceContext) throws RemoteException {
        this._secureStorageConfigurationHandler = secureStorageConfigurationHandler;
        this._serviceContext = serviceContext;
    }

    public void checkRootConfiguration(String rootName, boolean check) throws CreateConfigurationsException {
        block4: {
            String method = "checkRootConfiguration(String rootName, boolean check)";
            LOCATION.entering("checkRootConfiguration(String rootName, boolean check)");
            Configuration storageLocation = null;
            try {
                storageLocation = this._secureStorageConfigurationHandler.openConfiguration(rootName, 0);
                this._secureStorageConfigurationHandler.closeAllConfigurations();
            }
            catch (Exception e) {
                if (!check) break block4;
                this.createRoot(rootName);
            }
        }
        try {
            this._J2EEEngineKeystore = this.getKeystore();
        }
        catch (KeyStoreAccessException e) {
            SecureStorageImplMessage.ID0301_ERROR_CREATE_KEYSTOREVIEW.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "checkRootConfiguration(String rootName, boolean check)");
            CreateConfigurationsException cce = new CreateConfigurationsException(e, "Could not create key store view");
            LOCATION.exiting((Object)cce);
            throw cce;
        }
        LOCATION.exiting();
    }

    public void checkConfiguration(String name, boolean check) {
        block8: {
            String method = "checkConfiguration(String name, boolean check)";
            Configuration storageLocation = null;
            try {
                storageLocation = this._secureStorageConfigurationHandler.openConfiguration("securestorage", 0).getSubConfiguration(name);
                this._secureStorageConfigurationHandler.closeAllConfigurations();
            }
            catch (Exception e) {
                if (!check) break block8;
                try {
                    storageLocation = this._secureStorageConfigurationHandler.openConfiguration("securestorage", 1);
                    storageLocation = this.createConfiguration(name, storageLocation);
                }
                catch (ConfigurationLockedException d) {
                    SecureStorageImplMessage.ID0311_ERROR_CREATE_CONFIGURATION.create((Object)d.getMessage()).log(500, this.CATEGORY, LOCATION, "checkConfiguration(String name, boolean check)");
                }
                catch (ConfigurationException d) {
                    SecureStorageImplMessage.ID0311_ERROR_CREATE_CONFIGURATION.create((Object)d.getMessage()).log(500, this.CATEGORY, LOCATION, "checkConfiguration(String name, boolean check)");
                }
                catch (CreateConfigurationsException d) {
                    SecureStorageImplMessage.ID0311_ERROR_CREATE_CONFIGURATION.create((Object)d.getMessage()).log(500, this.CATEGORY, LOCATION, "checkConfiguration(String name, boolean check)");
                }
            }
        }
        try {
            this._secureStorageConfigurationHandler.closeAllConfigurations();
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(300, "checkConfiguration(String name, boolean check)", "An exception occurred when close configurations. The exception was: ", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    public void createRoot(String rootName) throws CreateConfigurationsException {
        block8: {
            String method = "createRoot(String rootName)";
            LOCATION.entering("createRoot(String rootName)");
            Configuration StorageLocation = null;
            StorageLocation = this._secureStorageConfigurationHandler.createRootConfiguration(rootName);
            this._secureStorageConfigurationHandler.commit();
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            Object var8_4 = null;
            try {
                this._secureStorageConfigurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e) {
                LOCATION.traceThrowableT(300, "createRoot(String rootName)", "An exception occurred when close configurations. The exception was: ", (Throwable)e);
            }
            break block8;
            {
                catch (ConfigurationLockedException e) {
                    SecureStorageImplMessage.ID0311_ERROR_CREATE_CONFIGURATION.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "createRoot(String rootName)");
                    CreateConfigurationsException cce = new CreateConfigurationsException((Exception)((Object)e), "Could not create configuration securestorage");
                    LOCATION.exiting((Object)cce);
                    throw cce;
                }
                catch (ConfigurationException e) {
                    SecureStorageImplMessage.ID0311_ERROR_CREATE_CONFIGURATION.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "createRoot(String rootName)");
                    CreateConfigurationsException cce = new CreateConfigurationsException((Exception)((Object)e), "Could not create configuration for securestorage");
                    LOCATION.exiting((Object)cce);
                    throw cce;
                }
            }
            catch (Throwable throwable) {
                Object var8_5 = null;
                try {
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e) {
                    LOCATION.traceThrowableT(300, "createRoot(String rootName)", "An exception occurred when close configurations. The exception was: ", (Throwable)e);
                }
                throw throwable;
            }
        }
        LOCATION.exiting();
    }

    public Configuration createConfiguration(String configurationName, Configuration storageLocation) throws CreateConfigurationsException {
        String method = "Configuration createConfiguration(String configurationName, Configuration storageLocation)";
        LOCATION.entering("Configuration createConfiguration(String configurationName, Configuration storageLocation)");
        try {
            storageLocation = storageLocation.createSubConfiguration(configurationName);
            this._secureStorageConfigurationHandler.commit();
            LOCATION.exiting();
            return storageLocation;
        }
        catch (ConfigurationLockedException e) {
            SecureStorageImplMessage.ID0311_ERROR_CREATE_CONFIGURATION.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "Configuration createConfiguration(String configurationName, Configuration storageLocation)");
            CreateConfigurationsException cce = new CreateConfigurationsException((Exception)((Object)e), "Could not create configuration");
            LOCATION.exiting((Object)cce);
            throw cce;
        }
        catch (NoWriteAccessException e) {
            SecureStorageImplMessage.ID0311_ERROR_CREATE_CONFIGURATION.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "Configuration createConfiguration(String configurationName, Configuration storageLocation)");
            CreateConfigurationsException cce = new CreateConfigurationsException((Exception)((Object)e), "Could not create configuration");
            LOCATION.exiting((Object)cce);
            throw cce;
        }
        catch (ConfigurationException e) {
            SecureStorageImplMessage.ID0311_ERROR_CREATE_CONFIGURATION.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "Configuration createConfiguration(String configurationName, Configuration storageLocation)");
            CreateConfigurationsException cce = new CreateConfigurationsException((Exception)((Object)e), "Could not create configuration");
            LOCATION.exiting((Object)cce);
            throw cce;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected KeyStore getKeystore() throws KeyStoreAccessException {
        KeyStore keyStore;
        String method = "KeyStore getKeystore()";
        LOCATION.entering("KeyStore getKeystore()");
        try {
            try {
                if (this.keystoreManager == null) {
                    this.setKeystoreReference();
                }
                this.lock();
                Object result = AccessController.doPrivileged(new LoadKeyStore(this.keystoreManager));
                if (!(result instanceof KeyStore)) throw new KeyStoreAccessException((Exception)result);
                this._J2EEEngineKeystore = (KeyStore)result;
                LOCATION.exiting();
                keyStore = this._J2EEEngineKeystore;
                Object var5_6 = null;
            }
            catch (InterruptedException e) {
                SecureStorageImplMessage.ID0302_ERROR_ACCESSING_KEYSTORE.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "KeyStore getKeystore()");
                KeyStoreAccessException ksae = new KeyStoreAccessException(e, "Could not lock key storage");
                LOCATION.exiting((Object)ksae);
                throw ksae;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                this.releaseLock();
                throw throwable;
            }
            catch (TechnicalLockException e) {
                SecureStorageImplMessage.ID0302_ERROR_ACCESSING_KEYSTORE.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "KeyStore getKeystore()");
                KeyStoreAccessException ksae = new KeyStoreAccessException((Exception)((Object)e), "Could not release key storage lock");
                LOCATION.exiting((Object)ksae);
                throw ksae;
            }
        }
        try {}
        catch (TechnicalLockException e) {
            SecureStorageImplMessage.ID0302_ERROR_ACCESSING_KEYSTORE.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "KeyStore getKeystore()");
            KeyStoreAccessException ksae = new KeyStoreAccessException((Exception)((Object)e), "Could not release key storage lock");
            LOCATION.exiting((Object)ksae);
            throw ksae;
        }
        this.releaseLock();
        return keyStore;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getLatestKeyID(int clientType, String clientID) throws KeyStoreAccessException, NoKeyForClientException {
        Object result;
        String method = "String getLatestKeyID(int clientType, String clientID)";
        LOCATION.entering("String getLatestKeyID(int clientType, String clientID)");
        int numberSecretKeysForClient = 0;
        String latestKeyID = null;
        String keyIDToCheck = null;
        int id = 0;
        int biggestIDValue = 0;
        int keysGeneratedOnGenerationDate = 0;
        int biggestKeysGeneratedOnGenerationDateValue = 0;
        int secondUnderLinePosition = 0;
        Calendar keyGenerationDate = Calendar.getInstance();
        Enumeration keyIDs = null;
        String secondLevelSubConfName = null;
        if (clientType == 1) {
            secondLevelSubConfName = "services";
        } else if (clientType == 2) {
            secondLevelSubConfName = "webapps";
        }
        if (this._J2EEEngineKeystore == null) {
            this._J2EEEngineKeystore = this.getKeystore();
        }
        if (!((result = AccessController.doPrivileged(new AliasesPrivilegedAction())) instanceof Enumeration)) {
            throw new KeyStoreAccessException((Exception)result, "Error reading keys from keystore");
        }
        keyIDs = (Enumeration)result;
        while (keyIDs.hasMoreElements()) {
            keyIDToCheck = (String)keyIDs.nextElement();
            if (!keyIDToCheck.startsWith(secondLevelSubConfName + "_" + clientID)) continue;
            ++numberSecretKeysForClient;
            secondUnderLinePosition = keyIDToCheck.indexOf(95, keyIDToCheck.indexOf(95) + 1);
            id = Integer.parseInt(keyIDToCheck.substring(secondUnderLinePosition + 1, secondUnderLinePosition + 9));
            keysGeneratedOnGenerationDate = Integer.parseInt(keyIDToCheck.substring(secondUnderLinePosition + 10));
            if (id > biggestIDValue) {
                biggestIDValue = id;
                biggestKeysGeneratedOnGenerationDateValue = keysGeneratedOnGenerationDate;
                latestKeyID = keyIDToCheck;
                continue;
            }
            if (id != biggestIDValue || keysGeneratedOnGenerationDate < biggestKeysGeneratedOnGenerationDateValue) continue;
            biggestKeysGeneratedOnGenerationDateValue = keysGeneratedOnGenerationDate;
            latestKeyID = keyIDToCheck;
        }
        if (numberSecretKeysForClient < 1) {
            throw new NoKeyForClientException("No Key for client " + clientID + " found in keystore");
        }
        LOCATION.exiting();
        return latestKeyID;
    }

    public String generateSecretKey(int clientType, String clientID) throws KeyGenerationException {
        String method = "String generateSecretKey(int clientType, String clientID)";
        LOCATION.entering("String generateSecretKey(int clientType, String clientID)");
        try {
            KeyGenerator kg = null;
            kg = KeyGenerator.getInstance("DESede", "IAIK");
            SecretKey clientsSecretKey = kg.generateKey();
            String secondLevelSubConfName = null;
            if (clientType == 1) {
                secondLevelSubConfName = "services";
            } else if (clientType == 2) {
                secondLevelSubConfName = "webapps";
            }
            Calendar keyGenerationDate = Calendar.getInstance();
            this._keyAlias = secondLevelSubConfName + "_" + clientID + "_" + this.firstCharZero(keyGenerationDate.get(1)) + this.firstCharZero(keyGenerationDate.get(2)) + this.firstCharZero(keyGenerationDate.get(5)) + "_" + this.getNumberOfKeysGeneratedToday();
            Object result = AccessController.doPrivileged(new AddKeyPrivilegedAction(clientsSecretKey));
            LOCATION.exiting();
            if (result == null) {
                return this._keyAlias;
            }
            if (result instanceof KeyStoreException) {
                throw new KeyGenerationException((KeyStoreException)result, "Could not generate secret key");
            }
            throw new KeyGenerationException("Could not generate secret key");
        }
        catch (NoSuchProviderException e) {
            KeyGenerationException kge = new KeyGenerationException(e, "Could not generate secret key");
            LOCATION.exiting((Object)kge);
            throw kge;
        }
        catch (NoSuchAlgorithmException e) {
            KeyGenerationException kge = new KeyGenerationException(e, "Could not generate secret key");
            LOCATION.exiting((Object)kge);
            throw kge;
        }
    }

    public Key getKey(String latestKeyID) throws KeyStoreException {
        Object result = AccessController.doPrivileged(new GetKeyPrivilegedAction(latestKeyID));
        if (result instanceof Key) {
            return (Key)result;
        }
        throw new KeyStoreException("Could not retrieve key from keystore");
    }

    private String firstCharZero(int number) {
        if (number < 10) {
            return "0" + Integer.toString(number);
        }
        return Integer.toString(number);
    }

    protected void setNumberOfKeys(String latestKeyID) {
        Calendar today = Calendar.getInstance();
        int secondUnderLinePosition = latestKeyID.indexOf("_", latestKeyID.indexOf("_") + 1);
        int year = Integer.parseInt(latestKeyID.substring(secondUnderLinePosition + 1, secondUnderLinePosition + 5));
        int month = Integer.parseInt(latestKeyID.substring(secondUnderLinePosition + 5, secondUnderLinePosition + 7));
        int day = Integer.parseInt(latestKeyID.substring(secondUnderLinePosition + 7, secondUnderLinePosition + 9));
        int keyID = Integer.parseInt(latestKeyID.substring(secondUnderLinePosition + 10));
        this.number_of_keys_generated_today = day != today.get(5) || month != today.get(2) || year != today.get(1) ? 0 : ++keyID;
    }

    private int getNumberOfKeysGeneratedToday() {
        return this.number_of_keys_generated_today;
    }

    public ProtectionDomain[] getProtectedProtectionDomainStack() {
        return this._protectionDomainStack;
    }

    public void setProtectedProtectionDomainStack() {
        this._protectionDomainStack = ProtectionDomainFactory.getFactory().getProtectionDomainStack();
    }

    protected void grantPermissions(String constants, String param1, String param2) {
        String method = "grantPermissions()";
        LOCATION.entering("grantPermissions()");
        this._constants = constants;
        this._param1 = param1;
        this._param2 = param2;
        try {
            if (this.keystoreManager == null) {
                this.setKeystoreReference();
            }
            SecurityConnector security = this.keystoreManager.getSecurityConnector();
            security.grantPermissionForGroup("Everyone", "view-creator", new String[]{this._constants, this._param1, this._param2});
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "An exception occurred at granting permissions. The exception was: ", "grantPermissions()", (Throwable)e);
        }
        LOCATION.exiting();
    }

    protected String getPermissionName(int clientType, String clientID) throws KeyStoreAccessException {
        String clientTypeName;
        if (clientType == 1) {
            clientTypeName = "services";
        } else if (clientType == 2) {
            clientTypeName = "webapps";
        } else {
            throw new KeyStoreAccessException("Error granting permission to application");
        }
        this._permissionKeyAlias = clientTypeName + "_" + clientID + "_" + "*";
        return this._permissionKeyAlias;
    }

    protected void setKeystoreReference() throws KeyStoreAccessException {
        String method = "setKeystoreReference()";
        this.keystoreManager = (KeystoreManager)this._serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("keystore");
        try {
            this._lockingContext = this._serviceContext.getCoreContext().getLockingContext();
            this._internalLock = this._lockingContext.createServerInternalLocking("$service.securestorage", "Global Synchronization For Security Service");
        }
        catch (TechnicalLockException tle) {
            LOCATION.traceThrowableT(300, "An exception occurred when instantiate ServerInternalLocking. The exception was:", "setKeystoreReference()", (Throwable)tle);
        }
    }

    private void lock() throws InterruptedException {
        long beginTime = System.currentTimeMillis();
        while (System.currentTimeMillis() <= beginTime + 600000L) {
            try {
                this._internalLock.lock("$service.securestorage", "", 'X');
                return;
            }
            catch (Exception e) {
                RemoteSecureStorageSuperContextImpl remoteSecureStorageSuperContextImpl = this;
                synchronized (remoteSecureStorageSuperContextImpl) {
                    this.wait(100L);
                }
            }
        }
        throw new InterruptedException();
    }

    private void releaseLock() throws TechnicalLockException {
        this._internalLock.unlock("$service.securestorage", "", 'X');
    }

    private void addKeyInternal(Key secretKey) throws KeyStoreException {
        String method = "addKeyInternal(Key)";
        try {
            this._J2EEEngineKeystore.setKeyEntry(this._keyAlias, secretKey, new char[0], new Certificate[0]);
        }
        catch (KeyStoreException e) {
            SecureStorageImplMessage.ID0322_ERROR_STORE_SECRET_KEY.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, method);
            throw new KeyStoreException("Error. Could not store key in keystore:" + e.getMessage());
        }
    }

    private Key getKeyInternal(String latestKeyID) throws KeyStoreException {
        String method = "getKeyInternal(Key)";
        try {
            return this._J2EEEngineKeystore.getKey(latestKeyID, new char[0]);
        }
        catch (KeyStoreException e) {
            SecureStorageImplMessage.ID0302_ERROR_ACCESSING_KEYSTORE.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, method);
            throw new KeyStoreException("Error. Could not retrieve key from keystore:" + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            SecureStorageImplMessage.ID0302_ERROR_ACCESSING_KEYSTORE.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, method);
            throw new KeyStoreException("Error. Could not retrieve key from keystore:" + e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            SecureStorageImplMessage.ID0302_ERROR_ACCESSING_KEYSTORE.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, method);
            throw new KeyStoreException("Error. Could not retrieve key from keystore:" + e.getMessage());
        }
    }

    private Enumeration getAliasesInternal() throws KeyStoreException {
        return this._J2EEEngineKeystore.aliases();
    }

    private KeyStore loadKeyStoreInternal(KeystoreManager keystoreManager) throws RemoteException {
        if (!keystoreManager.existKeystoreView("securestorage")) {
            keystoreManager.createKeystoreView("securestorage", new Properties());
        }
        this._J2EEEngineKeystore = keystoreManager.getKeystore("securestorage");
        try {
            this._J2EEEngineKeystore.load(null, null);
            return this._J2EEEngineKeystore;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RemoteException("Error. Could not load keystore");
        }
        catch (CertificateException e) {
            throw new RemoteException("Error. Could not load keystore");
        }
        catch (IOException e) {
            throw new RemoteException("Error. Could not load keystore");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class LoadKeyStore
    implements PrivilegedAction {
        KeystoreManager keystoreManager;

        LoadKeyStore(KeystoreManager keystoreManager) {
            this.keystoreManager = keystoreManager;
        }

        public Object run() {
            try {
                return RemoteSecureStorageSuperContextImpl.this.loadKeyStoreInternal(this.keystoreManager);
            }
            catch (Exception ex) {
                return ex;
            }
        }
    }

    public class AliasesPrivilegedAction
    implements PrivilegedAction {
        public Object run() {
            try {
                return RemoteSecureStorageSuperContextImpl.this.getAliasesInternal();
            }
            catch (Exception ex) {
                return ex;
            }
        }
    }

    public class GetKeyPrivilegedAction
    implements PrivilegedAction {
        String latestKeyID;

        GetKeyPrivilegedAction(String latestKeyID) {
            this.latestKeyID = latestKeyID;
        }

        public Object run() {
            try {
                return RemoteSecureStorageSuperContextImpl.this.getKeyInternal(this.latestKeyID);
            }
            catch (Exception ex) {
                return ex;
            }
        }
    }

    public class AddKeyPrivilegedAction
    implements PrivilegedAction {
        Key secretKey;

        AddKeyPrivilegedAction(Key secretKey) {
            this.secretKey = secretKey;
        }

        public Object run() {
            try {
                RemoteSecureStorageSuperContextImpl.this.addKeyInternal(this.secretKey);
                return null;
            }
            catch (Exception ex) {
                return ex;
            }
        }
    }
}

