/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.remote;

import com.sap.security.core.server.securestorage.SecureStorageObject;
import com.sap.security.core.server.securestorage.exception.KeyGenerationException;
import com.sap.security.core.server.securestorage.exception.ObjectDecryptionException;
import com.sap.security.core.server.securestorage.exception.ObjectDeletionException;
import com.sap.security.core.server.securestorage.exception.ObjectEncryptionException;
import com.sap.security.core.server.securestorage.exception.ObjectModificationException;
import com.sap.security.core.server.securestorage.exception.ObjectRetrievalException;
import com.sap.security.core.server.securestorage.exception.ObjectStorageException;
import com.sap.security.core.server.securestorage.exception.SecureStorageException;
import com.sap.security.core.server.securestorage.exception.StorageLocationOpenException;
import java.io.Serializable;
import java.rmi.RemoteException;

public interface RemoteSecureStorageClientContextInterface {
    public SecureStorageObject encrypt(Serializable var1) throws ObjectRetrievalException, ObjectEncryptionException, RemoteException;

    public byte[] base64Encoding(Serializable var1) throws ObjectEncryptionException;

    public Object decrypt(SecureStorageObject var1) throws ObjectDecryptionException, RemoteException;

    public void storeObject(Serializable var1, String var2) throws ObjectStorageException, RemoteException;

    public byte[] base64Decoding(byte[] var1) throws ObjectDecryptionException;

    public void generateNewKey() throws KeyGenerationException;

    public void deleteObject(String var1) throws ObjectDeletionException, RemoteException;

    public Object retrieveObject(String var1) throws ObjectRetrievalException, RemoteException;

    public byte[] retrieveBytes(String var1) throws ObjectRetrievalException, RemoteException;

    public String[] getObjectIDs() throws StorageLocationOpenException, ObjectRetrievalException, RemoteException;

    public boolean exist(String var1) throws SecureStorageException;

    public boolean isSecure(String var1) throws ObjectModificationException;
}

