/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.remote;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.lib.security.Base64;
import com.sap.engine.lib.security.domain.ProtectedProtectionDomain;
import com.sap.security.core.server.securestorage.CustomObjectInputStream;
import com.sap.security.core.server.securestorage.SecureStorageObject;
import com.sap.security.core.server.securestorage.exception.CreateConfigurationsException;
import com.sap.security.core.server.securestorage.exception.KeyGenerationException;
import com.sap.security.core.server.securestorage.exception.KeyStoreAccessException;
import com.sap.security.core.server.securestorage.exception.NoKeyForClientException;
import com.sap.security.core.server.securestorage.exception.ObjectDecryptionException;
import com.sap.security.core.server.securestorage.exception.ObjectDeletionException;
import com.sap.security.core.server.securestorage.exception.ObjectEncryptionException;
import com.sap.security.core.server.securestorage.exception.ObjectModificationException;
import com.sap.security.core.server.securestorage.exception.ObjectRetrievalException;
import com.sap.security.core.server.securestorage.exception.ObjectStorageException;
import com.sap.security.core.server.securestorage.exception.SecureStorageException;
import com.sap.security.core.server.securestorage.exception.StorageLocationOpenException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextImpl;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextInterface;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageSuperContextImpl;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.ProtectionDomain;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class RemoteSecureStorageClientContextImpl
extends RemoteSecureStorageSuperContextImpl
implements RemoteSecureStorageClientContextInterface,
Runnable {
    private String _oldClientID = null;
    private String _clientID = null;
    private String _permissionName = null;
    private int _clientType;
    private Object _mySyncObject;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl == null ? (class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl = RemoteSecureStorageClientContextImpl.class$("com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextImpl")) : class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl));
    static /* synthetic */ Class class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl;

    public RemoteSecureStorageClientContextImpl(ConfigurationHandler secureStorageConfigurationHandler, Object mySyncObject, ApplicationServiceContext serviceContext) throws RemoteException {
        String method = "RemoteSecureStorageClientContextImpl(ConfigurationHandler secureStorageConfigurationHandler, Object mySyncObject, ApplicationServiceContext serviceContext)";
        this._mySyncObject = mySyncObject;
        this.setProtectedProtectionDomainStack();
        ProtectionDomain[] myProtectionDomain = this.getProtectedProtectionDomainStack();
        this._permissionName = this._clientID = ((ProtectedProtectionDomain)myProtectionDomain[1]).getName();
        this._clientType = this._clientID.startsWith("service") ? 1 : 2;
        this._clientID = this._clientID.replace('/', '~');
        this._clientID = this._clientID.replace('.', '~');
        this._oldClientID = this._clientID = this._clientID.replace('_', '~');
        try {
            this._clientID = this._clientID.substring(0, this._clientID.indexOf("~servlet~jsp"));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this._clientID = this._clientID.substring(0, this._clientID.indexOf("~webservices~container"));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this._clientID = this._clientID.substring(0, this._clientID.indexOf("~EJBContainer"));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this._secureStorageConfigurationHandler = secureStorageConfigurationHandler;
        this._secureStorageConfigurationHandler = secureStorageConfigurationHandler;
        this._serviceContext = serviceContext;
        try {
            this.setKeystoreReference();
            if (this._J2EEEngineKeystore == null) {
                this.getKeystore();
            }
        }
        catch (KeyStoreAccessException e) {
            LOCATION.traceThrowableT(100, "RemoteSecureStorageClientContextImpl(ConfigurationHandler secureStorageConfigurationHandler, Object mySyncObject, ApplicationServiceContext serviceContext)", "Could not load key storage. That occure incorrect behaviour in later opperations. The exception was: ", (Throwable)e);
        }
    }

    public RemoteSecureStorageClientContextImpl(String clientExt, ConfigurationHandler secureStorageConfigurationHandler, Object mySyncObject, ApplicationServiceContext serviceContext) throws RemoteException {
        String method = "RemoteSecureStorageClientContextImpl(String clientExt, ConfigurationHandler secureStorageConfigurationHandler, Object mySyncObject, ApplicationServiceContext serviceContext)";
        this._mySyncObject = mySyncObject;
        this.setProtectedProtectionDomainStack();
        ProtectionDomain[] myProtectionDomain = this.getProtectedProtectionDomainStack();
        this._permissionName = this._clientID = ((ProtectedProtectionDomain)myProtectionDomain[1]).getName();
        this._clientType = this._clientID.startsWith("service") ? 1 : 2;
        this._clientID = this._clientID.replace('/', '~');
        this._clientID = this._clientID.replace('.', '~');
        this._clientID = this._clientID.replace('_', '~');
        this._oldClientID = this._clientID + clientExt;
        try {
            this._clientID = this._clientID.substring(0, this._clientID.indexOf("~servlet~jsp"));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this._clientID = this._clientID.substring(0, this._clientID.indexOf("~webservices~container"));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this._clientID = this._clientID.substring(0, this._clientID.indexOf("~EJBContainer"));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this._clientID = this._clientID + clientExt;
        this._secureStorageConfigurationHandler = secureStorageConfigurationHandler;
        this._secureStorageConfigurationHandler = secureStorageConfigurationHandler;
        this._serviceContext = serviceContext;
        try {
            this.setKeystoreReference();
            if (this._J2EEEngineKeystore == null) {
                this.getKeystore();
            }
        }
        catch (KeyStoreAccessException e) {
            LOCATION.traceThrowableT(100, "RemoteSecureStorageClientContextImpl(String clientExt, ConfigurationHandler secureStorageConfigurationHandler, Object mySyncObject, ApplicationServiceContext serviceContext)", "Could not load key storage. That occure incorrect behaviour in later opperations. The exception was: ", (Throwable)e);
        }
    }

    public RemoteSecureStorageClientContextImpl(String clientID, int clientType, ConfigurationHandler secureStorageConfigurationHandler, ApplicationServiceContext serviceContext) throws RemoteException {
        String method = "RemoteSecureStorageClientContextImpl(String clientID, int clientType, ConfigurationHandler secureStorageConfigurationHandler, ApplicationServiceContext serviceContext)";
        this._oldClientID = " ";
        this._clientID = clientID;
        this._clientType = clientType;
        this._secureStorageConfigurationHandler = secureStorageConfigurationHandler;
        this._secureStorageConfigurationHandler = secureStorageConfigurationHandler;
        this._serviceContext = serviceContext;
        try {
            this.setKeystoreReference();
            if (this._J2EEEngineKeystore == null) {
                this.getKeystore();
            }
        }
        catch (KeyStoreAccessException e) {
            LOCATION.traceThrowableT(100, "RemoteSecureStorageClientContextImpl(String clientID, int clientType, ConfigurationHandler secureStorageConfigurationHandler, ApplicationServiceContext serviceContext)", "Could not load key storage. That occure incorrect behaviour in later opperations. The exception was: ", (Throwable)e);
        }
    }

    private Configuration getClientsStorageLocation(String clientID, int accessMode, boolean check) throws ObjectRetrievalException, StorageLocationOpenException, ConfigurationLockedException {
        try {
            Configuration clientsStorageLocation = null;
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            String secondLevelSubConfName = null;
            if (this._clientType == 1) {
                secondLevelSubConfName = "services";
            } else if (this._clientType == 2) {
                secondLevelSubConfName = "webapps";
            }
            try {
                clientsStorageLocation = this._secureStorageConfigurationHandler.openConfiguration("securestorage", accessMode).getSubConfiguration(secondLevelSubConfName).getSubConfiguration(clientID);
            }
            catch (ConfigurationException e) {
                if (accessMode == 1) {
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                    clientsStorageLocation = this._secureStorageConfigurationHandler.openConfiguration("securestorage", accessMode).getSubConfiguration(secondLevelSubConfName);
                    clientsStorageLocation = this.createConfiguration(clientID, clientsStorageLocation);
                }
                throw new ObjectRetrievalException((Exception)((Object)e), "Could not find clientID");
            }
            return clientsStorageLocation;
        }
        catch (InconsistentReadException e) {
            throw new StorageLocationOpenException((Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new StorageLocationOpenException((Exception)((Object)e));
        }
        catch (CreateConfigurationsException e) {
            throw new StorageLocationOpenException(e);
        }
    }

    public synchronized SecureStorageObject encrypt(Serializable objectToEncrypt) throws ObjectEncryptionException {
        byte[] encryptedObject;
        String latestKeyID = null;
        SecretKey encryptionKey = null;
        try {
            try {
                latestKeyID = this.getLatestKeyID(this._clientType, this._clientID);
            }
            catch (NoKeyForClientException e) {
                latestKeyID = this.generateSecretKey(this._clientType, this._clientID);
            }
            encryptionKey = (SecretKey)this.getKey(latestKeyID);
            Cipher encryptionCipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            encryptionCipher.init(1, encryptionKey);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(objectToEncrypt);
            oos.flush();
            oos.close();
            baos.close();
            encryptedObject = encryptionCipher.doFinal(baos.toByteArray());
        }
        catch (KeyStoreAccessException e) {
            throw new ObjectEncryptionException(e, "Warning could not store Object in a secure behaviour because encryption algorithm is missing.");
        }
        catch (NoSuchAlgorithmException e) {
            latestKeyID = "Base64";
            encryptedObject = this.base64Encoding(objectToEncrypt);
        }
        catch (KeyGenerationException e) {
            latestKeyID = "Base64";
            encryptedObject = this.base64Encoding(objectToEncrypt);
        }
        catch (InvalidKeyException e) {
            throw new ObjectEncryptionException(e, "could not encrypt object");
        }
        catch (KeyStoreException e) {
            throw new ObjectEncryptionException(e, "could not encrypt object");
        }
        catch (NoSuchPaddingException e) {
            throw new ObjectEncryptionException(e, "could not encrypt object");
        }
        catch (IllegalBlockSizeException e) {
            throw new ObjectEncryptionException(e, "could not encrypt object");
        }
        catch (IOException e) {
            throw new ObjectEncryptionException(e, "could not encrypt object");
        }
        catch (BadPaddingException e) {
            throw new ObjectEncryptionException(e, "could not encrypt object");
        }
        return new SecureStorageObject(1, latestKeyID, encryptedObject);
    }

    public synchronized byte[] base64Encoding(Serializable objectToEncode) throws ObjectEncryptionException {
        byte[] base64EncodedObject = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(objectToEncode);
            oos.flush();
            oos.close();
            baos.close();
            base64EncodedObject = Base64.encode((byte[])baos.toByteArray());
            return base64EncodedObject;
        }
        catch (IOException e) {
            throw new ObjectEncryptionException(e, "could not encrypt object");
        }
        catch (Exception e) {
            throw new ObjectEncryptionException(e, "could not encrypt object");
        }
    }

    public synchronized SecureStorageObject[] reEncrypt(SecureStorageObject[] objectsToReEncrypt) throws ObjectEncryptionException {
        try {
            SecureStorageObject[] reEncryptedObjects = new SecureStorageObject[objectsToReEncrypt.length];
            int i = 0;
            while (i < objectsToReEncrypt.length) {
                if (!objectsToReEncrypt[i].getSecretKeyID().equals(this.getLatestKeyID(this._clientType, this._clientID))) {
                    SecureStorageObject reEncryptedObject;
                    reEncryptedObjects[i] = reEncryptedObject = this.encrypt((Serializable)this.decrypt(objectsToReEncrypt[i]));
                }
                ++i;
            }
            return reEncryptedObjects;
        }
        catch (KeyStoreAccessException e) {
            throw new ObjectEncryptionException(e, "Could not re-encrypt objects");
        }
        catch (NoKeyForClientException e) {
            throw new ObjectEncryptionException(e, "Could not re-encrypt objects");
        }
        catch (ObjectEncryptionException e) {
            throw new ObjectEncryptionException(e, "Could not re-encrypt objects");
        }
        catch (ObjectDecryptionException e) {
            throw new ObjectEncryptionException(e, "Could not re-encrypt objects");
        }
    }

    public synchronized Object decrypt(SecureStorageObject objectToDecrypt) throws ObjectDecryptionException {
        try {
            byte[] decryptedByteArray;
            byte[] encryptedData = objectToDecrypt.getEncryptedData();
            String encryptionSecretKeyID = objectToDecrypt.getSecretKeyID();
            if (encryptionSecretKeyID.equals("Base64")) {
                decryptedByteArray = this.base64Decoding(encryptedData);
            } else {
                SecretKey encryptionSecretKey = (SecretKey)this.getKey(encryptionSecretKeyID);
                Cipher encryptionCipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
                encryptionCipher.init(2, encryptionSecretKey);
                decryptedByteArray = encryptionCipher.doFinal(encryptedData);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(decryptedByteArray);
            CustomObjectInputStream ois = new CustomObjectInputStream(bais, Thread.currentThread().getContextClassLoader());
            Object decryptedObject = ois.readObject();
            bais.close();
            ois.close();
            return decryptedObject;
        }
        catch (InvalidKeyException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
        catch (KeyStoreException e) {
            throw new ObjectDecryptionException(e, "Extraordinary exception occurred. Trying to load the keystore failed");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ObjectDecryptionException(e, "Extraordinary exception occurred. Perhaps key was saved manually with another algorithm or SAP Java Crypto Lib is no longer available on this server");
        }
        catch (ClassNotFoundException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
        catch (IOException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
        catch (NoSuchPaddingException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
        catch (IllegalBlockSizeException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
        catch (BadPaddingException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
    }

    public synchronized byte[] decryptReturnBytes(SecureStorageObject objectToDecrypt) throws ObjectDecryptionException {
        try {
            byte[] decryptedByte;
            String encryptionSecretKeyID = objectToDecrypt.getSecretKeyID();
            byte[] encryptedData = objectToDecrypt.getEncryptedData();
            if (encryptionSecretKeyID.equals("Base64")) {
                decryptedByte = this.base64Decoding(encryptedData);
            } else {
                SecretKey encryptionSecretKey = (SecretKey)this.getKey(encryptionSecretKeyID);
                Cipher encryptionCipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
                encryptionCipher.init(2, encryptionSecretKey);
                decryptedByte = encryptionCipher.doFinal(encryptedData);
            }
            return decryptedByte;
        }
        catch (InvalidKeyException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
        catch (KeyStoreException e) {
            throw new ObjectDecryptionException(e, "Extraordinary exception occurred. Trying to load the keystore failed");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ObjectDecryptionException(e, "Extraordinary exception occurred. Perhaps key was saved manually with another algorithm");
        }
        catch (NoSuchPaddingException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
        catch (IllegalBlockSizeException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
        catch (BadPaddingException e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
    }

    public synchronized byte[] base64Decoding(byte[] objectToDecod) throws ObjectDecryptionException {
        byte[] decodedObject = null;
        try {
            decodedObject = Base64.decode((byte[])objectToDecod);
            return decodedObject;
        }
        catch (Exception e) {
            throw new ObjectDecryptionException(e, "Could not decrypt the object");
        }
    }

    /*
     * Loose catch block
     */
    public void commit() throws ObjectModificationException {
        block7: {
            String method = "commit()";
            this._secureStorageConfigurationHandler.commit();
            Object var4_2 = null;
            try {
                this._secureStorageConfigurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e) {
                LOCATION.traceThrowableT(300, "commit()", "An exception occurred when close configurations. It could occur incorrect behaviour in later opperations. The exception was: ", (Throwable)e);
            }
            break block7;
            {
                catch (ConfigurationException e) {
                    LOCATION.traceThrowableT(100, "commit()", "An exception occurred when commit. Changes will not be persisted. client {0} {1} was calling.", new Object[]{new Integer(this._clientType), this._clientID}, (Throwable)e);
                    throw new ObjectModificationException((Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                try {
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e) {
                    LOCATION.traceThrowableT(300, "commit()", "An exception occurred when close configurations. It could occur incorrect behaviour in later opperations. The exception was: ", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    public synchronized void storeObjectWithoutCommit(Serializable object, String objectID) throws ObjectStorageException {
        String method = "storeObjectWithoutCommit(Serializable object, String objectID)";
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        ByteArrayInputStream myByteArrayInputStream = null;
        boolean success = false;
        try {
            ClassLoader applicationLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl == null ? (class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl = RemoteSecureStorageClientContextImpl.class$("com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextImpl")) : class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl).getClassLoader());
            SecureStorageObject encryptedObject = this.encrypt(object);
            Configuration clientsStorageLocation = this.getClientsStorageLocation(this._clientID, 1, true);
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(encryptedObject);
            oos.flush();
            byte[] encryptedObjectInBytes = baos.toByteArray();
            myByteArrayInputStream = new ByteArrayInputStream(encryptedObjectInBytes);
            clientsStorageLocation.addFileAsStream(objectID, (InputStream)myByteArrayInputStream);
            oos.close();
            baos.close();
            myByteArrayInputStream.close();
            Thread.currentThread().setContextClassLoader(applicationLoader);
        }
        catch (ObjectEncryptionException e) {
            LOCATION.traceThrowableT(300, "storeObjectWithoutCommit(Serializable object, String objectID)", "Object could not stored because an exception occurred. client {0} {1} was calling for object {2}", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
            throw new ObjectStorageException(e, "Could not store object " + objectID);
        }
        catch (StorageLocationOpenException e) {
            LOCATION.traceThrowableT(300, "storeObjectWithoutCommit(Serializable object, String objectID)", "Object could not stored because an exception occurred. client {0} {1} was calling for object {2}", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
            throw new ObjectStorageException(e, "Could not store object " + objectID);
        }
        catch (NoWriteAccessException e) {
            LOCATION.traceThrowableT(300, "storeObjectWithoutCommit(Serializable object, String objectID)", "Object could not stored because an exception occurred. client {0} {1} was calling for object {2}", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
            throw new ObjectStorageException((Exception)((Object)e), "Could not store object " + objectID);
        }
        catch (InvalidValueException e) {
            LOCATION.traceThrowableT(300, "storeObjectWithoutCommit(Serializable object, String objectID)", "Object could not stored because an exception occurred. client {0} {1} was calling for object {2}", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
            throw new ObjectStorageException((Exception)((Object)e), "Could not store object " + objectID);
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(300, "storeObjectWithoutCommit(Serializable object, String objectID)", "Object could not stored because an exception occurred. client {0} {1} was calling for object {2}", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
            throw new ObjectStorageException((Exception)((Object)e), "Could not store object " + objectID);
        }
        catch (ObjectRetrievalException e) {
            LOCATION.traceThrowableT(300, "storeObjectWithoutCommit(Serializable object, String objectID)", "Object could not stored because an exception occurred. client {0} {1} was calling for object {2}", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
            throw new ObjectStorageException(e, "Could not store object " + objectID);
        }
        catch (IOException e) {
            LOCATION.traceThrowableT(300, "storeObjectWithoutCommit(Serializable object, String objectID)", "Object could not stored because an exception occurred. client {0} {1} was calling for object {2}", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
            throw new ObjectStorageException(e, "Could not store object " + objectID);
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void storeObject(Serializable object, String objectID) throws ObjectStorageException {
        block11: {
            String method = "storeObject(Serializable object, String objectID)";
            this.storeObjectWithoutCommit(object, objectID);
            this.commit();
            if (!this._clientID.equals(this._oldClientID)) {
                try {
                    RemoteSecureStorageAdministratorContextImpl adminContext = new RemoteSecureStorageAdministratorContextImpl(this._secureStorageConfigurationHandler, this._serviceContext);
                    adminContext.deleteObject(this._clientType, this._oldClientID, objectID);
                }
                catch (ObjectDeletionException e) {
                }
                catch (RemoteException e) {
                    LOCATION.traceThrowableT(100, "storeObject(Serializable object, String objectID)", "An exception occurred. Incorrect behaviour can occur in later opperations. The exception was: ", (Throwable)e);
                }
            }
            Object var7_8 = null;
            try {
                this._secureStorageConfigurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e) {
                LOCATION.traceThrowableT(300, "storeObject(Serializable object, String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", (Throwable)e);
            }
            break block11;
            {
                catch (ObjectModificationException e) {
                    throw new ObjectStorageException(e);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e) {
                    LOCATION.traceThrowableT(300, "storeObject(Serializable object, String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    public synchronized void generateNewKey() throws KeyGenerationException {
        try {
            String latestKeyID = null;
            try {
                latestKeyID = super.getLatestKeyID(this._clientType, this._clientID);
                super.setNumberOfKeys(latestKeyID);
                latestKeyID = super.generateSecretKey(this._clientType, this._clientID);
            }
            catch (Exception e) {
                latestKeyID = super.generateSecretKey(this._clientType, this._clientID);
            }
        }
        catch (Exception e) {
            throw new KeyGenerationException(e, "Error, could not generate new key for client " + this._clientID);
        }
    }

    public synchronized void deleteObject(String objectID) throws ObjectDeletionException {
        boolean newID;
        boolean oldID;
        RemoteSecureStorageAdministratorContextImpl adminContext;
        String method = "deleteObject(String objectID)";
        try {
            adminContext = new RemoteSecureStorageAdministratorContextImpl(this._secureStorageConfigurationHandler, this._serviceContext);
            adminContext.deleteObject(this._clientType, this._oldClientID, objectID);
            oldID = false;
            this._secureStorageConfigurationHandler.closeAllConfigurations();
        }
        catch (Exception e) {
            oldID = true;
            try {
                this._secureStorageConfigurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException cex) {
                LOCATION.traceThrowableT(300, "deleteObject(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)cex);
            }
        }
        try {
            adminContext = new RemoteSecureStorageAdministratorContextImpl(this._secureStorageConfigurationHandler, this._serviceContext);
            adminContext.deleteObject(this._clientType, this._clientID, objectID);
            newID = false;
            this._secureStorageConfigurationHandler.closeAllConfigurations();
        }
        catch (Exception e) {
            newID = true;
            try {
                this._secureStorageConfigurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException cex) {
                LOCATION.traceThrowableT(300, "deleteObject(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)cex);
            }
        }
        if (oldID && newID) {
            throw new ObjectDeletionException("Could not delete object " + objectID);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object retrieveObject(String objectID) throws ObjectRetrievalException {
        String method = "retrieveObject(String objectID)";
        SecureStorageObject encryptedObject = null;
        CustomObjectInputStream myObjectInputStream = null;
        InputStream myInputStream = null;
        try {
            try {
                Configuration clientsStorageLocation;
                ClassLoader applicationLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl == null ? (class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl = RemoteSecureStorageClientContextImpl.class$("com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextImpl")) : class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl).getClassLoader());
                try {
                    clientsStorageLocation = this.getClientsStorageLocation(this._oldClientID, 0, true);
                }
                catch (ObjectRetrievalException e) {
                    clientsStorageLocation = this.getClientsStorageLocation(this._clientID, 0, true);
                }
                if (clientsStorageLocation.existsConfigEntry(objectID)) {
                    encryptedObject = (SecureStorageObject)clientsStorageLocation.getConfigEntry(objectID);
                } else {
                    try {
                        myInputStream = clientsStorageLocation.getFile(objectID);
                    }
                    catch (NameNotFoundException e) {
                        clientsStorageLocation = this.getClientsStorageLocation(this._clientID, 0, true);
                        myInputStream = clientsStorageLocation.getFile(objectID);
                    }
                    myObjectInputStream = new CustomObjectInputStream(myInputStream, Thread.currentThread().getContextClassLoader());
                    encryptedObject = (SecureStorageObject)myObjectInputStream.readObject();
                    myObjectInputStream.close();
                    myInputStream.close();
                }
                if (encryptedObject.getSecretKeyID().equals("Base64")) {
                    try {
                        this.getLatestKeyID(this._clientType, this._clientID);
                    }
                    catch (NoKeyForClientException e) {
                        try {
                            this.generateSecretKey(this._clientType, this._clientID);
                        }
                        catch (KeyGenerationException key) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (!encryptedObject.getSecretKeyID().equals(this.getLatestKeyID(this._clientType, this._clientID))) {
                        try {
                            Thread.currentThread().setContextClassLoader(applicationLoader);
                            Object decryptedObject = this.decrypt(encryptedObject);
                            this.deleteObject(objectID);
                            this.storeObject((Serializable)decryptedObject, objectID);
                            this._secureStorageConfigurationHandler.commit();
                        }
                        catch (Exception exc) {}
                    }
                }
                catch (NoKeyForClientException e) {
                    // empty catch block
                }
                Thread.currentThread().setContextClassLoader(applicationLoader);
                Object e = this.decrypt(encryptedObject);
                Object var14_19 = null;
                try {
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                    return e;
                }
                catch (ConfigurationException e2) {
                    LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e2);
                }
                return e;
            }
            catch (StorageLocationOpenException e) {
                LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
            catch (InconsistentReadException e) {
                LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException((Exception)((Object)e), "could not retrieve object " + objectID);
            }
            catch (ObjectDecryptionException e) {
                LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
            catch (ConfigurationException e) {
                LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException((Exception)((Object)e), "could not retrieve object " + objectID);
            }
            catch (KeyStoreAccessException e) {
                LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
            catch (IOException e) {
                LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
            catch (ClassNotFoundException e) {
                LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            try {}
            catch (ConfigurationException e2) {
                LOCATION.traceThrowableT(300, "retrieveObject(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e2);
                throw throwable;
            }
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] retrieveBytes(String objectID) throws ObjectRetrievalException {
        String method = "retrieveBytes(String objectID)";
        SecureStorageObject encryptedObject = null;
        CustomObjectInputStream myObjectInputStream = null;
        InputStream myInputStream = null;
        try {
            try {
                Configuration clientsStorageLocation;
                Thread.currentThread().setContextClassLoader((class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl == null ? (class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl = RemoteSecureStorageClientContextImpl.class$("com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextImpl")) : class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageClientContextImpl).getClassLoader());
                try {
                    clientsStorageLocation = this.getClientsStorageLocation(this._oldClientID, 0, true);
                }
                catch (ObjectRetrievalException e) {
                    clientsStorageLocation = this.getClientsStorageLocation(this._clientID, 0, true);
                }
                if (clientsStorageLocation.existsConfigEntry(objectID)) {
                    encryptedObject = (SecureStorageObject)clientsStorageLocation.getConfigEntry(objectID);
                } else {
                    try {
                        myInputStream = clientsStorageLocation.getFile(objectID);
                    }
                    catch (NameNotFoundException e) {
                        clientsStorageLocation = this.getClientsStorageLocation(this._clientID, 0, true);
                        myInputStream = clientsStorageLocation.getFile(objectID);
                    }
                    myObjectInputStream = new CustomObjectInputStream(myInputStream, Thread.currentThread().getContextClassLoader());
                    encryptedObject = (SecureStorageObject)myObjectInputStream.readObject();
                    myObjectInputStream.close();
                    myInputStream.close();
                }
                if (encryptedObject.getSecretKeyID().equals("Base64")) {
                    try {
                        this.getLatestKeyID(this._clientType, this._clientID);
                    }
                    catch (NoKeyForClientException e) {
                        try {
                            this.generateSecretKey(this._clientType, this._clientID);
                        }
                        catch (KeyGenerationException key) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (!encryptedObject.getSecretKeyID().equals(this.getLatestKeyID(this._clientType, this._clientID))) {
                        try {
                            Object decryptedObject = this.decrypt(encryptedObject);
                            this.deleteObject(objectID);
                            this.storeObject((Serializable)decryptedObject, objectID);
                            this._secureStorageConfigurationHandler.commit();
                        }
                        catch (Exception exc) {}
                    }
                }
                catch (NoKeyForClientException e) {
                    // empty catch block
                }
                byte[] e = this.decryptReturnBytes(encryptedObject);
                Object var14_17 = null;
                try {
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                    return e;
                }
                catch (ConfigurationException e2) {
                    LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e2);
                }
                return e;
            }
            catch (KeyStoreAccessException e) {
                LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
            catch (StorageLocationOpenException e) {
                LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
            catch (InconsistentReadException e) {
                LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException((Exception)((Object)e), "could not retrieve object " + objectID);
            }
            catch (ObjectDecryptionException e) {
                LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
            catch (ConfigurationException e) {
                LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException((Exception)((Object)e), "could not retrieve object " + objectID);
            }
            catch (IOException e) {
                LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
            catch (ClassNotFoundException e) {
                LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "Could not retrieve object " + objectID + ". The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw new ObjectRetrievalException(e, "could not retrieve object " + objectID);
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            try {}
            catch (ConfigurationException e2) {
                LOCATION.traceThrowableT(300, "retrieveBytes(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e2);
                throw throwable;
            }
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String[] getObjectIDs() throws StorageLocationOpenException, ObjectRetrievalException {
        String method = "getObjectIDs()";
        try {
            try {
                Configuration clientsStorageLocation = this.getClientsStorageLocation(this._clientID, 0, true);
                String[] configEntries = clientsStorageLocation.getAllConfigEntryNames();
                String[] fileEntries = clientsStorageLocation.getAllFileEntryNames();
                String[] allEntries = new String[configEntries.length + fileEntries.length];
                int i = 0;
                while (i < configEntries.length) {
                    allEntries[i] = configEntries[i];
                    ++i;
                }
                int x = 0;
                while (x < fileEntries.length) {
                    allEntries[i + x] = fileEntries[x];
                    ++x;
                }
                String[] stringArray = allEntries;
                Object var10_12 = null;
                try {
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                    return stringArray;
                }
                catch (ConfigurationException e) {
                    LOCATION.traceThrowableT(300, "getObjectIDs()", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. Client {0} {1} was calling. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID}, (Throwable)e);
                }
                return stringArray;
            }
            catch (InconsistentReadException e) {
                throw new StorageLocationOpenException((Exception)((Object)e), "Error reading objects in client's storage-location");
            }
            catch (ConfigurationLockedException e) {
                throw new StorageLocationOpenException((Exception)((Object)e), "Error reading objects in client's storage-location");
            }
            catch (ConfigurationException e) {
                throw new StorageLocationOpenException((Exception)((Object)e), "Error reading objects in client's storage-location");
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {}
            catch (ConfigurationException e) {
                LOCATION.traceThrowableT(300, "getObjectIDs()", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. Client {0} {1} was calling. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID}, (Throwable)e);
                throw throwable;
            }
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            throw throwable;
        }
    }

    public void updateObjectNoCommit(Serializable object, String objectID) throws ObjectModificationException {
        try {
            Configuration clientsStorageLocation = this.getClientsStorageLocation(this._clientID, 1, true);
            clientsStorageLocation.deleteFile(objectID);
            this.storeObjectWithoutCommit(object, objectID);
        }
        catch (ConfigurationLockedException e) {
            throw new ObjectModificationException((Exception)((Object)e));
        }
        catch (NameNotFoundException e) {
            throw new ObjectModificationException((Exception)((Object)e));
        }
        catch (NoWriteAccessException e) {
            throw new ObjectModificationException((Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new ObjectModificationException((Exception)((Object)e));
        }
        catch (ObjectRetrievalException e) {
            throw new ObjectModificationException(e);
        }
        catch (StorageLocationOpenException e) {
            throw new ObjectModificationException(e);
        }
        catch (ObjectStorageException e) {
            throw new ObjectModificationException(e);
        }
    }

    protected void finalize() throws Throwable {
        String method = "finalize()";
        try {
            this._secureStorageConfigurationHandler.closeAllConfigurations();
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(300, "finalize()", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. Client {0} {1} was calling. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID}, (Throwable)e);
        }
        super.finalize();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean exist(String objectID) throws SecureStorageException {
        block15: {
            block14: {
                method = "isStored(String objectID)";
                try {
                    try {
                        clientLocation = this.getClientsStorageLocation(this._clientID, 0, false);
                        if (clientLocation.existsConfigEntry(objectID)) {
                            var4_4 = true;
                            var10_7 = null;
                            break block14;
                        }
                        var4_5 = clientLocation.existsFile(objectID);
                        break block15;
                    }
                    catch (ConfigurationLockedException e) {
                        throw new SecureStorageException((Exception)e, "Could not check object");
                    }
                    catch (ObjectRetrievalException e) {
                        var6_16 = false;
                        var10_9 = null;
                        try {
                            this._secureStorageConfigurationHandler.closeAllConfigurations();
                            return var6_16;
                        }
                        catch (ConfigurationException e1) {
                            RemoteSecureStorageClientContextImpl.LOCATION.traceThrowableT(300, "isStored(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e1);
                        }
                        return var6_16;
                    }
                    catch (StorageLocationOpenException e) {
                        throw new SecureStorageException(e, "Could not check object");
                    }
                    catch (InconsistentReadException e) {
                        throw new SecureStorageException((Exception)e, "Could not check object");
                    }
                    catch (ConfigurationException e) {
                        throw new SecureStorageException((Exception)e, "Could not check object");
                    }
                }
                catch (Throwable var9_20) {
                    var10_10 = null;
                    try {}
                    catch (ConfigurationException e1) {
                        RemoteSecureStorageClientContextImpl.LOCATION.traceThrowableT(300, "isStored(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e1);
                        throw var9_20;
                    }
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                    throw var9_20;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 125->137)] { 
lbl44:
            // 1 sources

            this._secureStorageConfigurationHandler.closeAllConfigurations();
            return var4_4;
lbl46:
            // 1 sources

            catch (ConfigurationException e1) {
                RemoteSecureStorageClientContextImpl.LOCATION.traceThrowableT(300, "isStored(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e1);
            }
            return var4_4;
        }
        var10_8 = null;
        ** try [egrp 2[TRYBLOCK] [6 : 125->137)] { 
lbl53:
        // 1 sources

        this._secureStorageConfigurationHandler.closeAllConfigurations();
        return var4_5;
lbl55:
        // 1 sources

        catch (ConfigurationException e1) {
            RemoteSecureStorageClientContextImpl.LOCATION.traceThrowableT(300, "isStored(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e1);
        }
        return var4_5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isSecure(String objectID) throws ObjectModificationException {
        String method = "isSecure(String objectID)";
        boolean secure = false;
        SecureStorageObject encryptedObject = null;
        InputStream myInputStream = null;
        CustomObjectInputStream myObjectInputStream = null;
        try {
            try {
                Configuration clientsStorageLocation = this.getClientsStorageLocation(this._clientID, 0, true);
                if (clientsStorageLocation.existsConfigEntry(objectID)) {
                    encryptedObject = (SecureStorageObject)clientsStorageLocation.getConfigEntry(objectID);
                } else {
                    myInputStream = clientsStorageLocation.getFile(objectID);
                    myObjectInputStream = new CustomObjectInputStream(myInputStream, Thread.currentThread().getContextClassLoader());
                    encryptedObject = (SecureStorageObject)myObjectInputStream.readObject();
                    myInputStream.close();
                    myObjectInputStream.close();
                }
                if (!encryptedObject.getSecretKeyID().equals("Base64")) {
                    secure = true;
                }
                boolean bl = secure;
                Object var16_10 = null;
                try {
                    this._secureStorageConfigurationHandler.closeAllConfigurations();
                    return bl;
                }
                catch (ConfigurationException e) {
                    LOCATION.traceThrowableT(300, "isSecure(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. Client {0} {1} was calling for object {2}. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                }
                return bl;
            }
            catch (ObjectRetrievalException e) {
                throw new ObjectModificationException(e, "Could not load Object");
            }
            catch (StorageLocationOpenException e) {
                throw new ObjectModificationException(e, "Could not load Object");
            }
            catch (NameNotFoundException e) {
                throw new ObjectModificationException((Exception)((Object)e), "Could not load Object");
            }
            catch (InconsistentReadException e) {
                throw new ObjectModificationException((Exception)((Object)e), "Could not load Object");
            }
            catch (ConfigurationException e) {
                throw new ObjectModificationException((Exception)((Object)e), "Could not load Object");
            }
            catch (IOException e) {
                throw new ObjectModificationException(e, "Could not deserialize the object");
            }
            catch (ClassNotFoundException e) {
                throw new ObjectModificationException(e, "Could not find class of the object");
            }
        }
        catch (Throwable throwable) {
            Object var16_11 = null;
            try {}
            catch (ConfigurationException e) {
                LOCATION.traceThrowableT(300, "isSecure(String objectID)", "An exception occurred when close configurations. Incorrect behaviour can occur in later opperations. Client {0} {1} was calling for object {2}. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID, objectID}, (Throwable)e);
                throw throwable;
            }
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            throw throwable;
        }
    }

    public void run() {
        String method = "run()";
        Object object = this._mySyncObject;
        synchronized (object) {
            block8: {
                try {
                    try {
                        String permissionName = this.getPermissionName(this._clientType, this._clientID);
                        this.grantPermissions("GET_VIEW", "securestorage", null);
                    }
                    catch (KeyStoreAccessException e) {
                        LOCATION.traceThrowableT(100, "run()", "An exception occurred when access to Key Storage service. Incorrect behaviour will occur in later opperations. Client {0} {1} was calling. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID}, (Throwable)e);
                        Object var7_5 = null;
                        this._mySyncObject.notifyAll();
                        break block8;
                    }
                    catch (Exception e) {
                        LOCATION.traceThrowableT(300, "run()", "An exception occurred when check permissions of Key Storage. Incorrect behaviour can occur in later opperations. Client {0} {1} was calling. The exception was: ", new Object[]{new Integer(this._clientType), this._clientID}, (Throwable)e);
                        Object var7_6 = null;
                        this._mySyncObject.notifyAll();
                    }
                    Object var7_4 = null;
                    this._mySyncObject.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this._mySyncObject.notifyAll();
                    throw throwable;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

