/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.remote;

import com.sap.security.core.server.securestorage.exception.CreateConfigurationsException;
import com.sap.security.core.server.securestorage.exception.KeyGenerationException;
import com.sap.security.core.server.securestorage.exception.KeyStoreAccessException;
import com.sap.security.core.server.securestorage.exception.NoKeyForClientException;
import com.sap.security.core.server.securestorage.exception.ObjectDeletionException;
import com.sap.security.core.server.securestorage.exception.ObjectEncryptionException;
import com.sap.security.core.server.securestorage.exception.ObjectModificationException;
import com.sap.security.core.server.securestorage.exception.SecureStorageException;
import com.sap.security.core.server.securestorage.exception.StorageLocationOpenException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Vector;

public interface RemoteSecureStorageAdministratorContextInterface
extends Remote {
    public String getLatestKeyID(int var1, String var2) throws NoKeyForClientException, KeyStoreAccessException, KeyStoreAccessException;

    public Vector getClientIDs(int var1) throws StorageLocationOpenException, RemoteException;

    public Vector getObjectIDs(int var1, String var2) throws StorageLocationOpenException, RemoteException;

    public Vector getSecretKeyIDs(String var1, int var2) throws NoKeyForClientException, KeyStoreAccessException, RemoteException;

    public boolean isSecure(int var1, String var2, String var3) throws SecureStorageException;

    public boolean isClientSecure(int var1, String var2) throws SecureStorageException;

    public int getNumberOfServiceClients() throws StorageLocationOpenException, RemoteException;

    public int getNumberOfWebAppClients() throws StorageLocationOpenException, RemoteException;

    public int getNumberOfAllClients() throws StorageLocationOpenException, RemoteException;

    public int getNumberOfServiceClientObjects() throws StorageLocationOpenException, RemoteException;

    public int getNumberOfWebAppClientObjects() throws StorageLocationOpenException, RemoteException;

    public int getNumberOfAllClientObjects() throws StorageLocationOpenException, RemoteException;

    public int getNumberOfEncryptedObjects() throws SecureStorageException, RemoteException;

    public int getNumberOfEncodedObjects() throws SecureStorageException, RemoteException;

    public int getEncryptionRate() throws SecureStorageException, RemoteException;

    public int getNumberOfServiceKeys() throws StorageLocationOpenException, KeyStoreAccessException, NoKeyForClientException, RemoteException;

    public int getNumberOfWebAppKeys() throws StorageLocationOpenException, KeyStoreAccessException, NoKeyForClientException, RemoteException;

    public int getNumberOfKeys() throws StorageLocationOpenException, KeyStoreAccessException, NoKeyForClientException, RemoteException;

    public boolean isCryptoLibDepolyed() throws RemoteException;

    public void deleteObject(int var1, String var2, String var3) throws ObjectDeletionException, RemoteException;

    public void reEncryptAllCentralStoredObjects() throws ObjectEncryptionException, RemoteException;

    public void reEncryptCentralStoredObject(int var1, String var2) throws ObjectModificationException, RemoteException;

    public void generateSecretKeyID(int var1, String var2) throws KeyGenerationException;

    public void checkRootConfiguration(String var1, boolean var2) throws RemoteException, CreateConfigurationsException;

    public void checkConfiguration(String var1, boolean var2) throws RemoteException;
}

