/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.remote;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.security.core.server.securestorage.CustomObjectInputStream;
import com.sap.security.core.server.securestorage.SecureStorageObject;
import com.sap.security.core.server.securestorage.exception.CreateConfigurationsException;
import com.sap.security.core.server.securestorage.exception.KeyGenerationException;
import com.sap.security.core.server.securestorage.exception.KeyStoreAccessException;
import com.sap.security.core.server.securestorage.exception.NoKeyForClientException;
import com.sap.security.core.server.securestorage.exception.ObjectDeletionException;
import com.sap.security.core.server.securestorage.exception.ObjectEncryptionException;
import com.sap.security.core.server.securestorage.exception.ObjectModificationException;
import com.sap.security.core.server.securestorage.exception.ObjectRetrievalException;
import com.sap.security.core.server.securestorage.exception.SecureStorageException;
import com.sap.security.core.server.securestorage.exception.StorageLocationOpenException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextImpl;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageSuperContextImpl;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.KeyGenerator;

public class RemoteSecureStorageAdministratorContextImpl
extends RemoteSecureStorageSuperContextImpl
implements RemoteSecureStorageAdministratorContextInterface {
    private ConfigurationHandler _secureStorageConfigurationHandler = null;
    private ApplicationServiceContext _serviceContext = null;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageAdministratorContextImpl == null ? (class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageAdministratorContextImpl = RemoteSecureStorageAdministratorContextImpl.class$("com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextImpl")) : class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageAdministratorContextImpl));
    static /* synthetic */ Class class$com$sap$security$core$server$securestorage$remote$RemoteSecureStorageAdministratorContextImpl;

    public RemoteSecureStorageAdministratorContextImpl(ConfigurationHandler secureStorageConfigurationHandler, ApplicationServiceContext serviceContext) throws RemoteException {
        super(secureStorageConfigurationHandler, serviceContext);
        this._secureStorageConfigurationHandler = secureStorageConfigurationHandler;
        this._serviceContext = serviceContext;
    }

    public void checkRootConfiguration(String rootName, boolean check) throws CreateConfigurationsException {
        super.checkRootConfiguration(rootName, check);
    }

    public void checkConfiguration(String name, boolean check) {
        super.checkConfiguration(name, check);
    }

    public String getLatestKeyID(int clientType, String clientID) throws NoKeyForClientException, KeyStoreAccessException, KeyStoreAccessException {
        return super.getLatestKeyID(clientType, clientID);
    }

    public Vector getClientIDs(int clientType) throws StorageLocationOpenException {
        Vector<String> secondLevelSubConfName = new Vector<String>();
        try {
            Configuration SecondLevelStorageLocation = this.getSecondLevelStorageLocation(clientType, 0);
            String[] subConfNames = SecondLevelStorageLocation.getAllSubConfigurationNames();
            int i = 0;
            while (i < subConfNames.length) {
                secondLevelSubConfName.add(i, subConfNames[i]);
                ++i;
            }
            return secondLevelSubConfName;
        }
        catch (InconsistentReadException e) {
            throw new StorageLocationOpenException((Exception)((Object)e), "Error reading objects in client's storage-location");
        }
        catch (ConfigurationException e) {
            throw new StorageLocationOpenException((Exception)((Object)e), "Error reading objects in client's storage-location");
        }
    }

    public Vector getObjectIDs(int clientType, String clientID) throws StorageLocationOpenException {
        try {
            Vector<String> objectIDs = new Vector<String>();
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            Configuration clientsStorageLocation = this.getSecondLevelStorageLocation(clientType, 0).getSubConfiguration(clientID);
            String[] fileIDString = clientsStorageLocation.getAllFileEntryNames();
            String[] configIDString = clientsStorageLocation.getAllConfigEntryNames();
            int i = 0;
            while (i < configIDString.length) {
                objectIDs.add(i, configIDString[i]);
                ++i;
            }
            int x = 0;
            while (x < fileIDString.length) {
                objectIDs.add(x + i, fileIDString[x]);
                ++x;
            }
            return objectIDs;
        }
        catch (InconsistentReadException e) {
            throw new StorageLocationOpenException((Exception)((Object)e), "Error reading objects in client's storage-location");
        }
        catch (ConfigurationException e) {
            throw new StorageLocationOpenException((Exception)((Object)e), "Error reading objects in client's storage-location");
        }
    }

    public Vector getSecretKeyIDs(String clientID, int clientType) throws KeyStoreAccessException, NoKeyForClientException {
        try {
            this._J2EEEngineKeystore = super.getKeystore();
            Enumeration<String> allKeys = this._J2EEEngineKeystore.aliases();
            Vector<String> clientsKeys = new Vector<String>();
            String secondLevelSubConfName = null;
            if (clientType == 1) {
                secondLevelSubConfName = "services";
            } else if (clientType == 2) {
                secondLevelSubConfName = "webapps";
            }
            String currentKeyAliasClientType = null;
            String currentKeyAliasClientID = null;
            int firstUnderScorePosition = 0;
            int secondUnderScorePosition = 0;
            int numberSecretKeysForClient = 0;
            while (allKeys.hasMoreElements()) {
                String currentKeyAlias = allKeys.nextElement();
                firstUnderScorePosition = currentKeyAlias.indexOf("_");
                secondUnderScorePosition = currentKeyAlias.indexOf(95, firstUnderScorePosition + 1);
                currentKeyAliasClientType = currentKeyAlias.substring(0, firstUnderScorePosition);
                currentKeyAliasClientID = currentKeyAlias.substring(firstUnderScorePosition + 1, secondUnderScorePosition);
                if (!secondLevelSubConfName.equals(currentKeyAliasClientType) || !clientID.equals(currentKeyAliasClientID)) continue;
                clientsKeys.add(currentKeyAlias);
                ++numberSecretKeysForClient;
            }
            if (numberSecretKeysForClient < 1) {
                // empty if block
            }
            return clientsKeys;
        }
        catch (KeyStoreException e) {
            throw new KeyStoreAccessException(e, "Could not get the secret-keys for client " + clientID);
        }
        catch (NullPointerException e) {
            throw new KeyStoreAccessException(e, "Could not get the secret-keys for client " + clientID);
        }
    }

    public void deleteObject(int clientType, String clientID, String objectID) throws ObjectDeletionException {
        try {
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            Configuration clientsStorageLocation = this.getSecondLevelStorageLocation(clientType, 1).getSubConfiguration(clientID);
            if (clientsStorageLocation.existsConfigEntry(objectID)) {
                clientsStorageLocation.deleteConfigEntry(objectID);
            } else {
                clientsStorageLocation.deleteFile(objectID);
            }
            this._secureStorageConfigurationHandler.commit();
            this._secureStorageConfigurationHandler.closeAllConfigurations();
        }
        catch (InconsistentReadException e) {
            throw new ObjectDeletionException((Exception)((Object)e), "Could not delete object " + objectID);
        }
        catch (StorageLocationOpenException e) {
            throw new ObjectDeletionException(e, "Could not delete object " + objectID);
        }
        catch (NoWriteAccessException e) {
            throw new ObjectDeletionException((Exception)((Object)e), "Could not delete object " + objectID);
        }
        catch (ConfigurationException e) {
            throw new ObjectDeletionException((Exception)((Object)e), "Could not delete object " + objectID);
        }
    }

    private String firstCharZero(int number) {
        if (number < 10) {
            return "0" + Integer.toString(number);
        }
        return Integer.toString(number);
    }

    public void generateSecretKeyID(int clientType, String clientID) throws KeyGenerationException {
        String latestKeyID = null;
        try {
            latestKeyID = super.getLatestKeyID(clientType, clientID);
            super.setNumberOfKeys(latestKeyID);
            latestKeyID = super.generateSecretKey(clientType, clientID);
        }
        catch (Exception e) {
            String string = super.generateSecretKey(clientType, clientID);
        }
    }

    public void reEncryptCentralStoredObject(int clientType, String clientID) throws ObjectModificationException {
        RemoteSecureStorageClientContextImpl clientContext = null;
        try {
            clientContext = new RemoteSecureStorageClientContextImpl(clientID, clientType, this._secureStorageConfigurationHandler, this._serviceContext);
            String[] currentClientsObjectIDs = clientContext.getObjectIDs();
            int i = 0;
            while (i < currentClientsObjectIDs.length) {
                clientContext.retrieveBytes(currentClientsObjectIDs[i]);
                ++i;
            }
        }
        catch (StorageLocationOpenException e) {
            throw new ObjectModificationException(e);
        }
        catch (ObjectRetrievalException e) {
            throw new ObjectModificationException(e);
        }
        catch (RemoteException e) {
            throw new ObjectModificationException(e);
        }
    }

    public void reEncryptAllCentralStoredObjects() throws ObjectEncryptionException, RemoteException {
        try {
            String[] currentClientsObjectIDs;
            RemoteSecureStorageClientContextImpl clientContext = null;
            String currentClientID = null;
            int currentClientType = 0;
            Vector allServiceClientIDs = this.getClientIDs(1);
            Vector allWebappClientIDs = this.getClientIDs(2);
            int i = 0;
            while (i < allServiceClientIDs.size()) {
                currentClientID = (String)allServiceClientIDs.get(i);
                currentClientType = 1;
                this.generateSecretKeyID(currentClientType, currentClientID);
                clientContext = new RemoteSecureStorageClientContextImpl(currentClientID, currentClientType, this._secureStorageConfigurationHandler, this._serviceContext);
                currentClientsObjectIDs = clientContext.getObjectIDs();
                int j = 0;
                while (j < currentClientsObjectIDs.length) {
                    clientContext.retrieveBytes(currentClientsObjectIDs[j]);
                    ++j;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < allWebappClientIDs.size()) {
                currentClientID = (String)allWebappClientIDs.get(i2);
                currentClientType = 2;
                this.generateSecretKeyID(currentClientType, currentClientID);
                clientContext = new RemoteSecureStorageClientContextImpl(currentClientID, currentClientType, this._secureStorageConfigurationHandler, this._serviceContext);
                currentClientsObjectIDs = clientContext.getObjectIDs();
                int j = 0;
                while (j < currentClientsObjectIDs.length) {
                    clientContext.retrieveBytes(currentClientsObjectIDs[j]);
                    ++j;
                }
                ++i2;
            }
        }
        catch (StorageLocationOpenException e) {
            throw new ObjectEncryptionException(e);
        }
        catch (ObjectRetrievalException e) {
            throw new ObjectEncryptionException(e);
        }
        catch (KeyGenerationException e) {
            throw new ObjectEncryptionException(e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSecure(int clientType, String clientID, String objectID) throws SecureStorageException {
        block18: {
            block17: {
                myConfiguration = null;
                mySecureStorageObject = null;
                myInputStream = null;
                myObjectInputStream = null;
                try {
                    try {
                        myConfiguration = this.getSecondLevelStorageLocation(clientType, 0).getSubConfiguration(clientID);
                        if (myConfiguration.existsConfigEntry(objectID)) {
                            mySecureStorageObject = (SecureStorageObject)myConfiguration.getConfigEntry(objectID);
                        } else {
                            try {
                                myInputStream = myConfiguration.getFile(objectID);
                                myObjectInputStream = new CustomObjectInputStream(myInputStream, Thread.currentThread().getContextClassLoader());
                                mySecureStorageObject = (SecureStorageObject)myObjectInputStream.readObject();
                                myInputStream.close();
                                myObjectInputStream.close();
                            }
                            catch (IOException e1) {
                                throw new SecureStorageException(e1, "Error. Could not analyse object");
                            }
                            catch (ClassNotFoundException e) {
                                throw new SecureStorageException(e, "Error. Could not analyse object");
                            }
                        }
                        if (mySecureStorageObject.getSecretKeyID().equals("Base64")) {
                            e1 = false;
                            var13_14 = null;
                            break block17;
                        }
                        e1 = true;
                        break block18;
                    }
                    catch (StorageLocationOpenException e) {
                        throw new SecureStorageException(e, "Error. Could not analyse object");
                    }
                    catch (NameNotFoundException e) {
                        throw new SecureStorageException((Exception)e, "Error. Could not analyse object");
                    }
                    catch (InconsistentReadException e) {
                        throw new SecureStorageException((Exception)e, "Error. Could not analyse object");
                    }
                    catch (ConfigurationException e) {
                        throw new SecureStorageException((Exception)e, "Error. Could not analyse object");
                    }
                }
                catch (Throwable var12_22) {
                    var13_16 = null;
                    try {
                        myConfiguration.close();
                        throw var12_22;
                    }
                    catch (ConfigurationException e1) {
                        throw var12_22;
                    }
                }
            }
            ** try [egrp 3[TRYBLOCK] [7 : 228->238)] { 
lbl48:
            // 1 sources

            myConfiguration.close();
            return e1;
lbl50:
            // 1 sources

            catch (ConfigurationException e1) {
                // empty catch block
            }
            return e1;
        }
        var13_15 = null;
        ** try [egrp 3[TRYBLOCK] [7 : 228->238)] { 
lbl56:
        // 1 sources

        myConfiguration.close();
        return e1;
lbl58:
        // 1 sources

        catch (ConfigurationException e1) {
            // empty catch block
        }
        return e1;
    }

    public boolean isClientSecure(int clientType, String clientID) throws SecureStorageException {
        boolean secureMode = false;
        Vector myObjectIDs = this.getObjectIDs(clientType, clientID);
        int i = 0;
        while (i < myObjectIDs.size()) {
            if (!this.isSecure(clientType, clientID, myObjectIDs.get(i).toString())) {
                secureMode = true;
                break;
            }
            ++i;
        }
        return !secureMode;
    }

    public int getNumberOfServiceClients() throws StorageLocationOpenException {
        Vector allServiceClients = this.getClientIDs(1);
        return allServiceClients.size();
    }

    public int getNumberOfWebAppClients() throws StorageLocationOpenException {
        Vector allServiceClients = this.getClientIDs(2);
        return allServiceClients.size();
    }

    public int getNumberOfAllClients() throws StorageLocationOpenException {
        return this.getNumberOfServiceClients() + this.getNumberOfWebAppClients();
    }

    public int getNumberOfServiceClientObjects() throws StorageLocationOpenException {
        int numberOfObjects = 0;
        Vector allServiceClients = this.getClientIDs(1);
        int i = 0;
        while (i < allServiceClients.size()) {
            numberOfObjects += this.getObjectIDs(1, (String)allServiceClients.get(i)).size();
            ++i;
        }
        return numberOfObjects;
    }

    public int getNumberOfWebAppClientObjects() throws StorageLocationOpenException {
        int numberOfObjects = 0;
        Vector allWebAppClients = this.getClientIDs(2);
        int i = 0;
        while (i < allWebAppClients.size()) {
            numberOfObjects += this.getObjectIDs(2, (String)allWebAppClients.get(i)).size();
            ++i;
        }
        return numberOfObjects;
    }

    public int getNumberOfAllClientObjects() throws StorageLocationOpenException {
        return this.getNumberOfServiceClientObjects() + this.getNumberOfWebAppClientObjects();
    }

    public int getNumberOfEncryptedObjects() throws SecureStorageException {
        int numberEncryptedObjects = 0;
        int z = 1;
        while (z < 3) {
            Vector myClientIDs = this.getClientIDs(z);
            int i = 0;
            while (i < myClientIDs.size()) {
                Vector myObjectIDs = this.getObjectIDs(z, (String)myClientIDs.get(i));
                int x = 0;
                while (x < myObjectIDs.size()) {
                    boolean isSecure = this.isSecure(z, (String)myClientIDs.get(i), (String)myObjectIDs.get(x));
                    if (isSecure) {
                        ++numberEncryptedObjects;
                    }
                    ++x;
                }
                ++i;
            }
            ++z;
        }
        return numberEncryptedObjects;
    }

    public int getNumberOfEncodedObjects() throws SecureStorageException {
        return this.getNumberOfAllClientObjects() - this.getNumberOfEncryptedObjects();
    }

    public int getEncryptionRate() throws SecureStorageException {
        if (this.getNumberOfAllClients() == 0) {
            return 0;
        }
        return 100 * this.getNumberOfEncryptedObjects() / this.getNumberOfAllClientObjects();
    }

    public int getNumberOfServiceKeys() throws StorageLocationOpenException, KeyStoreAccessException, NoKeyForClientException {
        int numberOfKeys = 0;
        Vector allServiceClients = this.getClientIDs(1);
        int i = 0;
        while (i < allServiceClients.size()) {
            numberOfKeys += this.getSecretKeyIDs((String)allServiceClients.get(i), 1).size();
            ++i;
        }
        return numberOfKeys;
    }

    public int getNumberOfWebAppKeys() throws StorageLocationOpenException, KeyStoreAccessException, NoKeyForClientException {
        int numberOfKeys = 0;
        Vector allWebAppClients = this.getClientIDs(2);
        int i = 0;
        while (i < allWebAppClients.size()) {
            numberOfKeys += this.getSecretKeyIDs((String)allWebAppClients.get(i), 1).size();
            ++i;
        }
        return numberOfKeys;
    }

    public int getNumberOfKeys() throws StorageLocationOpenException, KeyStoreAccessException, NoKeyForClientException {
        return this.getNumberOfServiceKeys() + this.getNumberOfWebAppKeys();
    }

    public boolean isCryptoLibDepolyed() {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance("DESede", "IAIK");
            kg = null;
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            kg = null;
            return false;
        }
        catch (NoSuchProviderException e) {
            kg = null;
            return false;
        }
    }

    private Configuration getSecondLevelStorageLocation(int clientType, int accessMode) throws StorageLocationOpenException {
        try {
            this._secureStorageConfigurationHandler.closeAllConfigurations();
            Configuration clientsStorageLocation = null;
            String secondLevelSubConfName = null;
            if (clientType == 1) {
                secondLevelSubConfName = "services";
            } else if (clientType == 2) {
                secondLevelSubConfName = "webapps";
            }
            clientsStorageLocation = this._secureStorageConfigurationHandler.openConfiguration("securestorage", accessMode).getSubConfiguration(secondLevelSubConfName);
            return clientsStorageLocation;
        }
        catch (InconsistentReadException e) {
            throw new StorageLocationOpenException((Exception)((Object)e));
        }
        catch (ConfigurationLockedException e) {
            throw new StorageLocationOpenException((Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new StorageLocationOpenException((Exception)((Object)e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

