/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.gui.renderer;

import com.sap.security.core.server.securestorage.exception.SecureStorageException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class ObjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private RemoteSecureStorageAdministratorContextInterface adminContext;
    private int clientType = 0;
    private ImageIcon greenIcon = null;
    private ImageIcon yellowIcon = null;
    private ImageIcon inactiveIcon = null;
    static /* synthetic */ Class class$com$sap$security$core$server$securestorage$gui$renderer$ObjectTreeCellRenderer;

    public ObjectTreeCellRenderer(int clientType, RemoteSecureStorageAdministratorContextInterface adminContext) {
        this.clientType = clientType;
        this.adminContext = adminContext;
        this.greenIcon = ObjectTreeCellRenderer.createImageIcon("images/ICON_LED_GREEN.gif");
        this.yellowIcon = ObjectTreeCellRenderer.createImageIcon("images/ICON_LED_YELLOW.gif");
        this.inactiveIcon = ObjectTreeCellRenderer.createImageIcon("images/ICON_LED_INACTIVE.gif");
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = (class$com$sap$security$core$server$securestorage$gui$renderer$ObjectTreeCellRenderer == null ? (class$com$sap$security$core$server$securestorage$gui$renderer$ObjectTreeCellRenderer = ObjectTreeCellRenderer.class$("com.sap.security.core.server.securestorage.gui.renderer.ObjectTreeCellRenderer")) : class$com$sap$security$core$server$securestorage$gui$renderer$ObjectTreeCellRenderer).getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        TreePath myTreePath = tree.getPathForRow(row);
        if (myTreePath != null) {
            if (myTreePath.getPathCount() == 1) {
                this.setIcon(this.inactiveIcon);
            }
            if (myTreePath.getPathCount() == 2) {
                if (leaf) {
                    this.setIcon(this.greenIcon);
                } else {
                    try {
                        if (this.adminContext.isClientSecure(this.clientType, myTreePath.getPathComponent(1).toString())) {
                            this.setIcon(this.greenIcon);
                        } else {
                            this.setIcon(this.yellowIcon);
                        }
                    }
                    catch (SecureStorageException e) {
                        // empty catch block
                    }
                }
            }
            if (myTreePath.getPathCount() == 3) {
                try {
                    if (this.adminContext.isSecure(this.clientType, myTreePath.getPathComponent(1).toString(), myTreePath.getLastPathComponent().toString())) {
                        this.setIcon(this.greenIcon);
                    } else {
                        this.setIcon(this.yellowIcon);
                    }
                }
                catch (SecureStorageException e) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

