/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.gui;

import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.services.locking.gui.ComponentFactory;
import com.sap.security.core.server.securestorage.exception.KeyGenerationException;
import com.sap.security.core.server.securestorage.exception.KeyStoreAccessException;
import com.sap.security.core.server.securestorage.exception.NoKeyForClientException;
import com.sap.security.core.server.securestorage.exception.ObjectDeletionException;
import com.sap.security.core.server.securestorage.exception.ObjectModificationException;
import com.sap.security.core.server.securestorage.exception.StorageLocationOpenException;
import com.sap.security.core.server.securestorage.gui.renderer.KeyTreeCellRenderer;
import com.sap.security.core.server.securestorage.gui.renderer.ObjectTreeCellRenderer;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class WebappPanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private RemoteSecureStorageAdministratorContextInterface _secureStorageAdministratorContext;
    public static JTree keyTree;
    public static JTree objectTree;
    private JPanel _webappPanel;
    private DefaultMutableTreeNode _treeTop;
    private DefaultTreeModel _model;
    private JTree _tree;
    private JTree _webappKeyTree;
    private JTree _webappObjectTree;
    private final String _SERVICE_CLIENT_TYPE = "services";
    private final String _WEBAPP_CLIENT_TYPE = "webapplication";
    private final String _KEY_TITLE = "Secret Key";
    private final String _OBJECT_TITLE = "Object";
    private JButton _newKeyButton;
    private JButton _deleteObjectButton;
    private JButton _reEncryptButton;
    private JButton _refreshGUIButton;
    private final String _NEW_KEY_BUTTON_TITLE = "New Key";
    private final String _REENCRYPT_BUTTON_TITLE = "Reencrypt Objects";
    private final String _DELETE_OBJECT_BUTTON_TITLE = "Delete Object";
    private final String _REFRESH_GUI_BUTTON_TITLE = "refresh";
    private JPanel clientWebappPanel;
    private JPanel clientButtonPanel;
    private Category myGUICategory = EditorViewManager.category;
    private static final Location LOCATION;
    static /* synthetic */ Class class$com$sap$security$core$server$securestorage$gui$WebappPanel;

    public WebappPanel(RemoteSecureStorageAdministratorContextInterface secureStorageAdministratorContext) {
        this._secureStorageAdministratorContext = secureStorageAdministratorContext;
        this.init();
        this._webappObjectTree.setCellRenderer(new ObjectTreeCellRenderer(2, this._secureStorageAdministratorContext));
        this._webappKeyTree.setCellRenderer(new KeyTreeCellRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)this._webappPanel, "Center");
    }

    private void init() {
        this._newKeyButton = ComponentFactory.createButton((String)"New Key", (ActionListener)this, (String)"Generate new secret key for selected client");
        this._deleteObjectButton = ComponentFactory.createButton((String)"Delete Object", (ActionListener)this, (String)"Delete selected object");
        this._reEncryptButton = ComponentFactory.createButton((String)"Reencrypt Objects", (ActionListener)this, (String)"Encrypt objects below selected client with newest key");
        JComponent[] buttonPanel = new JButton[]{this._newKeyButton, this._reEncryptButton};
        this._webappKeyTree = this.createTree("Secret Key");
        this._webappKeyTree.getSelectionModel().setSelectionMode(1);
        this._webappKeyTree.addTreeSelectionListener(this);
        JScrollPane scrollableWebappKeyTree = new JScrollPane(this._webappKeyTree, 20, 30);
        this._webappObjectTree = this.createTree("Object");
        this._webappObjectTree.addTreeSelectionListener(this);
        JScrollPane scrollableWebappObjectTree = new JScrollPane(this._webappObjectTree, 20, 30);
        JComponent[] webappPanel = new JScrollPane[]{scrollableWebappKeyTree, scrollableWebappObjectTree};
        this.clientWebappPanel = ComponentFactory.createHorizontalGridPanel((JComponent[])webappPanel);
        this.clientWebappPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " " + "webapplication" + " "));
        this.clientWebappPanel.setAutoscrolls(true);
        JPanel clientButtonPanel = ComponentFactory.createHorizontalGridPanel((JComponent[])buttonPanel);
        this.enableControls(0, 0);
        this._webappPanel = ComponentFactory.createVerticalPanel(null, (JComponent)this.clientWebappPanel, (JComponent)clientButtonPanel);
    }

    private JTree createTree(String title) {
        this._treeTop = new DefaultMutableTreeNode(title);
        this._model = new DefaultTreeModel(this._treeTop);
        if (title.equals("Secret Key")) {
            this.createWebappKeyNodes(this._treeTop);
        } else if (title.equals("Object")) {
            this.createWebappObjectNodes(this._treeTop);
        }
        this._tree = new JTree(this._model);
        return this._tree;
    }

    private void createWebappKeyNodes(DefaultMutableTreeNode top) {
        String method = "createWebappKeyNodes(DefaultMutableTreeNode top)";
        try {
            DefaultMutableTreeNode service = null;
            DefaultMutableTreeNode key = null;
            Vector webappClient = this._secureStorageAdministratorContext.getClientIDs(2);
            int i = 0;
            while (i < webappClient.size()) {
                service = new DefaultMutableTreeNode(webappClient.get(i));
                String serviceClientString = (String)webappClient.get(i);
                Vector keysOfClient = this._secureStorageAdministratorContext.getSecretKeyIDs(serviceClientString, 2);
                int n = 0;
                while (n < keysOfClient.size()) {
                    String elementKey = (String)keysOfClient.get(n);
                    key = new DefaultMutableTreeNode(elementKey);
                    service.add(key);
                    ++n;
                }
                top.add(service);
                ++i;
            }
        }
        catch (StorageLocationOpenException e) {
            this.myGUICategory.logThrowable(500, LOCATION, (Object)"createWebappKeyNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete keytree for webapplications. Exception was: ", (Throwable)e);
        }
        catch (RemoteException e) {
            this.myGUICategory.logThrowable(500, LOCATION, (Object)"createWebappKeyNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete keytree for webapplications. Exception was: ", (Throwable)e);
        }
        catch (NoKeyForClientException e) {
        }
        catch (KeyStoreAccessException e) {
            this.myGUICategory.logThrowable(500, LOCATION, (Object)"createWebappKeyNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete keytree for webapplications. Exception was: ", (Throwable)e);
        }
    }

    private void createWebappObjectNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode service = null;
        DefaultMutableTreeNode object = null;
        String method = "createWebappObjectNodes(DefaultMutableTreeNode top)";
        try {
            Vector webappClient = this._secureStorageAdministratorContext.getClientIDs(2);
            int i = 0;
            while (i < webappClient.size()) {
                service = new DefaultMutableTreeNode(webappClient.get(i));
                String serviceClientString = (String)webappClient.get(i);
                Vector clientObjects = this._secureStorageAdministratorContext.getObjectIDs(2, serviceClientString);
                int n = 0;
                while (n < clientObjects.size()) {
                    String elementObject = (String)clientObjects.get(n);
                    object = new DefaultMutableTreeNode(elementObject);
                    service.add(object);
                    ++n;
                }
                top.add(service);
                ++i;
            }
        }
        catch (StorageLocationOpenException e) {
            this.myGUICategory.logThrowable(500, LOCATION, (Object)"createWebappObjectNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete objecttree for webapplications. Exception was: ", (Throwable)e);
        }
        catch (RemoteException e) {
            this.myGUICategory.logThrowable(500, LOCATION, (Object)"createWebappObjectNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete objecttree for webapplications. Exception was: ", (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String method = "actionPerformed(ActionEvent e)";
        if (e.getActionCommand().equals(this._newKeyButton.getText())) {
            try {
                TreePath[] webappKeyPaths = this._webappKeyTree.getSelectionPaths();
                this._model = (DefaultTreeModel)this._webappKeyTree.getModel();
                this._treeTop = (DefaultMutableTreeNode)this._model.getRoot();
                int i = 0;
                while (i < webappKeyPaths.length) {
                    this._secureStorageAdministratorContext.generateSecretKeyID(2, webappKeyPaths[i].getPathComponent(1).toString());
                    try {
                        String latestKey = this._secureStorageAdministratorContext.getLatestKeyID(2, webappKeyPaths[i].getPathComponent(1).toString());
                        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(latestKey);
                        TreePath tp = this.getTreePath(this._treeTop, webappKeyPaths[i].getPathComponent(1));
                        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
                        this._model.insertNodeInto(childNode, parentNode, 0);
                    }
                    catch (NoKeyForClientException exc) {
                    }
                    catch (KeyStoreAccessException exc) {
                        this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Could not generate a new key for client. Exception was: ", (Throwable)exc);
                    }
                    catch (Exception exc) {
                        this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Could not generate a new key for client. Exception was: ", (Throwable)exc);
                    }
                    ++i;
                }
            }
            catch (KeyGenerationException exc) {
                JOptionPane.showMessageDialog(this, "Keygeneration failed because SAPJavaCryptoToolkit is not deployed on this server.\n Deploy SAPJavaCryptoToolkit and try again.", "Keygeneration failed", 2);
                this.myGUICategory.logThrowableT(300, LOCATION, "actionPerformed(ActionEvent e)", "Could not generate a new key because SAP Java Crypto Lib is missing. Delpoy SAPJavaCryptoLib with SDM on this server and try again. Exception was: ", (Throwable)exc);
            }
            catch (IllegalArgumentException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Could not generate a new key for client. Exception was: ", (Throwable)exc);
            }
            catch (NullPointerException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Could not generate a new key for client. Exception was: ", (Throwable)exc);
            }
        } else if (e.getActionCommand().equals(this._reEncryptButton.getText())) {
            try {
                TreePath[] webappObjectPaths = this._webappObjectTree.getSelectionPaths();
                int i = 0;
                while (i < webappObjectPaths.length) {
                    this._secureStorageAdministratorContext.reEncryptCentralStoredObject(2, webappObjectPaths[i].getPathComponent(1).toString());
                    ++i;
                }
            }
            catch (ObjectModificationException exc) {
                JOptionPane.showMessageDialog(this, "Reencryption failed.\n Some objects are only rencryptable by its application. Generate a new key for this application.", "Reencryption failed ", 2);
                this.myGUICategory.logThrowableT(300, LOCATION, "actionPerformed(ActionEvent e)", "Reencryption failed.Some objects are only rencryptable by its application. Generate a new key for this application. Exception was: ", (Throwable)exc);
            }
            catch (RemoteException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Reencryption failed. Exception was: ", (Throwable)exc);
            }
            catch (IllegalArgumentException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Reencryption failed. Exception was: ", (Throwable)exc);
            }
            catch (NullPointerException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Reencryption failed. Exception was: ", (Throwable)exc);
            }
        } else if (e.getActionCommand().equals(this._deleteObjectButton.getText())) {
            try {
                TreePath[] webappObjectPaths = this._webappObjectTree.getSelectionPaths();
                this._model = (DefaultTreeModel)this._webappObjectTree.getModel();
                int i = 0;
                while (i < webappObjectPaths.length) {
                    this._secureStorageAdministratorContext.deleteObject(2, webappObjectPaths[i].getPathComponent(1).toString(), webappObjectPaths[i].getPathComponent(2).toString());
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)webappObjectPaths[i].getLastPathComponent();
                    this._model.removeNodeFromParent(childNode);
                    ++i;
                }
                this._model.reload();
            }
            catch (ObjectDeletionException exc) {
                JOptionPane.showMessageDialog(this, "Delete object failed.", "delete object failed", 2);
            }
            catch (RemoteException exc) {
            }
            catch (IllegalArgumentException exc) {
            }
            catch (NullPointerException exc) {}
        } else if (e.getActionCommand().equals(this._refreshGUIButton.getText())) {
            // empty if block
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        int keyTreeCount = 0;
        int objectTreeCount = 0;
        if (!this._webappKeyTree.isSelectionEmpty()) {
            keyTreeCount = this._webappKeyTree.getSelectionPath().getPathCount();
        }
        if (!this._webappObjectTree.isSelectionEmpty()) {
            objectTreeCount = this._webappObjectTree.getSelectionPath().getPathCount();
        }
        this.enableControls(keyTreeCount, objectTreeCount);
    }

    public TreePath getTreePath(DefaultMutableTreeNode root, Object obj) {
        if (root.getUserObject().toString().equals(obj.toString())) {
            Object[] object = root.getUserObjectPath();
            return new TreePath(root.getPath());
        }
        int i = 0;
        while (i < root.getChildCount()) {
            TreePath tp = this.getTreePath((DefaultMutableTreeNode)root.getChildAt(i), obj);
            if (tp != null) {
                return tp;
            }
            ++i;
        }
        return null;
    }

    public void enableControls(int keyTreeCount, int objectTreeCount) {
        this._reEncryptButton.setEnabled(false);
        this._newKeyButton.setEnabled(false);
        this._deleteObjectButton.setEnabled(false);
        if (keyTreeCount == 2 || keyTreeCount == 3) {
            this._newKeyButton.setEnabled(true);
        }
        if (objectTreeCount == 2) {
            this._reEncryptButton.setEnabled(true);
        }
        if (objectTreeCount == 3) {
            this._deleteObjectButton.setEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$securestorage$gui$WebappPanel == null ? (class$com$sap$security$core$server$securestorage$gui$WebappPanel = WebappPanel.class$("com.sap.security.core.server.securestorage.gui.WebappPanel")) : class$com$sap$security$core$server$securestorage$gui$WebappPanel));
    }
}

