/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.gui;

import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.services.locking.gui.ComponentFactory;
import com.sap.security.core.server.securestorage.exception.KeyGenerationException;
import com.sap.security.core.server.securestorage.exception.KeyStoreAccessException;
import com.sap.security.core.server.securestorage.exception.NoKeyForClientException;
import com.sap.security.core.server.securestorage.exception.ObjectDeletionException;
import com.sap.security.core.server.securestorage.exception.ObjectModificationException;
import com.sap.security.core.server.securestorage.exception.StorageLocationOpenException;
import com.sap.security.core.server.securestorage.gui.renderer.KeyTreeCellRenderer;
import com.sap.security.core.server.securestorage.gui.renderer.ObjectTreeCellRenderer;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ServicePanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private RemoteSecureStorageAdministratorContextInterface _secureStorageAdministratorContext;
    public static JTree keyTree;
    public static JTree objectTree;
    private JPanel _servicePanel;
    private DefaultMutableTreeNode _treeTop;
    private DefaultTreeModel _model;
    private JTree _tree;
    private JTree _serviceKeyTree;
    private JTree _serviceObjectTree;
    private final String _SERVICE_CLIENT_TYPE = "services";
    private final String _WEBAPP_CLIENT_TYPE = "webapplication";
    private final String _KEY_TITLE = "Secret Key";
    private final String _OBJECT_TITLE = "Object";
    private JButton _newKeyButton;
    private JButton _deleteObjectButton;
    private JButton _reEncryptButton;
    private JButton _refreshGUIButton;
    private final String _NEW_KEY_BUTTON_TITLE = "New Key";
    private final String _REENCRYPT_BUTTON_TITLE = "Reencrypt Objects";
    private final String _DELETE_OBJECT_BUTTON_TITLE = "Delete Object";
    private final String _REFRESH_GUI_BUTTON_TITLE = "refresh";
    private Category myGUICategory = EditorViewManager.category;
    private static final Location LOCATION;
    static /* synthetic */ Class class$com$sap$security$core$server$securestorage$gui$ServicePanel;

    public ServicePanel(RemoteSecureStorageAdministratorContextInterface secureStorageAdministratorContext) {
        this._secureStorageAdministratorContext = secureStorageAdministratorContext;
        this.init();
        this._serviceObjectTree.setCellRenderer(new ObjectTreeCellRenderer(1, this._secureStorageAdministratorContext));
        this._serviceKeyTree.setCellRenderer(new KeyTreeCellRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)this._servicePanel, "Center");
    }

    private void init() {
        this._newKeyButton = ComponentFactory.createButton((String)"New Key", (ActionListener)this, (String)"Generate new secret key for selected client");
        this._deleteObjectButton = ComponentFactory.createButton((String)"Delete Object", (ActionListener)this, (String)"Delete selected object");
        this._reEncryptButton = ComponentFactory.createButton((String)"Reencrypt Objects", (ActionListener)this, (String)"Encrypt objects below selected client with newest key");
        JComponent[] buttonPanel = new JButton[]{this._newKeyButton, this._reEncryptButton};
        this._serviceKeyTree = this.createTree("Secret Key");
        this._serviceKeyTree.getSelectionModel().setSelectionMode(1);
        this._serviceKeyTree.addTreeSelectionListener(this);
        JScrollPane scrollableServiceKeyTree = new JScrollPane(this._serviceKeyTree, 20, 30);
        this._serviceObjectTree = this.createTree("Object");
        this._serviceObjectTree.addTreeSelectionListener(this);
        JScrollPane scrollableServiceObjectTree = new JScrollPane(this._serviceObjectTree, 20, 30);
        JComponent[] servicePanel = new JScrollPane[]{scrollableServiceKeyTree, scrollableServiceObjectTree};
        JPanel clientServicePanel = ComponentFactory.createHorizontalGridPanel((JComponent[])servicePanel);
        clientServicePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " " + "services" + " "));
        JPanel clientButtonPanel = ComponentFactory.createHorizontalGridPanel((JComponent[])buttonPanel);
        JPanel[] jPanel = new JPanel[]{clientServicePanel, clientButtonPanel};
        this.enableControls(0, 0);
        this._servicePanel = ComponentFactory.createVerticalPanel(null, (JComponent)clientServicePanel, (JComponent)clientButtonPanel);
    }

    private JTree createTree(String title) {
        this._treeTop = new DefaultMutableTreeNode(title);
        this._model = new DefaultTreeModel(this._treeTop);
        if (title.equals("Secret Key")) {
            this.createServiceKeyNodes(this._treeTop);
        } else if (title.equals("Object")) {
            this.createServiceObjectNodes(this._treeTop);
        }
        this._tree = new JTree(this._model);
        return this._tree;
    }

    private void createServiceKeyNodes(DefaultMutableTreeNode top) {
        String method = "createServiceKeyNodes(DefaultMutableTreeNode top)";
        try {
            DefaultMutableTreeNode service = null;
            DefaultMutableTreeNode key = null;
            Vector serviceClient = this._secureStorageAdministratorContext.getClientIDs(1);
            int i = 0;
            while (i < serviceClient.size()) {
                service = new DefaultMutableTreeNode(serviceClient.get(i));
                String serviceClientString = (String)serviceClient.get(i);
                Vector keysOfClient = this._secureStorageAdministratorContext.getSecretKeyIDs(serviceClientString, 1);
                int n = 0;
                while (n < keysOfClient.size()) {
                    String elementKey = (String)keysOfClient.get(n);
                    key = new DefaultMutableTreeNode(elementKey);
                    service.add(key);
                    ++n;
                }
                top.add(service);
                ++i;
            }
        }
        catch (StorageLocationOpenException e) {
            this.myGUICategory.logThrowableT(500, LOCATION, "createServiceKeyNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete keytree for services. Exception was: ", (Throwable)e);
        }
        catch (RemoteException e) {
            this.myGUICategory.logThrowableT(500, LOCATION, "createServiceKeyNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete keytree for services. Exception was: ", (Throwable)e);
        }
        catch (NoKeyForClientException e) {
            this.myGUICategory.logThrowableT(500, LOCATION, "createServiceKeyNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete keytree for services. Exception was: ", (Throwable)e);
        }
        catch (KeyStoreAccessException e) {
            this.myGUICategory.logThrowableT(500, LOCATION, "createServiceKeyNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete keytree for services. Exception was: ", (Throwable)e);
        }
    }

    private void createServiceObjectNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode service = null;
        DefaultMutableTreeNode object = null;
        String method = "createServiceObjectNodes(DefaultMutableTreeNode top)";
        try {
            Vector serviceClient = this._secureStorageAdministratorContext.getClientIDs(1);
            int i = 0;
            while (i < serviceClient.size()) {
                service = new DefaultMutableTreeNode(serviceClient.get(i));
                String serviceClientString = (String)serviceClient.get(i);
                Vector clientObjects = this._secureStorageAdministratorContext.getObjectIDs(1, serviceClientString);
                int n = 0;
                while (n < clientObjects.size()) {
                    String elementObject = (String)clientObjects.get(n);
                    object = new DefaultMutableTreeNode(elementObject);
                    service.add(object);
                    ++n;
                }
                top.add(service);
                ++i;
            }
        }
        catch (StorageLocationOpenException e) {
            this.myGUICategory.logThrowableT(500, LOCATION, "createServiceObjectNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete objecttree for services. Exception was: ", (Throwable)e);
        }
        catch (RemoteException e) {
            this.myGUICategory.logThrowableT(500, LOCATION, "createServiceObjectNodes(DefaultMutableTreeNode top)", "An internal exception occurred. Could not display complete objecttree for services. Exception was: ", (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String method = "actionPerformed(ActionEvent e)";
        if (e.getActionCommand().equals(this._newKeyButton.getText())) {
            try {
                TreePath[] serviceKeyPaths = this._serviceKeyTree.getSelectionPaths();
                this._model = (DefaultTreeModel)this._serviceKeyTree.getModel();
                this._treeTop = (DefaultMutableTreeNode)this._model.getRoot();
                int i = 0;
                while (i < serviceKeyPaths.length) {
                    this._secureStorageAdministratorContext.generateSecretKeyID(1, serviceKeyPaths[i].getPathComponent(1).toString());
                    try {
                        String latestKey = this._secureStorageAdministratorContext.getLatestKeyID(1, serviceKeyPaths[i].getPathComponent(1).toString());
                        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(latestKey);
                        TreePath tp = this.getTreePath(this._treeTop, serviceKeyPaths[i].getPathComponent(1));
                        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
                        this._model.insertNodeInto(childNode, parentNode, 0);
                    }
                    catch (NoKeyForClientException exc) {
                    }
                    catch (KeyStoreAccessException exc) {
                        this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Could not generate a new key for client. Exception was: ", (Throwable)exc);
                    }
                    catch (Exception exc) {
                        this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Could not generate a new key for client. Exception was: ", (Throwable)exc);
                    }
                    ++i;
                }
            }
            catch (KeyGenerationException exc) {
                JOptionPane.showMessageDialog(this, "Keygeneration failed because SAPJavaCryptoToolkit is not deployed on this server.\n Deploy SAPJavaCryptoToolkit and try again.", "Keygeneration failed", 2);
                this.myGUICategory.logThrowableT(300, LOCATION, "actionPerformed(ActionEvent e)", "Could not generate a new key because SAPJavaCryptoLib is missing. Delpoy SAP Java Crypto Lib with SDM on this server and try again. Exception was: ", (Throwable)exc);
            }
            catch (IllegalArgumentException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Could not generate a new key for client. Exception was: ", (Throwable)exc);
            }
            catch (NullPointerException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Could not generate a new key for client. Exception was: ", (Throwable)exc);
            }
        } else if (e.getActionCommand().equals(this._reEncryptButton.getText())) {
            try {
                TreePath[] serviceObjectPaths = this._serviceObjectTree.getSelectionPaths();
                int i = 0;
                while (i < serviceObjectPaths.length) {
                    this._secureStorageAdministratorContext.reEncryptCentralStoredObject(1, serviceObjectPaths[i].getPathComponent(1).toString());
                    ++i;
                }
            }
            catch (ObjectModificationException exc) {
                JOptionPane.showMessageDialog(this, "Reencryption failed.\n Some objects are only rencryptable by its application. Generate a new key for this application.", "Reencryption failed ", 2);
                this.myGUICategory.logThrowableT(300, LOCATION, "actionPerformed(ActionEvent e)", "Reencryption failed.Some objects are only rencryptable by its application. Generate a new key for this application. Exception was: ", (Throwable)exc);
            }
            catch (RemoteException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Reencryption failed. Exception was: ", (Throwable)exc);
            }
            catch (IllegalArgumentException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Reencryption failed. Exception was: ", (Throwable)exc);
            }
            catch (NullPointerException exc) {
                this.myGUICategory.logThrowableT(500, LOCATION, "actionPerformed(ActionEvent e)", "An internal exception occurred. Reencryption failed. Exception was: ", (Throwable)exc);
            }
        } else if (e.getActionCommand().equals(this._deleteObjectButton.getText())) {
            try {
                TreePath[] serviceObjectPaths = this._serviceObjectTree.getSelectionPaths();
                this._model = (DefaultTreeModel)this._serviceObjectTree.getModel();
                int i = 0;
                while (i < serviceObjectPaths.length) {
                    this._secureStorageAdministratorContext.deleteObject(1, serviceObjectPaths[i].getPathComponent(1).toString(), serviceObjectPaths[i].getPathComponent(2).toString());
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)serviceObjectPaths[i].getLastPathComponent();
                    this._model.removeNodeFromParent(childNode);
                    ++i;
                }
                this._model.reload();
            }
            catch (ObjectDeletionException exc) {
                JOptionPane.showMessageDialog(this, "Delete object failed.", "delete object failed", 2);
            }
            catch (RemoteException exc) {
            }
            catch (IllegalArgumentException exc) {
            }
            catch (NullPointerException exc) {}
        } else if (e.getActionCommand().equals(this._refreshGUIButton.getText())) {
            // empty if block
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        int keyTreeCount = 0;
        int objectTreeCount = 0;
        if (!this._serviceKeyTree.isSelectionEmpty()) {
            keyTreeCount = this._serviceKeyTree.getSelectionPath().getPathCount();
        }
        if (!this._serviceObjectTree.isSelectionEmpty()) {
            objectTreeCount = this._serviceObjectTree.getSelectionPath().getPathCount();
        }
        this.enableControls(keyTreeCount, objectTreeCount);
    }

    public TreePath getTreePath(DefaultMutableTreeNode root, Object obj) {
        if (root.getUserObject().toString().equals(obj.toString())) {
            Object[] object = root.getUserObjectPath();
            return new TreePath(root.getPath());
        }
        int i = 0;
        while (i < root.getChildCount()) {
            TreePath tp = this.getTreePath((DefaultMutableTreeNode)root.getChildAt(i), obj);
            if (tp != null) {
                return tp;
            }
            ++i;
        }
        return null;
    }

    public void enableControls(int keyTreeCount, int objectTreeCount) {
        this._reEncryptButton.setEnabled(false);
        this._newKeyButton.setEnabled(false);
        this._deleteObjectButton.setEnabled(false);
        if (keyTreeCount == 2 || keyTreeCount == 3) {
            this._newKeyButton.setEnabled(true);
        }
        if (objectTreeCount == 2) {
            this._reEncryptButton.setEnabled(true);
        }
        if (objectTreeCount == 3) {
            this._deleteObjectButton.setEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$securestorage$gui$ServicePanel == null ? (class$com$sap$security$core$server$securestorage$gui$ServicePanel = ServicePanel.class$("com.sap.security.core.server.securestorage.gui.ServicePanel")) : class$com$sap$security$core$server$securestorage$gui$ServicePanel));
    }
}

