/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.command.AbstractCommandSecureStorage;
import com.sap.security.core.server.securestorage.exception.CommandException;
import com.sap.security.core.server.securestorage.exception.ObjectEncryptionException;
import com.sap.security.core.server.securestorage.exception.ObjectModificationException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class ReEncryptCommand
extends AbstractCommandSecureStorage {
    private static final String NAME = "reencrypt";
    private static final String DESCRIPTION = "Description reencrypt: encrypt objects in the securestorage with their newest key";
    private static final String USAGE = "Usage: reencrypt [option]\nwhere [option] include\n   -a -all                   generate a new key for every client in secure storage and reencrypt all central stored objects with new key\n   <clienttype> <clientid>   encrypt objects of the given client with newest key";

    public ReEncryptCommand(SecureStorageRuntimeInterface secureStorageRuntimeInterface) {
        super(secureStorageRuntimeInterface);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getUsage() {
        return USAGE;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 1) {
            if (params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            } else if (params[0].equals("-a")) {
                try {
                    this._reEncryptAllCommand();
                }
                catch (CommandException e) {
                    pw.println("Could not reencrypt all objects.The exception was: " + e.getMessage());
                }
            } else {
                pw.println("Error unsupported parameter");
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            }
        } else if (params.length == 2) {
            try {
                this._reEncryptCommand(params[0], params[1]);
            }
            catch (CommandException e) {
                pw.println("An exception occurred when trying to reencrypt objects.The exception was: " + e.getMessage());
            }
        } else {
            pw.println("Error unsupported number of parameters");
            pw.println(this.getDescription());
            pw.println(this.getUsage());
        }
    }

    private void _reEncryptCommand(String client, String clientID) throws CommandException {
        int clientType;
        if (client.equals("services")) {
            clientType = 1;
        } else if (client.equals("webapps")) {
            clientType = 2;
        } else {
            throw new CommandException("Could not specify clienttype. Ensure that clienttype is correct.");
        }
        SecureStorageRuntimeInterface _secureStorageRuntimeInterface = this.getSecureStorageRuntimeInterface();
        try {
            RemoteSecureStorageAdministratorContextInterface remoteSecureStorageAdministratorContext = _secureStorageRuntimeInterface.getSecureStorageAdministratorContext();
            remoteSecureStorageAdministratorContext.reEncryptCentralStoredObject(clientType, clientID);
        }
        catch (ObjectModificationException e) {
            throw new CommandException(e, "Could not reencrypt objects. Exception was: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CommandException(e, "Could not connect to J2EE Engine. Exception was: " + e.getMessage());
        }
    }

    private void _reEncryptAllCommand() throws CommandException {
        SecureStorageRuntimeInterface _secureStorageRuntimeInterface = this.getSecureStorageRuntimeInterface();
        try {
            RemoteSecureStorageAdministratorContextInterface remoteSecureStorageAdministratorContext = _secureStorageRuntimeInterface.getSecureStorageAdministratorContext();
            remoteSecureStorageAdministratorContext.reEncryptAllCentralStoredObjects();
        }
        catch (ObjectEncryptionException e) {
            throw new CommandException(e, "Could not reencrypt objects. Exception was: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CommandException(e, "Could not connect to J2EE Engine. Exception was: " + e.getMessage());
        }
    }
}

