/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.command.AbstractCommandSecureStorage;
import com.sap.security.core.server.securestorage.exception.CommandException;
import com.sap.security.core.server.securestorage.exception.StorageLocationOpenException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Vector;

public class GetObjectCommand
extends AbstractCommandSecureStorage {
    private static final String NAME = "LIST_OBJECTS";
    private static final String DESCRIPTION = "Description LIST_OBJECTS: list object from the given client";
    private static final String USAGE = "Usage: LIST_OBJECTS <clienttype> <clintid>";

    public GetObjectCommand(SecureStorageRuntimeInterface secureStorageRuntimeInterface) {
        super(secureStorageRuntimeInterface);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getUsage() {
        return USAGE;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 1) {
            if (params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            } else {
                pw.println("Error unsupported parameter");
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            }
        } else if (params.length == 2) {
            try {
                this._getObjectCommand(params[0], params[1], pw);
            }
            catch (CommandException e) {
                pw.println("An exception occurred when trying to display objects. Exception was: " + e.getMessage());
            }
        } else {
            pw.println("Error unsupported number of parameters");
            pw.println(this.getDescription());
            pw.println(this.getUsage());
        }
    }

    private void _getObjectCommand(String client, String clientID, PrintWriter pw) throws CommandException {
        int clientType;
        if (client.equals("services")) {
            clientType = 1;
        } else if (client.equals("webapps")) {
            clientType = 2;
        } else {
            throw new CommandException("Could not specify clienttype. Ensure that clienttype is correct.");
        }
        SecureStorageRuntimeInterface _secureStorageRuntimeInterface = this.getSecureStorageRuntimeInterface();
        try {
            RemoteSecureStorageAdministratorContextInterface remoteSecureStorageAdministratorContext = _secureStorageRuntimeInterface.getSecureStorageAdministratorContext();
            Vector objectIDs = remoteSecureStorageAdministratorContext.getObjectIDs(clientType, clientID);
            if (objectIDs.size() == 0) {
                pw.println("no object found");
            } else {
                int i = 0;
                while (i < objectIDs.size()) {
                    pw.println(i + 1 + " " + objectIDs.get(i));
                    ++i;
                }
            }
        }
        catch (StorageLocationOpenException e) {
            throw new CommandException(e, "Could not read objects. Exception was: " + e.getMessage());
        }
        catch (RemoteException e) {
            throw new CommandException(e, "Could not read objects. Exception was: " + e.getMessage());
        }
    }
}

