/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.command.AbstractCommandSecureStorage;
import com.sap.security.core.server.securestorage.exception.CommandException;
import com.sap.security.core.server.securestorage.exception.KeyStoreAccessException;
import com.sap.security.core.server.securestorage.exception.NoKeyForClientException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Vector;

public class GetKeysCommand
extends AbstractCommandSecureStorage {
    private static final String NAME = "LIST_KEYS";
    private static final String DESCRIPTION = "Description LIST_KEYS: list all keys from the given client";
    private static final String USAGE = "Usage: LIST_KEYS <clienttype> <clientID>";

    public GetKeysCommand(SecureStorageRuntimeInterface secureStorageRuntimeInterface) {
        super(secureStorageRuntimeInterface);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getUsage() {
        return USAGE;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 1) {
            if (params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            } else {
                pw.println("Error unsupported parameter");
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            }
        } else if (params.length == 2) {
            try {
                this._getClientKey(params[0], params[1], pw);
            }
            catch (CommandException e) {
                pw.println("An exception occurred when trying to display keys of client.The exception was: " + e.getMessage());
            }
        } else {
            pw.println("Error unsupported number of parameters");
            pw.println(this.getDescription());
            pw.println(this.getUsage());
        }
    }

    private void _getClientKey(String clientType, String clientID, PrintWriter pw) throws CommandException {
        int _clientType = 0;
        if (clientType.equals("services")) {
            _clientType = 1;
        } else if (clientType.equals("webapps")) {
            _clientType = 2;
        } else {
            throw new CommandException("Could not specify clienttype. Ensure that clienttype is correct.");
        }
        SecureStorageRuntimeInterface _secureStorageRuntimeInterface = this.getSecureStorageRuntimeInterface();
        try {
            RemoteSecureStorageAdministratorContextInterface remoteSecureStorageAdministratorContext = _secureStorageRuntimeInterface.getSecureStorageAdministratorContext();
            try {
                Vector keysOfClient = remoteSecureStorageAdministratorContext.getSecretKeyIDs(clientID, _clientType);
                int i = 0;
                while (i < keysOfClient.size()) {
                    pw.println(i + 1 + " " + keysOfClient.get(i));
                    ++i;
                }
            }
            catch (NoKeyForClientException e) {
                pw.println("No key for client found. It is recommended to generate a new key for that client.");
            }
            catch (KeyStoreAccessException e) {
                throw new CommandException(e, "Could not read keys because of no access to Key Storage. Ensure that Key Storage Service is started. Exception was: " + e.getMessage());
            }
        }
        catch (RemoteException e) {
            throw new CommandException(e, "Could not connect to J2EE Engine. Exception was " + e.getMessage());
        }
    }
}

