/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.command.AbstractCommandSecureStorage;
import com.sap.security.core.server.securestorage.exception.CommandException;
import com.sap.security.core.server.securestorage.exception.StorageLocationOpenException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Vector;

public class GetClientCommand
extends AbstractCommandSecureStorage {
    private static final String NAME = "LIST_CLIENTS";
    private static final String DESCRIPTION = "Description LIST_CLIENTS: list ID of clients";
    private static final String USAGE = "Usage: LIST_CLIENTS[option] \nwhere [option] include\n      -no option        list IDs of all clients\n   -s -service          list IDs of webapplicationclients\n   -w -webapplication   list IDs of serviceclients";

    public GetClientCommand(SecureStorageRuntimeInterface secureStorageRuntimeInterface) {
        super(secureStorageRuntimeInterface);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getUsage() {
        return USAGE;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 0) {
            try {
                this._showClientIDs(1, pw);
                this._showClientIDs(2, pw);
            }
            catch (CommandException e) {
                pw.println("An exception occurred when trying to display all clienIDs. The exception was: " + e.getMessage());
            }
        } else if (params.length == 1) {
            if (params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            } else if (params[0].equals("-s")) {
                try {
                    this._showClientIDs(1, pw);
                }
                catch (CommandException e) {
                    pw.println("An exception occurred when trying to display all clienIDs. The exception was: " + e.getMessage());
                }
            } else if (params[0].equals("-w")) {
                try {
                    this._showClientIDs(2, pw);
                }
                catch (CommandException e) {
                    pw.println("An exception occurred when trying to display all clienIDs. The exception was: " + e.getMessage());
                }
            } else {
                pw.println("Error unsupported parameter");
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            }
        } else {
            pw.println("Error unsupported number of parameters");
        }
    }

    private void _showClientIDs(int clienttype, PrintWriter pw) throws CommandException {
        SecureStorageRuntimeInterface _secureStorageRuntimeInterface = this.getSecureStorageRuntimeInterface();
        try {
            RemoteSecureStorageAdministratorContextInterface remoteSecureStorageAdministratorContext = _secureStorageRuntimeInterface.getSecureStorageAdministratorContext();
            try {
                Vector clientIDs = remoteSecureStorageAdministratorContext.getClientIDs(clienttype);
                int i = 0;
                while (i < clientIDs.size()) {
                    if (clienttype == 1) {
                        pw.println("services " + clientIDs.get(i));
                    } else if (clienttype == 2) {
                        pw.println("webapps  " + clientIDs.get(i));
                    }
                    ++i;
                }
            }
            catch (StorageLocationOpenException e) {
                throw new CommandException(e, "Could not read all clients. Exception was: " + e.getMessage());
            }
        }
        catch (RemoteException e) {
            throw new CommandException(e, "Could not connect to J2EE Engine. Exception was: " + e.getMessage());
        }
    }
}

