/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.command.AbstractCommandSecureStorage;
import com.sap.security.core.server.securestorage.exception.CommandException;
import com.sap.security.core.server.securestorage.exception.KeyGenerationException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class GenerateSecretKeyCommand
extends AbstractCommandSecureStorage {
    private static final String NAME = "NEW_KEY";
    private static final String DESCRIPTION = "Description NEW_KEY: generate new secret key for the given client";
    private static final String USAGE = "Usage: NEW_KEY <clienttype> <clintid>";

    public GenerateSecretKeyCommand(SecureStorageRuntimeInterface secureStorageRuntimeInterface) {
        super(secureStorageRuntimeInterface);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getUsage() {
        return USAGE;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 1) {
            if (params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            } else {
                pw.println("Error unsupported parameter");
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            }
        } else if (params.length == 2) {
            try {
                this._generateSecretKeyCommand(params[0], params[1], pw);
            }
            catch (CommandException e) {
                pw.println("An exception occurred when generate key. The exception was: " + e.getMessage());
            }
        } else {
            pw.println("Error unsupported number of parameters");
            pw.println(this.getDescription());
            pw.println(this.getUsage());
        }
    }

    private void _generateSecretKeyCommand(String client, String clientID, PrintWriter pw) throws CommandException {
        int clientType = 0;
        if (client.equals("services")) {
            clientType = 1;
        } else if (client.equals("webapps")) {
            clientType = 2;
        } else {
            throw new CommandException("Could not specify clienttype. Ensure that clienttype is correct.");
        }
        SecureStorageRuntimeInterface _secureStorageRuntimeInterface = this.getSecureStorageRuntimeInterface();
        try {
            RemoteSecureStorageAdministratorContextInterface remoteSecureStorageAdministratorContext = _secureStorageRuntimeInterface.getSecureStorageAdministratorContext();
            remoteSecureStorageAdministratorContext.generateSecretKeyID(clientType, clientID);
            pw.println("key generated");
        }
        catch (KeyGenerationException e) {
            throw new CommandException(e, "Could not generate key. Ensure that SAP Java Crypto Lib is deployed on this server.");
        }
        catch (RemoteException e) {
            throw new CommandException(e, "Could not connect to J2EE Engine.");
        }
    }
}

