/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.command.AbstractCommandSecureStorage;
import com.sap.security.core.server.securestorage.exception.CommandException;
import com.sap.security.core.server.securestorage.exception.ObjectDeletionException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class DeleteObjectCommand
extends AbstractCommandSecureStorage {
    private static final String NAME = "DELETE_OBJECT";
    private static final String DESCRIPTION = "Description DELETE_OBJECT: delete object from the securestorage";
    private static final String USAGE = "Usage: DELETE_OBJECT <clienttype> <clientid> <objectid>";

    public DeleteObjectCommand(SecureStorageRuntimeInterface secureStorageRuntimeInterface) {
        super(secureStorageRuntimeInterface);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getUsage() {
        return USAGE;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 1) {
            if (params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            } else {
                pw.println("Error unsupported parameter");
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            }
        } else if (params.length == 3) {
            try {
                this._deleteObjectCommand(params[0], params[1], params[2]);
            }
            catch (CommandException e) {
                e.getMessage();
            }
        } else {
            pw.println("Error unsupported number of parameters");
            pw.println(this.getDescription());
            pw.println(this.getUsage());
        }
    }

    private void _deleteObjectCommand(String client, String clientID, String objectID) throws CommandException {
        int clientType = 0;
        if (client.equals("services")) {
            clientType = 1;
        } else if (client.equals("webapps")) {
            clientType = 2;
        } else {
            throw new CommandException("Could not specify clienttype");
        }
        SecureStorageRuntimeInterface _secureStorageRuntimeInterface = this.getSecureStorageRuntimeInterface();
        try {
            RemoteSecureStorageAdministratorContextInterface remoteSecureStorageAdministratorContext = _secureStorageRuntimeInterface.getSecureStorageAdministratorContext();
            remoteSecureStorageAdministratorContext.deleteObject(clientType, clientID, objectID);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ObjectDeletionException e) {
            e.printStackTrace();
        }
    }
}

