/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.command.AbstractCommandSecureStorage;
import com.sap.security.core.server.securestorage.exception.CommandException;
import com.sap.security.core.server.securestorage.exception.ObjectStorageException;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;

public class AddStringEntryCommand
extends AbstractCommandSecureStorage {
    private static final String NAME = "ADD_STRING";
    private static final String DESCRIPTION = "Description ADD_STRING: store a String into securestorage";
    private static final String USAGE = "Usage: ADD_STRING <clienttype> <clientid> <Alias> <String>";

    public AddStringEntryCommand(SecureStorageRuntimeInterface secureStorageRuntimeInterface) {
        super(secureStorageRuntimeInterface);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getUsage() {
        return USAGE;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length == 1) {
            if (params[0].equals("-h") || params[0].equals("-?") || params[0].equals("-help")) {
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            } else {
                pw.println("Error unsupported parameter");
                pw.println(this.getDescription());
                pw.println(this.getUsage());
            }
        } else if (params.length == 4) {
            try {
                this._addStringEntry(params[0], params[1], params[2], params[3]);
            }
            catch (CommandException e) {
                pw.println("An exception occurred when trying to store a String into Secure Storage. Exception was: " + e.getMessage());
            }
        } else {
            pw.println("Error unsupported number of parameters");
            pw.println(this.getDescription());
            pw.println(this.getUsage());
        }
    }

    private void _addStringEntry(String client, String clientID, String objectID, String object) throws CommandException {
        int clientType = 0;
        if (client.equals("services")) {
            clientType = 1;
        } else if (client.equals("webapps")) {
            clientType = 2;
        } else {
            throw new CommandException("Could not specify clienttype. Ensure that clienttype is correct.");
        }
        SecureStorageRuntimeInterface _secureStorageRuntimeInterface = this.getSecureStorageRuntimeInterface();
        try {
            RemoteSecureStorageClientContextInterface remoteSecureStorageClientContext = _secureStorageRuntimeInterface.getSecureStorageClientContext(clientID, clientType);
            remoteSecureStorageClientContext.storeObject((Serializable)((Object)object), objectID);
        }
        catch (RemoteException e) {
            throw new CommandException(e, "Could not connect to J2EE Engine. Exception was: " + e.getMessage());
        }
        catch (ObjectStorageException e) {
            throw new CommandException(e, "Could not store object. Exception was: " + e.getMessage());
        }
    }
}

