/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.security.core.server.securestorage.SecureStorageImplMessage;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterfaceImpl;
import com.sap.security.core.server.securestorage.command.AddStringEntryCommand;
import com.sap.security.core.server.securestorage.command.GenerateSecretKeyCommand;
import com.sap.security.core.server.securestorage.command.GetClientCommand;
import com.sap.security.core.server.securestorage.command.GetKeysCommand;
import com.sap.security.core.server.securestorage.command.GetObjectCommand;
import com.sap.security.core.server.securestorage.command.ReEncryptCommand;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Properties;

public class SecureStorageServiceFrame
implements ApplicationServiceFrame,
ContainerEventListener {
    public static final String ROOT_CONFIGURATION_NAME = "securestorage";
    public static final String KEYSTORE_CLIENT_NAME = "securestorage";
    public static final String SERVICES_SUBCONFIGURATION_NAME = "services";
    public static final String WEBAPPS_SUBCONFIGURATION_NAME = "webapps";
    public static final int CLIENT_TYPE_WEB_APPLICATION = 2;
    public static final int CLIENT_TYPE_SERVICE = 1;
    public static final String algorithm = "DESede";
    public static final int SECURE_STORAGE_OBJECT_MODEL_VERSION = 1;
    public static final String JNDI_NAME = "tc~sec~securestorage~service";
    private SecureStorageRuntimeInterface secureStorageRuntimeInterfaceImpl;
    private ShellInterface shell;
    private int commandID;
    private Command[] commands;
    private ApplicationServiceContext _applicationServiceContext;
    private String lockNameSpace = "[securestorage~service]";
    private String lockDescription = "internal lock set by securestorage service";
    private String lockingArgument = "securestorage.start";
    private int lockingTimeout = 30000;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$securestorage$SecureStorageServiceFrame == null ? (class$com$sap$security$core$server$securestorage$SecureStorageServiceFrame = SecureStorageServiceFrame.class$("com.sap.security.core.server.securestorage.SecureStorageServiceFrame")) : class$com$sap$security$core$server$securestorage$SecureStorageServiceFrame));
    final Category CATEGORY = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)"SecureStorage");
    static /* synthetic */ Class class$com$sap$security$core$server$securestorage$SecureStorageServiceFrame;

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        String method = "start";
        try {
            try {
                LOCATION.entering("start");
                this._applicationServiceContext = serviceContext;
                LockingContext lockingContext = serviceContext.getCoreContext().getLockingContext();
                ServerInternalLocking serverInternalLocking = lockingContext.createServerInternalLocking(this.lockNameSpace, this.lockDescription);
                try {
                    serverInternalLocking.lock(this.lockNameSpace, this.lockingArgument, 'X', this.lockingTimeout);
                    ConfigurationHandler secureStorageConfigurationHandler = this._applicationServiceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
                    this.secureStorageRuntimeInterfaceImpl = new SecureStorageRuntimeInterfaceImpl(this._applicationServiceContext);
                    Properties properties = this._applicationServiceContext.getServiceState().getProperties();
                    RemoteSecureStorageAdministratorContextInterface remoteSecureStorageAdministratorContext = this.secureStorageRuntimeInterfaceImpl.getSecureStorageAdministratorContext();
                    remoteSecureStorageAdministratorContext.checkRootConfiguration("securestorage", true);
                    remoteSecureStorageAdministratorContext.checkConfiguration(SERVICES_SUBCONFIGURATION_NAME, true);
                    remoteSecureStorageAdministratorContext.checkConfiguration(WEBAPPS_SUBCONFIGURATION_NAME, true);
                    if (!remoteSecureStorageAdministratorContext.isCryptoLibDepolyed()) {
                        SecureStorageImplMessage.ID0321_ERROR_CREATE_SECRET_KEY.create((Object)"cryptoLibCheck").log(400, this.CATEGORY, LOCATION, "start");
                    } else {
                        SecureStorageImplMessage.ID0320_ERROR_CREATE_SECRET_KEY.create((Object)"cryptoLibCheck").log(300, this.CATEGORY, LOCATION, "start");
                    }
                    this._applicationServiceContext.getContainerContext().getObjectRegistry().registerInterface((Object)this.secureStorageRuntimeInterfaceImpl);
                    this._applicationServiceContext.getServiceState().registerContainerEventListener((ContainerEventListener)this);
                    this._applicationServiceContext.getServiceState().registerManagementInterface((ManagementInterface)this.secureStorageRuntimeInterfaceImpl);
                    serverInternalLocking.unlock(this.lockNameSpace, this.lockingArgument, 'X');
                }
                catch (LockException e) {
                }
                catch (TechnicalLockException e) {
                }
                catch (Throwable e) {
                    LOCATION.traceThrowableT(100, "An exception occurred when start the service. The exception was: ", e);
                    try {
                        serverInternalLocking.unlock(this.lockNameSpace, this.lockingArgument, 'X');
                    }
                    catch (TechnicalLockException tlex) {
                    }
                }
                Object var10_14 = null;
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    this.stop();
                }
                catch (Exception x) {
                    LOCATION.exiting((Object)x);
                }
                throw new ServiceException("Can not start secure storage service: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public void stop() throws ServiceRuntimeException {
        try {
            this._applicationServiceContext.getContainerContext().getObjectRegistry().unregisterInterface();
            this._applicationServiceContext.getServiceState().unregisterContainerEventListener();
            this.shell = null;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException("Can not cleanup when stopping secure storage service", (Throwable)e);
        }
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        return true;
    }

    public void beginContainerStop() {
    }

    public void containerStarted() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public void markForShutdown(long mark) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            this.commands = new Command[6];
            this.commands[0] = new GetClientCommand(this.secureStorageRuntimeInterfaceImpl);
            this.commands[1] = new GetKeysCommand(this.secureStorageRuntimeInterfaceImpl);
            this.commands[2] = new GetObjectCommand(this.secureStorageRuntimeInterfaceImpl);
            this.commands[3] = new GenerateSecretKeyCommand(this.secureStorageRuntimeInterfaceImpl);
            this.commands[4] = new ReEncryptCommand(this.secureStorageRuntimeInterfaceImpl);
            this.commands[5] = new AddStringEntryCommand(this.secureStorageRuntimeInterfaceImpl);
            this.commandID = this.shell.registerCommands(this.commands);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (this.shell != null) {
            this.shell.unregisterCommands(this.commandID);
        }
        this.shell = null;
    }

    public void serviceInterfaceRegistered(String serviceName, Object serviceInterface) {
    }

    public void serviceInterfaceUnregistered(String serviceName) {
    }

    public boolean setServiceProperty(String key, String value) {
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

