/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.securestorage;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextImpl;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageAdministratorContextInterface;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextImpl;
import com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextInterface;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;

public class SecureStorageRuntimeInterfaceImpl
implements SecureStorageRuntimeInterface {
    private ApplicationServiceContext _serviceContext;
    private ConfigurationHandler _secureStorageConfigurationHandler = null;
    private Object _mySyncObject;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$securestorage$SecureStorageRuntimeInterfaceImpl == null ? (class$com$sap$security$core$server$securestorage$SecureStorageRuntimeInterfaceImpl = SecureStorageRuntimeInterfaceImpl.class$("com.sap.security.core.server.securestorage.SecureStorageRuntimeInterfaceImpl")) : class$com$sap$security$core$server$securestorage$SecureStorageRuntimeInterfaceImpl));
    static /* synthetic */ Class class$com$sap$security$core$server$securestorage$SecureStorageRuntimeInterfaceImpl;

    public SecureStorageRuntimeInterfaceImpl(ApplicationServiceContext applicationServiceContext) throws RemoteException {
        String method = "SecureStorageRuntimeInterfaceImpl(ApplicationServiceContext applicationServiceContext";
        try {
            this._mySyncObject = new Object();
            this._serviceContext = applicationServiceContext;
            this._secureStorageConfigurationHandler = applicationServiceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(100, "SecureStorageRuntimeInterfaceImpl(ApplicationServiceContext applicationServiceContext", "An exception occurred when instantiate a ConfigurationHandler object. The exception was: ", (Throwable)e);
        }
    }

    public RemoteSecureStorageClientContextInterface getSecureStorageClientContext() throws RemoteException {
        String method = "getSecureStorageClientContext()";
        Object object = this._mySyncObject;
        synchronized (object) {
            RemoteSecureStorageClientContextImpl clientContext;
            try {
                ConfigurationHandler secureStorageConfigurationHandler = this._serviceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
                clientContext = new RemoteSecureStorageClientContextImpl(secureStorageConfigurationHandler, this._mySyncObject, this._serviceContext);
                this._serviceContext.getCoreContext().getThreadSystem().startThread((Runnable)clientContext, true);
            }
            catch (ConfigurationException e) {
                throw new RemoteException();
            }
            try {
                this._mySyncObject.wait();
            }
            catch (InterruptedException ie) {
                LOCATION.traceThrowableT(100, "getSecureStorageClientContext()", "An exception occurred in internal processes. The exception was: ", (Throwable)ie);
            }
            RemoteSecureStorageClientContextImpl remoteSecureStorageClientContextImpl = clientContext;
            return remoteSecureStorageClientContextImpl;
        }
    }

    public RemoteSecureStorageClientContextInterface getSecureStorageClientContext(String clientExt) throws RemoteException {
        String method = "getSecureStorageClientContext(String clientExt)";
        Object object = this._mySyncObject;
        synchronized (object) {
            RemoteSecureStorageClientContextImpl clientContext;
            try {
                ConfigurationHandler secureStorageConfigurationHandler = this._serviceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
                clientContext = new RemoteSecureStorageClientContextImpl(clientExt, secureStorageConfigurationHandler, this._mySyncObject, this._serviceContext);
                this._serviceContext.getCoreContext().getThreadSystem().startThread((Runnable)clientContext, true);
            }
            catch (ConfigurationException e) {
                throw new RemoteException();
            }
            try {
                this._mySyncObject.wait();
            }
            catch (InterruptedException ie) {
                LOCATION.traceThrowableT(100, "getSecureStorageClientContext(String clientExt)", "An exception occurred in internal processes. The exception was: ", (Throwable)ie);
            }
            RemoteSecureStorageClientContextImpl remoteSecureStorageClientContextImpl = clientContext;
            return remoteSecureStorageClientContextImpl;
        }
    }

    public RemoteSecureStorageClientContextInterface getSecureStorageClientContext(String clientID, int clientType) throws RemoteException {
        RemoteSecureStorageClientContextImpl clientContext = new RemoteSecureStorageClientContextImpl(clientID, clientType, this._secureStorageConfigurationHandler, this._serviceContext);
        this._serviceContext.getCoreContext().getThreadSystem().startThread((Runnable)clientContext, true);
        return clientContext;
    }

    public RemoteSecureStorageAdministratorContextInterface getSecureStorageAdministratorContext() throws RemoteException {
        return new RemoteSecureStorageAdministratorContextImpl(this._secureStorageConfigurationHandler, this._serviceContext);
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

