/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.api.vault;

import com.sap.security.api.vault.InvalidFormatException;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.Hashtable;

public abstract class SecureStorage {
    private static String default_key = "DEFAULT";
    private static Hashtable engines = new Hashtable(5);
    public static final String STORE_FILE_NAME_KEY = "ume.secstore.filename";
    public static final String PORTAL_STORAGE_KEYTYPE_ALIAS = "ume.secstore.keytype";
    public static final String PORTAL_STORAGE_ALGO_ALIAS = "ume.secstore.algorithm";

    protected SecureStorage() {
    }

    public static void registerStorage(String key, Object storage) throws IllegalArgumentException {
        engines.put(key, storage);
    }

    public static void unregisterStorage(String key) {
        engines.remove(key);
    }

    public static SecureStorage getInstance(String key) {
        return (SecureStorage)engines.get(key);
    }

    public static SecureStorage getInstance() {
        return (SecureStorage)engines.get(default_key);
    }

    public abstract void addEntry(String var1, Serializable var2, Class[] var3) throws IOException;

    public abstract Serializable readEntry(String var1) throws AccessControlException, IOException, InvalidFormatException;

    public abstract void changeEntry(String var1, Serializable var2) throws AccessControlException, IllegalArgumentException, IOException;

    public abstract void deleteEntry(String var1) throws AccessControlException, IOException;
}

