/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.api.session;

import com.sap.security.api.session.ISSOSession;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class SessionFactory {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_api/java/com/sap/security/api/session/SessionFactory.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    public static final String SAP_USER_ID = "com.sap.security.user_id";
    public static final int SAP_AUTHSCHEME_INFOUNITID = 136;

    public static SessionFactory getInstance(Properties conf) throws ClassNotFoundException {
        String sess_fac_class_str = conf.getProperty("login.session.factory", "com.sap.security.core.session.imp.DefaultSAPSessionFactory");
        Class<?> sess_fac_class = null;
        SessionFactory fac = null;
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
            sess_fac_class = Class.forName(sess_fac_class_str, true, cl);
            Class[] args = new Class[]{conf.getClass()};
            fac = (SessionFactory)sess_fac_class.getMethod("getInstance", args).invoke(null, conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new NoClassDefFoundError(cnfe.toString());
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new NoClassDefFoundError(ite.toString());
        }
        catch (NoSuchMethodException nsme) {
            throw new NoClassDefFoundError(nsme.toString());
        }
        catch (SecurityException se) {
            throw new NoClassDefFoundError(se.toString());
        }
        catch (ClassCastException cce) {
            throw new NoClassDefFoundError(cce.toString());
        }
        catch (IllegalAccessException cce) {
            throw new NoClassDefFoundError(cce.toString());
        }
        return fac;
    }

    public abstract ISSOSession getSSOSession(HttpServletRequest var1, HttpServletResponse var2);
}

