/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.api.keystore;

import com.sap.security.api.keystore.PKList;
import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.Name;
import iaik.x509.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;

class PKListImpl
implements PKList {
    private static String name = "PKList";
    private static ObjectID pkloid = new ObjectID("1.3.36.2.6.1", "", "");
    private Hashtable certs = new Hashtable(10);
    private ASN1Object asn = null;

    PKListImpl() {
    }

    public String getName() {
        return name;
    }

    public void addCertificate(X509Certificate cert) {
        this.certs.put(cert.getSubjectDN().toString(), cert);
    }

    public void removeCertificate(String subject) {
        this.certs.remove(subject);
    }

    public synchronized ASN1Object getObject() {
        if (this.asn != null) {
            return this.asn;
        }
        int i = 0;
        SEQUENCE s = new SEQUENCE();
        PrintableString str = new PrintableString(name);
        SET ss = new SET();
        Enumeration keys = this.certs.keys();
        s.addComponent((ASN1Object)str, i++);
        s.addComponent((ASN1Object)pkloid, i++);
        while (keys.hasMoreElements()) {
            SEQUENCE cert = (SEQUENCE)((X509Certificate)this.certs.get(keys.nextElement())).toASN1Object();
            ss.addComponent(cert.getComponentAt(0), 0);
        }
        s.addComponent((ASN1Object)ss, i++);
        this.asn = s;
        return s;
    }

    public byte[] getEncoded() {
        if (this.asn == null) {
            this.getObject();
        }
        return DerCoder.encode((ASN1Object)this.asn);
    }

    public void removeCertificate(Name subject) {
    }
}

