/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.api;

import java.io.PrintStream;
import java.io.PrintWriter;

public class UMException
extends Exception {
    private static final String GLUE_TEXT = ": ";
    private static final String NO_MESSAGE_TEXT = "(No text available)";
    protected Throwable m_throwable;
    private boolean _getLocalizedMessageAlreadyActive = false;
    private boolean _getMessageAlreadyActive = false;

    public UMException(Throwable nestedException, String message) {
        super(message);
        this.m_throwable = nestedException;
    }

    public UMException(Throwable nestedException) {
        super(nestedException.getMessage());
        this.m_throwable = nestedException;
    }

    public UMException(String message) {
        super(message);
    }

    public UMException() {
    }

    public Throwable getNestedException() {
        return this.m_throwable;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace();
            if (this.m_throwable != null) {
                System.err.println("-------- caused by --------");
                this.m_throwable.printStackTrace();
            }
        }
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.m_throwable != null) {
            s.println("-------- caused by --------");
            this.m_throwable.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.m_throwable != null) {
            s.println("-------- caused by --------");
            this.m_throwable.printStackTrace(s);
        }
    }

    public String getLocalizedMessage() {
        String ownMessage;
        if (this._getLocalizedMessageAlreadyActive) {
            return null;
        }
        try {
            this._getLocalizedMessageAlreadyActive = true;
            ownMessage = super.getLocalizedMessage();
            if (!UMException.isUsable(ownMessage)) {
                ownMessage = super.getMessage();
            }
            if (!UMException.isUsable(ownMessage)) {
                ownMessage = NO_MESSAGE_TEXT;
            }
            Object var3_2 = null;
            this._getLocalizedMessageAlreadyActive = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._getLocalizedMessageAlreadyActive = false;
            throw throwable;
        }
        if (this.m_throwable == null || this._getLocalizedMessageAlreadyActive || this._getMessageAlreadyActive) {
            return ownMessage;
        }
        String nestedMessage = this.m_throwable.getLocalizedMessage();
        if (!UMException.isUsable(nestedMessage)) {
            nestedMessage = this.m_throwable.getMessage();
        }
        if (!UMException.isUsable(nestedMessage)) {
            nestedMessage = NO_MESSAGE_TEXT;
        }
        return UMException.concatenate(ownMessage, nestedMessage);
    }

    public String getMessage() {
        String ownMessage;
        if (this._getMessageAlreadyActive) {
            return null;
        }
        try {
            this._getMessageAlreadyActive = true;
            ownMessage = super.getMessage();
            if (!UMException.isUsable(ownMessage)) {
                ownMessage = super.getLocalizedMessage();
            }
            if (!UMException.isUsable(ownMessage)) {
                ownMessage = NO_MESSAGE_TEXT;
            }
            Object var3_2 = null;
            this._getMessageAlreadyActive = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._getMessageAlreadyActive = false;
            throw throwable;
        }
        if (this.m_throwable == null || this._getLocalizedMessageAlreadyActive || this._getMessageAlreadyActive) {
            return ownMessage;
        }
        String nestedMessage = this.m_throwable.getMessage();
        if (!UMException.isUsable(nestedMessage)) {
            nestedMessage = this.m_throwable.getLocalizedMessage();
        }
        if (!UMException.isUsable(nestedMessage)) {
            nestedMessage = NO_MESSAGE_TEXT;
        }
        return UMException.concatenate(ownMessage, nestedMessage);
    }

    private static boolean isUsable(String message) {
        return message != null && message.trim().length() > 0;
    }

    private static String concatenate(String ownMessage, String nestedMessage) {
        String usedPartOfNested = nestedMessage;
        while (usedPartOfNested.startsWith(ownMessage)) {
            if (!(usedPartOfNested = usedPartOfNested.substring(ownMessage.length())).startsWith(GLUE_TEXT)) continue;
            usedPartOfNested = usedPartOfNested.substring(GLUE_TEXT.length());
        }
        if (usedPartOfNested.trim().length() > 0) {
            return ownMessage + GLUE_TEXT + usedPartOfNested;
        }
        return ownMessage;
    }

    public static void main(String[] args) {
        UMException[] exceptions = new UMException[]{new UMException(), new UMException("Only own message"), new UMException(new NullPointerException("Only nested exception")), new UMException(new NullPointerException("Nested message"), "Own message")};
        int i = 0;
        while (i < exceptions.length) {
            System.out.println("Exception " + i + " getMessage()         : " + exceptions[i].getMessage());
            System.out.println("Exception " + i + " getLocalizedMessage(): " + exceptions[i].getLocalizedMessage());
            System.out.println("Stack trace: ");
            exceptions[i].printStackTrace();
            ++i;
        }
    }
}

