/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.api;

import com.sap.security.api.UMRuntimeException;
import java.io.Serializable;
import java.util.Vector;

public class AttributeList
implements Serializable {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_api/java/com/sap/security/api/AttributeList.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_BLOB = 2;
    protected Vector attributes = new Vector();
    protected boolean mCheckSizeLimit;

    public AttributeList() {
        this(true);
    }

    public AttributeList(boolean checkSizeLimit) {
        this.mCheckSizeLimit = checkSizeLimit;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AttributeList)) {
            return false;
        }
        AttributeList pa = (AttributeList)obj;
        if (this.getSize() != pa.getSize()) {
            return false;
        }
        boolean allOk = true;
        AttributeWrapper aw = null;
        int i = 0;
        while (i < pa.getSize() && allOk) {
            aw = new AttributeWrapper(pa.getNameSpaceOfAttributeAt(i), pa.getAttributeNameOfAttributeAt(i));
            allOk = allOk && this.attributes.contains(aw);
            ++i;
        }
        return allOk;
    }

    public int getAttributeTypeOfAttributeAt(int index) {
        return ((AttributeWrapper)this.attributes.elementAt(index)).getType();
    }

    public int getAttributeType(String nameSpace, String attributeName) {
        boolean found = false;
        int size = this.attributes.size();
        int attributeType = 0;
        int i = 0;
        while (i < size && !found) {
            String aName = ((AttributeWrapper)this.attributes.elementAt(i)).getAttributeName();
            String aNamespace = ((AttributeWrapper)this.attributes.elementAt(i)).getNameSpace();
            if (aName.equals(attributeName) && aNamespace.equals(nameSpace)) {
                found = true;
                attributeType = ((AttributeWrapper)this.attributes.elementAt(i)).getType();
            }
            ++i;
        }
        return attributeType;
    }

    public void removeAttribute(String nameSpace, String attributeName) {
        int size = this.attributes.size();
        int index = -1;
        int i = 0;
        while (i < size && index != -1) {
            AttributeWrapper dummy = (AttributeWrapper)this.attributes.elementAt(i);
            if (dummy.getAttributeName().equals(attributeName) && dummy.getNameSpace().equals(nameSpace)) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            this.attributes.remove(index);
        }
    }

    public boolean containsAttribute(String nameSpace, String attributeName, int type) {
        int size = this.attributes.size();
        boolean found = false;
        int i = 0;
        while (i < size && !found) {
            AttributeWrapper dummy = (AttributeWrapper)this.attributes.elementAt(i);
            found = dummy.getAttributeName().equals(attributeName) && dummy.getNameSpace().equals(nameSpace) && (type == 0 || type == dummy.getType() || dummy.getType() == 0);
            ++i;
        }
        return found;
    }

    public boolean containsAttribute(String nameSpace, String attributeName) {
        return this.containsAttribute(nameSpace, attributeName, 0);
    }

    public void addAttribute(String nameSpace, String attributeName) {
        this.addAttribute(nameSpace, attributeName, 0);
    }

    public void addAttribute(String nameSpace, String attributeName, int type) {
        if (this.mCheckSizeLimit && this.attributes.size() == 25) {
            throw new UMRuntimeException("This AttributeList contains already 25 attributes.");
        }
        if (nameSpace == null || attributeName == null) {
            throw new UMRuntimeException("Can't add attribute when namespace or attribute name is null!");
        }
        if (!this.containsAttribute(nameSpace, attributeName, type)) {
            AttributeWrapper aw = new AttributeWrapper(nameSpace, attributeName, type);
            this.attributes.add(aw);
        }
    }

    public void addAttributeList(AttributeList populateAttributes) {
        if (populateAttributes != null) {
            int size = populateAttributes.getSize();
            int i = 0;
            while (i < size) {
                this.addAttribute(populateAttributes.getNameSpaceOfAttributeAt(i), populateAttributes.getAttributeNameOfAttributeAt(i), populateAttributes.getAttributeTypeOfAttributeAt(i));
                ++i;
            }
        }
    }

    private AttributeWrapper getAttributeAt(int i) {
        return (AttributeWrapper)this.attributes.elementAt(i);
    }

    public boolean isSubsetOf(AttributeList populateAttributes) {
        if (populateAttributes == null || this.getSize() == 0) {
            return false;
        }
        int size = this.getSize();
        boolean allFound = true;
        int i = 0;
        while (i < size && allFound) {
            if (!populateAttributes.contains(this.getAttributeAt(i))) {
                allFound = false;
            }
            ++i;
        }
        return allFound;
    }

    private boolean contains(AttributeWrapper attrWrapper) {
        return this.attributes.contains(attrWrapper);
    }

    public AttributeList getNotContainedAttributes(AttributeList populateAttributes) {
        if (populateAttributes == null) {
            return new AttributeList();
        }
        AttributeList attrList = new AttributeList();
        int size = populateAttributes.getSize();
        int i = 0;
        while (i < size) {
            if (!this.attributes.contains(populateAttributes.getAttributeAt(i))) {
                attrList.addAttribute(populateAttributes.getNameSpaceOfAttributeAt(i), populateAttributes.getAttributeNameOfAttributeAt(i), populateAttributes.getAttributeTypeOfAttributeAt(i));
            }
            ++i;
        }
        return attrList;
    }

    public Object clone() {
        AttributeList attrList = new AttributeList(this.mCheckSizeLimit);
        attrList.addAttributeList(this);
        return attrList;
    }

    public int getSize() {
        return this.attributes.size();
    }

    public String getNameSpaceOfAttributeAt(int index) {
        return ((AttributeWrapper)this.attributes.elementAt(index)).getNameSpace();
    }

    public String getAttributeNameOfAttributeAt(int index) {
        return ((AttributeWrapper)this.attributes.elementAt(index)).getAttributeName();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("***************************************************************************\n");
        res.append("* ");
        if (this.mCheckSizeLimit) {
            res.append("Size limit (25) enabled.");
        } else {
            res.append("No size limit.");
        }
        res.append("\n");
        res.append("* ");
        res.append(this.getClass().getName());
        res.append("\n");
        res.append("*\n");
        int i = 0;
        while (i < this.attributes.size()) {
            res.append("* ");
            res.append(((AttributeWrapper)this.attributes.get(i)).toString());
            res.append("\n");
            ++i;
        }
        res.append("***************************************************************************\n");
        return res.toString();
    }

    private class AttributeWrapper
    implements Serializable {
        private String mNameSpace;
        private String mAttributeName;
        private int mType;

        public AttributeWrapper(String nameSpace, String attributeName) {
            this.mNameSpace = nameSpace;
            this.mAttributeName = attributeName;
            this.mType = 0;
        }

        public AttributeWrapper(String nameSpace, String attributeName, int type) {
            this.mNameSpace = nameSpace;
            this.mAttributeName = attributeName;
            this.mType = type;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AttributeWrapper)) {
                return false;
            }
            AttributeWrapper aw = (AttributeWrapper)obj;
            return aw.getNameSpace().equals(this.mNameSpace) && aw.getAttributeName().equals(this.mAttributeName) && (aw.getType() == this.mType || aw.getType() == 0 || this.mType == 0);
        }

        public int getType() {
            return this.mType;
        }

        public String getNameSpace() {
            return this.mNameSpace;
        }

        public String getAttributeName() {
            return this.mAttributeName;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("\"");
            res.append(this.mNameSpace);
            res.append("\"|->\"");
            res.append(this.mAttributeName);
            res.append("\" (type: ");
            switch (this.mType) {
                case 1: {
                    res.append("string");
                    break;
                }
                case 2: {
                    res.append("blob");
                    break;
                }
                case 0: {
                    res.append("unknown");
                }
            }
            res.append(")");
            return res.toString();
        }
    }
}

