/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.junittesting.util;

import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Tracer;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestSuiteHelper {
    private static final boolean IS_VERBOSE = true;
    private static int nNumberOfPackages = 0;
    private static int nNumberOfClassFiles = 0;
    private static int nNumberOfSourceFiles = 0;
    private static int nNumberOfJUnitTests = 0;
    private static Tracer logger = new Tracer(class$com$sapmarkets$junittesting$util$TestSuiteHelper == null ? (class$com$sapmarkets$junittesting$util$TestSuiteHelper = TestSuiteHelper.class$("com.sapmarkets.junittesting.util.TestSuiteHelper")) : class$com$sapmarkets$junittesting$util$TestSuiteHelper);
    private static String BASE_DIR;
    static /* synthetic */ Class class$com$sapmarkets$junittesting$util$TestSuiteHelper;

    public Test buildSuite(Class c) {
        return this.buildSuite(c, c.getName() + " test suite");
    }

    public Test buildSuite(Class c, String suiteName) {
        if (BASE_DIR == null && (BASE_DIR = System.getProperty("BASE_DIR")) == null) {
            throw new BAMRuntimeException(logger.getLocation(), "ALL_TESTS_FAILED_TO_RUN");
        }
        TestSuite suite = new TestSuite(suiteName);
        String packageName = c.getName().substring(0, c.getName().lastIndexOf("."));
        packageName = packageName.replace('.', File.separatorChar);
        String pathName = BASE_DIR + File.separator + packageName;
        logger.traceInfo("debug=> pathName: " + pathName);
        File currentDir = new File(pathName);
        File[] files = currentDir.listFiles();
        ArrayList<String> subDirs = new ArrayList<String>();
        ArrayList<String> localTests = new ArrayList<String>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    subDirs.add(files[i].getName());
                    logger.traceInfo("debug=> checking dir: " + files[i].getName() + ", package count = " + ++nNumberOfPackages);
                } else if (files[i].getName().endsWith("Test.class")) {
                    localTests.add(files[i].getName());
                    logger.traceInfo("debug=> added file: " + files[i].getName() + ", unit test count = " + ++nNumberOfJUnitTests);
                } else if (files[i].getName().endsWith(".class")) {
                    logger.traceInfo("debug=> non-test class file" + files[i].getName() + ", count = " + ++nNumberOfClassFiles);
                } else {
                    logger.traceInfo("debug=> non-test source file: " + files[i].getName() + ", count = " + ++nNumberOfSourceFiles);
                }
                ++i;
            }
        }
        this.addDescendantTests(subDirs, suite, packageName);
        this.addLocalTests(localTests, suite, packageName);
        return suite;
    }

    private void addDescendantTests(List subDirs, TestSuite suite, String packageName) {
        packageName = packageName.replace('\\', '.');
        Iterator itor = subDirs.iterator();
        while (itor.hasNext()) {
            String subdir = itor.next().toString();
            String testName = packageName + "." + subdir + ".AllTests";
            try {
                Class<?> cl = Class.forName(testName);
                Test t = (Test)cl.getMethod("suite", null).invoke(null, null);
                if (t == null) continue;
                suite.addTest(t);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void addLocalTests(List localTests, TestSuite suite, String packageName) {
        packageName = packageName.replace('\\', '.');
        Iterator itor = localTests.iterator();
        while (itor.hasNext()) {
            String localTest = itor.next().toString();
            try {
                localTest = localTest.substring(0, localTest.indexOf(".class"));
                Class<?> c = Class.forName(packageName + "." + localTest);
                Method suiteMethod = c.getDeclaredMethod("suite", null);
                suite.addTest((Test)suiteMethod.invoke(null, null));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

