/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.table;

import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.AbstractBufferTableModel;
import com.sapmarkets.bam.view.table.TableMap;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$table$TableSorter == null ? (class$com$sapmarkets$bam$view$table$TableSorter = TableSorter.class$("com.sapmarkets.bam.view.table.TableSorter")) : class$com$sapmarkets$bam$view$table$TableSorter);
    int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int compares;
    boolean isSorting;
    int previousSortedViewIndex = -1;
    boolean previousSortIsAscending = true;
    JTable tableView = null;
    static final ImageIcon[] arrowIcons = new ImageIcon[]{ViewUtil.getIcon("/images/arrow_up.gif"), ViewUtil.getIcon("/images/arrow_down.gif")};
    static final int UP_ARROW = 0;
    static final int DOWN_ARROW = 1;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$table$TableSorter;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TableSorter(TableModel model) {
        this.setModel(model);
        this.isSorting = false;
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public boolean isSorting() {
        return this.isSorting;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = this.model.getColumnClass(column);
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = TableSorter.class$("java.lang.Number")) : class$java$lang$Number)) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type.getSuperclass() == (class$java$util$Date == null ? (class$java$util$Date = TableSorter.class$("java.util.Date")) : class$java$util$Date) || type.getClass() == (class$java$util$Date == null ? (class$java$util$Date = TableSorter.class$("java.util.Date")) : class$java$util$Date)) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = TableSorter.class$("java.lang.String")) : class$java$lang$String)) {
            String s22;
            String s1 = (String)data.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableSorter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = data.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        int level = 0;
        while (level < this.sortingColumns.size()) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.ascending ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            this.indexes[row] = row;
            ++row;
        }
        this.resetState();
    }

    private void resetState() {
        if (null != this.tableView) {
            JLabel previousRenderer;
            TableColumnModel columnModel = this.tableView.getColumnModel();
            if (this.previousSortedViewIndex != -1 && null != (previousRenderer = (JLabel)((Object)columnModel.getColumn(this.previousSortedViewIndex).getHeaderRenderer()))) {
                previousRenderer.setIcon(null);
            }
        }
        this.previousSortedViewIndex = -1;
    }

    private void appendIndexes() {
        int rowCount = this.model.getRowCount();
        int[] tmpIndexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            tmpIndexes[row] = row < this.indexes.length ? this.indexes[row] : row;
            ++row;
        }
        this.indexes = tmpIndexes;
    }

    private void deleteIndex(int delRow) {
        int rowCount = this.model.getRowCount();
        int[] tmpIndexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            if (row < delRow) {
                tmpIndexes[row] = this.indexes[row];
            } else if (row >= delRow) {
                tmpIndexes[row] = this.indexes[row + 1];
            }
            ++row;
        }
        this.indexes = tmpIndexes;
    }

    public void tableChanged(TableModelEvent e) {
        if (null == this.indexes || this.indexes.length <= 1) {
            this.reallocateIndexes();
        } else if (e.getType() == 0) {
            if (e.getFirstRow() != e.getLastRow()) {
                this.reallocateIndexes();
            }
        } else if (e.getType() == 1) {
            if (e.getFirstRow() >= this.indexes.length) {
                this.appendIndexes();
            } else {
                this.reallocateIndexes();
            }
        } else if (e.getType() == -1) {
            if (e.getFirstRow() == e.getLastRow()) {
                int delRow = this.indexes[e.getFirstRow()];
                this.deleteIndex(delRow);
            } else {
                this.reallocateIndexes();
            }
        }
        super.tableChanged(e);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            mLogger.logError("TableModel Sorter not informed of a change in model.");
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        int i = 0;
        while (i < this.getRowCount()) {
            int j = i + 1;
            while (j < this.getRowCount()) {
                if (this.compare(this.indexes[i], this.indexes[j]) == -1) {
                    this.swap(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            int i = low;
            while (i < high) {
                to[i] = from[i];
                ++i;
            }
            return;
        }
        int i = low;
        while (i < high) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            ++i;
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        if (aRow + this.topIndex >= this.getRowCount()) {
            return "";
        }
        return this.model.getValueAt(this.indexes[aRow + this.topIndex], aColumn);
    }

    public int getIndexValueOfRow(int row) {
        return this.indexes[row];
    }

    public int findIndex(int idx) {
        int pos = -1;
        int i = 0;
        while (i < this.indexes.length) {
            if (this.indexes[i] == idx) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
        TableColumnModel columnModel = this.tableView.getColumnModel();
        JLabel curRenderer = (JLabel)((Object)columnModel.getColumn(column).getHeaderRenderer());
        if (null != curRenderer) {
            curRenderer.setIcon(this.ascending ? arrowIcons[0] : arrowIcons[1]);
        }
        this.previousSortedViewIndex = column;
    }

    public void reSort() {
        this.sort(this);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final TableSorter sorter = this;
        this.tableView = table;
        this.tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TableColumnModel columnModel = TableSorter.this.tableView.getColumnModel();
                    int viewIndex = TableSorter.this.tableView.columnAtPoint(e.getPoint());
                    int modelIndex = TableSorter.this.tableView.convertColumnIndexToModel(viewIndex);
                    if (modelIndex != -1) {
                        JLabel curRenderer;
                        JLabel previousRenderer;
                        boolean ascending = true;
                        if (TableSorter.this.previousSortedViewIndex != -1 && TableSorter.this.previousSortedViewIndex == viewIndex) {
                            ascending = !TableSorter.this.previousSortIsAscending;
                        }
                        TableSorter.this.previousSortIsAscending = ascending;
                        TableSorter.this.isSorting = true;
                        sorter.sortByColumn(modelIndex, ascending);
                        if (TableSorter.this.previousSortedViewIndex != -1 && TableSorter.this.previousSortedViewIndex != viewIndex && null != (previousRenderer = (JLabel)((Object)columnModel.getColumn(TableSorter.this.previousSortedViewIndex).getHeaderRenderer()))) {
                            previousRenderer.setIcon(null);
                        }
                        if (null != (curRenderer = (JLabel)((Object)columnModel.getColumn(viewIndex).getHeaderRenderer()))) {
                            curRenderer.setIcon(ascending ? arrowIcons[0] : arrowIcons[1]);
                        }
                        TableSorter.this.previousSortedViewIndex = viewIndex;
                    }
                }
            }
        };
        JTableHeader th = this.tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public int getIndexCount() {
        return this.indexes.length;
    }

    public void disableSorting() {
        this.isSorting = false;
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.logrecordDefinition;
    }

    public Object[] getColumnNames() {
        return ((AbstractBufferTableModel)this.model).getColumnNames();
    }

    public LogRecord getRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return ((AbstractBufferTableModel)this.model).getRow(this.indexes[rowIndex]);
        }
        return null;
    }

    public void updateRows(int firstRow, int lastRow) {
        this.fireTableRowsUpdated(firstRow, lastRow);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

