/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.table;

import com.sapmarkets.bam.view.overview.OverviewTableModel;
import com.sapmarkets.bam.view.table.TableSorter;
import javax.swing.table.TableModel;

public class OverviewTableSorter
extends TableSorter {
    OverviewTableModel otm;

    public OverviewTableSorter(TableModel model) {
        super(model);
        this.otm = (OverviewTableModel)model;
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Class<?> type = this.model.getColumnClass(column);
        if (!this.otm.isNameColumn(column) && !this.otm.isNumRecordsColumn(column)) {
            return super.compareRowsByColumn(row1, row2, column);
        }
        if (this.otm.isNameColumn(column)) {
            return this.compareNameCol(row1, row2, column);
        }
        if (this.otm.isNumRecordsColumn(column)) {
            return this.compareNumRecsColumn(row1, row2, column);
        }
        return 0;
    }

    private int compareNumRecsColumn(int row1, int row2, int column) {
        TableModel data = this.model;
        String s1 = (String)data.getValueAt(row1, column);
        String s2 = (String)data.getValueAt(row2, column);
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int s1IntVal = 0;
        int s2IntVal = 0;
        try {
            s1IntVal = new Integer(s1);
        }
        catch (Exception e) {
            s1IntVal = Integer.MIN_VALUE;
        }
        try {
            s2IntVal = new Integer(s2);
        }
        catch (Exception e) {
            s2IntVal = Integer.MIN_VALUE;
        }
        if (s1IntVal < s2IntVal) {
            return -1;
        }
        if (s1IntVal > s2IntVal) {
            return 1;
        }
        return 0;
    }

    private int compareNameCol(int row1, int row2, int column) {
        int result;
        TableModel data = this.model;
        String s1 = (String)data.getValueAt(row1, column);
        String s2 = (String)data.getValueAt(row2, column);
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        String openLogSeperator = OverviewTableModel.getOpenLogNameSeparator();
        if (s1.indexOf(openLogSeperator) > 0 && s1.indexOf(openLogSeperator) + openLogSeperator.length() < s1.length()) {
            s1 = s1.substring(s1.indexOf(openLogSeperator) + openLogSeperator.length());
        }
        if (s2.indexOf(openLogSeperator) > 0 && s2.indexOf(openLogSeperator) + openLogSeperator.length() < s2.length()) {
            s2 = s2.substring(s2.indexOf(openLogSeperator) + openLogSeperator.length());
        }
        if ((result = s1.compareToIgnoreCase(s2)) < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }
}

