/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.overview;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.overview.OverviewFacade;
import com.sapmarkets.bam.view.overview.OverviewTable;
import com.sapmarkets.bam.view.overview.OverviewTableModel;
import com.sapmarkets.bam.view.overview.OverviewWrapper;
import com.sapmarkets.bam.view.table.OverviewTableSorter;
import com.sapmarkets.bam.view.table.TableSorter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;

public class OverviewTableWrapper
extends OverviewWrapper {
    static OverviewTable mOverviewTable;
    private static OverviewTableModel mOverviewTableModel;
    private static TableSorter mTableSorter;
    private Map mArchiveNodes = new HashMap();

    public OverviewTableWrapper(ILogViewerApplication application, boolean isStandalone) {
        super(application, isStandalone);
        mOverviewTableModel = new OverviewTableModel(isStandalone);
        this.createTableWithSorting();
        mOverviewTable.addMouseListener(new OverviewTableMouseListener());
        mOverviewTable.addMouseListener(new OverviewTablePopupMenu());
        mOverviewTable.addKeyListener(new OverviewTableKeyListener());
    }

    private void createTable() {
        mOverviewTable = new OverviewTable(mOverviewTableModel);
    }

    private void createTableWithSorting() {
        mTableSorter = new OverviewTableSorter(mOverviewTableModel);
        mOverviewTable = new OverviewTable(mTableSorter);
        mOverviewTableModel.setSorter(mTableSorter);
        mTableSorter.addMouseListenerToHeaderInTable(mOverviewTable);
    }

    public JComponent getComponent() {
        return mOverviewTable;
    }

    public void populate() throws RemoteException, NotBoundException, MalformedURLException, Exception {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        mOverviewTable.clear();
    }

    public void setFocus() {
        mOverviewTable.requestFocus();
    }

    public void removeLogFile(LogDescriptor logDescriptor) {
        mOverviewTableModel.removeRow(logDescriptor);
    }

    public void removeSelectedLogFile() {
        LogFileNode logFileNode = this.getSelectedLogFileNode();
        if (logFileNode == null) {
            JOptionPane.showMessageDialog(OverviewWrapper.mApplication.getFrame(), "Please select a log first.");
            return;
        }
        LogDescriptor logDescriptor = logFileNode.getLogDescriptor();
        HostDescriptor hostDescriptor = this.getSelectedHostDescriptor();
        OverviewWrapper.mApplication.unregister(hostDescriptor, logDescriptor);
        mOverviewTable.removeSelectedRow();
    }

    public HostDescriptor getSelectedHostDescriptor() {
        HostDescriptor hostDescriptor = null;
        try {
            LogDescriptor logDescriptor = this.getSelectedLogFileNode().getLogDescriptor();
            Collection appNodeList = OverviewWrapper.mViewConfiguration.getMonitoredApplications();
            String key = logDescriptor.getApplicationName();
            Iterator itr = appNodeList.iterator();
            while (itr.hasNext()) {
                LogApplicationNode appNode = (LogApplicationNode)itr.next();
                if (!appNode.getHostDescriptor().getApplicationName().equals(key)) continue;
                hostDescriptor = appNode.getHostDescriptor();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostDescriptor;
    }

    public String getSelectionClusterID() {
        String hostName = null;
        try {
            LogDescriptor logDescriptor = this.getSelectedLogFileNode().getLogDescriptor();
            hostName = OverviewWrapper.isStandalone() ? logDescriptor.getHostName() : logDescriptor.getClusterNodeID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostName;
    }

    public LogDescriptor getSelectedLogDescriptor() {
        LogFileNode logFileNode = this.getSelectedLogFileNode();
        if (null != logFileNode) {
            return logFileNode.getLogDescriptor();
        }
        return null;
    }

    public LogFileNode getSelectedLogFileNode() {
        return mOverviewTableModel.getLogFileNode(mOverviewTable.getSelectedRow());
    }

    public static void directOpen() {
        int rows = mOverviewTable.getRowCount();
        mOverviewTable.setRowSelectionInterval(rows - 1, rows - 1);
        int srow = mOverviewTable.getSelectedRow();
        OverviewTableWrapper.openDirectLog(srow);
    }

    public static void openDirectLog(int selRow) {
        LogFileNode fileNode = mOverviewTableModel.getLogFileNode(selRow);
        if (fileNode.getState() == 1) {
            LogDescriptor ld = fileNode.getLogDescriptor().getLogDepot().getLogDescriptor(fileNode.getLogDescriptor().getObjectName());
            fileNode = new LogFileNode(ld);
        }
        if (null != fileNode) {
            ArrayList<LogFileNode> selectedFileNodes = new ArrayList<LogFileNode>();
            selectedFileNodes.add(fileNode);
            OverviewWrapper.mApplication.displayLogs(selectedFileNodes);
        }
    }

    public void SelectLog(int selRow) {
        if (mOverviewTable.getSelectedRows().length > 1) {
            OverviewWrapper.mApplication.logSelected(LogTypeEnumeration.SAPJLOG.toString());
            return;
        }
        LogFileNode logFileNode = mOverviewTableModel.getLogFileNode(selRow);
        if (null != logFileNode) {
            OverviewWrapper.mApplication.logSelected(logFileNode.getLogType());
        }
    }

    public void openLog(int selRow) {
        LogFileNode fileNode = mOverviewTableModel.getLogFileNode(selRow);
        if (fileNode.getState() == 1) {
            LogDescriptor ld = fileNode.getLogDescriptor().getLogDepot().getLogDescriptor(fileNode.getLogDescriptor().getObjectName());
            fileNode = new LogFileNode(ld);
        }
        if (null != fileNode) {
            this.setCursorType(3);
            ArrayList<LogFileNode> selectedFileNodes = new ArrayList<LogFileNode>();
            selectedFileNodes.add(fileNode);
            OverviewWrapper.mApplication.displayLogs(selectedFileNodes);
            this.setCursorType(0);
        }
    }

    public List getSelectedLogFileNodes() {
        ArrayList<LogFileNode> selectedDescriptors = new ArrayList<LogFileNode>();
        List selRows = mOverviewTable.getSelectedLogFileRows();
        Iterator rowSelItr = selRows.iterator();
        while (rowSelItr.hasNext()) {
            LogFileNode logFileNode = (LogFileNode)rowSelItr.next();
            selectedDescriptors.add(logFileNode);
        }
        return selectedDescriptors;
    }

    public void stateChanged(ChangeEvent event) {
        try {
            LogFileNode fileNode = (LogFileNode)event.getSource();
            mOverviewTableModel.rowStateChanged(fileNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogFileNode getFileNode(LogDescriptor fileDescriptor) {
        return mOverviewTableModel.getLogFileNode(fileDescriptor);
    }

    public void addArchiveNodes(LogFileNode logFileNode, Collection archiveNodes) {
        if (archiveNodes == null) {
            return;
        }
        Iterator itr = archiveNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode archiveNode = (LogFileNode)itr.next();
            if (this.getFileNode(archiveNode.getLogDescriptor()) != null) continue;
            this.mArchiveNodes.put(archiveNode, logFileNode);
            this.add(archiveNode);
        }
    }

    public void removeArchiveNodes(LogFileNode logFileNode) {
        if (logFileNode == null) {
            return;
        }
        Set fileNodes = mOverviewTableModel.getAllFileNode();
        Iterator itr = fileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode fileNode = (LogFileNode)itr.next();
            LogFileNode originalLog = (LogFileNode)this.mArchiveNodes.get(fileNode);
            if (originalLog == null || !fileNode.getLogDescriptor().getType().equals(LogTypeEnumeration.ARCHIVE_TYPE) || !originalLog.equals(logFileNode)) continue;
            this.mArchiveNodes.remove(fileNode);
            mOverviewTableModel.removeRow(fileNode.getLogDescriptor());
        }
    }

    public void add(LogFileNode fileNode) {
        mOverviewTableModel.addRow(fileNode);
        fileNode.addStateChangeListener(this);
    }

    public void allChanged() {
        mOverviewTableModel.fireTableChanged(new TableModelEvent(mOverviewTableModel));
    }

    private class TableSelectActionListener
    implements ActionListener {
        private TableSelectActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            if (source.getActionCommand().equals("Display Logs")) {
                this.displaySelectedLogs();
                return;
            }
            if (e.getActionCommand().equals("RefreshTree")) {
                OverviewWrapper.mApplication.refreshOverview();
                return;
            }
            if (e.getActionCommand().equals("AddLogFile")) {
                OverviewWrapper.mApplication.addFileListener();
            }
            if (e.getActionCommand().equals("AddLogDirectory")) {
                OverviewWrapper.mApplication.addDirectoryListener();
            }
            if (e.getActionCommand().equals("RemoveLogFile")) {
                OverviewWrapper.mApplication.removeSelectedLog();
            }
            if (e.getActionCommand().equals("ToggleOverviewDisplay")) {
                OverviewWrapper.mApplication.toggleOverviewDisplayMode();
                return;
            }
            if (e.getActionCommand().equals("HideBadLogs")) {
                OverviewWrapper.mApplication.hideBadLogs((JMenuItem)e.getSource());
                return;
            }
            if (e.getActionCommand().equals("Properties")) {
                OverviewWrapper.mApplication.showProperties();
            }
        }

        public void displaySelectedLogs() {
            List selRows = OverviewTableWrapper.this.getSelectedLogFileNodes();
            OverviewWrapper.mApplication.displayLogs(selRows);
        }
    }

    private class OverviewTablePopupMenu
    extends MouseAdapter {
        private OverviewTablePopupMenu() {
        }

        public void mousePressed(MouseEvent e) {
            this.showPopupMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }

        private void showPopupMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TableSelectActionListener anActionListener = new TableSelectActionListener();
                JPopupMenu aPopupMenu = new JPopupMenu();
                int selRow = mOverviewTable.getSelectedRow();
                if (selRow >= 0) {
                    List selLogFiles = mOverviewTable.getSelectedLogFileRows();
                    String menuName = selLogFiles != null && selLogFiles.size() > 1 ? "Merge files and display" : "Display file";
                    JMenuItem aMenuItem = new JMenuItem(menuName);
                    aMenuItem.setActionCommand("Display Logs");
                    aMenuItem.addActionListener(anActionListener);
                    aPopupMenu.add(aMenuItem);
                    aPopupMenu.addSeparator();
                    aMenuItem = new JMenuItem("Refresh Overview Table");
                    aMenuItem.setActionCommand("RefreshTree");
                    aMenuItem.addActionListener(anActionListener);
                    aPopupMenu.add(aMenuItem);
                    aMenuItem = new JMenuItem("View Logs As Tree");
                    aMenuItem.setActionCommand("ToggleOverviewDisplay");
                    aMenuItem.addActionListener(anActionListener);
                    aPopupMenu.add(aMenuItem);
                    aPopupMenu.addSeparator();
                    aMenuItem = new JMenuItem("Add a log file");
                    aMenuItem.setActionCommand("AddLogFile");
                    aMenuItem.addActionListener(anActionListener);
                    aPopupMenu.add(aMenuItem);
                    aMenuItem = new JMenuItem("Add Files from LogDirectory...");
                    aMenuItem.setActionCommand("AddLogDirectory");
                    aMenuItem.addActionListener(anActionListener);
                    aPopupMenu.add(aMenuItem);
                    aMenuItem = new JMenuItem(OverviewFacade.getHideBadFiles() ? "Show empty logs" : "Hide empty logs");
                    aMenuItem.setActionCommand("HideBadLogs");
                    aMenuItem.addActionListener(anActionListener);
                    aPopupMenu.add(aMenuItem);
                    LogFileNode logFileNode = mOverviewTableModel.getLogFileNode(selRow);
                    String userID = logFileNode.getLogDescriptor().getUser().toString();
                    if (userID.equalsIgnoreCase("Removable")) {
                        aPopupMenu.addSeparator();
                        aMenuItem = new JMenuItem("Remove this log file");
                        aMenuItem.setActionCommand("RemoveLogFile");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                    }
                    aMenuItem = new JMenuItem("Properties");
                    aMenuItem.setActionCommand("Properties");
                    aMenuItem.addActionListener(anActionListener);
                    aPopupMenu.add(aMenuItem);
                } else {
                    JMenuItem aMenuItem = new JMenuItem("View Logs As Tree");
                    aMenuItem.setActionCommand("ToggleOverviewDisplay");
                    aMenuItem.addActionListener(anActionListener);
                    aPopupMenu.add(aMenuItem);
                }
                aPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class OverviewTableKeyListener
    extends KeyAdapter {
        OverviewTableKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int selRow;
            if (e.getKeyCode() == 10 && (selRow = mOverviewTable.getSelectedRow()) != -1) {
                OverviewTableWrapper.this.openLog(selRow);
            }
        }
    }

    private class OverviewTableMouseListener
    extends MouseAdapter {
        private OverviewTableMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = mOverviewTable.getSelectedRow();
            if (selRow != -1) {
                if (e.getClickCount() == 1) {
                    OverviewTableWrapper.this.SelectLog(selRow);
                }
                if (e.getClickCount() == 2) {
                    OverviewTableWrapper.this.openLog(selRow);
                }
            }
        }
    }
}

