/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.overview;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.overview.OverviewWrapper;
import com.sapmarkets.bam.view.table.AbstractSortableTableModel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.event.TableModelEvent;

public class OverviewTableModel
extends AbstractSortableTableModel {
    protected static final String[] colHeads = new String[]{"Server", "Type", "State", "Name", "# New Records", "Length", "Last Modified"};
    public static final int SERVER_COL = 0;
    public static final int TYPE_COL = 1;
    public static final int STATE_COL = 2;
    public static final int NAME_COL = 3;
    public static final int NUM_RECS_COL = 4;
    public static final int LENGTH_COL = 5;
    public static final int MODIFIED_COL = 6;
    ArrayList mRowModelList = new ArrayList();
    private boolean isStandalone = false;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    public OverviewTableModel() {
        this.curSelection = -1;
    }

    public OverviewTableModel(boolean isStandalone) {
        this();
        this.isStandalone = isStandalone;
    }

    public void clear() {
        this.mRowModelList.clear();
    }

    public int getColumnCount() {
        return colHeads.length;
    }

    public int getRowCount() {
        return this.mRowModelList.size();
    }

    public Object getValueAt(int row, int col) {
        Object retValue = null;
        try {
            OverviewDisplayRow displayRow = (OverviewDisplayRow)this.mRowModelList.get(row);
            switch (col) {
                case 0: {
                    retValue = displayRow.getServerName();
                    break;
                }
                case 1: {
                    retValue = displayRow.getLogType();
                    break;
                }
                case 2: {
                    retValue = displayRow.getStateIcon();
                    break;
                }
                case 3: {
                    retValue = displayRow.getLogName();
                    break;
                }
                case 4: {
                    retValue = displayRow.getNumRecords();
                    break;
                }
                case 5: {
                    retValue = displayRow.getFileLength();
                    break;
                }
                case 6: {
                    retValue = displayRow.getModified();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Overview table error  [" + e.getMessage() + "] at getValueAt()!");
        }
        return retValue;
    }

    public String getColumnName(int col) {
        return colHeads[col];
    }

    public LogFileNode getLogFileNode(int selRow) {
        try {
            int row = this.getIndexValueOfRow(selRow);
            return ((OverviewDisplayRow)this.mRowModelList.get(row)).getLogFileNode();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void removeRow(int i) {
        int row = this.getIndexValueOfRow(i);
        this.removeRowUnmapped(row);
    }

    private void removeRowUnmapped(int row) {
        this.mRowModelList.remove(row);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addRow(LogFileNode logFileNode) {
        int rowNum = this.mRowModelList.size();
        OverviewDisplayRow displayRow = new OverviewDisplayRow(logFileNode);
        this.mRowModelList.add(displayRow);
        this.fireTableChanged(new TableModelEvent(this, rowNum, rowNum, -1, 1));
    }

    private void rowStateChanged(int rowNum) {
        if (rowNum >= 0) {
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }

    public void rowStateChanged(LogFileNode node) {
        int row = this.getUnmappedRowNum(node);
        if (row == -1) {
            return;
        }
        OverviewDisplayRow displayRow = (OverviewDisplayRow)this.mRowModelList.get(row);
        if (null != displayRow && node.getState() != displayRow.getState()) {
            displayRow.setState(node.getState());
            this.rowStateChanged(this.findIndex(row));
        }
    }

    private int getUnmappedRowNum(LogFileNode targetNode) {
        Iterator itr = ((AbstractList)this.mRowModelList).iterator();
        int i = 0;
        while (itr.hasNext()) {
            OverviewDisplayRow ovr = (OverviewDisplayRow)itr.next();
            LogFileNode fileNode = ovr.getLogFileNode();
            if (fileNode.equals(targetNode)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addRows(Collection logList) {
        this.mRowModelList.clear();
        if (!logList.isEmpty()) {
            Iterator itr = logList.iterator();
            int i = 0;
            while (itr.hasNext()) {
                LogFileNode logFileNode = (LogFileNode)itr.next();
                OverviewDisplayRow displayRow = new OverviewDisplayRow(logFileNode);
                this.mRowModelList.add(displayRow);
                ++i;
            }
        } else {
            OverviewDisplayRow displayRow = new OverviewDisplayRow();
            this.mRowModelList.add(displayRow);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 2) {
            return class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = OverviewTableModel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon;
        }
        if (columnIndex == 5) {
            return class$java$lang$Long == null ? (class$java$lang$Long = OverviewTableModel.class$("java.lang.Long")) : class$java$lang$Long;
        }
        return class$java$lang$String == null ? (class$java$lang$String = OverviewTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public void removeRow(LogDescriptor logDescriptor) {
        Iterator itr = ((AbstractList)this.mRowModelList).iterator();
        int i = 0;
        while (itr.hasNext()) {
            OverviewDisplayRow ovr = (OverviewDisplayRow)itr.next();
            LogFileNode fileNode = ovr.getLogFileNode();
            if (fileNode.getLogDescriptor().equals(logDescriptor)) {
                this.removeRowUnmapped(i);
                break;
            }
            ++i;
        }
    }

    public Set getAllFileNode() {
        HashSet<LogFileNode> fileNodes = new HashSet<LogFileNode>();
        Iterator itr = ((AbstractList)this.mRowModelList).iterator();
        while (itr.hasNext()) {
            OverviewDisplayRow ovr = (OverviewDisplayRow)itr.next();
            LogFileNode node = ovr.getLogFileNode();
            fileNodes.add(node);
        }
        return fileNodes;
    }

    public LogFileNode getLogFileNode(LogDescriptor fileDescriptor) {
        Iterator itr = ((AbstractList)this.mRowModelList).iterator();
        while (itr.hasNext()) {
            OverviewDisplayRow ovr = (OverviewDisplayRow)itr.next();
            LogFileNode node = ovr.getLogFileNode();
            if (!node.getLogDescriptor().equals(fileDescriptor)) continue;
            return node;
        }
        return null;
    }

    public boolean contains(LogFileNode lfn) {
        return this.getLogFileNode(lfn.getLogDescriptor()) != null;
    }

    public boolean isNameColumn(int colNum) {
        return colNum == 3;
    }

    public boolean isNumRecordsColumn(int colNum) {
        return colNum == 4;
    }

    public static String getOpenLogNameSeparator() {
        return ": ";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class OverviewDisplayRow {
        LogDescriptor logDescriptor = null;
        LogFileNode logFileNode = null;
        int state = 0;

        public OverviewDisplayRow() {
        }

        public Long getFileLength() {
            return this.logFileNode.getFileLength();
        }

        public String getNumRecords() {
            return this.logFileNode.getNumberOfLogRecords();
        }

        public OverviewDisplayRow(LogFileNode logFileNode) {
            this.state = logFileNode.getState();
            this.logDescriptor = logFileNode.getLogDescriptor();
            this.logFileNode = logFileNode;
        }

        public String getIndex() {
            return this.logFileNode.getIndex();
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public ImageIcon getStateIcon() {
            if (this.state == 1) {
                return OverviewWrapper.unconnectedIcon;
            }
            if (this.state == 2) {
                return OverviewWrapper.checkIcon;
            }
            if (this.state == 3) {
                return OverviewWrapper.closedAndOkIcon;
            }
            if (this.state == 5) {
                return OverviewWrapper.filelessIcon;
            }
            if (this.state == 4) {
                return OverviewWrapper.emptyIcon;
            }
            return null;
        }

        public String getLogName() {
            String displayName = "";
            displayName = this.getIndex() + OverviewTableModel.getOpenLogNameSeparator() + this.logDescriptor.getLogId().getURI();
            return displayName;
        }

        public LogFileNode getLogFileNode() {
            return this.logFileNode;
        }

        public String getLogType() {
            return this.logDescriptor.getSpecificLogType();
        }

        public String getServerName() {
            String serverName = "";
            if (null != this.logDescriptor) {
                if (OverviewTableModel.this.isStandalone) {
                    serverName = this.logDescriptor.getApplicationName();
                    serverName = serverName + " (" + this.logDescriptor.getHostName() + " : " + this.logDescriptor.getPort() + ")";
                } else {
                    serverName = this.logDescriptor.getClusterNodeName();
                }
            } else {
                serverName = "Not Connected";
            }
            return serverName;
        }

        public String getModified() {
            return this.logFileNode.getLastModifiedString();
        }
    }
}

