/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.overview;

import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.overview.OverviewTableModel;
import com.sapmarkets.bam.view.table.SortableTable;
import com.sapmarkets.bam.view.table.TableSorter;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OverviewTable
extends SortableTable {
    public OverviewTable(TableModel dm) {
        super(dm);
        this.setSelectionMode(2);
        this.setAutoResizeMode(0);
        this.configureColumnWidths(dm);
        int i = 0;
        while (i < dm.getColumnCount()) {
            this.getColumn(OverviewTableModel.colHeads[i]).setHeaderRenderer(this.createHeaderRenderer());
            ++i;
        }
    }

    private void configureColumnWidths(TableModel dm) {
        int avePixWidth = this.calcAvePixWidth();
        if (avePixWidth > 0) {
            TableColumn column = null;
            int i = 0;
            while (i < dm.getColumnCount()) {
                column = this.getColumnModel().getColumn(i);
                switch (i) {
                    case 1: {
                        column.setPreferredWidth(8 * avePixWidth);
                        break;
                    }
                    case 2: {
                        column.setPreferredWidth(4 * avePixWidth);
                        break;
                    }
                    case 0: {
                        column.setPreferredWidth(16 * avePixWidth);
                        break;
                    }
                    case 3: {
                        column.setPreferredWidth(48 * avePixWidth);
                        break;
                    }
                    case 4: {
                        column.setPreferredWidth(16 * avePixWidth);
                        break;
                    }
                    case 5: {
                        column.setPreferredWidth(12 * avePixWidth);
                        break;
                    }
                    case 6: {
                        column.setPreferredWidth(30 * avePixWidth);
                        break;
                    }
                    default: {
                        column.setPreferredWidth(16 * avePixWidth);
                    }
                }
                ++i;
            }
        }
    }

    protected TableCellRenderer createHeaderRenderer() {
        DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        label.setHorizontalAlignment(0);
        return label;
    }

    public void clear() {
        this.getOverviewTableModel().clear();
        this.invalidate();
    }

    public OverviewTableModel getOverviewTableModel() {
        TableModel model = super.getModel();
        if (model instanceof TableSorter) {
            return (OverviewTableModel)((TableSorter)model).getModel();
        }
        return (OverviewTableModel)model;
    }

    public void removeSelectedRow() {
        this.getOverviewTableModel().removeRow(this.getSelectedRow());
        this.invalidate();
    }

    public List getSelectedLogFileRows() {
        ArrayList<LogFileNode> selLogFileRows = new ArrayList<LogFileNode>();
        int[] selRows = this.getSelectedRows();
        int i = 0;
        while (i < selRows.length) {
            LogFileNode curLogFile = this.getOverviewTableModel().getLogFileNode(selRows[i]);
            if (null != curLogFile) {
                selLogFileRows.add(curLogFile);
            }
            ++i;
        }
        return selLogFileRows;
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.getKeyCode() == 10) {
            if (pressed) {
                boolean test = false;
            }
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    protected int calcAvePixWidth() {
        FontMetrics fm = ((Component)this).getFontMetrics(this.getFont());
        int[] widths = fm.getWidths();
        int total = 0;
        int i = 0;
        while (i < widths.length) {
            total += widths[i];
            ++i;
        }
        int result = 0;
        if (widths.length > 0) {
            result = total / widths.length + 1;
        }
        return result;
    }
}

