/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.overview;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.MonitorableFileHandler;
import com.sapmarkets.bam.application.logdepot.HostLogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.application.logdepot.VALogDepot;
import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.jmxadapter.util.LogDirectory;
import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.AddFileStandalone;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.LogClusterNode;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.LogGroupNode;
import com.sapmarkets.bam.view.LogViewerApplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.overview.LogFilePathTree;
import com.sapmarkets.bam.view.overview.OverviewFacade;
import com.sapmarkets.bam.view.overview.OverviewTableWrapper;
import com.sapmarkets.bam.view.overview.OverviewWrapper;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OverviewFilePathTreeWrapper
extends OverviewWrapper {
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$view$overview$OverviewFilePathTreeWrapper == null ? (class$com$sapmarkets$bam$view$overview$OverviewFilePathTreeWrapper = OverviewFilePathTreeWrapper.class$("com.sapmarkets.bam.view.overview.OverviewFilePathTreeWrapper")) : class$com$sapmarkets$bam$view$overview$OverviewFilePathTreeWrapper);
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$view$overview$OverviewFilePathTreeWrapper == null ? (class$com$sapmarkets$bam$view$overview$OverviewFilePathTreeWrapper = OverviewFilePathTreeWrapper.class$("com.sapmarkets.bam.view.overview.OverviewFilePathTreeWrapper")) : class$com$sapmarkets$bam$view$overview$OverviewFilePathTreeWrapper);
    private LogFilePathTree mTree;
    private Map logFileNodes;
    private DataFlavor[] flavors;
    private Transferable tr;
    public static List filelist;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$overview$OverviewFilePathTreeWrapper;

    public OverviewFilePathTreeWrapper(ILogViewerApplication application, boolean isStandalone) {
        super(application, isStandalone);
        if (isStandalone) {
            this.mTree = new LogFilePathTree();
            this.initDragDrop();
        } else {
            this.mTree = new LogFilePathTree(new DefaultMutableTreeNode("Nodes"));
        }
        this.mTree.setRootVisible(false);
        this.mTree.addMouseListener(new TreeMouseListener());
        this.mTree.addMouseListener(new TreeSelectPopupMenu());
        this.mTree.addKeyListener(new TreeKeyListener());
    }

    public JComponent getComponent() {
        return this.mTree;
    }

    public void populate() throws RemoteException, NotBoundException, MalformedURLException, Exception {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.mTree.clear();
    }

    public void clear(LogGroupNode rootNode) {
        DefaultMutableTreeNode treeRoot = this.mTree.findLogGroupNode(rootNode);
        this.mTree.clear(treeRoot);
    }

    public void refresh() {
        this.mTree.repaint();
    }

    public void setFocus() {
        this.mTree.requestFocus();
    }

    public void removeSelectedLogFile() {
        TreePath treePath = this.mTree.getSelectionPath();
        if (treePath == null) {
            JOptionPane.showMessageDialog(OverviewWrapper.mApplication.getFrame(), "Please select an application node or a log file node first.");
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (treeNode.getUserObject() instanceof LogFileNode) {
            LogFileNode logFileNode = (LogFileNode)treeNode.getUserObject();
            LogDescriptor logDescriptor = logFileNode.getLogDescriptor();
            treeNode = (DefaultMutableTreeNode)treeNode.getParent();
            HostDescriptor hostDescriptor = ((LogApplicationNode)treeNode.getUserObject()).getHostDescriptor();
            OverviewWrapper.mApplication.unregister(hostDescriptor, logDescriptor);
            this.mTree.removeCurrentNode();
            this.mTree.contract(this.mTree.getRoot());
        }
    }

    public void removeLogFile(LogDescriptor logDescriptor) {
        if (OverviewWrapper.mViewConfiguration.getMonitoredApplications() != null) {
            Iterator itr = this.mTree.getApplicationNodes().iterator();
            while (itr.hasNext()) {
                DefaultMutableTreeNode appNode = (DefaultMutableTreeNode)itr.next();
                Collection logFileNodes = this.mTree.getFileNodes(appNode);
                Iterator nodeItr = logFileNodes.iterator();
                while (nodeItr.hasNext()) {
                    LogFileNode fileNode = (LogFileNode)nodeItr.next();
                    if (!fileNode.getLogDescriptor().equals(logDescriptor)) continue;
                    this.mTree.removeNode(this.mTree.getRoot(), fileNode);
                    return;
                }
            }
        }
    }

    public HostDescriptor getSelectedHostDescriptor() {
        TreePath treePath = this.mTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        HostDescriptor hostDescriptor = null;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        while (!(treeNode.getUserObject() instanceof LogApplicationNode)) {
            treeNode = (DefaultMutableTreeNode)treeNode.getParent();
        }
        hostDescriptor = ((LogApplicationNode)treeNode.getUserObject()).getHostDescriptor();
        return hostDescriptor;
    }

    public String getSelectionClusterID() {
        TreePath treePath = this.mTree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (treeNode.getUserObject() instanceof LogFileNode || treeNode.getUserObject() instanceof LogClusterNode || treeNode.getUserObject() instanceof String) {
                TRACE.traceInfo("TreeNode is instance of " + treeNode.getUserObject().getClass() + " indicating the directory with the value " + treeNode.getUserObject().toString());
                while (!(treeNode.getUserObject() instanceof LogClusterNode)) {
                    treeNode = (DefaultMutableTreeNode)treeNode.getParent();
                }
                TRACE.traceInfo("treeNode is a " + treeNode.getUserObject().getClass() + " with the ID:" + ((LogClusterNode)treeNode.getUserObject()).getID());
                return ((LogClusterNode)treeNode.getUserObject()).getID();
            }
            if (treeNode.getUserObject() instanceof LogApplicationNode) {
                treeNode = (DefaultMutableTreeNode)treeNode.getFirstChild();
                TRACE.traceInfo("treeNode is a " + treeNode.getUserObject().getClass() + " with the ID:" + ((LogClusterNode)treeNode.getUserObject()).getID());
                return ((LogClusterNode)treeNode.getUserObject()).getID();
            }
            TRACE.traceInfo("treeNode is wether an instance of LogFileNode nor LogApplicationNode. It is a " + treeNode.getUserObject().getClass() + " and has the value:" + treeNode.getUserObject().toString());
        }
        return null;
    }

    public LogDescriptor getSelectedLogDescriptor() {
        Object obj;
        TreePath treePath = this.mTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        LogDescriptor logDescriptor = null;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (treeNode.getUserObject() instanceof LogFileNode) {
            logDescriptor = ((LogFileNode)treeNode.getUserObject()).getLogDescriptor();
        } else if ((treeNode.getUserObject() instanceof LogApplicationNode || treeNode.getUserObject() instanceof LogClusterNode || treeNode.getUserObject() instanceof String) && (obj = (treeNode = treeNode.getFirstLeaf()).getUserObject()) instanceof LogFileNode) {
            logDescriptor = ((LogFileNode)obj).getLogDescriptor();
        }
        return logDescriptor;
    }

    public void openLog(int selRow, TreePath selPath) {
        try {
            this.setCursorType(3);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof LogFileNode) {
                LogFileNode fileNode = (LogFileNode)node.getUserObject();
                if (fileNode.getState() == 1 || fileNode.getState() == 4 || fileNode.getState() == 5) {
                    LogDescriptor ld = fileNode.getLogDescriptor().getLogDepot().getLogDescriptor(fileNode.getLogDescriptor().getObjectName());
                    fileNode.init(ld);
                }
                fileNode.setException(null);
                try {
                    ArrayList<LogFileNode> selectedLogFileNodes = new ArrayList<LogFileNode>();
                    selectedLogFileNodes.add(fileNode);
                    OverviewWrapper.mApplication.displayLogs(selectedLogFileNodes);
                }
                catch (BAMSysRuntimeException ex) {
                    ExceptionDialog.showErrorMessage(OverviewWrapper.mApplication.getFrame(), (Throwable)((Object)ex), "Please try reconnecting to the server via (File->Configuration...).");
                }
            }
            Object var8_8 = null;
            this.setCursorType(0);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.setCursorType(0);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveSubtreeAsLogdir(DefaultMutableTreeNode treeNode, File saveTofile) {
        FileWriter writer = null;
        writer = new FileWriter(saveTofile);
        writer.write("<logs>");
        this.saveTree(treeNode, writer);
        writer.write("</logs>");
        Object var6_4 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException e1) {}
        return;
        {
            catch (IOException ioex) {
                LOG.logError("Writing to Log Directory `" + saveTofile + "` caused an error: " + ioex.getMessage());
                JOptionPane.showMessageDialog(OverviewWrapper.mApplication.getFrame(), ioex.getMessage(), "Error writing to '" + saveTofile.toString() + "`", 0);
                Object var6_5 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException e1) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void saveTree(DefaultMutableTreeNode treeNode, OutputStreamWriter writer) throws IOException {
        if (treeNode.getUserObject() instanceof LogFileNode) {
            LogFileNode aNode = (LogFileNode)treeNode.getUserObject();
            LogDescriptor ld = aNode.getLogDescriptor();
            LogDirectory.writeOneLogDirectoryEntry(writer, (String)ld.getAttribute("AbsoluteLogPattern"), ld.getAttribute("FormatterType").toString(), (Integer)ld.getAttribute("FileLimit"), (Integer)ld.getAttribute("FileCount"), null, null, ld.getObjectName());
        }
        Enumeration<TreeNode> children = treeNode.children();
        while (children.hasMoreElements()) {
            this.saveTree((DefaultMutableTreeNode)children.nextElement(), writer);
        }
    }

    public LogFileNode getSelectedLogFileNode() {
        TreePath treePath = this.mTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (treeNode.getUserObject() instanceof LogFileNode) {
            return (LogFileNode)treeNode.getUserObject();
        }
        return null;
    }

    public List getSelectedLogFileNodes() {
        TreePath[] aTreePathArray = this.mTree.getSelectionPaths();
        ArrayList<LogFileNode> selectedDescriptors = new ArrayList<LogFileNode>();
        int i = 0;
        while (i < aTreePathArray.length) {
            Object[] objArray = aTreePathArray[i].getPath();
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)objArray[objArray.length - 1];
            if (treeNode.getUserObject() instanceof LogFileNode) {
                LogFileNode logFileNode = (LogFileNode)treeNode.getUserObject();
                selectedDescriptors.add(logFileNode);
            }
            ++i;
        }
        return selectedDescriptors;
    }

    public void stateChanged(ChangeEvent event) {
        try {
            LogFileNode fileNode = (LogFileNode)event.getSource();
            LogFilePathTree LogFilePathTree2 = (LogFilePathTree)this.getComponent();
            LogFilePathTree2.nodeStateChanged(fileNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addNew(DefaultMutableTreeNode logGroupTreeNode, LogFileNode fileNode) {
        LogFilePathTree logFilePathTree = (LogFilePathTree)this.getComponent();
        fileNode.addStateChangeListener(this);
        DefaultMutableTreeNode fileTreeNode = logFilePathTree.addObject(logGroupTreeNode, fileNode, false);
    }

    public void add(LogGroupNode logGroupNode, LogFileNode fileNode) {
        LogFilePathTree logFilePathTree = (LogFilePathTree)this.getComponent();
        fileNode.addStateChangeListener(this);
        DefaultMutableTreeNode fileTreeNode = logFilePathTree.addFileNode(logGroupNode, fileNode);
        logFilePathTree.contract(logGroupNode);
    }

    public void addAll(LogGroupNode rootNode, Collection fileNodes) {
        Set sortedFileNodes = this.sortFileNodesByPath(fileNodes);
        LogFilePathTree logFilePathTree = (LogFilePathTree)this.getComponent();
        Iterator itr = sortedFileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode fileNode = (LogFileNode)itr.next();
            fileNode.addStateChangeListener(this);
            DefaultMutableTreeNode fileTreeNode = logFilePathTree.addFileNode(rootNode, fileNode);
            fileNode.setArchiveUpdated(false);
            OverviewFacade.populateArchiveNodes(fileNode);
        }
        logFilePathTree.contract(rootNode);
    }

    public void addArchiveNodes(LogFileNode fileNode, Collection archiveNodes) {
        LogFilePathTree logFilePathTree = (LogFilePathTree)this.getComponent();
        fileNode.addStateChangeListener(this);
        DefaultMutableTreeNode logTreeNode = logFilePathTree.findLogFileNode(fileNode);
        Iterator itr = archiveNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode archiveNode = (LogFileNode)itr.next();
            archiveNode.addStateChangeListener(this);
            logFilePathTree.addObject(logTreeNode, archiveNode, true);
        }
    }

    private Set sortFileNodesByPath(Collection fileNodes) {
        TreeSet sortedNodes = new TreeSet(new FileNodePathComparator());
        sortedNodes.addAll(fileNodes);
        return sortedNodes;
    }

    public LogFilePathTree getLogTree() {
        return this.mTree;
    }

    private String[] getTokenArray(String path) {
        StringTokenizer tokenizer = this.getTokenList(path);
        int numTokens = tokenizer.countTokens();
        String[] tokens = new String[numTokens];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    private StringTokenizer getTokenList(String filepath) {
        return new StringTokenizer(filepath, LogFileNode.FileSeparatorString, false);
    }

    public void initDragDrop() {
        DropTargetListener dropTargetListener = new DropTargetListener(){

            public void drop(DropTargetDropEvent e) {
                try {
                    OverviewFilePathTreeWrapper.this.tr = e.getTransferable();
                    OverviewFilePathTreeWrapper.access$602(OverviewFilePathTreeWrapper.this, OverviewFilePathTreeWrapper.this.tr.getTransferDataFlavors());
                    int i = 0;
                    while (i < OverviewFilePathTreeWrapper.this.flavors.length) {
                        if (OverviewFilePathTreeWrapper.this.flavors[i].isFlavorJavaFileListType()) {
                            e.acceptDrop(e.getDropAction());
                            filelist = (List)OverviewFilePathTreeWrapper.this.tr.getTransferData(DataFlavor.javaFileListFlavor);
                            LogViewerApplication.isDrop = true;
                            OverviewFilePathTreeWrapper.this.setCursorType(3);
                            OverviewFilePathTreeWrapper.this.addDropNode();
                        }
                        e.dropComplete(true);
                        int rows = OverviewTableWrapper.mOverviewTable.getRowCount();
                        int idx = 1;
                        while (idx < AddFileStandalone.fileCount + 1) {
                            OverviewTableWrapper.openDirectLog(rows - idx);
                            ++idx;
                        }
                        AddFileStandalone.fileCount = 0;
                        OverviewFilePathTreeWrapper.this.setCursorType(0);
                        ++i;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                e.rejectDrop();
            }

            public void dragEnter(DropTargetDragEvent dte) {
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }
        };
        DropTarget dropTarget = new DropTarget(this.mTree, dropTargetListener);
    }

    public void addDropNode() {
        JFrame frame = LogViewerApplication.dropFrame;
        HostDescriptor hostDescriptor = LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__;
        String clusterNodeID = "\"\"";
        HostLogDepot logDepot = LogDepotFactory.getHostLogDepot(hostDescriptor, clusterNodeID);
        MonitorableFileHandler fileMonitorHandler = new MonitorableFileHandler(logDepot);
        MetaDataOfReaders mdor = logDepot.getMetaDataOfReaders();
        List formats = mdor.getFileReadingCapableFormats();
        if (formats == null) {
            JOptionPane.showMessageDialog(frame, "The selected system reports no available formats.\nThis is a installation or configuration error.", "Error", 0);
            return;
        }
        String[] formatArray = new String[formats.size()];
        int i = 0;
        int j = 0;
        while (i < LogViewerApplication.FORMAT_ORDER.length) {
            if (formats.contains(LogViewerApplication.FORMAT_ORDER[i])) {
                formatArray[j++] = LogViewerApplication.FORMAT_ORDER[i];
            }
            ++i;
        }
        AddFileStandalone addFileDialog = new AddFileStandalone(LogViewerApplication.logViewer, ViewUtil.getOwnerFrame(frame), fileMonitorHandler, formatArray);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ DataFlavor[] access$602(OverviewFilePathTreeWrapper x0, DataFlavor[] x1) {
        x0.flavors = x1;
        return x1;
    }

    class TreeKeyListener
    extends KeyAdapter {
        TreeKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                TreePath selPath = OverviewFilePathTreeWrapper.this.mTree.getSelectionPath();
                int selRow = OverviewFilePathTreeWrapper.this.mTree.getSelectionRows()[0];
                if (selPath != null) {
                    OverviewFilePathTreeWrapper.this.openLog(selRow, selPath);
                }
            }
        }
    }

    class FileNodePathComparator
    implements Comparator {
        FileNodePathComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            String path1 = ((LogFileNode)o1).getNormalizedURI();
            String path2 = ((LogFileNode)o2).getNormalizedURI();
            String[] path1Tokens = OverviewFilePathTreeWrapper.this.getTokenArray(path1);
            String[] path2Tokens = OverviewFilePathTreeWrapper.this.getTokenArray(path2);
            if (path1Tokens.length == 0) {
                return 1;
            }
            if (path2Tokens.length == 0) {
                return -1;
            }
            boolean reverseComparison = false;
            if (path2Tokens.length > path1Tokens.length) {
                String[] temp = path1Tokens;
                path1Tokens = path2Tokens;
                path2Tokens = temp;
                reverseComparison = true;
            }
            int i = 0;
            while (i < path1Tokens.length) {
                if (path2Tokens.length - 1 == i) {
                    if (reverseComparison) {
                        return -1;
                    }
                    return 1;
                }
                String token1 = path1Tokens[i];
                String token2 = path2Tokens[i];
                if (!token1.equalsIgnoreCase(token2)) {
                    if (reverseComparison) {
                        return token1.compareToIgnoreCase(token2) * -1;
                    }
                    return token1.compareToIgnoreCase(token2);
                }
                ++i;
            }
            return 0;
        }
    }

    private class TreeSelectActionListener
    implements ActionListener {
        private TreeSelectActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            if (source.getActionCommand().equals("Display Logs")) {
                List selRows = OverviewFilePathTreeWrapper.this.getSelectedLogFileNodes();
                OverviewWrapper.mApplication.displayLogs(selRows);
                return;
            }
            LogFileNode node = OverviewFilePathTreeWrapper.this.getSelectedLogFileNode();
            if (e.getActionCommand().equals("RefreshTree")) {
                OverviewWrapper.mApplication.refreshOverview();
                return;
            }
            if (e.getActionCommand().equals("SaveSubTreeAsLogDir")) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showSaveDialog((AbstractLogViewerAppplication)OverviewWrapper.mApplication);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    if (OverviewFilePathTreeWrapper.this.mTree.getSelectionPath() == null) {
                        return;
                    }
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)OverviewFilePathTreeWrapper.this.mTree.getSelectionPath().getLastPathComponent();
                    OverviewFilePathTreeWrapper.this.saveSubtreeAsLogdir(treeNode, file);
                }
                return;
            }
            if (e.getActionCommand().equals("RefreshSubTree")) {
                DefaultMutableTreeNode parentNode;
                Object parentObj;
                TreePath treePath = OverviewFilePathTreeWrapper.this.mTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object obj = treeNode.getUserObject();
                if (obj instanceof LogApplicationNode) {
                    if (OverviewWrapper.mApplication instanceof LogViewerApplication) {
                        OverviewWrapper.mApplication.refreshApplicationNode((LogApplicationNode)obj);
                    } else {
                        OverviewWrapper.mApplication.refreshOverview();
                    }
                } else if (obj instanceof LogClusterNode && (parentObj = (parentNode = (DefaultMutableTreeNode)treeNode.getParent()).getUserObject()) instanceof LogApplicationNode) {
                    OverviewWrapper.mApplication.refreshClusterNode((LogApplicationNode)parentObj, (LogClusterNode)obj);
                }
                return;
            }
            if (e.getActionCommand().equals("AddLogFile")) {
                OverviewWrapper.mApplication.addFileListener();
                return;
            }
            if (e.getActionCommand().equals("AddLogDirectory")) {
                OverviewWrapper.mApplication.addDirectoryListener();
                return;
            }
            if (e.getActionCommand().equals("SetAttribute")) {
                OverviewWrapper.mApplication.showAttributeDialog();
                return;
            }
            if (e.getActionCommand().equals("RemoveLogFile")) {
                OverviewWrapper.mApplication.removeSelectedLog();
                return;
            }
            if (e.getActionCommand().equals("ToggleOverviewDisplay")) {
                OverviewWrapper.mApplication.toggleOverviewDisplayMode();
                return;
            }
            if (e.getActionCommand().equals("Properties")) {
                OverviewWrapper.mApplication.showProperties();
            }
            if (e.getActionCommand().equals("serverVersion")) {
                OverviewWrapper.mApplication.showServerProperties();
            }
            if (e.getActionCommand().equals("HideBadLogs")) {
                OverviewWrapper.mApplication.hideBadLogs((JMenuItem)e.getSource());
            }
        }
    }

    private class TreeSelectPopupMenu
    extends MouseAdapter {
        private TreeSelectPopupMenu() {
        }

        public void mousePressed(MouseEvent e) {
            this.showPopupMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }

        private void showPopupMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int selRow = OverviewFilePathTreeWrapper.this.mTree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = OverviewFilePathTreeWrapper.this.mTree.getSelectionPath();
                if (selPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                    if (node.isRoot()) {
                        return;
                    }
                    Object userObject = node.getUserObject();
                    TreeSelectActionListener anActionListener = new TreeSelectActionListener();
                    JPopupMenu aPopupMenu = new JPopupMenu();
                    HostDescriptor hd = OverviewFilePathTreeWrapper.this.getSelectedHostDescriptor();
                    JMenuItem aMenuItem = new JMenuItem(OverviewFacade.getHideBadFiles() ? "Show empty logs" : "Hide empty logs");
                    aMenuItem.setActionCommand("HideBadLogs");
                    aMenuItem.addActionListener(anActionListener);
                    if (hd != null && !hd.isConnected()) {
                        aMenuItem.setEnabled(false);
                    }
                    aPopupMenu.add(aMenuItem);
                    if (!(userObject instanceof LogFileNode)) {
                        aMenuItem = new JMenuItem("Refresh Overview Tree");
                        aMenuItem.setActionCommand("RefreshTree");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        aMenuItem = new JMenuItem("Refresh this node");
                        aMenuItem.setActionCommand("RefreshSubTree");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        aMenuItem = new JMenuItem("Save sub-nodes as Log Directory");
                        aMenuItem.setActionCommand("SaveSubTreeAsLogDir");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        if (hd != null && !hd.isConnected()) {
                            aMenuItem.setEnabled(false);
                        }
                        aMenuItem = new JMenuItem("View Logs As Table");
                        aMenuItem.setActionCommand("ToggleOverviewDisplay");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        if (hd != null && !hd.isConnected()) {
                            aMenuItem.setEnabled(false);
                        }
                        aPopupMenu.addSeparator();
                        aMenuItem = new JMenuItem("Add a log file");
                        aMenuItem.setActionCommand("AddLogFile");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        if (hd != null && !hd.isConnected()) {
                            aMenuItem.setEnabled(false);
                        }
                        aMenuItem = new JMenuItem("Add Files from LogDirectory...");
                        aMenuItem.setActionCommand("AddLogDirectory");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        if (hd != null && !hd.isConnected()) {
                            aMenuItem.setEnabled(false);
                        }
                        aPopupMenu.addSeparator();
                        aMenuItem = new JMenuItem("Server Version");
                        aMenuItem.setActionCommand("serverVersion");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        if (hd != null && !hd.isConnected()) {
                            aMenuItem.setEnabled(false);
                        }
                        aPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (userObject instanceof LogFileNode) {
                        LogFileNode logFileNode = (LogFileNode)userObject;
                        TreePath[] aTreePathArray = OverviewFilePathTreeWrapper.this.mTree.getSelectionPaths();
                        String menuName = aTreePathArray != null && aTreePathArray.length > 1 ? "Merge files and display" : "Display file";
                        aMenuItem = new JMenuItem(menuName);
                        aMenuItem.setActionCommand("Display Logs");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        aPopupMenu.addSeparator();
                        aMenuItem = new JMenuItem("Refresh Overview Tree");
                        aMenuItem.setActionCommand("RefreshTree");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        aMenuItem = new JMenuItem("View Logs As Table");
                        aMenuItem.setActionCommand("ToggleOverviewDisplay");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        String userID = logFileNode.getLogDescriptor().getUser().toString();
                        if (logFileNode.getLogType().equals(LogTypeEnumeration.SAPJLOG.toString()) && !userID.equalsIgnoreCase("Removable") && !AbstractLogViewerAppplication.isStandalone()) {
                            aMenuItem = new JMenuItem("Set attribute");
                            aMenuItem.setActionCommand("SetAttribute");
                            aMenuItem.addActionListener(anActionListener);
                            aPopupMenu.add(aMenuItem);
                        }
                        if (userID.equalsIgnoreCase("Removable")) {
                            aPopupMenu.addSeparator();
                            aMenuItem = new JMenuItem("Remove this log file");
                            aMenuItem.setActionCommand("RemoveLogFile");
                            aMenuItem.addActionListener(anActionListener);
                            aPopupMenu.add(aMenuItem);
                        }
                        aMenuItem = new JMenuItem("Properties");
                        aMenuItem.setActionCommand("Properties");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                        aPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        aMenuItem = new JMenuItem("View Logs As Table");
                        aMenuItem.setActionCommand("ToggleOverviewDisplay");
                        aMenuItem.addActionListener(anActionListener);
                        aPopupMenu.add(aMenuItem);
                    }
                }
            }
        }

        private boolean isFromJ2EEEngine(LogFileNode logFileNode) {
            LogDepot logDepot = logFileNode.getLogDescriptor().getLogDepot();
            if (logDepot instanceof VALogDepot) {
                return true;
            }
            if (logDepot instanceof HostLogDepot) {
                HostDescriptor hd = ((HostLogDepot)logDepot).getHostDescriptor();
                return ConnectionProtocol.P4.equals(hd.getProtocol());
            }
            return false;
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = OverviewFilePathTreeWrapper.this.mTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = OverviewFilePathTreeWrapper.this.mTree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1) {
                if (e.getClickCount() == 2) {
                    OverviewFilePathTreeWrapper.this.openLog(selRow, selPath);
                }
                if ((e.getModifiers() & 4) == 4) {
                    if (OverviewFilePathTreeWrapper.this.mTree.getSelectionPaths() != null) {
                        boolean contains = false;
                        TreePath[] treePath = OverviewFilePathTreeWrapper.this.mTree.getSelectionPaths();
                        int i = 0;
                        while (i < treePath.length) {
                            if (selPath.equals(treePath[i])) {
                                contains = true;
                                break;
                            }
                            ++i;
                        }
                        if (!contains) {
                            OverviewFilePathTreeWrapper.this.mTree.setSelectionPath(selPath);
                        }
                    } else {
                        OverviewFilePathTreeWrapper.this.mTree.setSelectionPath(selPath);
                    }
                }
                if (e.getClickCount() == 1) {
                    this.SelectLog(selPath);
                    HostDescriptor hd = OverviewFilePathTreeWrapper.this.getSelectedHostDescriptor();
                    if (hd != null) {
                        if (!hd.isConnected()) {
                            OverviewWrapper.mApplication.changeStateOfToolBarAndMenu(false);
                        } else {
                            OverviewWrapper.mApplication.changeStateOfToolBarAndMenu(true);
                        }
                    }
                }
            }
        }

        public void SelectLog(TreePath selPath) {
            if (OverviewFilePathTreeWrapper.this.mTree.getSelectionPaths() != null && OverviewFilePathTreeWrapper.this.mTree.getSelectionPaths().length > 1) {
                OverviewWrapper.mApplication.logSelected(LogTypeEnumeration.SAPJLOG.toString());
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            Object value = node.getUserObject();
            if (node.isLeaf() && value instanceof LogFileNode) {
                LogFileNode logFileNode = (LogFileNode)value;
                OverviewWrapper.mApplication.logSelected(logFileNode.getLogType());
            } else {
                OverviewWrapper.mApplication.logSelected("ASCIILog");
            }
        }
    }
}

