/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.overview;

import com.sap.tc.logging.Location;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.jmx.connector.rmi.IntegratedServerPropertiesNotFoundException;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.LogClusterNode;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.LogGroupNode;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.config.IViewConfiguration;
import com.sapmarkets.bam.view.overview.LogFilePathTree;
import com.sapmarkets.bam.view.overview.OverviewFilePathTreeWrapper;
import com.sapmarkets.bam.view.overview.OverviewTable;
import com.sapmarkets.bam.view.overview.OverviewTableModel;
import com.sapmarkets.bam.view.overview.OverviewTableWrapper;
import com.sapmarkets.bam.view.overview.OverviewWrapper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OverviewFacade {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$view$overview$OverviewFacade == null ? (class$com$sapmarkets$bam$view$overview$OverviewFacade = OverviewFacade.class$("com.sapmarkets.bam.view.overview.OverviewFacade")) : class$com$sapmarkets$bam$view$overview$OverviewFacade);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$view$overview$OverviewFacade == null ? (class$com$sapmarkets$bam$view$overview$OverviewFacade = OverviewFacade.class$("com.sapmarkets.bam.view.overview.OverviewFacade")) : class$com$sapmarkets$bam$view$overview$OverviewFacade);
    protected static OverviewWrapper mDisplayedOverview;
    protected static OverviewFilePathTreeWrapper mFilePathOverview;
    protected static OverviewTableWrapper mTableOverview;
    protected static JPanel mOverviewPanel;
    protected static CardLayout overviewCL;
    protected static boolean isOverviewDisplayAsTree;
    protected static ILogViewerApplication mApplication;
    protected static IViewConfiguration mViewConfiguration;
    private static int mIndexCount;
    private static Map mFilePathTreeRootNodes;
    private static Map mGroupNodes;
    private static boolean mHideBadFiles;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$overview$OverviewFacade;

    public static JPanel createOverviewPanel(ILogViewerApplication application, boolean isStandalone) {
        mApplication = application;
        OverviewFacade.createOverview(application, isStandalone);
        overviewCL = new CardLayout();
        mOverviewPanel = new JPanel();
        mOverviewPanel.setLayout(overviewCL);
        JScrollPane filePathScrollPane = new JScrollPane(mFilePathOverview.getComponent());
        JScrollPane tableScrollPane = new JScrollPane(mTableOverview.getComponent());
        Dimension minimumSize = new Dimension(100, 50);
        tableScrollPane.setMinimumSize(minimumSize);
        mOverviewPanel.add((Component)filePathScrollPane, "FilePathPanel");
        mOverviewPanel.add((Component)tableScrollPane, "TablePanel");
        overviewCL.show(mOverviewPanel, OverviewFacade.getVisibleOverviewPanelID(application.isOverviewDisplayAsTree()));
        return mOverviewPanel;
    }

    protected static void createOverview(ILogViewerApplication application, boolean isStandalone) {
        mFilePathOverview = new OverviewFilePathTreeWrapper(application, isStandalone);
        mTableOverview = new OverviewTableWrapper(application, isStandalone);
        ToolTipManager.sharedInstance().registerComponent(mFilePathOverview.getComponent());
        ToolTipManager.sharedInstance().registerComponent(mTableOverview.getComponent());
        mDisplayedOverview = application.isOverviewDisplayAsTree() ? mFilePathOverview : mTableOverview;
    }

    public static void updateOverviewDisplayType(boolean isOverviewDisplayAsTree) {
        mDisplayedOverview = isOverviewDisplayAsTree ? mFilePathOverview : mTableOverview;
        overviewCL.show(mOverviewPanel, OverviewFacade.getVisibleOverviewPanelID(isOverviewDisplayAsTree));
    }

    protected static String getVisibleOverviewPanelID(boolean isOverviewDisplayAsTree) {
        if (isOverviewDisplayAsTree) {
            return "FilePathPanel";
        }
        return "TablePanel";
    }

    public static void setViewConfiguration(IViewConfiguration viewConfiguration) {
        mFilePathOverview.setViewConfiguration(viewConfiguration);
        mTableOverview.setViewConfiguration(viewConfiguration);
        mViewConfiguration = viewConfiguration;
    }

    public static void setHideBadFiles(boolean newState) {
        mHideBadFiles = newState;
    }

    public static boolean getHideBadFiles() {
        return mHideBadFiles;
    }

    public static void addLog(LogDescriptor ld) {
        mViewConfiguration.addLogDescriptor(ld);
        LogFileNode nodeToAdd = mViewConfiguration.createLogFileNode(ld);
        nodeToAdd.setUserAddedMode(true);
        String hostName = ld.getHostName();
        String clusterNodeName = ld.getClusterNodeName();
        String toAddAppName = ld.getApplicationName();
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        Collection monitoredApplications = mViewConfiguration.getMonitoredApplications();
        if (monitoredApplications != null) {
            Iterator itr = monitoredApplications.iterator();
            while (itr.hasNext()) {
                LogApplicationNode appNode = (LogApplicationNode)itr.next();
                if (!toAddAppName.equals(appNode.getApplicationName())) continue;
                if (appNode.isJ2EE630()) {
                    OverviewFacade.addClusterNode(logFilePathTree.getRoot(), appNode, nodeToAdd);
                    break;
                }
                OverviewFacade.addLogFileNode(logFilePathTree.getRoot(), appNode, nodeToAdd);
                break;
            }
        }
    }

    public static void populateOverview() {
        if (mViewConfiguration == null) {
            return;
        }
        try {
            LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
            logFilePathTree.setRootVisible(true);
            HashSet<String> allExpandedNodes = new HashSet<String>();
            Enumeration<TreeNode> e = logFilePathTree.getRoot().breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = new TreePath(node.getPath());
                if (!logFilePathTree.isExpanded(path)) continue;
                allExpandedNodes.add(path.toString());
            }
            try {
                mViewConfiguration.initializeViewConfiguration(mApplication.getConfiguratedConnections());
            }
            catch (IntegratedServerPropertiesNotFoundException ex) {
                LOG.logException((Throwable)((Object)ex));
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame((Component)((Object)mApplication)), (Throwable)((Object)ex), "Integrated server properties not found");
            }
            Collection monitoredApplications = mViewConfiguration.getMonitoredApplications();
            if (monitoredApplications != null) {
                TreePath path;
                DefaultMutableTreeNode node;
                Iterator itr = monitoredApplications.iterator();
                while (itr.hasNext()) {
                    LogApplicationNode appNode = (LogApplicationNode)itr.next();
                    DefaultMutableTreeNode appFPTreeNode = LogFilePathTree.findLogGroupNode(logFilePathTree.getRoot(), appNode);
                    if (appFPTreeNode != null) {
                        appFPTreeNode.setUserObject(appNode);
                    }
                    if (appNode.isJ2EE630()) {
                        OverviewFacade.populateClusterNodes(logFilePathTree.getRoot(), appNode);
                        continue;
                    }
                    OverviewFacade.populateLogFileNodes(logFilePathTree.getRoot(), appNode);
                }
                e = logFilePathTree.getRoot().breadthFirstEnumeration();
                while (e.hasMoreElements()) {
                    node = (DefaultMutableTreeNode)e.nextElement();
                    path = new TreePath(node.getPath());
                    if (!allExpandedNodes.contains(path.toString())) continue;
                    logFilePathTree.expandPath(path);
                }
                mApplication.initColumnSettingsForFilterPanel();
                e = logFilePathTree.getRoot().children();
                while (e.hasMoreElements()) {
                    node = (DefaultMutableTreeNode)e.nextElement();
                    path = new TreePath(node.getPath());
                    logFilePathTree.expandPath(path);
                }
                logFilePathTree.setRootVisible(false);
            }
        }
        catch (RemoteException rEx) {
            JOptionPane.showMessageDialog((Component)((Object)mApplication), ViewUtil.removeTabFromString(rEx.getMessage()), "Error", 0);
        }
        catch (NotBoundException nEx) {
            JOptionPane.showMessageDialog((Component)((Object)mApplication), ViewUtil.removeTabFromString(nEx.getMessage()), "Error", 0);
        }
        catch (MalformedURLException mEx) {
            JOptionPane.showMessageDialog((Component)((Object)mApplication), ViewUtil.removeTabFromString(mEx.getMessage()), "Error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)mApplication), ViewUtil.removeTabFromString(e.getMessage()), "Error", 0);
        }
    }

    public static void populateOverview(LogApplicationNode applicationNode) {
        if (mViewConfiguration == null) {
            return;
        }
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        LogApplicationNode appNode = mViewConfiguration.refreshApplicationNode(applicationNode);
        DefaultMutableTreeNode appFPTreeNode = LogFilePathTree.findLogGroupNode(logFilePathTree.getRoot(), applicationNode);
        if (appFPTreeNode != null) {
            appFPTreeNode.setUserObject(appNode);
        }
        if (appNode != null) {
            if (appNode.isJ2EE630()) {
                OverviewFacade.populateClusterNodes(logFilePathTree.getRoot(), appNode);
            } else {
                OverviewFacade.populateLogFileNodes(logFilePathTree.getRoot(), appNode);
            }
        }
    }

    public static void populateOverview(LogApplicationNode applicationNode, LogClusterNode clusterNode) {
        if (mViewConfiguration == null) {
            return;
        }
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        logFilePathTree.setRootVisible(true);
        LogClusterNode newClusterNode = mViewConfiguration.refreshClusterNode(applicationNode, clusterNode);
        if (newClusterNode != null) {
            DefaultMutableTreeNode appFPTreeNode = LogFilePathTree.findLogGroupNode(logFilePathTree.getRoot(), applicationNode);
            OverviewFacade.populateLogFileNodes(appFPTreeNode, newClusterNode);
        }
    }

    private static void populateClusterNodes(DefaultMutableTreeNode rootFilePathTreeNode, LogApplicationNode appNode) {
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        DefaultMutableTreeNode appFPTreeNode = LogFilePathTree.findLogGroupNode(rootFilePathTreeNode, appNode);
        if (appFPTreeNode == null) {
            logFilePathTree.addLogGroupNode(rootFilePathTreeNode, appNode);
            appFPTreeNode = LogFilePathTree.findLogGroupNode(rootFilePathTreeNode, appNode);
        }
        if (!appNode.isConnected()) {
            logFilePathTree.clear(appFPTreeNode);
            return;
        }
        List clusterNodes = appNode.getLogGroupNodes();
        Iterator iter = clusterNodes.iterator();
        while (iter.hasNext()) {
            LogClusterNode clusterNode = (LogClusterNode)iter.next();
            OverviewFacade.populateLogFileNodes(appFPTreeNode, clusterNode);
        }
    }

    public static void populateArchiveNodes(LogFileNode fileNode) {
        if (fileNode.isArchiveUpdated()) {
            return;
        }
        LogDescriptor ld = fileNode.getLogDescriptor();
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        DefaultMutableTreeNode logTreeNode = logFilePathTree.findLogFileNode(fileNode);
        mDisplayedOverview.setCursorType(3);
        OverviewFacade.removeArchiveNodes(fileNode);
        LogDepot logDepot = ld.getLogDepot();
        try {
            try {
                Set archiveNodes;
                block16: {
                    block15: {
                        List logDescriptors;
                        List archiveObjectNames = (ArrayList)ld.getAttribute("Archives");
                        if (archiveObjectNames == null) {
                            try {
                                archiveObjectNames = (List)logDepot.invokeMBeanMethod(ld.getObjectName(), "findArchives", null, null);
                            }
                            catch (BAMRuntimeException ex) {
                                LOG.logWarning("Old LogViewer servier is used. Warning for log: " + ld.getObjectName());
                            }
                        }
                        if (archiveObjectNames == null) {
                            archiveObjectNames = new ArrayList();
                        }
                        if ((archiveNodes = OverviewFacade.addArchiveNodes(fileNode, logDescriptors = logDepot.getLogDescriptors(archiveObjectNames))) == null) break block15;
                        if (!archiveNodes.isEmpty()) break block16;
                    }
                    Object var9_12 = null;
                    mDisplayedOverview.setCursorType(0);
                    return;
                }
                mFilePathOverview.addArchiveNodes(fileNode, archiveNodes);
                mTableOverview.addArchiveNodes(fileNode, archiveNodes);
            }
            catch (ReflectionException ex) {
                throw new BAMRuntimeException(Location.getLocation((Class)(class$com$sapmarkets$bam$view$overview$OverviewFacade == null ? (class$com$sapmarkets$bam$view$overview$OverviewFacade = OverviewFacade.class$("com.sapmarkets.bam.view.overview.OverviewFacade")) : class$com$sapmarkets$bam$view$overview$OverviewFacade)), ex);
            }
            catch (MBeanException ex) {
                throw new BAMRuntimeException(Location.getLocation((Class)(class$com$sapmarkets$bam$view$overview$OverviewFacade == null ? (class$com$sapmarkets$bam$view$overview$OverviewFacade = OverviewFacade.class$("com.sapmarkets.bam.view.overview.OverviewFacade")) : class$com$sapmarkets$bam$view$overview$OverviewFacade)), ex);
            }
            catch (InstanceNotFoundException ex) {
                throw new BAMRuntimeException(Location.getLocation((Class)(class$com$sapmarkets$bam$view$overview$OverviewFacade == null ? (class$com$sapmarkets$bam$view$overview$OverviewFacade = OverviewFacade.class$("com.sapmarkets.bam.view.overview.OverviewFacade")) : class$com$sapmarkets$bam$view$overview$OverviewFacade)), ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            mDisplayedOverview.setCursorType(0);
            throw throwable;
        }
        Object var9_13 = null;
        mDisplayedOverview.setCursorType(0);
        fileNode.setArchiveUpdated(true);
    }

    private static void populateLogFileNodes(DefaultMutableTreeNode appFilePathTreeNode, LogGroupNode groupNode) {
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        LogGroupNode existingGroupNode = (LogGroupNode)mGroupNodes.get(groupNode);
        List existingLogNodes = null;
        if (logFilePathTree.findLogGroupNode(groupNode) == null) {
            logFilePathTree.addLogGroupNode(appFilePathTreeNode, existingGroupNode == null ? groupNode : existingGroupNode);
        }
        if (existingGroupNode != null) {
            existingLogNodes = existingGroupNode.getLogFileNodes();
        } else {
            mGroupNodes.put(groupNode, groupNode);
        }
        if (groupNode.hasLogs()) {
            List nodesUnderGroupNode = groupNode.getLogFileNodes();
            ArrayList<LogFileNode> newNodes = new ArrayList<LogFileNode>();
            Iterator groupNodeItr = nodesUnderGroupNode.iterator();
            ArrayList<LogFileNode> nodesToAdd = new ArrayList<LogFileNode>();
            while (groupNodeItr.hasNext()) {
                LogFileNode fileNode = (LogFileNode)groupNodeItr.next();
                if (mHideBadFiles && !fileNode.isWorthDisplaying()) {
                    mTableOverview.removeLogFile(fileNode.getLogDescriptor());
                    continue;
                }
                if (existingLogNodes == null || !existingLogNodes.contains(fileNode)) {
                    int indexCount = OverviewFacade.getIndexCount();
                    fileNode.setIndex(Integer.toString(indexCount + 1));
                    OverviewFacade.increaseIndexCount();
                    if (existingGroupNode != null) {
                        existingGroupNode.addLogFileNode(fileNode);
                    }
                    newNodes.add(fileNode);
                } else {
                    LogFileNode foundNode = OverviewFacade.syncExistingNode(fileNode, existingLogNodes);
                    if (null != foundNode) {
                        nodesToAdd.add(foundNode);
                    }
                    mTableOverview.removeLogFile(fileNode.getLogDescriptor());
                    fileNode = foundNode;
                }
                mTableOverview.add(fileNode);
            }
            mFilePathOverview.clear(groupNode);
            nodesToAdd.addAll(newNodes);
            mFilePathOverview.addAll(groupNode, nodesToAdd);
        } else {
            DefaultMutableTreeNode groupFPTreeNode = LogFilePathTree.findLogGroupNode(appFilePathTreeNode, groupNode);
            Collection unconnectedNodes = logFilePathTree.getFileNodes(groupFPTreeNode);
            OverviewTable ot = (OverviewTable)mTableOverview.getComponent();
            OverviewTableModel otm = ot.getOverviewTableModel();
            Iterator unconnectedNodesItr = unconnectedNodes.iterator();
            while (unconnectedNodesItr.hasNext()) {
                LogFileNode fileNode = (LogFileNode)unconnectedNodesItr.next();
                if (!otm.contains(fileNode)) continue;
                otm.removeRow(fileNode.getLogDescriptor());
            }
            logFilePathTree.clear(groupFPTreeNode);
        }
    }

    public static LogFileNode syncExistingNode(LogFileNode targetNode, Collection logFileNodes) {
        LogFileNode returnNode = null;
        Iterator itr = logFileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode fileNode = (LogFileNode)itr.next();
            if (!fileNode.equals(targetNode)) continue;
            fileNode.setLogDescriptor(targetNode.getLogDescriptor());
            fileNode.setUserAddedMode(false);
            returnNode = fileNode;
            break;
        }
        return returnNode;
    }

    private static void addLogFileNode(DefaultMutableTreeNode appTreeNodeFP, LogGroupNode groupNode, LogFileNode nodeToAdd) {
        DefaultMutableTreeNode clusterTreeNodeFP;
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        LogGroupNode existingGroupNode = (LogGroupNode)mGroupNodes.get(groupNode);
        List existingLogNodes = null;
        if (existingGroupNode != null) {
            clusterTreeNodeFP = LogFilePathTree.findLogGroupNode(appTreeNodeFP, groupNode);
            existingLogNodes = existingGroupNode.getLogFileNodes();
        } else {
            clusterTreeNodeFP = logFilePathTree.addLogGroupNode(appTreeNodeFP, groupNode);
            mGroupNodes.put(groupNode, groupNode);
        }
        if (existingLogNodes == null || !existingLogNodes.contains(nodeToAdd)) {
            int indexCount = OverviewFacade.getIndexCount();
            nodeToAdd.setIndex(Integer.toString(indexCount + 1));
            OverviewFacade.increaseIndexCount();
            if (existingGroupNode != null) {
                existingGroupNode.addLogFileNode(nodeToAdd);
            }
            mFilePathOverview.addNew(clusterTreeNodeFP, nodeToAdd);
            mTableOverview.add(nodeToAdd);
        }
    }

    private static void addClusterNode(DefaultMutableTreeNode rootTreeNodeFP, LogGroupNode appNode, LogFileNode nodeToAdd) {
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        DefaultMutableTreeNode appTreeNodeFP = LogFilePathTree.findLogGroupNode(rootTreeNodeFP, appNode);
        if (appTreeNodeFP == null) {
            logFilePathTree.addLogGroupNode(rootTreeNodeFP, appNode);
            appTreeNodeFP = LogFilePathTree.findLogGroupNode(rootTreeNodeFP, appNode);
        }
        List clusterNodes = appNode.getLogGroupNodes();
        Iterator iter = clusterNodes.iterator();
        while (iter.hasNext()) {
            LogClusterNode clusterNode = (LogClusterNode)iter.next();
            if (!clusterNode.contains(nodeToAdd)) continue;
            OverviewFacade.addLogFileNode(appTreeNodeFP, clusterNode, nodeToAdd);
            break;
        }
    }

    public static void removeApplicationNodes(List applicationNodes) {
        LogFilePathTree logTree = mFilePathOverview.getLogTree();
        DefaultMutableTreeNode root = logTree.getRoot();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            LogApplicationNode treeNode;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof LogApplicationNode) || OverviewFacade.foundApplicationNode(applicationNodes, treeNode = (LogApplicationNode)userObject)) continue;
            List logFileNodes = treeNode.getLogFileNodes();
            if (logFileNodes != null) {
                int i = 0;
                while (i < logFileNodes.size()) {
                    LogFileNode fileNode = (LogFileNode)logFileNodes.get(i);
                    LogDescriptor logDescriptor = fileNode.getLogDescriptor();
                    OverviewFacade.removeLog(logDescriptor);
                    mApplication.closeOpenedLogFile(fileNode);
                    ++i;
                }
            }
            logTree.removeTreeNode(node);
        }
    }

    public static boolean foundApplicationNode(List applicationNodes, LogApplicationNode nodeToFind) {
        Iterator itr = applicationNodes.iterator();
        while (itr.hasNext()) {
            LogApplicationNode appNode = (LogApplicationNode)itr.next();
            if (!appNode.equals(nodeToFind)) continue;
            return true;
        }
        return false;
    }

    public static void removeArchiveNodes(LogFileNode fileNode) {
        LogFilePathTree logFilePathTree = (LogFilePathTree)mFilePathOverview.getComponent();
        logFilePathTree.removeAllChildren(fileNode);
        mTableOverview.removeArchiveNodes(fileNode);
    }

    public static void removeLog(LogDescriptor logDescriptor) {
        mFilePathOverview.removeLogFile(logDescriptor);
        mTableOverview.removeLogFile(logDescriptor);
        Iterator itr = mGroupNodes.values().iterator();
        while (itr.hasNext()) {
            LogGroupNode groupNode = (LogGroupNode)itr.next();
            OverviewFacade.removeLogNodeFromGroupNode(groupNode, logDescriptor);
        }
    }

    private static void removeLogNodeFromGroupNode(LogGroupNode groupNode, LogDescriptor ld) {
        List childGroupNodes = groupNode.getLogGroupNodes();
        if (childGroupNodes == null || childGroupNodes.isEmpty()) {
            List logNodes = groupNode.getLogFileNodes();
            if (logNodes == null) {
                return;
            }
            Iterator itr = logNodes.iterator();
            while (itr.hasNext()) {
                LogFileNode logNode = (LogFileNode)itr.next();
                if (!logNode.getLogDescriptor().equals(ld)) continue;
                groupNode.removeLogFileNode(logNode);
                return;
            }
        } else {
            Iterator itr = childGroupNodes.iterator();
            while (itr.hasNext()) {
                LogGroupNode childGroupNode = (LogGroupNode)itr.next();
                OverviewFacade.removeLogNodeFromGroupNode(childGroupNode, ld);
            }
        }
    }

    public static void removeSelectedLog() {
        OverviewFacade.removeLog(OverviewFacade.getSelectedLogDescriptor());
    }

    public static LogFileNode getSelectedLogFileNode() {
        return mDisplayedOverview.getSelectedLogFileNode();
    }

    public static List getSelectedLogFileNodes() {
        return mDisplayedOverview.getSelectedLogFileNodes();
    }

    public static LogDescriptor getSelectedLogDescriptor() {
        return mDisplayedOverview.getSelectedLogDescriptor();
    }

    public static HostDescriptor getSelectedHostDescriptor() {
        return mDisplayedOverview.getSelectedHostDescriptor();
    }

    public static void clear() {
        mFilePathOverview.clear();
        mTableOverview.clear();
        mFilePathTreeRootNodes.clear();
    }

    public static void broadcastRefresh() {
        mTableOverview.allChanged();
    }

    public static LogFileNode getFileNode(LogDescriptor logDescriptor) {
        return mTableOverview.getFileNode(logDescriptor);
    }

    public static void setFocus() {
        mDisplayedOverview.setFocus();
    }

    public static String getSelectionClusterID() {
        return mDisplayedOverview.getSelectionClusterID();
    }

    public static int getIndexCount() {
        return mIndexCount;
    }

    public static void increaseIndexCount() {
        ++mIndexCount;
    }

    public static Set addArchiveNodes(LogFileNode fileNode, List lds) {
        HashSet<LogFileNode> archiveNodes = new HashSet<LogFileNode>();
        Iterator itr = lds.iterator();
        while (itr.hasNext()) {
            LogDescriptor ld = (LogDescriptor)itr.next();
            LogFileNode archiveNode = fileNode.getArchive(ld);
            if (archiveNode == null) {
                archiveNode = mViewConfiguration.createArchiveLogFileNode(ld);
                int indexCount = OverviewFacade.getIndexCount();
                archiveNode.setIndex(Integer.toString(indexCount + 1));
                OverviewFacade.increaseIndexCount();
                fileNode.addArchive(archiveNode);
            }
            archiveNodes.add(archiveNode);
        }
        return archiveNodes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        isOverviewDisplayAsTree = true;
        mApplication = null;
        mViewConfiguration = null;
        mIndexCount = 0;
        mFilePathTreeRootNodes = null;
        mGroupNodes = new HashMap();
        mHideBadFiles = false;
        mFilePathTreeRootNodes = new HashMap();
    }
}

