/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.overview;

import com.sap.tc.logging.Location;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.LogGroupNode;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.overview.OverviewWrapper;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LogFilePathTree
extends JTree {
    protected DefaultMutableTreeNode mRoot;
    protected DefaultTreeModel mTreeModel;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private DefaultTreeCellRenderer mCellRenderer;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$overview$LogFilePathTree;

    public LogFilePathTree() {
        this.init(new DefaultMutableTreeNode("Application"));
    }

    public LogFilePathTree(DefaultMutableTreeNode root) {
        this.init(root);
    }

    public void init(DefaultMutableTreeNode root) {
        this.mRoot = root;
        this.mTreeModel = new DefaultTreeModel(this.mRoot);
        this.mTreeModel.addTreeModelListener(new MyTreeModelListener());
        this.setModel(this.mTreeModel);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(4);
        this.setShowsRootHandles(true);
        LogViewerTreeRenderer myRender = new LogViewerTreeRenderer();
        this.setCellRenderer(myRender);
    }

    public void setRoot(DefaultMutableTreeNode root) {
        this.mRoot = root;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.mRoot;
    }

    public Set getApplicationNodes() {
        HashSet<DefaultMutableTreeNode> childNodes = new HashSet<DefaultMutableTreeNode>();
        Enumeration<TreeNode> children = this.mRoot.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            childNodes.add(node);
        }
        return childNodes;
    }

    public static DefaultMutableTreeNode findLogGroupNode(DefaultMutableTreeNode parentNode, LogGroupNode logGroupNode) {
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            LogGroupNode treeNode;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof LogGroupNode) || !(treeNode = (LogGroupNode)userObject).equals(logGroupNode)) continue;
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode findLogGroupNodeAtRoot(LogGroupNode logGroupNode) {
        return LogFilePathTree.findLogGroupNode(this.mRoot, logGroupNode);
    }

    public DefaultMutableTreeNode findLogGroupNode(LogGroupNode logGroupNode) {
        DefaultMutableTreeNode returnVal = this.findLogGroupNodeAtRoot(logGroupNode);
        if (null == returnVal) {
            Iterator itr = this.getApplicationNodes().iterator();
            while (itr.hasNext()) {
                DefaultMutableTreeNode appTreeNode = (DefaultMutableTreeNode)itr.next();
                DefaultMutableTreeNode logGroupTreeNode = LogFilePathTree.findLogGroupNode(appTreeNode, logGroupNode);
                if (null == logGroupTreeNode) continue;
                returnVal = logGroupTreeNode;
                break;
            }
        }
        return returnVal;
    }

    public static DefaultMutableTreeNode findLogFileNode(DefaultMutableTreeNode parentNode, LogFileNode logFileNode) {
        Enumeration<TreeNode> nodeChildren = parentNode.children();
        while (nodeChildren.hasMoreElements()) {
            LogFileNode treeNode;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)nodeChildren.nextElement();
            Object childUserObject = childNode.getUserObject();
            if (childUserObject instanceof LogFileNode && (treeNode = (LogFileNode)childUserObject).equals(logFileNode)) {
                return childNode;
            }
            DefaultMutableTreeNode foundNode = LogFilePathTree.findLogFileNode(childNode, logFileNode);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public DefaultMutableTreeNode findLogFileNode(LogFileNode logFileNode) {
        return LogFilePathTree.findLogFileNode(this.mRoot, logFileNode);
    }

    public Collection getFileNodes(DefaultMutableTreeNode applicationNode) {
        HashSet<LogFileNode> childNodes = new HashSet<LogFileNode>();
        Enumeration<TreeNode> children = applicationNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            if (node.getUserObject() instanceof LogFileNode) {
                childNodes.add((LogFileNode)node.getUserObject());
            }
            childNodes.addAll(this.getFileNodes(node));
        }
        return childNodes;
    }

    public void clear() {
        this.mRoot.removeAllChildren();
        this.mTreeModel.reload();
    }

    public void clear(DefaultMutableTreeNode root) {
        if (root == null) {
            return;
        }
        root.removeAllChildren();
        this.mTreeModel.reload(root);
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        TreePath currentSelection = this.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.mTreeModel.removeNodeFromParent(currentNode);
            return;
        }
        this.toolkit.beep();
    }

    public void removeNode(LogFileNode logFileNode) {
        this.removeNode(this.getRoot(), logFileNode);
    }

    public void removeNode(DefaultMutableTreeNode parentTreeNode, LogFileNode logFileNode) {
        DefaultMutableTreeNode parent;
        DefaultMutableTreeNode foundNode = LogFilePathTree.findLogFileNode(parentTreeNode, logFileNode);
        if (null != foundNode && (parent = (DefaultMutableTreeNode)foundNode.getParent()) != null) {
            this.mTreeModel.removeNodeFromParent(foundNode);
            if (this.isLeaf(parent) && LogFilePathTree.isPathNode(parent)) {
                this.removeTreeNode(parent);
            }
            return;
        }
    }

    public void removeAllChildren(LogFileNode logFileNode) {
        DefaultMutableTreeNode foundNode = LogFilePathTree.findLogFileNode(this.getRoot(), logFileNode);
        foundNode.removeAllChildren();
    }

    private boolean isLeaf(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> children = node.children();
        int i = 0;
        while (children.hasMoreElements()) {
            if (i > 0) break;
            ++i;
        }
        return i == 0;
    }

    public void removeTreeNode(DefaultMutableTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent != null) {
            this.mTreeModel.removeNodeFromParent(node);
        }
    }

    public DefaultMutableTreeNode addLogGroupNode(LogGroupNode child) {
        DefaultMutableTreeNode parentNode = null;
        TreePath parentPath = this.getSelectionPath();
        parentNode = parentPath == null ? this.mRoot : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        return this.addLogGroupNode(parentNode, child, true);
    }

    public DefaultMutableTreeNode addFileNode(LogGroupNode logGroupNode, LogFileNode logFileNode) {
        DefaultMutableTreeNode logGroupTreeNode;
        DefaultMutableTreeNode curRoot = logGroupTreeNode = this.findLogGroupNode(logGroupNode);
        String filepath = logFileNode.getNormalizedURI();
        String rootpath = null;
        String filename = filepath;
        int lastSeparatorIndex = filepath.lastIndexOf(LogFileNode.getFileSeparator());
        if (lastSeparatorIndex != -1) {
            rootpath = filepath.substring(0, lastSeparatorIndex);
            if (filepath.length() < lastSeparatorIndex + 2) {
                throw new BAMRuntimeException(Location.getLocation((Class)(class$com$sapmarkets$bam$view$overview$LogFilePathTree == null ? (class$com$sapmarkets$bam$view$overview$LogFilePathTree = LogFilePathTree.class$("com.sapmarkets.bam.view.overview.LogFilePathTree")) : class$com$sapmarkets$bam$view$overview$LogFilePathTree)), "INVALID_FILE", new Object[]{filepath});
            }
            filename = filepath.substring(filepath.lastIndexOf(LogFileNode.getFileSeparator()) + 1);
        }
        if (null != rootpath) {
            String[] dirTokens = this.getTokenArray(rootpath);
            DefaultMutableTreeNode newNode = this.addAllPathBasedNodes(curRoot, dirTokens, logFileNode);
            return newNode;
        }
        return this.addObject(logGroupTreeNode, logFileNode, false);
    }

    private Object[] getUserObjectPathFromRoot(DefaultMutableTreeNode root, DefaultMutableTreeNode node) {
        Object[] pathArray = node.getUserObjectPath();
        Object rootUO = root.getUserObject();
        int i = 0;
        boolean foundRootInNewPath = false;
        i = 0;
        while (i < pathArray.length) {
            String curPathStr = pathArray[i].toString();
            if (rootUO.toString().equalsIgnoreCase(curPathStr)) {
                foundRootInNewPath = true;
                break;
            }
            ++i;
        }
        if (!foundRootInNewPath) {
            return null;
        }
        Object[] adjPathArray = new Object[pathArray.length - i];
        System.arraycopy(pathArray, i, adjPathArray, 1, pathArray.length - i);
        return adjPathArray;
    }

    private DefaultMutableTreeNode addAllPathBasedNodes(DefaultMutableTreeNode root, String[] pathTokens, LogFileNode logFileNode) {
        if (pathTokens.length < 1) {
            return null;
        }
        DefaultMutableTreeNode newNode = null;
        DefaultMutableTreeNode foundPathNode = LogFilePathTree.findPathNode(root, pathTokens[0]);
        if (null != foundPathNode) {
            if (pathTokens.length > 1) {
                String[] subTokens = new String[pathTokens.length - 1];
                System.arraycopy(pathTokens, 1, subTokens, 0, pathTokens.length - 1);
                newNode = this.addAllPathBasedNodes(foundPathNode, subTokens, logFileNode);
            } else {
                newNode = this.addObject(foundPathNode, logFileNode, false);
            }
        } else {
            DefaultMutableTreeNode newPathNode = this.addObject(root, pathTokens[0], false);
            if (pathTokens.length > 1) {
                String[] subTokens = new String[pathTokens.length - 1];
                if (pathTokens.length > 1) {
                    System.arraycopy(pathTokens, 1, subTokens, 0, pathTokens.length - 1);
                }
                newNode = this.addAllPathBasedNodes(newPathNode, subTokens, logFileNode);
            } else {
                newNode = this.addObject(newPathNode, logFileNode, false);
            }
        }
        return newNode;
    }

    private DefaultMutableTreeNode addPathBasedNode(DefaultMutableTreeNode root, String[] pathTokens, LogFileNode logFileNode) {
        if (pathTokens.length < 1) {
            return null;
        }
        DefaultMutableTreeNode newNode = null;
        DefaultMutableTreeNode foundPathNode = LogFilePathTree.findPathNode(root, pathTokens[0]);
        if (null != foundPathNode) {
            if (pathTokens.length > 1) {
                String[] subTokens = new String[pathTokens.length - 1];
                System.arraycopy(pathTokens, 1, subTokens, 0, pathTokens.length - 1);
                newNode = this.addPathBasedNode(foundPathNode, subTokens, logFileNode);
            } else {
                newNode = this.addObject(foundPathNode, logFileNode, false);
            }
        } else if (pathTokens.length > 1) {
            String[] subTokens = new String[pathTokens.length - 1];
            subTokens[0] = pathTokens[0] + LogFileNode.getFileSeparator() + pathTokens[1];
            if (pathTokens.length > 2) {
                System.arraycopy(pathTokens, 2, subTokens, 1, pathTokens.length - 2);
            }
            newNode = this.addPathBasedNode(root, subTokens, logFileNode);
        } else {
            DefaultMutableTreeNode newPathNode = this.addObject(root, pathTokens[0], false);
            newNode = this.addObject(newPathNode, logFileNode, false);
        }
        return newNode;
    }

    public void contract(LogGroupNode rootNode) {
        DefaultMutableTreeNode rootTreeNode = this.findLogGroupNode(rootNode);
        this.contract(rootTreeNode);
    }

    /*
     * Unable to fully structure code
     */
    void contract(DefaultMutableTreeNode node) {
        block6: {
            if (node.getChildCount() == 0) {
                if (LogFilePathTree.isPathNode(node)) {
                    this.removeTreeNode(node);
                }
                return;
            }
            children = node.children();
            if (node.getChildCount() != 1 || !LogFilePathTree.isPathNode(node)) ** GOTO lbl18
            childNode = (DefaultMutableTreeNode)children.nextElement();
            if (!LogFilePathTree.isPathNode(childNode)) break block6;
            combineStr = (String)node.getUserObject() + LogFileNode.getFileSeparator() + (String)childNode.getUserObject();
            node.setUserObject(combineStr);
            this.setNodeChildrenToNewRoot(node, childNode);
            this.contract(node);
            break block6;
lbl-1000:
            // 1 sources

            {
                childNode = (DefaultMutableTreeNode)children.nextElement();
                if (!LogFilePathTree.isPathNode(childNode)) continue;
                this.contract(childNode);
lbl18:
                // 3 sources

                ** while (children.hasMoreElements())
            }
        }
    }

    private int getNumChildPathNodes(DefaultMutableTreeNode node) {
        return this.getChildPathNodes(node).size();
    }

    private List getChildPathNodes(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> resultNodes = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)children.nextElement();
            if (!LogFilePathTree.isPathNode(curNode)) continue;
            resultNodes.add(curNode);
        }
        return resultNodes;
    }

    private Enumeration setNodeChildrenToNewRoot(DefaultMutableTreeNode newRootNode, DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> childList = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)children.nextElement();
            childList.add(curNode);
        }
        this.removeTreeNode(node);
        Iterator itr = childList.iterator();
        while (itr.hasNext()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)itr.next();
            this.mTreeModel.insertNodeInto(curNode, newRootNode, newRootNode.getChildCount());
        }
        return newRootNode.children();
    }

    private static boolean isPathNode(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        return userObject instanceof String;
    }

    private String[] getTokenArray(String rootpath) {
        StringTokenizer tokenizer = this.getTokenList(rootpath);
        int numTokens = tokenizer.countTokens();
        String[] tokens = new String[numTokens];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        if (rootpath.startsWith(LogFileNode.REMOTE_MACHINE_TOKEN) && numTokens != 0) {
            tokens[0] = LogFileNode.REMOTE_MACHINE_TOKEN + tokens[0];
        }
        return tokens;
    }

    private StringTokenizer getTokenList(String filepath) {
        StringTokenizer tokenizer = new StringTokenizer(filepath, new Character(LogFileNode.getFileSeparator()).toString(), false);
        return tokenizer;
    }

    private static DefaultMutableTreeNode findPathNode(DefaultMutableTreeNode parentNode, String targetPath) {
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            if (!LogFilePathTree.isPathNode(node) || !((String)node.getUserObject()).equalsIgnoreCase(targetPath)) continue;
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.mRoot;
        }
        this.mTreeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public DefaultMutableTreeNode addLogGroupNode(DefaultMutableTreeNode parent, LogGroupNode child) {
        return this.addLogGroupNode(parent, child, false);
    }

    public DefaultMutableTreeNode addLogGroupNode(DefaultMutableTreeNode parent, LogGroupNode child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.mRoot;
        }
        this.mTreeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public void expandAll() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            if (value instanceof DefaultMutableTreeNode) {
                Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObj instanceof LogFileNode && !((LogFileNode)userObj).isUserAddedMode()) {
                    return ((LogFileNode)userObj).getShortDisplayName();
                }
                return value.toString();
            }
            return value.toString();
        }
        return "";
    }

    public void nodeStateChanged(LogFileNode fileNode) {
        try {
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.getKeyCode() == 10) {
            if (pressed) {
                boolean test = false;
            }
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LogViewerTreeRenderer
    extends DefaultTreeCellRenderer {
        private final ImageIcon leafIcon = ViewUtil.getIcon("/images/bullet.gif");
        private final ImageIcon openIcon = ViewUtil.getIcon("/images/folder_open.gif");
        private final ImageIcon closeIcon = ViewUtil.getIcon("/images/folder_closed.gif");
        private final ImageIcon unconnectedIcon = OverviewWrapper.unconnectedIcon;
        private final ImageIcon logOpenedIcon = OverviewWrapper.checkIcon;
        private final ImageIcon logClosedIcon = OverviewWrapper.closedAndOkIcon;
        private final ImageIcon logEmptyIcon = OverviewWrapper.emptyIcon;
        private final ImageIcon logFilelessIcon = OverviewWrapper.filelessIcon;
        private final ImageIcon xmlIcon = OverviewWrapper.xmlIcon;
        private final ImageIcon sqlIcon = OverviewWrapper.sqlIcon;
        private final ImageIcon sapjIcon = OverviewWrapper.sapjIcon;
        private final ImageIcon asciiIcon = OverviewWrapper.asciiIcon;
        private final ImageIcon satIcon = OverviewWrapper.satIcon;
        private final ImageIcon unconnected_sqlIcon = OverviewWrapper.unconnected_sqlIcon;
        private final ImageIcon unconnected_sapjIcon = OverviewWrapper.unconnected_sapjIcon;
        private final ImageIcon unconnected_asciiIcon = OverviewWrapper.unconnected_asciiIcon;
        private final ImageIcon unconnected_xmlIcon = OverviewWrapper.unconnected_xmlIcon;
        private final ImageIcon unconnected_satIcon = OverviewWrapper.unconnected_satIcon;
        private final ImageIcon opened_sqlIcon = OverviewWrapper.opened_sqlIcon;
        private final ImageIcon opened_sapjIcon = OverviewWrapper.opened_sapjIcon;
        private final ImageIcon opened_asciiIcon = OverviewWrapper.opened_asciiIcon;
        private final ImageIcon opened_xmlIcon = OverviewWrapper.opened_xmlIcon;
        private final ImageIcon opened_satIcon = OverviewWrapper.opened_satIcon;
        private final ImageIcon closed_sqlIcon = OverviewWrapper.closed_sqlIcon;
        private final ImageIcon closed_sapjIcon = OverviewWrapper.closed_sapjIcon;
        private final ImageIcon closed_asciiIcon = OverviewWrapper.closed_asciiIcon;
        private final ImageIcon closed_xmlIcon = OverviewWrapper.closed_xmlIcon;
        private final ImageIcon closed_satIcon = OverviewWrapper.closed_satIcon;
        private final ImageIcon empty_sqlIcon = OverviewWrapper.empty_sqlIcon;
        private final ImageIcon empty_sapjIcon = OverviewWrapper.empty_sapjIcon;
        private final ImageIcon empty_asciiIcon = OverviewWrapper.empty_asciiIcon;
        private final ImageIcon empty_xmlIcon = OverviewWrapper.empty_xmlIcon;
        private final ImageIcon empty_satIcon = OverviewWrapper.empty_satIcon;

        public LogViewerTreeRenderer() {
            this.setLeafIcon(this.leafIcon);
            this.setOpenIcon(this.openIcon);
            this.setClosedIcon(this.closeIcon);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf && this.isLogApplicationNode(value)) {
                this.setIcon(this.closeIcon);
            }
            if (this.isLogFileNode(value)) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                LogFileNode fileNode = (LogFileNode)node.getUserObject();
                this.setToolTipText(fileNode.getToolTipText());
                String logType = fileNode.getLogType();
                this.setIcon(this.getTypeStateIcon(fileNode));
            }
            return this;
        }

        private ImageIcon getTypeStateIcon(LogFileNode fileNode) {
            ImageIcon returnIcon = null;
            String logType = fileNode.getLogType();
            if (fileNode.getState() == 1) {
                returnIcon = this.unconnectedIcon;
            } else if (fileNode.getState() == 2) {
                returnIcon = this.logOpenedIcon;
            } else if (fileNode.getState() == 3) {
                returnIcon = this.logClosedIcon;
            } else if (fileNode.getState() == 5) {
                returnIcon = this.logFilelessIcon;
            } else if (fileNode.getState() == 4) {
                returnIcon = this.logEmptyIcon;
            } else if (fileNode.getState() == 0) {
                returnIcon = this.leafIcon;
            }
            return returnIcon;
        }

        private boolean isLogFileNode(Object value) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object nodeValue = treeNode.getUserObject();
            return nodeValue instanceof LogFileNode;
        }

        private boolean isLogApplicationNode(Object value) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object nodeValue = treeNode.getUserObject();
            return nodeValue instanceof LogApplicationNode;
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            try {
                int index = e.getChildIndices()[0];
                node = (DefaultMutableTreeNode)node.getChildAt(index);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

