/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.view.filter.Spring;
import com.sapmarkets.bam.view.filter.SpringLayout;
import java.awt.Component;
import java.awt.Container;

public class SpringUtilities {
    public static void printSizes(Component c) {
        System.out.println("minimumSize = " + c.getMinimumSize());
        System.out.println("preferredSize = " + c.getPreferredSize());
        System.out.println("maximumSize = " + c.getMaximumSize());
    }

    public static void makeGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeGrid must use SpringLayout.");
            return;
        }
        Spring xPadSpring = Spring.constant(xPad);
        Spring yPadSpring = Spring.constant(yPad);
        Spring initialXSpring = Spring.constant(initialX);
        Spring initialYSpring = Spring.constant(initialY);
        int max = rows * cols;
        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        int i = 1;
        while (i < max) {
            SpringLayout.Constraints cons = layout.getConstraints(parent.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
            ++i;
        }
        int i2 = 0;
        while (i2 < max) {
            SpringLayout.Constraints cons = layout.getConstraints(parent.getComponent(i2));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
            ++i2;
        }
        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        int i3 = 0;
        while (i3 < max) {
            SpringLayout.Constraints cons = layout.getConstraints(parent.getComponent(i3));
            if (i3 % cols == 0) {
                lastRowCons = lastCons;
                cons.setX(initialXSpring);
            } else {
                cons.setX(Spring.sum(lastCons.getConstraint("East"), xPadSpring));
            }
            if (i3 / cols == 0) {
                cons.setY(initialYSpring);
            } else {
                cons.setY(Spring.sum(lastRowCons.getConstraint("South"), yPadSpring));
            }
            lastCons = cons;
            ++i3;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(yPad), lastCons.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(xPad), lastCons.getConstraint("East")));
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        int r;
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            r = 0;
            while (r < rows) {
                width = Spring.max(width, SpringUtilities.getConstraintsForCell(r, c, parent, cols).getWidth());
                ++r;
            }
            int r2 = 0;
            while (r2 < rows) {
                SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(r2, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r2;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        Spring y = Spring.constant(initialY);
        r = 0;
        while (r < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, SpringUtilities.getConstraintsForCell(r, c2, parent, cols).getHeight());
                ++c2;
            }
            int c3 = 0;
            while (c3 < cols) {
                SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(r, c3, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++c3;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++r;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }
}

