/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.view.filter.Spring;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class SpringLayout
implements LayoutManager2 {
    private Map componentConstraints = new HashMap();
    private Spring cyclicReference = Spring.constant(Integer.MIN_VALUE);
    private Set cyclicSprings;
    private Set acyclicSprings;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    static /* synthetic */ Class class$com$sapmarkets$bam$view$filter$SpringLayout;

    private void resetCyclicStatuses() {
        this.cyclicSprings = new HashSet();
        this.acyclicSprings = new HashSet();
    }

    private void setParent(Container p) {
        this.resetCyclicStatuses();
        Constraints pc = this.getConstraints(p);
        pc.setX(Spring.constant(0));
        pc.setY(Spring.constant(0));
        pc.setWidth(null);
        pc.setHeight(null);
        if (pc.getEast() == null) {
            pc.setEast(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        if (pc.getSouth() == null) {
            pc.setSouth(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
    }

    boolean isCyclic(Spring s) {
        if (s == null) {
            return false;
        }
        if (this.cyclicSprings.contains(s)) {
            return true;
        }
        if (this.acyclicSprings.contains(s)) {
            return false;
        }
        this.cyclicSprings.add(s);
        boolean result = s.isCyclic(this);
        if (!result) {
            this.acyclicSprings.add(s);
            this.cyclicSprings.remove(s);
        } else {
            System.err.println(s + " is cyclic. ");
        }
        return result;
    }

    private Spring abandonCycles(Spring s) {
        return this.isCyclic(s) ? this.cyclicReference : s;
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
        this.componentConstraints.remove(c);
    }

    private static Dimension addInsets(int width, int height, Container p) {
        Insets i = p.getInsets();
        return new Dimension(width + i.left + i.right, height + i.top + i.bottom);
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.setParent(parent);
        Constraints pc = this.getConstraints(parent);
        return SpringLayout.addInsets(this.abandonCycles(pc.getWidth()).getMinimumValue(), this.abandonCycles(pc.getHeight()).getMinimumValue(), parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.setParent(parent);
        Constraints pc = this.getConstraints(parent);
        return SpringLayout.addInsets(this.abandonCycles(pc.getWidth()).getPreferredValue(), this.abandonCycles(pc.getHeight()).getPreferredValue(), parent);
    }

    public Dimension maximumLayoutSize(Container parent) {
        this.setParent(parent);
        Constraints pc = this.getConstraints(parent);
        return SpringLayout.addInsets(this.abandonCycles(pc.getWidth()).getMaximumValue(), this.abandonCycles(pc.getHeight()).getMaximumValue(), parent);
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints instanceof Constraints) {
            this.putConstraints(component, (Constraints)constraints);
        }
    }

    public float getLayoutAlignmentX(Container p) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container p) {
        return 0.5f;
    }

    public void invalidateLayout(Container p) {
    }

    public void putConstraint(String e1, Component c1, int pad, String e2, Component c2) {
        this.putConstraint(e1, c1, Spring.constant(pad), e2, c2);
    }

    public void putConstraint(String e1, Component c1, Spring s, String e2, Component c2) {
        this.putConstraint(e1, c1, Spring.sum(s, this.getConstraint(e2, c2)));
    }

    private void putConstraint(String e, Component c, Spring s) {
        if (s != null) {
            this.getConstraints(c).setConstraint(e, s);
        }
    }

    private Constraints applyDefaults(Component c, Constraints constraints) {
        if (constraints == null) {
            constraints = new Constraints();
        }
        if (constraints.getWidth() == null) {
            constraints.setWidth(new WidthSpring(c));
        }
        if (constraints.getHeight() == null) {
            constraints.setHeight(new HeightSpring(c));
        }
        if (constraints.getX() == null) {
            constraints.setX(Spring.constant(0));
        }
        if (constraints.getY() == null) {
            constraints.setY(Spring.constant(0));
        }
        return constraints;
    }

    private void putConstraints(Component component, Constraints constraints) {
        this.componentConstraints.put(component, this.applyDefaults(component, constraints));
    }

    public Constraints getConstraints(Component c) {
        Constraints result = (Constraints)this.componentConstraints.get(c);
        if (result == null) {
            Object cp;
            if (c instanceof JComponent && (cp = ((JComponent)c).getClientProperty(class$com$sapmarkets$bam$view$filter$SpringLayout == null ? (class$com$sapmarkets$bam$view$filter$SpringLayout = SpringLayout.class$("com.sapmarkets.bam.view.filter.SpringLayout")) : class$com$sapmarkets$bam$view$filter$SpringLayout)) instanceof Constraints) {
                return this.applyDefaults(c, (Constraints)cp);
            }
            result = new Constraints();
            this.putConstraints(c, result);
        }
        return result;
    }

    public Spring getConstraint(String edgeName, Component c) {
        edgeName = edgeName.intern();
        return new SpringProxy(edgeName, c, this);
    }

    public void layoutContainer(Container parent) {
        this.setParent(parent);
        int n = parent.getComponentCount();
        this.getConstraints(parent).reset();
        int i = 0;
        while (i < n) {
            this.getConstraints(parent.getComponent(i)).reset();
            ++i;
        }
        Insets insets = parent.getInsets();
        Constraints pc = this.getConstraints(parent);
        this.abandonCycles(pc.getX()).setValue(0);
        this.abandonCycles(pc.getY()).setValue(0);
        this.abandonCycles(pc.getWidth()).setValue(parent.getWidth() - insets.left - insets.right);
        this.abandonCycles(pc.getHeight()).setValue(parent.getHeight() - insets.top - insets.bottom);
        int i2 = 0;
        while (i2 < n) {
            Component c = parent.getComponent(i2);
            Constraints cc = this.getConstraints(c);
            int x = this.abandonCycles(cc.getX()).getValue();
            int y = this.abandonCycles(cc.getY()).getValue();
            int width = this.abandonCycles(cc.getWidth()).getValue();
            int height = this.abandonCycles(cc.getHeight()).getValue();
            c.setBounds(insets.left + x, insets.top + y, width, height);
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SpringProxy
    extends Spring {
        private String edgeName;
        private Component c;
        private SpringLayout l;

        public SpringProxy(String edgeName, Component c, SpringLayout l) {
            this.edgeName = edgeName;
            this.c = c;
            this.l = l;
        }

        private Spring getConstraint() {
            return this.l.getConstraints(this.c).getConstraint(this.edgeName);
        }

        public int getMinimumValue() {
            return this.getConstraint().getMinimumValue();
        }

        public int getPreferredValue() {
            return this.getConstraint().getPreferredValue();
        }

        public int getMaximumValue() {
            return this.getConstraint().getMaximumValue();
        }

        public int getValue() {
            return this.getConstraint().getValue();
        }

        public void setValue(int size) {
            this.getConstraint().setValue(size);
        }

        boolean isCyclic(SpringLayout l) {
            return l.isCyclic(this.getConstraint());
        }

        public String toString() {
            return "SpringProxy for " + this.edgeName + " edge of " + this.c.getName() + ".";
        }
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring width;
        private Spring height;
        private Spring east;
        private Spring south;
        private Spring verticalDerived = null;
        private Spring horizontalDerived = null;

        public Constraints() {
            this(null, null, null, null);
        }

        public Constraints(Spring x, Spring y) {
            this(x, y, null, null);
        }

        public Constraints(Spring x, Spring y, Spring width, Spring height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        private boolean overConstrainedHorizontally() {
            return this.x != null && this.width != null && this.east != null;
        }

        private boolean overConstrainedVertically() {
            return this.y != null && this.height != null && this.south != null;
        }

        private Spring sum(Spring s1, Spring s2) {
            return s1 == null || s2 == null ? null : Spring.sum(s1, s2);
        }

        private Spring difference(Spring s1, Spring s2) {
            return s1 == null || s2 == null ? null : Spring.difference(s1, s2);
        }

        public void setX(Spring x) {
            this.x = x;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.width = null;
            }
        }

        public Spring getX() {
            if (this.x != null) {
                return this.x;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.difference(this.east, this.width);
            }
            return this.horizontalDerived;
        }

        public void setY(Spring y) {
            this.y = y;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.height = null;
            }
        }

        public Spring getY() {
            if (this.y != null) {
                return this.y;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.difference(this.south, this.height);
            }
            return this.verticalDerived;
        }

        public void setWidth(Spring width) {
            this.width = width;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.east = null;
            }
        }

        public Spring getWidth() {
            if (this.width != null) {
                return this.width;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.difference(this.east, this.x);
            }
            return this.horizontalDerived;
        }

        public void setHeight(Spring height) {
            this.height = height;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.south = null;
            }
        }

        public Spring getHeight() {
            if (this.height != null) {
                return this.height;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.difference(this.south, this.y);
            }
            return this.verticalDerived;
        }

        private void setEast(Spring east) {
            this.east = east;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.x = null;
            }
        }

        private Spring getEast() {
            if (this.east != null) {
                return this.east;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.sum(this.x, this.width);
            }
            return this.horizontalDerived;
        }

        private void setSouth(Spring south) {
            this.south = south;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.y = null;
            }
        }

        private Spring getSouth() {
            if (this.south != null) {
                return this.south;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.sum(this.y, this.height);
            }
            return this.verticalDerived;
        }

        public void setConstraint(String edgeName, Spring s) {
            if ((edgeName = edgeName.intern()) == SpringLayout.WEST) {
                this.setX(s);
            } else if (edgeName == SpringLayout.NORTH) {
                this.setY(s);
            } else if (edgeName == SpringLayout.EAST) {
                this.setEast(s);
            } else if (edgeName == SpringLayout.SOUTH) {
                this.setSouth(s);
            }
        }

        public Spring getConstraint(String edgeName) {
            return (edgeName = edgeName.intern()) == SpringLayout.WEST ? this.getX() : (edgeName == SpringLayout.NORTH ? this.getY() : (edgeName == SpringLayout.EAST ? this.getEast() : (edgeName == SpringLayout.SOUTH ? this.getSouth() : null)));
        }

        void reset() {
            if (this.x != null) {
                this.x.setValue(Integer.MIN_VALUE);
            }
            if (this.y != null) {
                this.y.setValue(Integer.MIN_VALUE);
            }
            if (this.width != null) {
                this.width.setValue(Integer.MIN_VALUE);
            }
            if (this.height != null) {
                this.height.setValue(Integer.MIN_VALUE);
            }
            if (this.east != null) {
                this.east.setValue(Integer.MIN_VALUE);
            }
            if (this.south != null) {
                this.south.setValue(Integer.MIN_VALUE);
            }
            if (this.horizontalDerived != null) {
                this.horizontalDerived.setValue(Integer.MIN_VALUE);
            }
            if (this.verticalDerived != null) {
                this.verticalDerived.setValue(Integer.MIN_VALUE);
            }
        }
    }

    private static class HeightSpring
    extends Spring.AbstractSpring {
        private Component c;

        public HeightSpring(Component c) {
            this.c = c;
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().height;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().height;
        }

        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().height);
        }
    }

    private static class WidthSpring
    extends Spring.AbstractSpring {
        private Component c;

        public WidthSpring(Component c) {
            this.c = c;
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().width;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().width;
        }

        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().width);
        }
    }
}

